/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking.visa;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.TravellerExport;
import com.gridnine.xtrip.common.model.export.booking.v2.VisaProductExport;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BookingExportVisaFillProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        VisaProduct product = (VisaProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        VisaProductExport productExport = new VisaProductExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        VisaProductExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof VisaProduct) {
            previousProductExport = new VisaProductExport();
            this.updateProductExport(previousProductExport, (VisaProduct)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, settings, previousSettings)));
    }

    private void updateProductExport(VisaProductExport productExport, VisaProduct product) {
        ProductStatus status = product.getStatus();
        boolean negate = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE;
        String equiveCurrency = DictHelper.getEquivCurrency();
        productExport.setUid(product.getUid());
        productExport.setStatus(MetadataBasedExportHelper.convertEnum(product.getStatus()));
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum(product.getTicketType()));
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setBlankOwner(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)product.getBlankOwner()));
        productExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)product.getAgent()));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference<SalesPoint>)product.getSalesPoint()));
        productExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)VisaProductHelper.getSubagency((VisaProduct)product)));
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)VisaProductHelper.getAgency((VisaProduct)product)));
        productExport.setIssueDate(product.getIssueDate());
        EntityReference supplierRef = VisaProductHelper.getSupplier((VisaProduct)product);
        productExport.setSupplier(MetadataBasedExportHelper.convertSupplier((EntityReference<Organization>)supplierRef));
        productExport.setContractRulesApplied(Boolean.valueOf(product.isContractRulesApplied()));
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        productExport.setStartDate(product.getStartDate());
        productExport.setEndDate(product.getEndDate());
        productExport.setNotes(product.getNotes());
        productExport.setComments(product.getComments());
        productExport.setCountry(MetadataBasedExportHelper.convertDictionary(product.getCountry()));
        productExport.setExpressService(Boolean.valueOf(product.isExpressService()));
        productExport.getTravellers().addAll(this.getTravellersExport(product));
        productExport.setEntryType(MetadataBasedExportHelper.convertEnum(product.getEntryType()));
        productExport.setType(MetadataBasedExportHelper.convertDictionary(product.getType()));
        productExport.setApplicationStatus(MetadataBasedExportHelper.convertDictionary(product.getApplicationStatus()));
        productExport.setFare(MetadataBasedExportHelper.convertMoney(product.getFare(), negate));
        productExport.setEquivalentFare(MetadataBasedExportHelper.convertMoney(product.getEquivalentFare(), negate));
        productExport.setPenalty(product.getPenalty());
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
        if (product.getPenalty() != null && product.getPenaltyVatValue() != null) {
            productExport.setPenaltyVatValue(MetadataBasedExportHelper.convertVatAmount(product.getPenalty(), equiveCurrency, product.getPenaltyVatValue().getAmount()));
        }
        if (product.getEquivalentFare() != null && product.getEquivalentFareVatValue() != null) {
            productExport.setEquivalentFareVatValue(MetadataBasedExportHelper.convertVatAmount(product.getEquivalentFare().getValue(), product.getEquivalentFare().getCurrency(), product.getEquivalentFareVatValue().getAmount()));
        }
        List contractRelations = VisaProductHelper.getContractRelations((VisaProduct)product);
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, arg_0 -> ((VisaProductExport)productExport).setClientContract(arg_0), arg_0 -> ((VisaProductExport)productExport).setSubagencyContract(arg_0), arg_0 -> ((VisaProductExport)productExport).setVendorContract(arg_0), arg_0 -> ((VisaProductExport)productExport).setTechnicalProviderContract(arg_0));
            List<GeneralProductFop> fops = MetadataBasedExportHelper.getSortedFops(contractRelation.getFops());
            for (GeneralProductFop fop : fops) {
                Object card;
                FopExport fopExport = new FopExport();
                productExport.getFops().add(fopExport);
                FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
                fopExport.setContractType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())));
                fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getAgreementType((BaseContractRelationData)contractRelation)));
                fopExport.setCategory(BookingExportVisaFillProductHeaderProcessor.getFopCategory(fop));
                fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum(fop.getType()));
                fopExport.setAmount(MetadataBasedExportHelper.convertMoney(MoneyHelper.buildMoney((BigDecimal)fop.getEquivalentAmount(), (String)GeneralProductHelper.getContractCurrency((GeneralProductContractRelationData)contractRelation)), negate));
                PaymentType paymentType = fop.getType();
                if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setDetails(MetadataBasedExportHelper.convertEnum(card.getVendor()));
                        fopExport.setCardNumber(card.getNumber());
                        fopExport.setCardExpirationDate(card.getExpiration());
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                } else {
                    fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum(fop.getPassengerStatus()) : null));
                    fopExport.setNumber(fop.getRelatedTicketNumber());
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                }
                fopExport.setOperationDate(fop.getOperationDate());
                fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)fop.getAgent()));
                fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
                fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)fop.getPayer()));
                for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                    ReferenceItemExport commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                    fopExport.getServiceFees().add(commissionExport);
                }
                List<FopComponent> components = MetadataBasedExportHelper.getSortedFopComponents(fopDetalization.getComponents());
                for (FopComponent component : components) {
                    FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent(component, negate);
                    fopExport.getFopComponents().add(componentExport);
                }
            }
        }
    }

    private List<TravellerExport> getTravellersExport(VisaProduct product) {
        if (product == null) {
            return Collections.emptyList();
        }
        ArrayList<TravellerExport> result = new ArrayList<TravellerExport>();
        product.getTravellers().forEach(traveller -> {
            TravellerExport travellerExport = new TravellerExport();
            travellerExport.setName(traveller.getName());
            travellerExport.setNameInGds(traveller.getNameInGds());
            travellerExport.setNameInCyrillic(traveller.getCyrillicName());
            if (traveller.getPassenger() != null) {
                EntityContainer personCtr = EntityStorage.get().resolve(traveller.getPassenger());
                travellerExport.setPassengerUid(traveller.getPassenger().getUid());
                if (personCtr != null) {
                    travellerExport.getExternalCodes().addAll(BookingXmlExportHelper.getPersonExternalCodes((EntityContainer<Person>)personCtr));
                    travellerExport.setCode(((Person)personCtr.getEntity()).getCode());
                }
            }
            result.add(travellerExport);
        });
        return result;
    }

    private static ObjectReferenceExport getFopCategory(GeneralProductFop fop) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
            boolean payment = false;
            boolean discount = false;
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    payment = true;
                    break;
                }
                if (commission.getCommissionProperties() == null || !GeneralProductHelper.discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                discount = true;
                break;
            }
            if (payment) {
                result.setCode("PAYMENT_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            } else if (discount) {
                result.setCode("DISCOUNT");
                result.setCaption("\u0421\u043a\u0438\u0434\u043a\u0430");
            } else {
                result.setCode("SERVICE_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440");
            }
        } else {
            result.setCode("PRODUCT");
            result.setCaption("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        }
        return result;
    }
}

