/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.finance;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CategoryFopComponent;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.TaxesFopComponent;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.export.booking.v2.DecimalItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.finance.v2.BillingItemComponentExport;
import com.gridnine.xtrip.common.model.export.finance.v2.BillingItemExport;
import com.gridnine.xtrip.common.model.export.finance.v2.BillingItemFopComponentExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceBookingExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceContractExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceFopExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceProductExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceReservationExport;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemComponent;
import com.gridnine.xtrip.common.model.finance.BillingItemComponentType;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.finance.FinanceExportHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BillingItemExportProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        NestedEntityReference billingItemReference = (NestedEntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM);
        Map billingItemsMap = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_MAP);
        Collection billingItemExportDocuments = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_EXPORT_DOCUMENTS);
        EntityContainer contract = (EntityContainer)ctx.getObject((Enum)IBusFinanceContextKeys.CONTRACT_CONTAINER);
        ContractType contractType = Optional.ofNullable(contract).map(EntityContainer::getEntity).map(Contract::getContractType).orElse(null);
        List<FopComponent> fopComponents = billingItemsMap.values().stream().flatMap(bi -> bi.getFopComponents().stream()).map(fc -> (FopComponent)MetadataBasedExportHelper.resolve(fc, storageContext, this.log)).filter(Objects::nonNull).collect(Collectors.toList());
        boolean negate = false;
        BillingItem billingItem = (BillingItem)billingItemsMap.get(billingItemReference);
        if (billingItem != null) {
            BillingItemExport billingItemExport = new BillingItemExport();
            BaseProduct product = null;
            ExchangeRateData exchangeRateData = null;
            GeneralProductContractRelationData contractRelation = null;
            String baseCurrency = null;
            if (billingItem.getProduct() != null) {
                product = (BaseProduct)MetadataBasedExportHelper.resolve(billingItem.getProduct(), storageContext, this.log);
                billingItemExport.setProduct(this.convertProduct(billingItem.getProduct().getUid(), product, (EntityContainer<Contract>)contract, storageContext));
                if (product != null) {
                    ProductStatus status = ProductHandler.of((BaseProduct)product).getBaseStatus(product);
                    negate = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE;
                    contractRelation = GeneralProductHelper.getContractRelation((BaseProduct)product, (ContractType)contractType);
                    List contractRelations = GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)product);
                    int index = contractRelations.indexOf(contractRelation);
                    if (index != 0) {
                        GeneralProductContractRelationData previousContractRelation = (GeneralProductContractRelationData)contractRelations.get(index - 1);
                        baseCurrency = Optional.ofNullable(previousContractRelation.getGeneralData().getCurrency()).map(DictionaryReference::getCode).orElse(null);
                    }
                }
            }
            BigDecimal totalBaseAmount = null;
            boolean failedCalculateBaseAmount = false;
            ArrayList<BigDecimal> supplierVatRates = new ArrayList<BigDecimal>();
            for (NestedEntityReference fopComponentRef : billingItem.getFopComponents()) {
                FopComponent fopComponent = (FopComponent)MetadataBasedExportHelper.resolve(fopComponentRef, storageContext, this.log);
                exchangeRateData = this.getExchangeRateData(product, fopComponent, contractType);
                BigDecimal baseAmount = null;
                try {
                    baseAmount = this.getBaseAmount(fopComponent, product, contractRelation, exchangeRateData, fopComponents);
                }
                catch (Exception e) {
                    failedCalculateBaseAmount = true;
                    this.log.error(String.format("failed to calculate baseAmount for billingItem %s when exporting shipment %s (uid %s)", billingItem.getUid(), billingItem.getShipment(), billingItem.getShipment().getUid()), (Throwable)e);
                }
                BillingItemFopComponentExport fopComponentExport = this.convertFopComponent(fopComponent, product, contractRelation, exchangeRateData, baseCurrency, baseAmount, negate);
                if (fopComponentExport == null) continue;
                totalBaseAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalBaseAmount, baseAmount});
                if (fopComponentExport.getAmount() != null) {
                    fopComponentExport.getAmount().getSupplierVatRates().stream().map(DecimalItemExport::getValue).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).ifPresent(supplierVatRates::add);
                }
                billingItemExport.getFopComponents().add(fopComponentExport);
            }
            if (failedCalculateBaseAmount) {
                totalBaseAmount = null;
            }
            billingItemExport.setUid(billingItem.getUid());
            billingItemExport.setName(billingItem.getName());
            billingItemExport.setAmount(MetadataBasedExportHelper.convertVatAmount(billingItem.getAmount(), totalBaseAmount, exchangeRateData, supplierVatRates, baseCurrency));
            billingItemExport.setServiceType(MetadataBasedExportHelper.convertEnum(billingItem.getServiceType()));
            billingItemExport.setSupplier(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)billingItem.getSupplier(), storageContext));
            for (NestedEntityReference fop : billingItem.getFops()) {
                FinanceFopExport fopExport = MetadataBasedExportHelper.convertFop((NestedEntityReference<BookingFile, Fop>)fop, storageContext, this.log);
                if (fopExport == null) continue;
                billingItemExport.getFops().add(fopExport);
            }
            for (BillingItemComponent component : billingItem.getComponents()) {
                BillingItemComponentExport componentExport = this.convertBillingItemComponent(component);
                if (componentExport == null) continue;
                billingItemExport.getComponents().add(componentExport);
            }
            if (billingItem.getTraveller() != null) {
                billingItemExport.setTravellerUid(billingItem.getTraveller().getNestedEntityUid());
            }
            billingItemExportDocuments.add(billingItemExport);
        }
    }

    private BigDecimal getBaseAmount(FopComponent fopComponent, BaseProduct product, GeneralProductContractRelationData contractRelation, ExchangeRateData exchangeRateData, List<FopComponent> fopComponents) {
        if (fopComponent == null || product == null || contractRelation == null || MiscUtil.guarded((BigDecimal)fopComponent.getAmount()).compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        if (exchangeRateData == null || exchangeRateData.getCurrencyRateData() == null) {
            return null;
        }
        String currency = Optional.ofNullable(exchangeRateData.getCurrency()).map(DictionaryReference::getCode).orElse(null);
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        Collection travellers = handler.getTravellers(product);
        HashSet adults = new HashSet();
        if (travellers != null) {
            travellers.forEach(tr -> {
                DictionaryReference passengerType = handler.getPassengerType(product, tr);
                if (DictHelper.isAdultPassengerTypeCategory((DictionaryReference)passengerType)) {
                    adults.add(tr);
                }
            });
        }
        int size = !adults.isEmpty() ? adults.size() : 1;
        ProductStatus status = handler.getStatus(product);
        boolean negate = ProductStatus.REFUND == status || ProductStatus.EXCHANGE == status;
        BaseProduct previousProduct = handler.getPreviousProduct(product);
        BaseProduct sellProduct = null;
        if (previousProduct != null && ProductStatus.EXCHANGE == handler.getStatus(previousProduct)) {
            sellProduct = handler.getPreviousProduct(previousProduct);
        }
        boolean sameTypeFound = fopComponents.stream().filter(fc -> fc.getType() == fopComponent.getType()).count() > 1L;
        boolean typeDefined = false;
        if (fopComponent instanceof TaxesFopComponent) {
            BigDecimal sellTaxAmount;
            String taxCode = ((TaxesFopComponent)fopComponent).getTaxes();
            if (fopComponents.stream().filter(fc -> fc instanceof TaxesFopComponent).map(fc -> (TaxesFopComponent)fc).filter(fc -> MiscUtil.equals((Object)fc.getTaxes(), (Object)taxCode)).count() > 1L) {
                return this.calcBaseAmount(fopComponent, exchangeRateData, negate);
            }
            BigDecimal taxAmount = this.getTaxAmount(handler.getTaxes(product), taxCode);
            if (taxAmount == null) {
                return null;
            }
            if (sellProduct != null && (sellTaxAmount = this.getTaxAmount(handler.getTaxes(sellProduct), taxCode)) != null) {
                return MetadataBasedExportHelper.convertSum(taxAmount.subtract(sellTaxAmount).divide(BigDecimal.valueOf(size), 2, 3), negate);
            }
            return MetadataBasedExportHelper.convertSum(taxAmount.divide(BigDecimal.valueOf(size), 2, 3), negate);
        }
        if (FopComponentType.PRODUCT == fopComponent.getType()) {
            if (sameTypeFound) {
                return this.calcBaseAmount(fopComponent, exchangeRateData, negate);
            }
            if (fopComponent.isHidden()) {
                for (GeneralProductCommission commission : contractRelation.getCommissions()) {
                    EntityContainer properties = EntityStorage.get().resolve(commission.getCommissionProperties());
                    if (properties == null || !(properties.getEntity() instanceof FeeProperties) || !((FeeProperties)properties.getEntity()).isHidden() || commission.getAmount() == null || commission.getAmount().getValue() == null || commission.getEquivalentAmount() == null || MiscUtil.equals((Object)commission.getAmount().getCurrency(), (Object)currency, (boolean)false) || !MiscUtil.equals((Object)commission.getEquivalentAmount().divide(BigDecimal.valueOf(size), 2, 3), (Object)fopComponent.getAmount().setScale(2, 3))) continue;
                    return MetadataBasedExportHelper.convertSum(commission.getAmount().getValue().divide(BigDecimal.valueOf(size), 2, 3), negate);
                }
            } else {
                BigDecimal equivalentFare = handler.getEquivalentFare(product);
                if (equivalentFare == null) {
                    return null;
                }
                if (sellProduct != null) {
                    BigDecimal sellEquivalentFare = handler.getEquivalentFare(sellProduct);
                    if (sellEquivalentFare != null) {
                        return MetadataBasedExportHelper.convertSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{equivalentFare, sellEquivalentFare.negate()}).divide(BigDecimal.valueOf(size), 2, 3), negate);
                    }
                } else {
                    return MetadataBasedExportHelper.convertSum(equivalentFare.divide(BigDecimal.valueOf(size), 2, 3), negate);
                }
            }
            return null;
        }
        if (fopComponent instanceof CategoryFopComponent) {
            typeDefined = true;
            for (GeneralProductCommission commission : contractRelation.getCommissions()) {
                EntityContainer properties = EntityStorage.get().resolve(commission.getCommissionProperties());
                if (properties == null || commission.getAmount() == null || commission.getAmount().getValue() == null || MiscUtil.equals((Object)commission.getAmount().getCurrency(), (Object)currency, (boolean)false)) continue;
                DictionaryReference category = ((CategoryFopComponent)fopComponent).getCategory();
                if (properties.getEntity() instanceof FeeProperties && !((FeeProperties)properties.getEntity()).isHidden() && MiscUtil.equals((Object)((FeeProperties)properties.getEntity()).getCategory(), (Object)category)) {
                    return MetadataBasedExportHelper.convertSum(commission.getAmount().getValue().divide(BigDecimal.valueOf(size), 2, 3), negate);
                }
                if (!(properties.getEntity() instanceof DiscountProperties) || !MiscUtil.equals((Object)((DiscountProperties)properties.getEntity()).getCategory(), (Object)category)) continue;
                return MetadataBasedExportHelper.convertSum(commission.getAmount().getValue().divide(BigDecimal.valueOf(size), 2, 3).negate(), negate);
            }
        }
        if (FopComponentType.SERVICE == fopComponent.getType()) {
            if (sameTypeFound) {
                return this.calcBaseAmount(fopComponent, exchangeRateData, negate);
            }
            typeDefined = true;
            BigDecimal addFeeEquiv = handler.getAdditionalFeeEquivalentAmount(product);
            if (addFeeEquiv != null) {
                return MetadataBasedExportHelper.convertSum(addFeeEquiv.divide(BigDecimal.valueOf(size), 2, 3), negate);
            }
        }
        if (FopComponentType.PENALTY == fopComponent.getType()) {
            if (sameTypeFound) {
                return this.calcBaseAmount(fopComponent, exchangeRateData, false);
            }
            typeDefined = true;
            BigDecimal penalty = handler.getPenalty(product);
            if (penalty != null) {
                return penalty.divide(BigDecimal.valueOf(size), 2, 3);
            }
        }
        if (!typeDefined) {
            throw Xeption.forDeveloper((String)String.format("FopComponent with type %s (uid %s) not taken into account when calculating baseAmount", fopComponent.getType() != null ? fopComponent.getType().toString() : null, fopComponent.getUid()), (Object[])new Object[0]);
        }
        return null;
    }

    private BigDecimal calcBaseAmount(FopComponent fopComponent, ExchangeRateData rateData, boolean negate) {
        ExchangeRateData cloneRateData = new ExchangeRateData();
        cloneRateData.setRoundingMode(rateData.getRoundingMode());
        cloneRateData.setRoundingValue(rateData.getRoundingValue());
        if (rateData.getRateWithCoefficient() != 0.0) {
            cloneRateData.setRateWithCoefficient(1.0 / rateData.getRateWithCoefficient());
        } else {
            cloneRateData.setRateWithCoefficient(rateData.getRateWithCoefficient());
        }
        return MetadataBasedExportHelper.convertSum(MulticurrencyHelper.convert((BigDecimal)fopComponent.getAmount(), (ExchangeRateData)cloneRateData), negate);
    }

    private ExchangeRateData getExchangeRateData(BaseProduct product, FopComponent fopComponent, ContractType contractType) {
        GeneralProductContractRelationData sellContractRelation;
        BaseProduct previousProduct;
        if (product == null || fopComponent == null || contractType == null) {
            return null;
        }
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        BaseProduct sellProduct = handler.getPreviousProduct(product);
        while (sellProduct != null && (previousProduct = handler.getPreviousProduct(sellProduct)) != null) {
            sellProduct = previousProduct;
        }
        if (sellProduct != null && (sellContractRelation = GeneralProductHelper.getContractRelation((BaseProduct)sellProduct, (ContractType)contractType)) != null) {
            ExchangeRateData sellExchangeRateData = sellContractRelation.getGeneralData().getRate();
            FopComponentType type = fopComponent.getType();
            if (sellExchangeRateData != null && type != FopComponentType.PENALTY && !(fopComponent instanceof CategoryFopComponent)) {
                return sellExchangeRateData;
            }
        }
        ExchangeRateData exchangeRateData = null;
        GeneralProductContractRelationData contractRelation = GeneralProductHelper.getContractRelation((BaseProduct)product, (ContractType)contractType);
        if (contractRelation != null) {
            exchangeRateData = contractRelation.getGeneralData().getRate();
        }
        return exchangeRateData;
    }

    private Double getSupplierVatRate(FopComponent fopComponent, BaseProduct product, GeneralProductContractRelationData contractRelation) {
        ContractRelationVatDetalization vat;
        if (fopComponent == null || product == null || contractRelation == null || MiscUtil.guarded((BigDecimal)fopComponent.getAmount()).compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        List allRelations = ProductHandler.of((BaseProduct)product).getUnmodifiableContractRelations(product);
        int idx = allRelations.indexOf(contractRelation);
        if (idx == 0) {
            return null;
        }
        GeneralProductContractRelationData previousRelation = (GeneralProductContractRelationData)allRelations.get(idx - 1);
        if (GeneralProductHelper.getContractType((EntityReference)previousRelation.getDescription()) == ContractType.TECHNICAL_PROVIDER) {
            if (idx - 2 < 0) {
                return null;
            }
            previousRelation = (GeneralProductContractRelationData)allRelations.get(idx - 2);
        }
        if ((vat = previousRelation.getServiceData().getDetalization().getVat()) == null || vat.getComponents().isEmpty()) {
            return null;
        }
        List components = vat.getComponents();
        if (fopComponent instanceof CategoryFopComponent) {
            return null;
        }
        if (FopComponentType.PRODUCT == fopComponent.getType() && fopComponent.isHidden()) {
            return null;
        }
        if (fopComponent instanceof TaxesFopComponent) {
            TaxesFopComponent taxesFopComponent = (TaxesFopComponent)fopComponent;
            for (VatComponent component : components) {
                if (!component.getBasisTypes().contains(VatBasisType.TAXES)) continue;
                for (String uid : component.getTaxesUids()) {
                    String taxCode = previousRelation.getServiceData().getDetalization().getTaxes().stream().filter(t -> t.getUid().equals(uid)).map(SimpleTax::getCode).filter(Objects::nonNull).findFirst().orElse(null);
                    if (taxCode == null || taxesFopComponent.getTaxes() == null || !taxesFopComponent.getTaxes().contains(taxCode)) continue;
                    return component.getRate();
                }
            }
            return null;
        }
        if (FopComponentType.PRODUCT == fopComponent.getType() && !fopComponent.isHidden()) {
            return components.stream().filter(c -> c.getBasisTypes().contains(VatBasisType.FARE)).map(VatComponent::getRate).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (FopComponentType.SERVICE == fopComponent.getType()) {
            return components.stream().filter(c -> c.getBasisTypes().contains(VatBasisType.SERVICE)).map(VatComponent::getRate).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (FopComponentType.PENALTY == fopComponent.getType()) {
            return components.stream().filter(c -> c.getBasisTypes().contains(VatBasisType.PENALTY)).map(VatComponent::getRate).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (FopComponentType.DEDUCTION == fopComponent.getType()) {
            return components.stream().filter(c -> c.getBasisTypes().contains(VatBasisType.DEDUCTION)).map(VatComponent::getRate).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    private BigDecimal getTaxAmount(List<GeneralProductTax> taxes, String taxCode) {
        return taxes.stream().filter(tax -> TextUtil.isSame((String)tax.getCode(), (String)taxCode, (boolean)true)).map(GeneralProductTax::getEquivalentAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
    }

    private FinanceProductExport convertProduct(String referenceUid, BaseProduct product, EntityContainer<Contract> contract, EntityStorageContext storageContext) {
        if (product == null) {
            return null;
        }
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        FinanceProductExport result = new FinanceProductExport();
        result.setUid(product.getUid());
        if (product instanceof AgencyMemoProduct) {
            AgencyMemoProduct vendorAgencyMemo = this.getVendorAgencyMemo((AgencyMemoProduct)product, storageContext, new HashSet<String>());
            if (vendorAgencyMemo != null) {
                result.setSupplier(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)GeneralProductHelper.getSupplier((BaseProduct)vendorAgencyMemo), storageContext));
                result.setVendorContract(this.convertVendorContract((BaseProduct)vendorAgencyMemo, storageContext));
                result.setVendorCommissionEquivalentAmount(this.getVendorEquivalentAmount((BaseProduct)vendorAgencyMemo, GeneralProductHelper.commissionPropertyTypes));
                result.setVendorFeeEquivalentAmount(this.getVendorEquivalentAmount((BaseProduct)vendorAgencyMemo, GeneralProductHelper.feePropertyTypes));
                result.setVendorDiscountEquivalentAmount(this.getVendorEquivalentAmount((BaseProduct)vendorAgencyMemo, GeneralProductHelper.discountPropertyTypes));
            }
        } else {
            result.setSupplier(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)GeneralProductHelper.getSupplier((BaseProduct)product), storageContext));
            result.setVendorContract(this.convertVendorContract(product, storageContext));
            result.setVendorCommissionEquivalentAmount(this.getVendorEquivalentAmount(product, GeneralProductHelper.commissionPropertyTypes));
            result.setVendorFeeEquivalentAmount(this.getVendorEquivalentAmount(product, GeneralProductHelper.feePropertyTypes));
            result.setVendorDiscountEquivalentAmount(this.getVendorEquivalentAmount(product, GeneralProductHelper.discountPropertyTypes));
        }
        result.setIssuingAgent(MetadataBasedExportHelper.convertBasicPerson((EntityReference<Person>)handler.findIssuingAgent(product), storageContext));
        result.setPcc(handler.getPCC(product));
        result.setType(product.getClass().getName());
        result.setCarrierNumber(handler.getCarrierNumber(product));
        result.setNumber(String.join((CharSequence)",", handler.getProductNumbers(product)));
        result.setIssueDate(handler.findIssueDate(product));
        if (product.getReservation() != null) {
            FinanceReservationExport reservation = new FinanceReservationExport();
            result.setReservation(reservation);
            reservation.setUid(product.getReservation().getUid());
            reservation.setNumber(CommonReservationGdsNameInfoHelper.getExport1CRecordLocator((Reservation)product.getReservation()));
            reservation.setCreateDate(product.getReservation().getResDate());
            if (product.getReservation().getBookingFile() != null) {
                FinanceBookingExport booking = new FinanceBookingExport();
                reservation.setBooking(booking);
                booking.setUid(referenceUid);
                booking.setNumber(product.getReservation().getBookingFile().getNumber());
                booking.setCreateDate(product.getReservation().getBookingFile().getCreateDate());
                booking.setCustomer(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile(), storageContext));
            }
        }
        result.setStartDate(handler.getFirstStartDate(product));
        result.setEndDate(handler.getLastEndDate(product));
        BaseProduct firstSellProduct = null;
        BaseProduct previousProduct = handler.getPreviousProduct(product);
        while (previousProduct != null) {
            firstSellProduct = previousProduct;
            previousProduct = handler.getPreviousProduct(previousProduct);
        }
        if (firstSellProduct != null) {
            ContractType contractType;
            GeneralProductContractRelationData contractRelation;
            result.setFirstSellProductNumber(String.join((CharSequence)",", handler.getProductNumbers(firstSellProduct)));
            if (contract != null && (contractRelation = GeneralProductHelper.getContractRelation((BaseProduct)firstSellProduct, (ContractType)(contractType = ((Contract)contract.getEntity()).getContractType()))) != null) {
                List uids = contractRelation.getFops().stream().map(BaseIdentity::getUid).collect(Collectors.toList());
                for (Map.Entry entry : firstSellProduct.getFopDetalizations().entrySet()) {
                    if (!uids.contains(entry.getKey())) continue;
                    List<String> shipmentNumbers = ((FopDetalization)entry.getValue()).getComponents().stream().map(FopComponent::getShipment).filter(Objects::nonNull).distinct().map(ref -> EntityStorageHelper.resolve((EntityReference)ref, (EntityStorageContext)storageContext)).filter(Objects::nonNull).map(s -> ((Shipment)s.getEntity()).getNumber()).collect(Collectors.toList());
                    MetadataBasedExportHelper.convertStringCollection(result.getFirstSellProductShipmentNumbers(), shipmentNumbers);
                }
            }
        }
        return result;
    }

    private AgencyMemoProduct getVendorAgencyMemo(AgencyMemoProduct product, EntityStorageContext context, HashSet<String> visitedProducts) {
        AgencyMemoProduct relatedProduct;
        visitedProducts.add(product.getUid());
        if (this.getAgencyMemoType(product, context) == ContractType.VENDOR) {
            return product;
        }
        if (product.getSupplierAgencyMemo() != null && !visitedProducts.contains(product.getSupplierAgencyMemo().getNestedEntityUid()) && (relatedProduct = (AgencyMemoProduct)EntityStorageHelper.resolve((NestedEntityReference)product.getSupplierAgencyMemo(), (EntityStorageContext)context)) != null) {
            return this.getVendorAgencyMemo(relatedProduct, context, visitedProducts);
        }
        return null;
    }

    private ContractType getAgencyMemoType(AgencyMemoProduct product, EntityStorageContext context) {
        return Optional.ofNullable(product.getContract()).map(contractReference -> EntityStorageHelper.resolve((EntityReference)contractReference, (EntityStorageContext)context)).map(EntityContainer::getEntity).map(Contract::getContractType).orElse(ContractType.CLIENT);
    }

    private BillingItemComponentExport convertBillingItemComponent(BillingItemComponent component) {
        BillingItemComponentExport result = new BillingItemComponentExport();
        for (BillingItemComponentType type : component.getTypes()) {
            if (type == null) continue;
            ReferenceItemExport referenceItemExport = new ReferenceItemExport();
            referenceItemExport.setValue(MetadataBasedExportHelper.convertEnum(type));
            result.getTypes().add(referenceItemExport);
        }
        result.setAmount(MetadataBasedExportHelper.convertVatAmount(component.getAmount()));
        return result;
    }

    private FinanceContractExport convertVendorContract(BaseProduct product, EntityStorageContext storageContext) {
        GeneralProductContractRelationData contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
        if (contractRelation == null) {
            return null;
        }
        EntityReference contractReference = contractRelation.getGeneralData().getContractData().getContract();
        EntityContainer contractContainer = EntityStorageHelper.resolve((EntityReference)contractReference, (EntityStorageContext)storageContext);
        if (EntityStorageHelper.isEmpty((EntityContainer)contractContainer)) {
            return null;
        }
        ContractCustomerInfo contractCustomerInfo = null;
        if (!((Contract)contractContainer.getEntity()).isNewModel() && product.getReservation() != null && product.getReservation().getBookingFile() != null) {
            contractCustomerInfo = ProfileHelper.getContractCustomerInfo((EntityReference)contractContainer.toReference(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        }
        return FinanceExportHelper.convertContract((EntityContainer<Contract>)contractContainer, contractCustomerInfo, storageContext);
    }

    private BillingItemFopComponentExport convertFopComponent(FopComponent fopComponent, BaseProduct product, GeneralProductContractRelationData contractRelation, ExchangeRateData exchangeRateData, String baseCurrency, BigDecimal baseAmount, boolean negate) {
        if (fopComponent == null) {
            return null;
        }
        BigDecimal amount = MetadataBasedExportHelper.convertSum(fopComponent.getAmount(), negate);
        BigDecimal vat = MetadataBasedExportHelper.convertSum(fopComponent.getVatAmount(), negate);
        ArrayList<BigDecimal> supplierVatRates = new ArrayList<BigDecimal>();
        VatAmount vatAmount = fopComponent.getVatRate() != null ? VatAmount.of((BigDecimal)amount, (BigDecimal)vat, (double)fopComponent.getVatRate()) : (vat != null ? VatAmount.of((BigDecimal)amount, (BigDecimal)vat) : VatAmount.of((BigDecimal)amount));
        Double supplierVatRate = this.getSupplierVatRate(fopComponent, product, contractRelation);
        if (supplierVatRate != null) {
            supplierVatRates.add(BigDecimal.valueOf(supplierVatRate).setScale(2, RoundingMode.HALF_UP));
        }
        BillingItemFopComponentExport result = new BillingItemFopComponentExport();
        result.setNomenclature(MetadataBasedExportHelper.convertDictionary(fopComponent.getNomenclature()));
        result.setHidden(Boolean.valueOf(fopComponent.isHidden()));
        result.setAmount(MetadataBasedExportHelper.convertVatAmount(vatAmount, baseAmount, exchangeRateData, supplierVatRates, baseCurrency));
        return result;
    }

    private BigDecimal getVendorEquivalentAmount(BaseProduct baseProduct, Set<Class<? extends BaseCommissionProperties>> properties) {
        EntityReference blankOwner = GeneralProductHelper.getBlankOwner((BaseProduct)baseProduct);
        EntityReference supplier = GeneralProductHelper.getSupplier((BaseProduct)baseProduct);
        boolean isSubagency = blankOwner != null && supplier != null && !blankOwner.equals((Object)supplier);
        Collection commissions = GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getVendorCommissions((BaseProduct)baseProduct), properties, null, null);
        BigDecimal result = MetadataBasedExportHelper.convertSum(GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)commissions));
        if (!properties.contains(CommissionProperties.class) || !(baseProduct instanceof Product)) {
            return result;
        }
        Product product = (Product)baseProduct;
        BigDecimal bspCommissionValue = this.getBSPCommissionValue(product);
        if (bspCommissionValue == null) {
            return result;
        }
        Collection bspCommissions = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), null, (Set)GeneralProductHelper.bspCommissionTypes, null);
        BigDecimal calculateBspCommissionValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)bspCommissions);
        if (calculateBspCommissionValue == null) {
            calculateBspCommissionValue = BigDecimal.ZERO;
        }
        if (isSubagency && this.containsSubagencyCommission(commissions)) {
            bspCommissionValue = BigDecimal.ZERO;
        }
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, calculateBspCommissionValue.negate(), bspCommissionValue});
    }

    private BigDecimal getBSPCommissionValue(Product product) {
        if (!AirProductHelper.isBSPTicket((Product)product)) {
            return null;
        }
        if (product.getBspCommissionValue() == null || product.getBspCommissionValue().getCurrency() == null) {
            return null;
        }
        return product.getBspCommissionValue().getValue();
    }

    private boolean containsSubagencyCommission(Collection<GeneralProductCommission> commissions) {
        for (GeneralProductCommission commission : commissions) {
            EntityContainer commissionPropertiesContainer;
            if (commission.getCommissionProperties() == null || !CommissionProperties.class.equals((Object)commission.getCommissionProperties().getType()) || (commissionPropertiesContainer = EntityStorage.get().resolve(commission.getCommissionProperties())) == null || !((CommissionProperties)commissionPropertiesContainer.getEntity()).isSubagencyCommission() || ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission()) continue;
            return true;
        }
        return false;
    }
}

