/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceDocumentExport;
import com.gridnine.xtrip.common.model.export.profile.v2.BankAccountExport;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.finance.FinanceExportHelper;

public class FinanceExportFillProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FinanceDocumentExport financeDocumentExport = (FinanceDocumentExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        FinanceDocument financeDocument = (FinanceDocument)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT);
        EntityContainer financeDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        Boolean deleted = (Boolean)ctx.getObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_DELETED);
        financeDocumentExport.setDeleted(deleted);
        financeDocumentExport.setUid(financeDocumentContainer.getUid());
        financeDocumentExport.setNumber(financeDocument.getNumber());
        financeDocumentExport.setName(financeDocument.getName());
        financeDocumentExport.setDate(financeDocument.getDate());
        financeDocumentExport.setType(MetadataBasedExportHelper.convertEnum(financeDocument.getType()));
        financeDocumentExport.setSupplier(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)financeDocument.getSupplier(), storageContext));
        financeDocumentExport.setCustomer(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)financeDocument.getCustomer(), storageContext));
        financeDocumentExport.setPayer(FinanceExportHelper.convertPayer((EntityReference<? extends BaseProfile>)financeDocument.getPayer(), storageContext));
        financeDocumentExport.setAgent(MetadataBasedExportHelper.convertBasicPerson((EntityReference<Person>)financeDocument.getAgent(), storageContext));
        financeDocumentExport.setPayerBankAccount(this.convertBankAccount((NestedEntityReference<Organization, BankAccount>)financeDocument.getPayerBankAccount(), storageContext));
        financeDocumentExport.setSupplierBankAccount(this.convertBankAccount((NestedEntityReference<Organization, BankAccount>)financeDocument.getSupplierBankAccount(), storageContext));
    }

    private BankAccountExport convertBankAccount(NestedEntityReference<Organization, BankAccount> reference, EntityStorageContext storageContext) {
        BankAccount bankAccount = MetadataBasedExportHelper.resolve(reference, storageContext, this.log);
        if (bankAccount == null) {
            return null;
        }
        BankAccountExport accountExport = new BankAccountExport();
        accountExport.setBankName(bankAccount.getBankName());
        accountExport.setBik(bankAccount.getBik());
        accountExport.setCity(MetadataBasedExportHelper.convertDictionary(bankAccount.getCity()));
        accountExport.setCorrespondentAccount(bankAccount.getCorrespondentAccount());
        accountExport.setCurrencyCode(bankAccount.getCurrency());
        accountExport.setSettlementAccount(bankAccount.getSettlementAccount());
        return accountExport;
    }
}

