/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.export.finance.v2.BasicOrganizationExport;
import com.gridnine.xtrip.common.model.export.finance.v2.BasicPersonExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceContractExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinancePayerExport;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;

class FinanceExportHelper {
    public static final String CREATION_DATE = "${creationDate}";
    public static final String NUMBER = "${number}";

    FinanceExportHelper() {
    }

    static FinanceContractExport convertContract(EntityContainer<Contract> contactContainer, ContractCustomerInfo contractCustomerInfo, EntityStorageContext storageContext) {
        if (EntityStorageHelper.isEmpty(contactContainer)) {
            return null;
        }
        FinanceContractExport contractExport = new FinanceContractExport();
        Contract contract = (Contract)contactContainer.getEntity();
        contractExport.setUid(contract.getUid());
        contractExport.setName(contract.getName());
        contractExport.setContractType(MetadataBasedExportHelper.convertEnum(contract.getContractType()));
        contractExport.setAgreementType(MetadataBasedExportHelper.convertEnum(contract.getAgreementType()));
        contractExport.setAgreementType(MetadataBasedExportHelper.convertEnum(contract.getAgreementType()));
        if (contract.getPaymentCurrency() != null) {
            contractExport.setCurrency(contract.getPaymentCurrency());
        } else {
            contractExport.setCurrency(DictHelper.getEquivCurrency());
        }
        if (contractCustomerInfo != null) {
            contractExport.setNumber(contractCustomerInfo.getNumber());
            contractExport.setIssueDate(contractCustomerInfo.getIssueDate());
            contractExport.setStartDate(contractCustomerInfo.getStartDate());
            contractExport.setEndDate(contractCustomerInfo.getEndDate());
            contractExport.setCustomer(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)contractCustomerInfo.getCustomer(), storageContext));
        } else if (contract.isNewModel()) {
            contractExport.setNumber(contract.getNumber());
            contractExport.setIssueDate(contract.getIssueDate());
            contractExport.setStartDate(contract.getStartDate());
            contractExport.setEndDate(contract.getEndDate());
            contractExport.setCustomer(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)contract.getCustomer(), storageContext));
        }
        contractExport.setSupplier(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)contract.getSupplier(), storageContext));
        return contractExport;
    }

    static FinancePayerExport convertPayer(EntityReference<? extends BaseProfile> reference, EntityStorageContext context) {
        if (reference == null) {
            return null;
        }
        FinancePayerExport payerExport = new FinancePayerExport();
        payerExport.setUid(reference.getUid());
        payerExport.setType(reference.getType().getSimpleName());
        if (Organization.class.isAssignableFrom(reference.getType())) {
            EntityReference<? extends BaseProfile> payerOrg = reference;
            BasicOrganizationExport organizationExport = MetadataBasedExportHelper.convertBasicOrganization(payerOrg, context);
            payerExport.setCode(organizationExport.getCode());
            payerExport.setRegistrationId(organizationExport.getRegistrationId());
            payerExport.setKpp(organizationExport.getKpp());
            payerExport.setForeign(organizationExport.getForeign());
            payerExport.getShortName().clear();
            payerExport.getShortName().addAll(organizationExport.getShortName());
            payerExport.getFullName().clear();
            payerExport.getFullName().addAll(organizationExport.getFullName());
            payerExport.setBeneficiaryCode(organizationExport.getBeneficiaryCode());
        }
        if (Person.class.isAssignableFrom(reference.getType())) {
            EntityReference<? extends BaseProfile> payerPer = reference;
            BasicPersonExport personExport = MetadataBasedExportHelper.convertBasicPerson(payerPer, context);
            payerExport.setCode(personExport.getCode());
            payerExport.getLastName().clear();
            payerExport.getLastName().addAll(personExport.getLastName());
            payerExport.getFirstName().clear();
            payerExport.getFirstName().addAll(personExport.getFirstName());
            payerExport.getSecondName().clear();
            payerExport.getSecondName().addAll(personExport.getSecondName());
            payerExport.getMiddleName().clear();
            payerExport.getMiddleName().addAll(personExport.getMiddleName());
        }
        return payerExport;
    }
}

