/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.export.finance.v2.FinancePassportExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceTravellerExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceTravellerProfileExport;
import com.gridnine.xtrip.common.model.export.profile.v2.CommunicationExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PersonCommunicationExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PersonPassportNameItemExport;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PassportCorrelationQualifier;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonPassportWrapper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import java.util.List;

public class FinanceTravellerExportProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.TRAVELLER);
        List travellerExports = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_TRAVELLERS_EXPORT);
        travellerExports.add(this.convertTraveller(traveller, storageContext));
    }

    private FinanceTravellerExport convertTraveller(Traveller traveller, EntityStorageContext storageContext) {
        FinanceTravellerExport travellerExport = new FinanceTravellerExport();
        travellerExport.setUid(traveller.getUid());
        travellerExport.setProfile(this.convertPassenger((EntityReference<Person>)traveller.getPassenger(), storageContext));
        return travellerExport;
    }

    private FinanceTravellerProfileExport convertPassenger(EntityReference<Person> personRef, EntityStorageContext storageContext) {
        EntityContainer person = EntityStorageHelper.resolve(personRef, (EntityStorageContext)storageContext);
        if (person == null) {
            return null;
        }
        FinanceTravellerProfileExport profileExport = new FinanceTravellerProfileExport();
        profileExport.setGender(MetadataBasedExportHelper.convertEnum(((Person)person.getEntity()).getGender()));
        profileExport.setBirthday(((Person)person.getEntity()).getBirthday());
        MetadataBasedExportHelper.convertL10nStringCollection(profileExport.getLastName(), ((Person)person.getEntity()).getLastName());
        MetadataBasedExportHelper.convertL10nStringCollection(profileExport.getFirstName(), ((Person)person.getEntity()).getFirstName());
        MetadataBasedExportHelper.convertL10nStringCollection(profileExport.getMiddleName(), ((Person)person.getEntity()).getMiddleName());
        for (PersonCommunication communication : ((Person)person.getEntity()).getCommunications()) {
            CommunicationExport communicationExport = new CommunicationExport();
            communicationExport.setView(communication.getView());
            communicationExport.setType(MetadataBasedExportHelper.convertEnum(communication.getType()));
            communicationExport.setSense(communication.getSense());
            communicationExport.setInternalNumber(communication.getInternalNumber());
            communicationExport.setCountryCode(communication.getCountryCode());
            communicationExport.setCityCode(communication.getCityCode());
            PersonCommunicationExport personCommunicationExport = new PersonCommunicationExport();
            personCommunicationExport.setCommunication(communicationExport);
            personCommunicationExport.setOrganization(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)communication.getOrganization()));
            profileExport.getCommunications().add(personCommunicationExport);
        }
        List passports = PersonPassportWrapper.wrap((List)((Person)person.getEntity()).getPassports());
        for (PersonPassportWrapper passport : passports) {
            PersonPassportNameItemExport name;
            FinancePassportExport passportExport = new FinancePassportExport();
            passportExport.setType(MetadataBasedExportHelper.convertEnum(passport.getType()));
            passportExport.setNumber(passport.getNumber());
            passportExport.setBirthday(passport.getBirthday());
            passportExport.setCitizenship(MetadataBasedExportHelper.convertDictionary(passport.getCitizenship()));
            passportExport.setIssueDate(passport.getIssued());
            passportExport.setExpirationDate(passport.getExpired());
            passportExport.setOriginCountry(MetadataBasedExportHelper.convertDictionary(passport.getOriginCountry()));
            if (TextUtil.nonBlank((String)passport.getFirstNameCyrillic())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.CYRILLIC.name().toLowerCase());
                name.setValue(passport.getFirstNameCyrillic());
                passportExport.getFirstNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getLastNameCyrillic())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.CYRILLIC.name().toLowerCase());
                name.setValue(passport.getLastNameCyrillic());
                passportExport.getLastNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getMiddleNameCyrillic())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.CYRILLIC.name().toLowerCase());
                name.setValue(passport.getMiddleNameCyrillic());
                passportExport.getMiddleNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getFirstNameLatin())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.LATIN.name().toLowerCase());
                name.setValue(passport.getFirstNameLatin());
                passportExport.getFirstNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getLastNameLatin())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.LATIN.name().toLowerCase());
                name.setValue(passport.getLastNameLatin());
                passportExport.getLastNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getMiddleNameLatin())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.LATIN.name().toLowerCase());
                name.setValue(passport.getMiddleNameLatin());
                passportExport.getMiddleNames().add(name);
            }
            profileExport.getPassports().add(passportExport);
        }
        return profileExport;
    }
}

