/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.finance;

import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceFopExport;
import com.gridnine.xtrip.common.model.export.finance.v2.PaymentItemExport;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import java.util.Collection;

public class PaymentItemExportProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        NestedEntityReference paymentItemReference = (NestedEntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEM);
        Collection paymentItemExportDocuments = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEM_EXPORT_DOCUMENTS);
        PaymentItem paymentItem = (PaymentItem)MetadataBasedExportHelper.resolve(paymentItemReference, storageContext, this.log);
        PaymentItemExport paymentItemExport = new PaymentItemExport();
        if (paymentItem != null) {
            paymentItemExport.setUid(paymentItem.getUid());
            paymentItemExport.setAmount(MetadataBasedExportHelper.convertMoney(paymentItem.getAmount()));
            paymentItemExport.setPaymentType(MetadataBasedExportHelper.convertEnum(paymentItem.getPaymentType()));
            for (NestedEntityReference fop : paymentItem.getFops()) {
                FinanceFopExport fopExport = MetadataBasedExportHelper.convertFop((NestedEntityReference<BookingFile, Fop>)fop, storageContext, this.log);
                if (fopExport == null) continue;
                paymentItemExport.getFops().add(fopExport);
            }
        } else {
            paymentItemExport.setUid(paymentItemReference.getUid());
        }
        paymentItemExportDocuments.add(paymentItemExport);
    }
}

