/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.finance.v2.ShipmentExport;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.finance.FinanceExportHelper;
import java.util.Objects;
import java.util.stream.Collectors;

public class ShipmentExportFillProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ShipmentExport shipmentExport = (ShipmentExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        EntityContainer shipmentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        Boolean deleted = (Boolean)ctx.getObject((Enum)IBusFinanceContextKeys.SHIPMENT_DELETED);
        shipmentExport.setDeleted(deleted);
        shipmentExport.setUid(shipmentContainer.getUid());
        Shipment shipment = (Shipment)shipmentContainer.getEntity();
        shipmentExport.setNumber(shipment.getNumber());
        shipmentExport.setDate(shipment.getDate());
        shipmentExport.setCorrection(Boolean.valueOf(shipment.isCorrection()));
        shipmentExport.setNotes(shipment.getNotes());
        shipmentExport.getCategories().clear();
        shipmentExport.getCategories().addAll(shipment.getCategories().stream().map(MetadataBasedExportHelper::convertDictionary).filter(Objects::nonNull).map(ref -> {
            ReferenceItemExport referenceItemExport = new ReferenceItemExport();
            referenceItemExport.setValue(ref);
            return referenceItemExport;
        }).collect(Collectors.toList()));
        shipmentExport.setSupplier(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)shipment.getSupplier(), storageContext));
        shipmentExport.setCustomer(MetadataBasedExportHelper.convertBasicOrganization((EntityReference<Organization>)shipment.getCustomer(), storageContext));
        shipmentExport.setPayer(FinanceExportHelper.convertPayer((EntityReference<? extends BaseProfile>)shipment.getPayer(), storageContext));
        shipmentExport.setAgent(MetadataBasedExportHelper.convertBasicPerson((EntityReference<Person>)shipment.getAgent(), storageContext));
        shipmentExport.setCategoryAgent(MetadataBasedExportHelper.convertBasicPerson((EntityReference<Person>)shipment.getCategoryAgent(), storageContext));
        shipmentExport.setCurrency(MetadataBasedExportHelper.convertDictionary(shipment.getCurrency()));
        shipmentExport.setPaymentCode(shipment.getCategoryPaymentCode());
        this.convertContract((NestedEntityReference<Contract, ContractCustomerInfo>)shipment.getContract(), shipmentExport, storageContext);
    }

    private void convertContract(NestedEntityReference<Contract, ContractCustomerInfo> contractRef, ShipmentExport shipmentExport, EntityStorageContext storageContext) {
        EntityContainer contractCont = EntityStorageHelper.resolve(contractRef, (EntityStorageContext)storageContext);
        ContractCustomerInfo contractCustomerInfo = MetadataBasedExportHelper.resolve(contractRef, storageContext, this.log);
        shipmentExport.setContract(FinanceExportHelper.convertContract((EntityContainer<Contract>)contractCont, contractCustomerInfo, storageContext));
    }
}

