/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.DictionaryCompressedData;
import com.gridnine.xtrip.common.model.export.ElementExportSettings;
import com.gridnine.xtrip.common.model.export.EntityCompressedData;
import com.gridnine.xtrip.common.model.export.ExportCategory;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.ObjectFilterType;
import com.gridnine.xtrip.common.model.export.finance.v2.ShipmentExport;
import com.gridnine.xtrip.common.model.export.xml.MetadataBasedExportObjectsXmlHelper;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.export.v2.ShipmentXmlExportSettings;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.export.RootEntityExportHandler;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ShipmentXmlExportHandler
implements RootEntityExportHandler<Shipment, ShipmentXmlExportSettings> {
    @Override
    @Deprecated
    public byte[] export(EntityCompressedData object, EntityCompressedData previousVersion, List<EntityCompressedData> referencedEntities, List<DictionaryCompressedData> referencedDictionaries, EntityContainer<ShipmentXmlExportSettings> settings, List<Message> messages) throws Exception {
        return new byte[0];
    }

    @Override
    public boolean accept(Shipment entity, ShipmentXmlExportSettings settings) throws Exception {
        if (settings.getOrganizationFilterType() == ObjectFilterType.ALL_EXCEPT && entity.getSupplier() != null && settings.getOrganizations().contains(entity.getSupplier())) {
            return false;
        }
        return settings.getOrganizationFilterType() != ObjectFilterType.ONLY || entity.getSupplier() != null && settings.getOrganizations().contains(entity.getSupplier());
    }

    @Override
    public byte[] createContent(EntityContainer<Shipment> objectCtr, EntityContainer<Shipment> oldObjectCtr, boolean deleted, EntityContainer<ShipmentXmlExportSettings> settings, List<Message> messages, EntityStorageContext storageContext) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ShipmentExport shipmentExport = new ShipmentExport();
        ctx.put(IBusStandardContextKeys.EXPORTED_OBJECT.name(), shipmentExport);
        ctx.put(IBusFinanceContextKeys.SHIPMENT_CONTAINER.name(), objectCtr);
        ctx.put(IBusFinanceContextKeys.SHIPMENT.name(), objectCtr.getEntity());
        ctx.put(IBusStandardContextKeys.EXPORT_SETTINGS.name(), settings.getEntity());
        ctx.put(IBusFinanceContextKeys.SHIPMENT_DELETED.name(), deleted);
        ctx.put(IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT.name(), storageContext);
        IntegrationBusFacade.get().processRouteSync("export:finance:export-shipment", ctx);
        String result = MetadataBasedExportObjectsXmlHelper.generateXml((BaseEntityExport)shipmentExport, (ElementExportSettings)((ShipmentXmlExportSettings)settings.getEntity()).getRootExportSettings());
        return result.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String updateFileNamePrefix(String prefix, EntityContainer<ExportDocument> exportDocumentCtr) throws Exception {
        byte[] unzippedContent;
        EntityContainer shipmentContainer;
        String result = prefix;
        Shipment shipment = null;
        if ((prefix.contains("${number}") || prefix.contains("${creationDate}")) && ((ExportDocument)exportDocumentCtr.getEntity()).getObject() != null && ((ExportDocument)exportDocumentCtr.getEntity()).getObject().getContent() != null && EntityStorageHelper.nonEmpty((EntityContainer)(shipmentContainer = (EntityContainer)XUtil.deserialize((byte[])(unzippedContent = GZIPUtil.gunzip((byte[])((ExportDocument)exportDocumentCtr.getEntity()).getObject().getContent())))))) {
            shipment = (Shipment)shipmentContainer.getEntity();
        }
        if (shipment != null) {
            String number;
            if (result.contains("${number}") && TextUtil.nonBlank((String)(number = shipment.getNumber()))) {
                result = result.replace("${number}", number).trim().replaceAll(" ", "_");
            }
            if (result.contains("${creationDate}")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date date = shipment.getDate();
                if (date != null) {
                    result = result.replace("${creationDate}", sdf.format(date));
                }
            }
        }
        return RootEntityExportHandler.super.updateFileNamePrefix(result, exportDocumentCtr);
    }

    @Override
    public boolean isExportDeletedObjects(ShipmentXmlExportSettings settings) {
        return settings.isCreateDeleteDocuments();
    }

    @Override
    public Class<Shipment> getEntityType() {
        return Shipment.class;
    }

    @Override
    public ExportCategory getExportCategory() {
        return ExportCategory.SHIPMENTS_XML;
    }

    @Override
    public Class<ShipmentXmlExportSettings> getSettingsClass() {
        return ShipmentXmlExportSettings.class;
    }
}

