/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.export.DictionaryCompressedData;
import com.gridnine.xtrip.common.model.export.EntityCompressedData;
import com.gridnine.xtrip.common.model.export.ExportCategory;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.ObjectFilterType;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.export.v2.TemplateBasedShipmentExportSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.export.RootEntityExportHandler;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.xml.MarkupBuilder;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class TemplateBasedShipmentExportHandler
implements RootEntityExportHandler<Shipment, TemplateBasedShipmentExportSettings> {
    @Override
    public byte[] export(EntityCompressedData object, EntityCompressedData previousVersion, List<EntityCompressedData> referencedEntities, List<DictionaryCompressedData> referencedDictionaries, EntityContainer<TemplateBasedShipmentExportSettings> settings, List<Message> messages) throws Exception {
        return new byte[0];
    }

    @Override
    public boolean accept(Shipment entity, TemplateBasedShipmentExportSettings settings) throws Exception {
        if (settings.getOrganizationFilterType() == ObjectFilterType.ALL_EXCEPT && entity.getCustomer() != null && settings.getOrganizations().contains(entity.getCustomer())) {
            return false;
        }
        return settings.getOrganizationFilterType() != ObjectFilterType.ONLY || entity.getCustomer() != null && settings.getOrganizations().contains(entity.getCustomer());
    }

    @Override
    public String updateFileNamePrefix(String prefix, EntityContainer<ExportDocument> exportDocumentCtr) throws Exception {
        String number;
        byte[] unzippedContent;
        EntityContainer shipmentContainer;
        if (prefix.contains("${number}") && ((ExportDocument)exportDocumentCtr.getEntity()).getObject() != null && ((ExportDocument)exportDocumentCtr.getEntity()).getObject().getContent() != null && EntityStorageHelper.nonEmpty((EntityContainer)(shipmentContainer = (EntityContainer)XUtil.deserialize((byte[])(unzippedContent = GZIPUtil.gunzip((byte[])((ExportDocument)exportDocumentCtr.getEntity()).getObject().getContent()))))) && TextUtil.nonBlank((String)(number = ((Shipment)shipmentContainer.getEntity()).getNumber()))) {
            return prefix.replace("${number}", number).trim().replaceAll(" ", "_");
        }
        return RootEntityExportHandler.super.updateFileNamePrefix(prefix, exportDocumentCtr);
    }

    @Override
    public byte[] createContent(EntityContainer<Shipment> objectCtr, EntityContainer<Shipment> oldObjectCtr, boolean deleted, EntityContainer<TemplateBasedShipmentExportSettings> settings, List<Message> messages, EntityStorageContext storageContext) throws Exception {
        if (objectCtr != null) {
            StringWriter writer = new StringWriter();
            Binding binding = new Binding();
            binding.setProperty("xml", (Object)new MarkupBuilder((Writer)writer));
            binding.setProperty("shipment", (Object)objectCtr.getEntity());
            new GroovyShell(binding).evaluate(new String(((TemplateBasedShipmentExportSettings)settings.getEntity()).getTemplate(), StandardCharsets.UTF_8));
            return writer.toString().getBytes(StandardCharsets.UTF_8);
        }
        return new byte[0];
    }

    @Override
    public boolean isExportDeletedObjects(TemplateBasedShipmentExportSettings settings) {
        return settings.isCreateDeleteDocuments();
    }

    @Override
    public Class<Shipment> getEntityType() {
        return Shipment.class;
    }

    @Override
    public ExportCategory getExportCategory() {
        return ExportCategory.TEMPLATE_BASED_SHIPMENTS_XML;
    }

    @Override
    public Class<TemplateBasedShipmentExportSettings> getSettingsClass() {
        return TemplateBasedShipmentExportSettings.class;
    }
}

