/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.organization;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.profile.v2.AddressExport;
import com.gridnine.xtrip.common.model.export.profile.v2.BankAccountExport;
import com.gridnine.xtrip.common.model.export.profile.v2.BillingItemSettingsExport;
import com.gridnine.xtrip.common.model.export.profile.v2.CommunicationExport;
import com.gridnine.xtrip.common.model.export.profile.v2.CostCodePropertiesExport;
import com.gridnine.xtrip.common.model.export.profile.v2.FinanceDocumentSettingsExport;
import com.gridnine.xtrip.common.model.export.profile.v2.FinanceDocumentsPropertiesExport;
import com.gridnine.xtrip.common.model.export.profile.v2.ManagerExport;
import com.gridnine.xtrip.common.model.export.profile.v2.OrganizationContractExport;
import com.gridnine.xtrip.common.model.export.profile.v2.OrganizationExport;
import com.gridnine.xtrip.common.model.export.profile.v2.ProfileKeyContactPersonExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreProfileCommand1FnbtsExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreProfileCommand2OsiExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreProfileCommand3WtExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreProfileCommand4SSRExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreProfileLineExport;
import com.gridnine.xtrip.common.model.export.profile.v2.WorkModeExport;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.BillingItemsSplitParameterType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.profile.Manager;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand1Fnbts;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand3Wt;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand4SSR;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.WorkMode;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import java.util.Collection;
import java.util.List;

public class OrganizationExportFillHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OrganizationExport organizationExport = (OrganizationExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        Organization organization = (Organization)ctx.getMandatoryObject((Enum)IBusProfileContextKeys.ORGANIZATION);
        EntityContainer organizationCtr = (EntityContainer)ctx.getObject(IBusProfileContextKeys.ORGANIZATION_CONTAINER.name());
        organizationExport.setCode(organization.getCode());
        MetadataBasedExportHelper.convertL10nStringCollection(organizationExport.getShortName(), organization.getShortName());
        MetadataBasedExportHelper.convertL10nStringCollection(organizationExport.getFullName(), organization.getFullName());
        organizationExport.setLegalForm(MetadataBasedExportHelper.convertDictionary(organization.getLegalForm()));
        for (Manager manager : organization.getManagers()) {
            ManagerExport managerExport = new ManagerExport();
            managerExport.setName(manager.getName());
            managerExport.setType(MetadataBasedExportHelper.convertEnum(manager.getType()));
            organizationExport.getManagers().add(managerExport);
        }
        for (WorkMode workMode : organization.getWorkModes()) {
            WorkModeExport workModeExport = new WorkModeExport();
            workModeExport.setFinishTime(workMode.getFinishTime());
            workModeExport.setStartTime(workMode.getStartTime());
            workModeExport.setWorkModeType(MetadataBasedExportHelper.convertEnum(workMode.getWorkModeType()));
            organizationExport.getWorkModes().add(workModeExport);
        }
        for (Address address : organization.getAddresses()) {
            AddressExport addressExport = new AddressExport();
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getAddress(), address.getAddress());
            addressExport.setAddressType(MetadataBasedExportHelper.convertEnum(address.getAddressType()));
            addressExport.setStartDate(address.getStartDate());
            addressExport.setEndDate(address.getEndDate());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getBuilding(), address.getBuilding());
            addressExport.setCity(MetadataBasedExportHelper.convertDictionary(address.getCity()));
            addressExport.setCountry(MetadataBasedExportHelper.convertDictionary(address.getCountry()));
            addressExport.setDeliveryRegion(MetadataBasedExportHelper.convertDictionary(address.getDeliveryRegion()));
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getDistrict(), address.getDistrict());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getFlat(), address.getFlat());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getHouse(), address.getHouse());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getHousing(), address.getHousing());
            addressExport.setMetroStation(MetadataBasedExportHelper.convertDictionary(address.getMetroStation()));
            addressExport.setNotes(address.getNotes());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getOffice(), address.getOffice());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getPavilion(), address.getPavilion());
            MetadataBasedExportHelper.convertGeoRegion(addressExport.getRegion(), (DictionaryReference<GeoRegion>)address.getRegion());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getTown(), address.getTown());
            addressExport.setPoBox(address.getPoBox());
            addressExport.setZip(address.getZip());
            organizationExport.getAddresses().add(addressExport);
        }
        for (Communication communication : organization.getCommunications()) {
            CommunicationExport communicationExport = new CommunicationExport();
            communicationExport.setCityCode(communication.getCityCode());
            communicationExport.setCountryCode(communication.getCountryCode());
            communicationExport.setInternalNumber(communication.getInternalNumber());
            communicationExport.setSense(communication.getSense());
            communicationExport.setType(MetadataBasedExportHelper.convertEnum(communication.getType()));
            communicationExport.setView(communication.getView());
            organizationExport.getCommunications().add(communicationExport);
        }
        for (BankAccount account : organization.getBankAccounts()) {
            organizationExport.getBankAccounts().add(this.getBankAccountExport(account));
        }
        for (SabreProfileLine sabreProfileLine : organization.getSabreAdditionalProfileLines()) {
            SabreProfileLineExport sabreProfileLineExport = new SabreProfileLineExport();
            sabreProfileLineExport.setLineBody(sabreProfileLine.getLineBody());
            sabreProfileLineExport.setLineFlag(sabreProfileLine.getLineFlag());
            sabreProfileLineExport.setLineServiceType(MetadataBasedExportHelper.convertEnum(sabreProfileLine.getLineServiceType()));
            sabreProfileLineExport.setLineSubsection(sabreProfileLine.getLineSubsection());
            sabreProfileLineExport.setLineType(MetadataBasedExportHelper.convertEnum(sabreProfileLine.getLineType()));
            organizationExport.getSabreProfileLines().add(sabreProfileLineExport);
        }
        organizationExport.setAirline(MetadataBasedExportHelper.convertDictionary(organization.getAirline()));
        for (ProfileKeyContactPerson keyContact : organization.getKeyContacts()) {
            ProfileKeyContactPersonExport keyContactExport = new ProfileKeyContactPersonExport();
            keyContactExport.setEmailType(MetadataBasedExportHelper.convertEnum(keyContact.getEmailType()));
            keyContactExport.setLineType(MetadataBasedExportHelper.convertEnum(keyContact.getLineType()));
            keyContactExport.setPerson(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)keyContact.getPerson()));
            organizationExport.getProfileKeyContactPersons().add(keyContactExport);
        }
        for (SabreProfileCommand1Fnbts command1Fnbts : organization.getSabreAdditionalCommand1Lines()) {
            SabreProfileCommand1FnbtsExport command1FnbtsExport = new SabreProfileCommand1FnbtsExport();
            command1FnbtsExport.setEntry1(command1Fnbts.getEntry1());
            command1FnbtsExport.setEntry2(command1Fnbts.getEntry2());
            command1FnbtsExport.setEntry3(command1Fnbts.getEntry3());
            command1FnbtsExport.setEntry4(command1Fnbts.getEntry4());
            command1FnbtsExport.setEntry5(command1Fnbts.getEntry5());
            organizationExport.getSabreProfileCommand1Fnbts().add(command1FnbtsExport);
        }
        for (SabreProfileCommand2Osi command2Osi : organization.getSabreAdditionalCommand2Lines()) {
            SabreProfileCommand2OsiExport command2OsiExport = new SabreProfileCommand2OsiExport();
            command2OsiExport.setEntry1(command2Osi.getEntry1());
            command2OsiExport.setEntry2(command2Osi.getEntry2());
            command2OsiExport.setLineType(MetadataBasedExportHelper.convertEnum(command2Osi.getLineType()));
            organizationExport.getSabreProfileCommand2Osis().add(command2OsiExport);
        }
        for (SabreProfileCommand3Wt command3Wt : organization.getSabreAdditionalCommand3Lines()) {
            SabreProfileCommand3WtExport command3WtExport = new SabreProfileCommand3WtExport();
            command3WtExport.setEntry1(command3Wt.getEntry1());
            command3WtExport.setEntry2(command3Wt.getEntry2());
            command3WtExport.setEntry3(command3Wt.getEntry3());
            organizationExport.getSabreProfileCommand3Wts().add(command3WtExport);
        }
        for (SabreProfileCommand4SSR command4SSR : organization.getSabreAdditionalCommand4Lines()) {
            SabreProfileCommand4SSRExport command4SSRExport = new SabreProfileCommand4SSRExport();
            command4SSRExport.setLineType(MetadataBasedExportHelper.convertEnum(command4SSR.getLineType()));
            command4SSRExport.setSsrCode(command4SSR.getSsrCode());
            command4SSRExport.setSsrInfo(command4SSR.getSsrInfo());
            organizationExport.getSabreProfileCommand4SSRs().add(command4SSRExport);
        }
        for (CostCodeProperties costCodeProperties : organization.getCostCodeProperties()) {
            CostCodePropertiesExport propertiesExport = new CostCodePropertiesExport();
            propertiesExport.setCategory(MetadataBasedExportHelper.convertDictionary(costCodeProperties.getCategory()));
            if (costCodeProperties.getConstraintsSet() != null) {
                propertiesExport.setConstraintsSetUID(costCodeProperties.getConstraintsSet().getUid());
            }
            propertiesExport.setDisplayType(MetadataBasedExportHelper.convertEnum(costCodeProperties.getDisplayType()));
            propertiesExport.setDontSyncToSabre(Boolean.valueOf(costCodeProperties.isDontSyncToSabre()));
            propertiesExport.setIncludeToInvoice(Boolean.valueOf(costCodeProperties.isIncludeToInvoice()));
            propertiesExport.setLocalSabreValue(costCodeProperties.getLocalSabreValue());
            propertiesExport.setMask(costCodeProperties.getMask());
            propertiesExport.setName(costCodeProperties.getName());
            propertiesExport.setCommon(Boolean.valueOf(costCodeProperties.isCommon()));
            propertiesExport.setPassengerUdid(Boolean.valueOf(costCodeProperties.isPassengerUdid()));
            propertiesExport.setRemarks(costCodeProperties.getRemarks());
            propertiesExport.setSabreDropList(Boolean.valueOf(costCodeProperties.isSabreDropList()));
            propertiesExport.setSabreRemarks(costCodeProperties.getSabreRemarks());
            propertiesExport.setSabreValue(costCodeProperties.getSabreValue());
            propertiesExport.setType(MetadataBasedExportHelper.convertEnum(costCodeProperties.getType()));
            propertiesExport.setDependant(Boolean.valueOf(costCodeProperties.isDependant()));
            propertiesExport.setStartDate(costCodeProperties.getStartDate());
            propertiesExport.setEndDate(costCodeProperties.getEndDate());
            organizationExport.getCostCodeProperties().add(propertiesExport);
        }
        organizationExport.setSabreNotes(organization.getSabreNotes());
        organizationExport.setSabreNotesOptional(organization.getSabreNotesOptional());
        organizationExport.setSabreProfilesLastOperationType(MetadataBasedExportHelper.convertEnum(organization.getSabreProfilesLastOperationType()));
        organizationExport.setOldShortName(organization.getOldShortName());
        organizationExport.setOldDkNumber(organization.getOldDkNumber());
        organizationExport.setRegistrationId(organization.getRegistrationId());
        organizationExport.setKpp(organization.getKpp());
        organizationExport.setOkpoCode(organization.getOkpoCode());
        organizationExport.setClientID(organization.getClientID());
        organizationExport.setSabreProfileCTP(organization.getSabreProfileCTP());
        organizationExport.setForeign(Boolean.valueOf(organization.isForeign()));
        organizationExport.setSimpleTaxed(Boolean.valueOf(organization.isSimpleTaxed()));
        organizationExport.setVatPayer(organization.isVatPayer());
        organizationExport.setVatLicenseNumber(organization.getVatLicenseNumber());
        organizationExport.setFinanceDocumentProperties(this.getFinanceDocumentsPropertiesExport(organization));
        organizationExport.setBeneficiaryCode(organization.getBeneficiaryCode() != null ? organization.getBeneficiaryCode().toString() : null);
        organizationExport.setUid(organization.getUid());
        organizationExport.setBin(organization.getBin());
        organizationExport.setVatSeriesNumber(organization.getVatSeriesNumber());
        organizationExport.setVatSeriesDate(organization.getVatSeriesDate());
        for (OrganizationType type : organization.getTypes()) {
            ReferenceItemExport item = new ReferenceItemExport();
            ObjectReferenceExport referenceExport = MetadataBasedExportHelper.convertEnum(type);
            item.setValue(referenceExport);
            organizationExport.getTypes().add(item);
        }
        if (organizationCtr != null) {
            List<ContractCustomerIndex> indices = this.getContractCustomerIndices((EntityReference<Organization>)organizationCtr.toReference());
            indices.forEach(index -> organizationExport.getContracts().add(this.convertContractCustomerIndex((ContractCustomerIndex)index)));
        }
    }

    private FinanceDocumentsPropertiesExport getFinanceDocumentsPropertiesExport(Organization organization) {
        FinanceDocumentsProperties properties = organization.getFinanceDocumentProperties();
        if (properties == null) {
            return null;
        }
        FinanceDocumentsPropertiesExport propertiesExport = new FinanceDocumentsPropertiesExport();
        if (properties.getBankAccount() != null) {
            propertiesExport.setBankAccount(this.getBankAccountExport(properties.getBankAccount()));
        }
        for (FinanceDocumentSettings settings : properties.getFinanceDocumentsSettings()) {
            FinanceDocumentSettingsExport settingsExport = new FinanceDocumentSettingsExport();
            settingsExport.setGroupBillingItems(Boolean.valueOf(settings.isGroupBillingItems()));
            settingsExport.setMergeBillingItems(Boolean.valueOf(settings.isMergeBillingItems()));
            settingsExport.setType(MetadataBasedExportHelper.convertEnum(settings.getType()));
            settingsExport.setUseCyrillicTravellerName(Boolean.valueOf(settings.isUseCyrillicTravellerName()));
            settingsExport.setUseDocument(Boolean.valueOf(settings.isUseDocument()));
            settingsExport.setUseFacsimile(Boolean.valueOf(settings.isUseFacsimile()));
            settingsExport.setUseSettings(Boolean.valueOf(settings.isUseSettings()));
            for (BillingItemSettings itemSettings : settings.getBillingItemsSettings()) {
                BillingItemSettingsExport itemSettingsExport = new BillingItemSettingsExport();
                itemSettingsExport.setIncludeVat(Boolean.valueOf(itemSettings.isIncludeVat()));
                itemSettingsExport.setType(MetadataBasedExportHelper.convertEnum(itemSettings.getType()));
                itemSettingsExport.setUseBillingItem(Boolean.valueOf(itemSettings.isUseBillingItem()));
                settingsExport.getBillingItemsSettings().add(itemSettingsExport);
            }
            propertiesExport.getFinanceDocumentsSettings().add(settingsExport);
        }
        this.convertBillingItemsSplitParameterTypeCollection(propertiesExport.getDiscountsSplitTypes(), properties.getDiscountsSplitTypes());
        this.convertBillingItemsSplitParameterTypeCollection(propertiesExport.getFeesSplitTypes(), properties.getFeesSplitTypes());
        this.convertBillingItemsSplitParameterTypeCollection(propertiesExport.getPenaltiesSplitTypes(), properties.getPenaltiesSplitTypes());
        this.convertBillingItemsSplitParameterTypeCollection(propertiesExport.getProductsSplitTypes(), properties.getProductsSplitTypes());
        return propertiesExport;
    }

    private BankAccountExport getBankAccountExport(BankAccount account) {
        BankAccountExport accountExport = new BankAccountExport();
        accountExport.setBankName(account.getBankName());
        accountExport.setBik(account.getBik());
        accountExport.setCity(MetadataBasedExportHelper.convertDictionary(account.getCity()));
        accountExport.setCorrespondentAccount(account.getCorrespondentAccount());
        if (account.getCurrency() != null) {
            accountExport.setCurrencyCode(account.getCurrency());
        }
        accountExport.setSettlementAccount(account.getSettlementAccount());
        return accountExport;
    }

    private void convertBillingItemsSplitParameterTypeCollection(Collection<ReferenceItemExport> collection, Collection<BillingItemsSplitParameterType> values) {
        collection.clear();
        for (BillingItemsSplitParameterType type : values) {
            ReferenceItemExport item = new ReferenceItemExport();
            item.setValue(MetadataBasedExportHelper.convertEnum(type));
            collection.add(item);
        }
    }

    private OrganizationContractExport convertContractCustomerIndex(ContractCustomerIndex index) {
        OrganizationContractExport contractExport = new OrganizationContractExport();
        contractExport.setUid(index.getContractUid());
        contractExport.setName(index.getName());
        contractExport.setContractType(MetadataBasedExportHelper.convertEnum(index.getContractType()));
        contractExport.setStartDate(index.getStartDate());
        contractExport.setEndDate(index.getEndDate());
        return contractExport;
    }

    private List<ContractCustomerIndex> getContractCustomerIndices(EntityReference<Organization> organization) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), organization), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), organization)}));
        query.getPreferredProperties().add(ContractCustomerIndex.Property.contractUid.name());
        query.getPreferredProperties().add(ContractCustomerIndex.Property.name.name());
        query.getPreferredProperties().add(ContractCustomerIndex.Property.contractType.name());
        query.getPreferredProperties().add(ContractCustomerIndex.Property.startDate.name());
        query.getPreferredProperties().add(ContractCustomerIndex.Property.endDate.name());
        return EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
    }
}

