/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.person;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.profile.v2.AddressExport;
import com.gridnine.xtrip.common.model.export.profile.v2.AirlineBonusCardExport;
import com.gridnine.xtrip.common.model.export.profile.v2.BankAccountExport;
import com.gridnine.xtrip.common.model.export.profile.v2.CarBonusCardExport;
import com.gridnine.xtrip.common.model.export.profile.v2.CardExport;
import com.gridnine.xtrip.common.model.export.profile.v2.CommunicationExport;
import com.gridnine.xtrip.common.model.export.profile.v2.CostCodeConstraintsSetExport;
import com.gridnine.xtrip.common.model.export.profile.v2.CreditLimitInfoExport;
import com.gridnine.xtrip.common.model.export.profile.v2.FinanceRestrictionExport;
import com.gridnine.xtrip.common.model.export.profile.v2.GdsReferenceExport;
import com.gridnine.xtrip.common.model.export.profile.v2.HotelBonusCardExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PassportExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PersonAddressExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PersonCommunicationExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PersonCostExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PersonEmploymentExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PersonExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PersonPassportNameItemExport;
import com.gridnine.xtrip.common.model.export.profile.v2.PlaceOfSalesExport;
import com.gridnine.xtrip.common.model.export.profile.v2.RailwayBonusCardExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreContactEmailExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreContactPhoneExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreProfileCommand2OsiExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreProfileCommand4SSRExport;
import com.gridnine.xtrip.common.model.export.profile.v2.SabreProfileLineExport;
import com.gridnine.xtrip.common.model.export.profile.v2.VisaExport;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.CostCodeConstraintsSet;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.FinanceRestrictions;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PassportCorrelationQualifier;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonPassportWrapper;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SabreContactEmail;
import com.gridnine.xtrip.common.model.profile.SabreContactPhone;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand4SSR;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import java.util.List;
import java.util.Objects;

public class PersonExportFillHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirlineBonusCardExport bonusCardExport;
        PersonExport personExport = (PersonExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        Person person = (Person)ctx.getMandatoryObject((Enum)IBusProfileContextKeys.PERSON);
        Boolean deleted = (Boolean)ctx.getObject((Enum)IBusProfileContextKeys.PERSON_DELETED);
        personExport.setCode(person.getCode());
        personExport.setDeleted(deleted);
        personExport.setDraftState(Boolean.valueOf(person.isDraftState()));
        personExport.setLoginName(person.getLoginName());
        MetadataBasedExportHelper.convertL10nStringCollection(personExport.getLastName(), person.getLastName());
        MetadataBasedExportHelper.convertL10nStringCollection(personExport.getFirstName(), person.getFirstName());
        MetadataBasedExportHelper.convertL10nStringCollection(personExport.getMiddleName(), person.getMiddleName());
        MetadataBasedExportHelper.convertL10nStringCollection(personExport.getSecondName(), person.getSecondName());
        personExport.setOldLastName(person.getOldLastName());
        personExport.setOldFirstName(person.getOldFirstName());
        personExport.setResourceIdForGetThere(person.getResourceIdForGetThere());
        personExport.setNotes(person.getNotes());
        personExport.setGender(MetadataBasedExportHelper.convertEnum(person.getGender()));
        personExport.setTitle(MetadataBasedExportHelper.convertEnum(person.getTitle()));
        personExport.setPreferredDepartureAirport(MetadataBasedExportHelper.convertDictionary(person.getPreferredDepartureAirport()));
        personExport.setSabreProfileCTP(person.getSabreProfileCTP());
        for (PersonType type : person.getTypes()) {
            ReferenceItemExport item = new ReferenceItemExport();
            ObjectReferenceExport referenceExport = MetadataBasedExportHelper.convertEnum(type);
            item.setValue(referenceExport);
            personExport.getTypes().add(item);
        }
        for (Card card : person.getCards()) {
            CardExport cardExport = new CardExport();
            cardExport.setBta(Boolean.valueOf(card.isBta()));
            cardExport.setExpiration(card.getExpiration());
            cardExport.setNameOnCard(card.getNameOnCard());
            cardExport.setNumber(card.getNumber());
            cardExport.setRemarks(card.getRemarks());
            cardExport.setSecurityCode(card.getSecurityCode());
            cardExport.setSof(Boolean.valueOf(card.isSof()));
            cardExport.setToRemove(Boolean.valueOf(card.isToRemove()));
            cardExport.setVendor(MetadataBasedExportHelper.convertEnum(card.getVendor()));
            personExport.getCards().add(cardExport);
        }
        for (Object communication : person.getCommunications()) {
            CommunicationExport communicationExport = new CommunicationExport();
            communicationExport.setView(communication.getView());
            communicationExport.setType(MetadataBasedExportHelper.convertEnum(communication.getType()));
            communicationExport.setSense(communication.getSense());
            communicationExport.setInternalNumber(communication.getInternalNumber());
            communicationExport.setCountryCode(communication.getCountryCode());
            communicationExport.setCityCode(communication.getCityCode());
            PersonCommunicationExport personCommunicationExport = new PersonCommunicationExport();
            personCommunicationExport.setCommunication(communicationExport);
            personCommunicationExport.setOrganization(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)communication.getOrganization()));
            personExport.getPersonCommunications().add(personCommunicationExport);
        }
        List passports = PersonPassportWrapper.wrap((List)person.getPassports());
        for (PersonPassportWrapper passport : passports) {
            PersonPassportNameItemExport name;
            PassportExport passportExport = new PassportExport();
            if (passport.getCorrelationId() == null) {
                passportExport.setFirstName(passport.getFirstNameFallback());
                passportExport.setLastName(passport.getLastNameFallback());
                passportExport.setMiddleName(passport.getMiddleNameFallback());
                passportExport.setSecondName(passport.getSecondNameFallback());
            }
            if (TextUtil.nonBlank((String)passport.getFirstNameCyrillic())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.CYRILLIC.name().toLowerCase());
                name.setValue(passport.getFirstNameCyrillic());
                passportExport.getFirstNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getLastNameCyrillic())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.CYRILLIC.name().toLowerCase());
                name.setValue(passport.getLastNameCyrillic());
                passportExport.getLastNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getMiddleNameCyrillic())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.CYRILLIC.name().toLowerCase());
                name.setValue(passport.getMiddleNameCyrillic());
                passportExport.getMiddleNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getSecondNameCyrillic())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.CYRILLIC.name().toLowerCase());
                name.setValue(passport.getSecondNameCyrillic());
                passportExport.getSecondNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getFirstNameLatin())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.LATIN.name().toLowerCase());
                name.setValue(passport.getFirstNameLatin());
                passportExport.getFirstNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getLastNameLatin())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.LATIN.name().toLowerCase());
                name.setValue(passport.getLastNameLatin());
                passportExport.getLastNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getMiddleNameLatin())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.LATIN.name().toLowerCase());
                name.setValue(passport.getMiddleNameLatin());
                passportExport.getMiddleNames().add(name);
            }
            if (TextUtil.nonBlank((String)passport.getSecondNameLatin())) {
                name = new PersonPassportNameItemExport();
                name.setType(PassportCorrelationQualifier.LATIN.name().toLowerCase());
                name.setValue(passport.getSecondNameLatin());
                passportExport.getSecondNames().add(name);
            }
            passportExport.setBirthday(passport.getBirthday());
            passportExport.setBirthPlace(passport.getBirthPlace());
            passportExport.setCitizenship(MetadataBasedExportHelper.convertDictionary(passport.getCitizenship()));
            passportExport.setExpired(passport.getExpired());
            passportExport.setGender(MetadataBasedExportHelper.convertEnum(passport.getGender()));
            passportExport.setIssueCity(passport.getIssueCity());
            passportExport.setIssued(passport.getIssued());
            passportExport.setIssueOrganization(passport.getIssueOrganization());
            passportExport.setNumber(passport.getNumber());
            passportExport.setOriginCountry(MetadataBasedExportHelper.convertDictionary(passport.getOriginCountry()));
            passportExport.setRemarks(passport.getRemarks());
            passportExport.setType(MetadataBasedExportHelper.convertEnum(passport.getType()));
            personExport.getPassports().add(passportExport);
        }
        for (Visa visa : person.getVisas()) {
            VisaExport visaExport = new VisaExport();
            visaExport.setBirthPlace(MetadataBasedExportHelper.convertDictionary(visa.getBirthPlace()));
            visaExport.setCountry(MetadataBasedExportHelper.convertDictionary(visa.getCountry()));
            visaExport.setEndDate(visa.getEndDate());
            visaExport.setIssueCity(MetadataBasedExportHelper.convertDictionary(visa.getIssueCity()));
            visaExport.setIssueCountry(MetadataBasedExportHelper.convertDictionary(visa.getIssueCountry()));
            visaExport.setIssueDate(visa.getIssueDate());
            visaExport.setNumber(visa.getNumber());
            visaExport.setStartDate(visa.getStartDate());
            personExport.getVisas().add(visaExport);
        }
        for (BankAccount bankAccount : person.getBankAccounts()) {
            BankAccountExport bankAccountExport = new BankAccountExport();
            bankAccountExport.setSettlementAccount(bankAccount.getSettlementAccount());
            bankAccountExport.setCurrencyCode(bankAccount.getCurrency());
            bankAccountExport.setCorrespondentAccount(bankAccount.getCorrespondentAccount());
            bankAccountExport.setCity(MetadataBasedExportHelper.convertDictionary(bankAccount.getCity()));
            bankAccountExport.setBik(bankAccount.getBik());
            bankAccountExport.setBankName(bankAccount.getBankName());
            personExport.getBankAccounts().add(bankAccountExport);
        }
        for (PlaceOfSales placeOfSales : person.getSalesPoints()) {
            PlaceOfSalesExport placeOfSalesExport = new PlaceOfSalesExport();
            placeOfSalesExport.setClosed(placeOfSales.getClosed());
            placeOfSalesExport.setOpened(placeOfSales.getOpened());
            if (placeOfSales.getSalesPoint() != null) {
                placeOfSalesExport.setSalesPointCode(placeOfSales.getSalesPoint().getUid());
            }
            personExport.getSalesPoints().add(placeOfSalesExport);
        }
        for (PersonAddress personAddress : person.getAddresses()) {
            PersonAddressExport personAddressExport = new PersonAddressExport();
            personAddressExport.setOrganization(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)personAddress.getOrganization()));
            AddressExport addressExport = new AddressExport();
            personAddressExport.setAddress(addressExport);
            addressExport.setZip(personAddress.getZip());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getTown(), personAddress.getTown());
            MetadataBasedExportHelper.convertGeoRegion(addressExport.getRegion(), (DictionaryReference<GeoRegion>)personAddress.getRegion());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getPavilion(), personAddress.getPavilion());
            addressExport.setPoBox(personAddress.getPoBox());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getOffice(), personAddress.getOffice());
            addressExport.setNotes(personAddress.getNotes());
            addressExport.setMetroStation(MetadataBasedExportHelper.convertDictionary(personAddress.getMetroStation()));
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getHousing(), personAddress.getHousing());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getHouse(), personAddress.getHouse());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getFlat(), personAddress.getFlat());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getDistrict(), personAddress.getDistrict());
            addressExport.setDeliveryRegion(MetadataBasedExportHelper.convertDictionary(personAddress.getDeliveryRegion()));
            addressExport.setCountry(MetadataBasedExportHelper.convertDictionary(personAddress.getCountry()));
            addressExport.setCity(MetadataBasedExportHelper.convertDictionary(personAddress.getCity()));
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getBuilding(), personAddress.getBuilding());
            MetadataBasedExportHelper.convertL10nStringCollection(addressExport.getAddress(), personAddress.getAddress());
            addressExport.setAddressType(MetadataBasedExportHelper.convertEnum(personAddress.getAddressType()));
            personExport.getPersonAddresses().add(personAddressExport);
        }
        for (PersonEmployment employment : person.getEmployments()) {
            PersonEmploymentExport employmentExport = new PersonEmploymentExport();
            employmentExport.setAuthorized(Boolean.valueOf(employment.isAuthorized()));
            employmentExport.setClosed(employment.getClosed());
            employmentExport.setDepartmentSuffix(employment.getDepartmentSuffix());
            if (employment.getEmployeeCategory() != null) {
                MetadataBasedExportHelper.convertL10nStringCollection(employmentExport.getEmployeeCategoryName(), employment.getEmployeeCategory().getName());
            }
            employmentExport.setMainEmployment(Boolean.valueOf(employment.isMainEmployment()));
            employmentExport.setOldDepartmentSuffix(employment.getOldDepartmentSuffix());
            employmentExport.setOpened(employment.getOpened());
            employmentExport.setOrganization(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)employment.getOrganization()));
            employmentExport.setPosition(MetadataBasedExportHelper.convertDictionary(employment.getPosition()));
            personExport.getEmployments().add(employmentExport);
        }
        for (GdsReference gdsReference : person.getGdsReferences()) {
            GdsReferenceExport gdsReferenceExport = new GdsReferenceExport();
            gdsReferenceExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)gdsReference.getAgency()));
            gdsReferenceExport.setClosed(gdsReference.getClosed());
            gdsReferenceExport.setGdsName(MetadataBasedExportHelper.convertEnum(gdsReference.getGdsName()));
            gdsReferenceExport.setOpened(gdsReference.getOpened());
            gdsReferenceExport.setReference(gdsReference.getReference());
            gdsReferenceExport.setRemarks(gdsReference.getRemarks());
            gdsReferenceExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference<SalesPoint>)gdsReference.getSalesPoint()));
            personExport.getGdsReferences().add(gdsReferenceExport);
        }
        for (AirlineBonusCard bonusCard : person.getAirlineBonusCards()) {
            bonusCardExport = new AirlineBonusCardExport();
            bonusCardExport.setAirline(MetadataBasedExportHelper.convertDictionary(bonusCard.getAirline()));
            bonusCardExport.setAirlineApplied(MetadataBasedExportHelper.convertDictionary(bonusCard.getAirlineApplied()));
            bonusCardExport.setNameOnCard(bonusCard.getNameOnCard());
            bonusCardExport.setNumber(bonusCard.getNumber());
            personExport.getAirlineBonusCards().add(bonusCardExport);
        }
        for (AirlineBonusCard bonusCard : person.getHotelBonusCards()) {
            bonusCardExport = new HotelBonusCardExport();
            bonusCardExport.setHotelBrand(MetadataBasedExportHelper.convertDictionary(bonusCard.getHotelBrand()));
            bonusCardExport.setNumber(bonusCard.getNumber());
            personExport.getHotelBonusCards().add(bonusCardExport);
        }
        for (AirlineBonusCard bonusCard : person.getCarBonusCards()) {
            bonusCardExport = new CarBonusCardExport();
            bonusCardExport.setCarSupplier(MetadataBasedExportHelper.convertDictionary(bonusCard.getCarSupplier()));
            bonusCardExport.setNumber(bonusCard.getNumber());
            personExport.getCarBonusCards().add(bonusCardExport);
        }
        for (AirlineBonusCard bonusCard : person.getRailwayBonusCards()) {
            bonusCardExport = new RailwayBonusCardExport();
            bonusCardExport.setNumber(bonusCard.getNumber());
            bonusCardExport.setRailwayCarrierCode(bonusCard.getRailwayCarrierCode());
            personExport.getRailwayBonusCards().add(bonusCardExport);
        }
        for (PersonCostCode code : person.getCostCodes()) {
            PersonCostExport costExport = new PersonCostExport();
            costExport.setEnglishValue(code.getEnglishValue());
            costExport.setLocalValue(code.getLocalValue());
            costExport.setValue(code.getValue());
            costExport.setOrganization(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)code.getOrganization()));
            costExport.setCostCodeProperties(MetadataBasedExportHelper.convertCostCodeProperties(code.getCostCodeProperties()));
            code.getRelatedCostCodeProperties().forEach(ccp -> costExport.getRelatedCostCodeProperties().add(MetadataBasedExportHelper.convertCostCodeProperties(ccp)));
            CostCodeConstraintsSetExport setExport = new CostCodeConstraintsSetExport();
            costExport.setConstraintsSet(setExport);
            CostCodeConstraintsSet set = code.getConstraintsSet();
            if (set != null) {
                MetadataBasedExportHelper.convertStringCollection(setExport.getEmptyValuesCostCodePropertiesUIDS(), set.getEmptyValuesCostCodePropertiesUIDS());
                MetadataBasedExportHelper.convertStringCollection(setExport.getRelatedCostCodesUIDS(), set.getRelatedCostCodesUIDS());
                MetadataBasedExportHelper.convertStringCollection(setExport.getWildcardCostCodePropertiesUIDS(), set.getWildcardCostCodePropertiesUIDS());
            }
            personExport.getCostCodes().add(costExport);
        }
        FinanceRestrictions restrictions = person.getFinanceRestrictions();
        if (restrictions != null) {
            FinanceRestrictionExport restrictionExport = new FinanceRestrictionExport();
            personExport.setFinanceRestriction(restrictionExport);
            for (CreditLimitInfo info : restrictions.getCreditLimits()) {
                CreditLimitInfoExport infoExport = new CreditLimitInfoExport();
                infoExport.setCreditLimit(info.getCreditLimit());
                infoExport.setCreditType(MetadataBasedExportHelper.convertEnum(info.getCreditType()));
                infoExport.setTerminalCreditDateEnd(info.getTerminalCreditDateEnd());
                infoExport.setTerminalCreditDateStart(info.getTerminalCreditDateStart());
                infoExport.setTerminalCreditLimit(info.getTerminalCreditLimit());
                infoExport.setUnlimited(Boolean.valueOf(info.isUnlimited()));
                restrictionExport.getCreditLimits().add(infoExport);
            }
        }
        for (SabreProfileLine line : person.getSabreAdditionalProfileLines()) {
            SabreProfileLineExport lineExport = new SabreProfileLineExport();
            lineExport.setLineType(MetadataBasedExportHelper.convertEnum(line.getLineType()));
            lineExport.setLineSubsection(line.getLineSubsection());
            lineExport.setLineServiceType(MetadataBasedExportHelper.convertEnum(line.getLineServiceType()));
            lineExport.setLineFlag(line.getLineFlag());
            lineExport.setLineBody(line.getLineBody());
            personExport.getSabreProfileLines().add(lineExport);
        }
        for (SabreContactPhone phone : person.getSabrePhoneContacts()) {
            SabreContactPhoneExport phoneExport = new SabreContactPhoneExport();
            phoneExport.setCityCode(phone.getCityCode());
            phoneExport.setContactName(phone.getContactName());
            phoneExport.setCountryCode(phone.getCountryCode());
            phoneExport.setInternalNumber(phone.getInternalNumber());
            phoneExport.setPrimaryContact(Boolean.valueOf(phone.isPrimaryContact()));
            phoneExport.setSense(phone.getSense());
            phoneExport.setType(MetadataBasedExportHelper.convertEnum(phone.getType()));
            personExport.getSabrePhoneContacts().add(phoneExport);
        }
        for (SabreContactEmail email : person.getSabreEmailContacts()) {
            SabreContactEmailExport emailExport = new SabreContactEmailExport();
            emailExport.setContactName(email.getContactName());
            emailExport.setSense(email.getSense());
            emailExport.setType(email.getType());
            personExport.getSabreEmailContacts().add(emailExport);
        }
        MetadataBasedExportHelper.convertStringCollection(personExport.getSabreFreeTextRemarks(), person.getSabreFreeTextRemarks());
        for (SabreProfileCommand2Osi command2Osi : person.getSabreAdditionalCommand2Lines()) {
            SabreProfileCommand2OsiExport command2OsiExport = new SabreProfileCommand2OsiExport();
            command2OsiExport.setLineType(MetadataBasedExportHelper.convertEnum(command2Osi.getLineType()));
            command2OsiExport.setEntry2(command2Osi.getEntry2());
            command2OsiExport.setEntry1(command2Osi.getEntry1());
            personExport.getSabreProfileCommand2Osis().add(command2OsiExport);
        }
        for (SabreProfileCommand4SSR command4SSR : person.getSabreAdditionalCommand4Lines()) {
            SabreProfileCommand4SSRExport command4SSRExport = new SabreProfileCommand4SSRExport();
            command4SSRExport.setSsrInfo(command4SSR.getSsrInfo());
            command4SSRExport.setSsrCode(command4SSR.getSsrCode());
            command4SSRExport.setLineType(MetadataBasedExportHelper.convertEnum(command4SSR.getLineType()));
        }
        person.getExternalCodesV2().stream().map(MetadataBasedExportHelper::convertExternalSystemCode).filter(Objects::nonNull).forEach(personExport.getExternalCodes()::add);
    }
}

