/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.transaction;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.finance.v2.ChartOfAccountsElementExport;
import com.gridnine.xtrip.common.model.export.finance.v2.TransactionExport;
import com.gridnine.xtrip.common.model.export.finance.v2.TransactionSplitExport;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import java.math.BigDecimal;

public class TransactionExportFillHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        TransactionExport transactionExport = (TransactionExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        Transaction transaction = (Transaction)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.TRANSACTION_DATA);
        transactionExport.setOrganization(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)transaction.getOrganization()));
        transactionExport.setDescription(transaction.getDescription());
        transactionExport.setOperationDate(transaction.getOperationDate());
        transactionExport.setHistorical(Boolean.valueOf(transaction.isHistorical()));
        transactionExport.setCalculationDate(transaction.getCalculationDate());
        if (transaction.getBooking() != null) {
            transactionExport.setBookingFileUid(transaction.getBooking().getUid());
        }
        transactionExport.setProductUid(transaction.getProductUid());
        transactionExport.setDocumentUid(transaction.getDocumentUid());
        transactionExport.setTransactionUid(transaction.getTransactionUid());
        transactionExport.setAutocreated(Boolean.valueOf(transaction.isAutocreated()));
        for (TransactionSplit split : transaction.getSplits()) {
            EntityContainer chartCont;
            TransactionSplitExport splitExport = new TransactionSplitExport();
            splitExport.setAmount(new BigDecimal(split.getAmount()));
            splitExport.setCredit(Boolean.valueOf(split.isCredit()));
            splitExport.setDimension1(split.getDimension1());
            splitExport.setDimension2(split.getDimension2());
            splitExport.setDimension3(split.getDimension3());
            if (split.getAccount() != null && (chartCont = EntityStorage.get().resolve(split.getAccount())) != null) {
                ChartOfAccountsElement element = (ChartOfAccountsElement)chartCont.getEntity();
                ChartOfAccountsElementExport elementExport = new ChartOfAccountsElementExport();
                elementExport.setType(MetadataBasedExportHelper.convertEnum(element.getType()));
                elementExport.setCurrency(MetadataBasedExportHelper.convertDictionary(element.getCurrency()));
                elementExport.setOrganization(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)element.getOrganization()));
                splitExport.setAccount(elementExport);
            }
            transactionExport.getSplits().add(splitExport);
        }
    }
}

