/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceAgencyMemoTransactionsTest
extends FinanceTestBase {
    private DictionaryReference<CurrencyInfo> currency = null;
    private String incomeElementName = null;
    private String customerElementName = null;
    private String bankElementName = null;
    private String customerCommissionElementName = null;
    private String expenseCommissionElementName = null;
    private final String currencyCode = "RUB";
    private String supplierCaption = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        EntityContainer agencyContainer = EntityStorage.get().resolve(TestBookingFileBuilder.agency);
        TestOrganizationBuilder agencyBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)agencyContainer.getEntity()).containerUid(agencyContainer.getUid());
        agencyContainer = ((TestOrganizationBuilder)((TestOrganizationBuilder)agencyBuilder.fopPaymentInfo().paymentType(PaymentType.INVOICE).createPaymentDate(false).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.MTD).createPaymentDate(false).createPaymentTransaction(false).end()).create();
        EntityContainer blankOwnerContainer = EntityStorage.get().resolve(TestBookingFileBuilder.blankOwner);
        TestOrganizationBuilder clientBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)blankOwnerContainer.getEntity()).containerUid(blankOwnerContainer.getUid());
        blankOwnerContainer = ((TestOrganizationBuilder)((TestOrganizationBuilder)clientBuilder.fopPaymentInfo().paymentType(PaymentType.CASH).createPaymentDate(true).createPaymentTransaction(true).end()).fopPaymentInfo().paymentType(PaymentType.MTD).createPaymentDate(true).createPaymentTransaction(false).end()).create();
        this.supplierCaption = TestBookingFileBuilder.blankOwner.getCaption();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.blankOwner).trackTransactionsChanges(false).supplierSettings().dimension1().type(DimensionType.AGENT).end().enabled(true).end().customerSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        this.incomeElementName = ChartOfAccountsElementType.INCOME.toString(LocaleHelper.EN_LOCALE);
        this.customerElementName = ChartOfAccountsElementType.CUSTOMER.toString(LocaleHelper.EN_LOCALE);
        this.bankElementName = ChartOfAccountsElementType.BANK.toString(LocaleHelper.EN_LOCALE);
        this.customerCommissionElementName = ChartOfAccountsElementType.CUSTOMER_COMMISSION.toString(LocaleHelper.EN_LOCALE);
        this.expenseCommissionElementName = ChartOfAccountsElementType.EXPENSE_COMMISSION.toString(LocaleHelper.EN_LOCALE);
    }

    @Test
    public void testACM() throws Exception {
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().agencyMemo(new AgencyMemoProduct()).type(AgencyMemoProductType.ACM).blankOwner(TestBookingFileBuilder.blankOwner).supplier(TestBookingFileBuilder.blankOwner).agency(TestBookingFileBuilder.agency).type(AgencyMemoProductType.ACM).issueDate("2020-01-01 00:00:00.000").acceptDate("2020-01-01 00:00:00.000").sourceReportDate("2020-01-01 00:00:00.000").targetReportDate("2020-01-01 00:00:00.000").itemGroup().type(AgencyMemoProductEntryType.BONUS).amount(100.0).end().itemGroup().type(AgencyMemoProductEntryType.COMMISSION).amount(50.0).end().itemGroup().type(AgencyMemoProductEntryType.TARIFF).amount(20.0).end().itemGroup().type(AgencyMemoProductEntryType.TAX_OTHERS).amount(35.0).end().clientFop().amount(205.0).paymentType(PaymentType.INVOICE).agent(TestBookingFileBuilder.subagencyAgent).end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions(null);
        Assert.assertEquals((long)5L, (long)transactions.size());
        Assert.assertTrue((boolean)transactions.stream().allMatch(transaction -> transaction.getSplits().size() == 2));
        boolean found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.incomeElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(100000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(100000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
        found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(100000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.bankElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(100000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
        found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.incomeElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-2050000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-2050000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
        found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerCommissionElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(1500000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.expenseCommissionElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(1500000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
        found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-2050000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.bankElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-2050000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testADM() throws Exception {
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().agencyMemo(new AgencyMemoProduct()).type(AgencyMemoProductType.ADM).blankOwner(TestBookingFileBuilder.blankOwner).supplier(TestBookingFileBuilder.blankOwner).agency(TestBookingFileBuilder.agency).type(AgencyMemoProductType.ADM).issueDate("2020-01-01 00:00:00.000").acceptDate("2020-01-01 00:00:00.000").sourceReportDate("2020-01-01 00:00:00.000").targetReportDate("2020-01-01 00:00:00.000").itemGroup().type(AgencyMemoProductEntryType.BONUS).amount(100.0).end().itemGroup().type(AgencyMemoProductEntryType.COMMISSION).amount(50.0).end().itemGroup().type(AgencyMemoProductEntryType.TARIFF).amount(20.0).end().itemGroup().type(AgencyMemoProductEntryType.TAX_OTHERS).amount(35.0).end().clientFop().amount(205.0).paymentType(PaymentType.INVOICE).agent(TestBookingFileBuilder.subagencyAgent).end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions(null);
        Assert.assertEquals((long)5L, (long)transactions.size());
        Assert.assertTrue((boolean)transactions.stream().allMatch(transaction -> transaction.getSplits().size() == 2));
        boolean found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.incomeElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-100000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-100000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
        found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-100000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.bankElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-100000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
        found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.incomeElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(2050000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(2050000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
        found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerCommissionElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-1500000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.expenseCommissionElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(-1500000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
        found = transactions.stream().anyMatch(transaction -> transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.customerElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(2050000L).equals(split.getAmount())) && transaction.getSplits().stream().anyMatch(split -> String.format("%s - %s (%s)", this.supplierCaption, this.bankElementName, "RUB").equals(split.getAccount().getCaption()) && Long.valueOf(2050000L).equals(split.getAmount())));
        Assert.assertTrue((boolean)found);
    }

    private List<Transaction> getTransactions(EntityReference<BookingFile> bookingFile) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.bookingUid.name(), null));
        if (bookingFile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), bookingFile));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }
}

