/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceClearTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsElementBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestTransactionBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;

public class FinanceClearTest
extends FinanceTestBase {
    private final LongRunningTaskCallback callback = new LongRunningTaskCallback(){

        @Override
        public boolean isToBeStopped() {
            return false;
        }

        @Override
        public void addEvent(String eventId, Message description) {
        }

        @Override
        public void updateProgress(byte progress) {
        }
    };
    private final FinanceClearTaskConfiguration clearConfiguration = new FinanceClearTaskConfiguration();
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    public void testFinanceClear1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.AGENT).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder testChartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer supplierChartOfAccountsElementContainer = testChartOfAccountsElementBuilder.organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).type(ChartOfAccountsElementType.SUPPLIER).currency(this.currency).create();
        EntityReference supplierChartOfAccountsElement = supplierChartOfAccountsElementContainer.toReference();
        EntityContainer expenseChartOfAccountsElementContainer = testChartOfAccountsElementBuilder.organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).type(ChartOfAccountsElementType.EXPENSE).currency(this.currency).create();
        EntityReference expenseChartOfAccountsElement = expenseChartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date operationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-4));
        String operationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(operationDate);
        Date calculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-3));
        String calculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calculationDate);
        for (int i = 0; i < 10; ++i) {
            TestTransactionBuilder testTransactionBuilder = new TestTransactionBuilder();
            testTransactionBuilder.operationDate(operationDateString).calculationDate(calculationDateString).historical(i % 4 == 0).autocreated(i % 3 != 0).split().account(supplierChartOfAccountsElement).amount((long)(2400 + i * 50)).credit(false).end().split().account(expenseChartOfAccountsElement).amount((long)(2400 + i * 50)).credit(true).end().create();
        }
        Assert.assertEquals((long)2L, (long)this.getChartOfAccountsElements(null).size());
        Assert.assertEquals((long)10L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, LongRunningTaskCallback> data = new HashMap<String, LongRunningTaskCallback>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), (LongRunningTaskCallback)this.clearConfiguration);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:clear").processSync(data);
        Assert.assertEquals((long)0L, (long)this.getChartOfAccountsElements(null).size());
        Assert.assertEquals((long)0L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private List<OpeningBalance> getBalances(EntityReference<Organization> organization) {
        ArrayList<OpeningBalance> balances = new ArrayList<OpeningBalance>();
        for (EntityReference<ChartOfAccountsElement> chartOfAccountsElement : this.getChartOfAccountsElements(organization)) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.accountUid.name(), chartOfAccountsElement));
            for (OpeningBalance balance : AssetsStorage.get().search(OpeningBalance.class, query).getData()) {
                if (balances.contains(balance)) continue;
                balances.add(balance);
            }
        }
        return balances;
    }

    private List<Transaction> getTransactions(EntityReference<Organization> organization) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        for (EntityReference<ChartOfAccountsElement> chartOfAccountsElement : this.getChartOfAccountsElements(organization)) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), chartOfAccountsElement));
            List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
            for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
                Transaction transaction;
                EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
                if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
                transactions.add(transaction);
            }
        }
        return transactions;
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }
}

