/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.finance.FinanceUpdateBalancesTest;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceCorrectionTest
extends FinanceTestBase {
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        EntityContainer agencyContainer = EntityStorage.get().resolve(TestBookingFileBuilder.agency);
        TestOrganizationBuilder agencyBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)agencyContainer.getEntity()).containerUid(agencyContainer.getUid());
        ((TestOrganizationBuilder)((TestOrganizationBuilder)agencyBuilder.fopPaymentInfo().paymentType(PaymentType.INVOICE).createPaymentDate(false).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.MTD).createPaymentDate(false).createPaymentTransaction(false).end()).create();
        EntityContainer clientContainer = EntityStorage.get().resolve(TestBookingFileBuilder.client);
        TestOrganizationBuilder clientBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)clientContainer.getEntity()).containerUid(clientContainer.getUid());
        ((TestOrganizationBuilder)((TestOrganizationBuilder)clientBuilder.fopPaymentInfo().paymentType(PaymentType.CASH).createPaymentDate(true).createPaymentTransaction(true).end()).fopPaymentInfo().paymentType(PaymentType.MTD).createPaymentDate(true).createPaymentTransaction(false).end()).create();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testFinanceCorrection() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date issueDate = sdf.parse("2020-01-01");
        Date correctionDate = sdf.parse("2020-01-02");
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).issueDate(issueDate).correctionDate(correctionDate).rulesApplied(true).ticketType(TicketType.CORRECTION).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.MTD).amount(490.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.MTD).amount(500.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(490L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(490L)), (long)debitTransactionSplit.getAmount());
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getCorrectionDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-490L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-490L)), (long)debitTransactionSplit.getAmount());
    }

    private List<Transaction> getTransactions(EntityReference<BookingFile> bookingFile) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.bookingUid.name(), null));
        if (bookingFile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), bookingFile));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private Transaction getTransaction(List<Transaction> transactions, EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement, EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement, String productUid, boolean historical, boolean refund) {
        for (Transaction transaction : transactions) {
            TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
            TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
            if (!TextUtil.isSame((String)transaction.getProductUid(), (String)productUid) || transaction.isHistorical() != historical || creditTransactionSplit == null || creditTransactionSplit.getAmount() < 0L != refund || debitTransactionSplit == null || debitTransactionSplit.getAmount() < 0L != refund) continue;
            return transaction;
        }
        return null;
    }

    private TransactionSplit getTransactionSplit(Transaction transaction, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, boolean credit) {
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            if (credit != transactionSplit.isCredit() || !MiscUtil.equals((Object)transactionSplit.getAccount(), chartOfAccountsElement)) continue;
            return transactionSplit;
        }
        return null;
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }

    protected List<URL> collectIntegrationBusDescriptions() {
        List result = super.collectIntegrationBusDescriptions();
        result.add(ResourceUtil.getResource(FinanceUpdateBalancesTest.class, (String)"ibus-finance-test.xml"));
        return result;
    }
}

