/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.StandardTransactionActions;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionAction;
import com.gridnine.xtrip.common.model.finance.TransactionDataHolder;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceCreateCustomTransactionTest
extends FinanceTestBase {
    private final EntityReference<BookingFile> fakeBookingFile = new EntityReference("fake_booking_file", BookingFile.class, "Fake booking file");
    private final String fakeProductUid = "fake_product_uid";
    private final String fakeDocumentUid = "fake_document_uid";
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testFinanceCreateCustomTransaction1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettings = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Billing";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.INCOME, (EntityReference)TestBookingFileBuilder.agency, (EntityReference)TestBookingFileBuilder.client).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)7400.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().debitDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
    }

    @Test
    public void testFinanceCreateCustomTransaction2() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension2().type(DimensionType.AGENT).end().dimension3().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettings = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Billing";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.INCOME, (EntityReference)TestBookingFileBuilder.agency, (EntityReference)TestBookingFileBuilder.client).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)7400.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().debitDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.BANK, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction3() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension2().type(DimensionType.SALES_POINT).end().dimension3().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().dimension2().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettings = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Expense";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.EXPENSE, (EntityReference)TestBookingFileBuilder.agency, (EntityReference)TestBookingFileBuilder.client).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)2000.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().debitDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2000L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2000L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2000L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2000L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction4() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().dimension3().type(DimensionType.SALES_POINT).end().end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettings = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Correction";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CORRECTION, (EntityReference)TestBookingFileBuilder.agency, (EntityReference)TestBookingFileBuilder.client).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)8200.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CREDIT).contractType(ContractType.SUBAGENCY).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().debitDimensionData().paymentType(PaymentType.CREDIT).contractType(ContractType.SUBAGENCY).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8200L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8200L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.BANK, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8200L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8200L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction5() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().dimension2().type(DimensionType.CASH_REGISTER).end().dimension3().type(DimensionType.CASH).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Agent -> Cash Register";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.AGENT_CASH_REGISTER, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)1900.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.AGENT, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REGISTER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER, (Object)TestBookingFileBuilder.agencyCashRegister), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH, (Object)TestBookingFileBuilder.agencyCash), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1900L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER, (Object)TestBookingFileBuilder.agencyCashRegister), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH, (Object)TestBookingFileBuilder.agencyCash), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1900L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction6() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().dimension2().type(DimensionType.CASH).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Agent -> Agent Correction";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.AGENT_AGENT_CORRECTION, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)5700.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CREDIT_CARD).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CREDIT_CARD).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.AGENT, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.AGENT_CORRECTION, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH, (Object)TestBookingFileBuilder.agencyCash), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5700L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH, (Object)TestBookingFileBuilder.agencyCash), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5700L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction7() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(true).dimension2().type(DimensionType.CASH_REGISTER_WORKPLACE).end().dimension3().type(DimensionType.SALES_POINT).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Cash Register -> Cash";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REGISTER_CASH, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)1400.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REGISTER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER_WORKPLACE, (Object)TestBookingFileBuilder.agencyCashRegisterWorkplace), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1400L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER_WORKPLACE, (Object)TestBookingFileBuilder.agencyCashRegisterWorkplace), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1400L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction8() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(true).dimension1().type(DimensionType.CASH_REGISTER).end().dimension3().type(DimensionType.AGENT).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Cash -> Cash Stash";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_CASH_STASH, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)7100.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.INVOICE).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.INVOICE).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_STASH, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER, (Object)TestBookingFileBuilder.agencyCashRegister), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7100L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER, (Object)TestBookingFileBuilder.agencyCashRegister), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7100L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction9() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().dimension2().type(DimensionType.SALES_POINT).end().dimension3().type(DimensionType.ORGANIZATION).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Cash -> Cash Correction";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_CASH_CORRECTION, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)6300.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CREDIT).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CREDIT).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_CORRECTION, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6300L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6300L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction10() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().dimension2().type(DimensionType.CASH_REGISTER).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Cash Correction -> Cash Stash";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_CORRECTION_CASH_STASH, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)4300.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CREDIT).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CREDIT).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_CORRECTION, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_STASH, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER, (Object)TestBookingFileBuilder.agencyCashRegister), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER, (Object)TestBookingFileBuilder.agencyCashRegister), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction11() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().cashRemainsSettings().enabled(true).dimension1().type(DimensionType.CASH).end().dimension3().type(DimensionType.ORGANIZATION).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Cash Remains Agent -> Cash Remains Stash";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_AGENT_STASH, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)7900.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_AGENT, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_STASH, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH, (Object)TestBookingFileBuilder.agencyCash), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH, (Object)TestBookingFileBuilder.agencyCash), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction12() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().cashRemainsSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().dimension2().type(DimensionType.CASH_REGISTER_WORKPLACE).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Cash Remains Agent -> Cash Remains Correction";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_AGENT_CORRECTION, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)2900.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CREDIT_CARD).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CREDIT_CARD).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_AGENT, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_CORRECTION, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER_WORKPLACE, (Object)TestBookingFileBuilder.agencyCashRegisterWorkplace), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER_WORKPLACE, (Object)TestBookingFileBuilder.agencyCashRegisterWorkplace), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction13() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().cashRemainsSettings().enabled(true).dimension1().type(DimensionType.CASH).end().dimension2().type(DimensionType.SALES_POINT).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Cash Remains Agent -> Cash Remains Cash";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_AGENT_CASH, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)4800.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.MTD).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.MTD).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_AGENT, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_CASH, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH, (Object)TestBookingFileBuilder.agencyCash), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.MTD), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4800L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH, (Object)TestBookingFileBuilder.agencyCash), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.MTD), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4800L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction14() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().cashRemainsSettings().enabled(true).dimension2().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.CASH_REGISTER).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Cash Remains Correction -> Cash Remains Stash";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_CORRECTION_STASH, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)7300.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_CORRECTION, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_STASH, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER, (Object)TestBookingFileBuilder.agencyCashRegister), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7300L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER, (Object)TestBookingFileBuilder.agencyCashRegister), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7300L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction15() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().cashRemainsSettings().enabled(true).dimension2().type(DimensionType.AGENT).end().dimension3().type(DimensionType.ORGANIZATION).end().end().create();
        Date date = new Date();
        String description = "Correction solve";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)new TransactionAction(){

            public List<ChartOfAccountsElementType> getOrganizationCreditChartOfAccounts() {
                return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_CORRECTION, ChartOfAccountsElementType.CASH_REMAINS_CUSTOMER);
            }

            public List<ChartOfAccountsElementType> getOrganizationDebitChartOfAccounts() {
                return Arrays.asList(ChartOfAccountsElementType.CASH_REMAINS_CASH);
            }
        }, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)-5000.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CASH).contractType(null).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_CORRECTION, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REMAINS_CASH, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-5000L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-5000L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceCreateCustomTransaction16() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.SALES_POINT).end().end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettings = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        String description = "Billing";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)new TransactionAction(){

            public List<ChartOfAccountsElementType> getSupplierCreditChartOfAccounts() {
                return Arrays.asList(ChartOfAccountsElementType.AGENT, ChartOfAccountsElementType.CUSTOMER);
            }

            public List<ChartOfAccountsElementType> getSupplierDebitChartOfAccounts() {
                return Arrays.asList(ChartOfAccountsElementType.BANK, ChartOfAccountsElementType.AGENT);
            }

            public List<ChartOfAccountsElementType> getCustomerCreditChartOfAccounts() {
                return Arrays.asList(ChartOfAccountsElementType.BANK, ChartOfAccountsElementType.INCOME);
            }

            public List<ChartOfAccountsElementType> getCustomerDebitChartOfAccounts() {
                return Arrays.asList(ChartOfAccountsElementType.SUPPLIER, ChartOfAccountsElementType.EXPENSE);
            }
        }, (EntityReference)TestBookingFileBuilder.agency, (EntityReference)TestBookingFileBuilder.client).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(date).amount(SystemHelper.getMoney((double)9900.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().debitDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().build();
        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<Transaction> transactions = this.getTransactions(this.fakeBookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9900L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9900L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.BANK, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)date, (Object)transaction.getOperationDate());
        Assert.assertEquals((Object)description, (Object)transaction.getDescription());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9900L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9900L)), (long)debitTransactionSplit.getAmount());
    }

    private List<Transaction> getTransactions(EntityReference<BookingFile> bookingFile) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.bookingUid.name(), null));
        if (bookingFile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), bookingFile));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private Transaction getTransaction(List<Transaction> transactions, EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement, EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement, String productUid, boolean historical, boolean refund) {
        for (Transaction transaction : transactions) {
            TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
            TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
            if (!TextUtil.isSame((String)transaction.getProductUid(), (String)productUid) || transaction.isHistorical() != historical || creditTransactionSplit == null || debitTransactionSplit == null) continue;
            return transaction;
        }
        return null;
    }

    private TransactionSplit getTransactionSplit(Transaction transaction, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, boolean credit) {
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            if (credit != transactionSplit.isCredit() || !MiscUtil.equals((Object)transactionSplit.getAccount(), chartOfAccountsElement)) continue;
            return transactionSplit;
        }
        return null;
    }
}

