/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesDivergenceTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesUpdateTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class FinanceDivergenceBalancesTest
extends FinanceTestBase {
    private final List<Message> messages = new ArrayList<Message>();
    private final LongRunningTaskCallback callback = new LongRunningTaskCallback(){

        @Override
        public boolean isToBeStopped() {
            return false;
        }

        @Override
        public void addEvent(String eventId, Message description) {
            FinanceDivergenceBalancesTest.this.messages.add(description);
        }

        @Override
        public void updateProgress(byte progress) {
        }
    };
    private final FinanceBalancesDivergenceTaskConfiguration balancesDivergenceConfiguration = new FinanceBalancesDivergenceTaskConfiguration();
    private final FinanceBalancesUpdateTaskConfiguration balancesUpdateConfiguration = new FinanceBalancesUpdateTaskConfiguration();
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        EntityContainer agencyContainer = EntityStorage.get().resolve(TestBookingFileBuilder.agency);
        TestOrganizationBuilder agencyBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)agencyContainer.getEntity()).containerUid(agencyContainer.getUid());
        agencyContainer = ((TestOrganizationBuilder)agencyBuilder.fopPaymentInfo().paymentType(PaymentType.INVOICE).createPaymentDate(false).createPaymentTransaction(false).end()).create();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testFinanceDivergenceBalances1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(3550.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(3550.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        Assert.assertEquals((long)2L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        this.messages.clear();
        HashMap<String, LongRunningTaskCallback> data = new HashMap<String, LongRunningTaskCallback>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), (LongRunningTaskCallback)this.balancesDivergenceConfiguration);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-divergence").processSync(data);
        Assert.assertEquals((long)0L, (long)MessageHelper.filterMessages(this.messages, (MessageType)MessageType.ERROR).size());
        Assert.assertEquals((long)2L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
    }

    @Test
    public void testFinanceDivergenceBalances2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(3550.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(3550.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        Assert.assertEquals((long)2L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        this.messages.clear();
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesDivergenceConfiguration);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-divergence").processSync(data);
        Assert.assertFalse((boolean)MessageHelper.hasErrorMessages(this.messages));
        Assert.assertEquals((long)2L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)4L, (long)this.getBalances(null).size());
    }

    @Test
    public void testFinanceDivergenceBalances3() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(3550.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(3550.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        Assert.assertEquals((long)2L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        this.messages.clear();
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesDivergenceConfiguration);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-divergence").processSync(data);
        Assert.assertEquals((long)0L, (long)MessageHelper.filterMessages(this.messages, (MessageType)MessageType.ERROR).size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        OpeningBalance balance = balances.get(0);
        balance.setDebit(balance.getDebit() + 700000L);
        balance.setCredit(balance.getCredit() + 500000L);
        AssetsStorage.get().save((BaseAsset)balance);
        balance = balances.get(1);
        balance.setDebit(balance.getDebit() + 300000L);
        balance.setCredit(balance.getCredit() + 170000L);
        AssetsStorage.get().save((BaseAsset)balance);
        this.messages.clear();
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesDivergenceConfiguration);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-divergence").processSync(data);
        Assert.assertEquals((long)1L, (long)MessageHelper.filterMessages(this.messages, (MessageType)MessageType.ERROR).size());
        Assert.assertEquals((long)2L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)4L, (long)this.getBalances(null).size());
    }

    @Test
    public void testFinanceDivergenceBalances4() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct product = new HotelProduct();
        HotelProductFop vendorFop = new HotelProductFop();
        HotelProductFop clientFop = new HotelProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = TestBookingFileBuilder.getDateFormat().format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().hotelProduct(product).rulesApplied(true).issueDate(issueDateString).unholdDate(null).vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(6600.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(6600.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions(null);
        Assert.assertEquals((long)2L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        this.messages.clear();
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesDivergenceConfiguration);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-divergence").processSync(data);
        Assert.assertFalse((boolean)MessageHelper.hasErrorMessages(this.messages));
        Assert.assertEquals((long)2L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)5L, (long)this.getBalances(null).size());
    }

    @Test
    public void testFinanceDivergenceBalances5() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct product = new HotelProduct();
        HotelProductFop vendorFop = new HotelProductFop();
        HotelProductFop clientFop = new HotelProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        Date unholdDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-5));
        String unholdDateString = TestBookingFileBuilder.getDateFormat().format(unholdDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = TestBookingFileBuilder.getDateFormat().format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().hotelProduct(product).rulesApplied(true).issueDate(issueDateString).unholdDate(unholdDateString).vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(6600.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(6600.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions(null);
        Assert.assertEquals((long)4L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        this.messages.clear();
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesDivergenceConfiguration);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-divergence").processSync(data);
        Assert.assertFalse((boolean)MessageHelper.hasErrorMessages(this.messages));
        Assert.assertEquals((long)4L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)6L, (long)this.getBalances(null).size());
    }

    @Test
    public void testFinanceDivergenceBalances6() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct product = new HotelProduct();
        HotelProductFop vendorFop = new HotelProductFop();
        HotelProductFop clientFop = new HotelProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        Date unholdDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-5));
        String unholdDateString = TestBookingFileBuilder.getDateFormat().format(unholdDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = TestBookingFileBuilder.getDateFormat().format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().hotelProduct(product).rulesApplied(true).issueDate(issueDateString).unholdDate(unholdDateString).vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(6600.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(6600.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions(null);
        Assert.assertEquals((long)4L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        this.messages.clear();
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesDivergenceConfiguration);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-divergence").processSync(data);
        Assert.assertFalse((boolean)MessageHelper.hasErrorMessages(this.messages));
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        OpeningBalance balance = balances.get(0);
        balance.setDebit(balance.getDebit() + ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7000L)));
        balance.setCredit(balance.getCredit() + ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5000L)));
        AssetsStorage.get().save((BaseAsset)balance);
        balance = balances.get(1);
        balance.setDebit(balance.getDebit() + ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3000L)));
        balance.setCredit(balance.getCredit() + ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1700L)));
        AssetsStorage.get().save((BaseAsset)balance);
        this.messages.clear();
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesDivergenceConfiguration);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-divergence").processSync(data);
        Assert.assertEquals((long)1L, (long)MessageHelper.filterMessages(this.messages, (MessageType)MessageType.ERROR).size());
        Assert.assertEquals((long)4L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)6L, (long)this.getBalances(null).size());
    }

    private List<Transaction> getTransactions(EntityReference<BookingFile> bookingFile) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        if (bookingFile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), bookingFile));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private List<OpeningBalance> getBalances(EntityReference<ChartOfAccountsElement> chartOfAccountsElement) {
        SearchQuery query = new SearchQuery();
        if (chartOfAccountsElement != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.accountUid.name(), chartOfAccountsElement));
        }
        return AssetsStorage.get().search(OpeningBalance.class, query).getData();
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }

    protected List<URL> collectIntegrationBusDescriptions() {
        List result = super.collectIntegrationBusDescriptions();
        result.add(ResourceUtil.getResource(FinanceDivergenceBalancesTest.class, (String)"ibus-finance-test.xml"));
        return result;
    }
}

