/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.ProjectionQueryHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsElementBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestOpeningBalanceInternalBuilder;
import com.gridnine.xtrip.server.model.test.TestTransactionBuilder;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceHelperTest
extends FinanceTestBase {
    private final EntityReference<BookingFile> fakeBookingFile = new EntityReference("fake_bf", BookingFile.class, "Fake booking file");
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testGetBalance1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder chartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElementBuilder.type(ChartOfAccountsElementType.CUSTOMER).organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).currency(this.currency).create();
        EntityReference chartOfAccountsElement = chartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date operationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20));
        Date calculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35));
        String operationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(operationDate);
        String calculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calculationDate);
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance = (OpeningBalance)testOpeningBalanceBuilder.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(15000L).credit(8500L).dimension1(null).dimension2(null).dimension3(null).create();
        Assert.assertEquals(null, (Object)FinanceHelper.getBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), this.getDimensions(null, null, null)));
        Assert.assertEquals(null, (Object)FinanceHelper.getBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), this.getDimensions(null, null, null)));
        Assert.assertEquals(null, (Object)FinanceHelper.getBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40)), this.getDimensions(null, null, null)));
        Assert.assertEquals(null, (Object)FinanceHelper.getBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), this.getDimensions(null, null, null)));
        Assert.assertEquals((Object)balance, (Object)FinanceHelper.getBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40)), this.getDimensions(null, null, null)));
        Assert.assertEquals((Object)balance, (Object)FinanceHelper.getBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null)));
    }

    @Test
    public void testGetBalance2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder chartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElementBuilder.type(ChartOfAccountsElementType.CUSTOMER).organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).currency(this.currency).create();
        EntityReference chartOfAccountsElement = chartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date operationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20));
        Date calculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35));
        String operationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(operationDate);
        String calculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calculationDate);
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder01 = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance01 = (OpeningBalance)testOpeningBalanceBuilder01.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(15000L).credit(8500L).dimension1(null).dimension2(null).dimension3(null).create();
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder02 = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance02 = (OpeningBalance)testOpeningBalanceBuilder02.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(12000L).credit(500L).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).create();
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder03 = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance03 = (OpeningBalance)testOpeningBalanceBuilder03.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(3000L).credit(8000L).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).dimension3(null).create();
        Assert.assertEquals((Object)balance01, (Object)FinanceHelper.getBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null)));
        Assert.assertEquals((Object)balance02, (Object)FinanceHelper.getBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null)));
        Assert.assertEquals((Object)balance03, (Object)FinanceHelper.getBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null)));
    }

    @Test
    public void testCalculateBalance1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder chartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElementBuilder.type(ChartOfAccountsElementType.CUSTOMER).organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).currency(this.currency).create();
        EntityReference chartOfAccountsElement = chartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date operationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20));
        Date calculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35));
        String operationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(operationDate);
        String calculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calculationDate);
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder01 = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance01 = (OpeningBalance)testOpeningBalanceBuilder01.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(15000L))).credit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8500L))).dimension1(null).dimension2(null).dimension3(null).create();
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder02 = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance02 = (OpeningBalance)testOpeningBalanceBuilder02.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(12000L))).credit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(500L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).create();
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder03 = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance03 = (OpeningBalance)testOpeningBalanceBuilder03.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3000L))).credit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).dimension3(null).create();
        Date transaction01OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5));
        Date transaction01CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25));
        String transaction01OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01OperationDate);
        String transaction01CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01CalculationDate);
        TestTransactionBuilder testTransactionBuilder01 = new TestTransactionBuilder();
        EntityContainer transaction01Container = testTransactionBuilder01.operationDate(transaction01OperationDateString).calculationDate(transaction01CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4500L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1500L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction01 = transaction01Container.toReference();
        Date transaction02OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30));
        Date transaction02CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40));
        String transaction02OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02OperationDate);
        String transaction02CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02CalculationDate);
        TestTransactionBuilder testTransactionBuilder02 = new TestTransactionBuilder();
        EntityContainer transaction02Container = testTransactionBuilder02.operationDate(transaction02OperationDateString).calculationDate(transaction02CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5600L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4100L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction02 = transaction02Container.toReference();
        Date transaction03OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15));
        Date transaction03CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50));
        String transaction03OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03OperationDate);
        String transaction03CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03CalculationDate);
        TestTransactionBuilder testTransactionBuilder03 = new TestTransactionBuilder();
        EntityContainer transaction03Container = testTransactionBuilder03.operationDate(transaction03OperationDateString).calculationDate(transaction03CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7500L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8100L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction03 = transaction03Container.toReference();
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(4500L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1500L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(4500L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1500L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(20600L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(12600L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(17600L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(4600L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3000L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(8000L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(28100L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(20700L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(25100L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(12700L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3000L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(8000L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)true)) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateBalance2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder chartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElementBuilder.type(ChartOfAccountsElementType.CUSTOMER).organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).currency(this.currency).create();
        EntityReference chartOfAccountsElement = chartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date operationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5));
        Date calculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30));
        String operationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(operationDate);
        String calculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calculationDate);
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder01 = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance01 = (OpeningBalance)testOpeningBalanceBuilder01.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3300L))).credit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9800L))).dimension1(null).dimension2(null).dimension3(null).create();
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder02 = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance02 = (OpeningBalance)testOpeningBalanceBuilder02.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1200L))).credit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8200L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).create();
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder03 = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance03 = (OpeningBalance)testOpeningBalanceBuilder03.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2100L))).credit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1600L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).dimension3(null).create();
        Date transaction01OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction01CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20));
        String transaction01OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01OperationDate);
        String transaction01CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01CalculationDate);
        TestTransactionBuilder testTransactionBuilder01 = new TestTransactionBuilder();
        EntityContainer transaction01Container = testTransactionBuilder01.operationDate(transaction01OperationDateString).calculationDate(transaction01CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1750L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1400L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction01 = transaction01Container.toReference();
        Date transaction02OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35));
        Date transaction02CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50));
        String transaction02OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02OperationDate);
        String transaction02CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02CalculationDate);
        TestTransactionBuilder testTransactionBuilder02 = new TestTransactionBuilder();
        EntityContainer transaction02Container = testTransactionBuilder02.operationDate(transaction02OperationDateString).calculationDate(transaction02CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1000L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6150L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction02 = transaction02Container.toReference();
        Date transaction03OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40));
        Date transaction03CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50));
        String transaction03OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03OperationDate);
        String transaction03CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03CalculationDate);
        TestTransactionBuilder testTransactionBuilder03 = new TestTransactionBuilder();
        EntityContainer transaction03Container = testTransactionBuilder03.operationDate(transaction03OperationDateString).calculationDate(transaction03CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(650L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2500L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction03 = transaction03Container.toReference();
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1750L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1400L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1750L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1400L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(5050L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(11200L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(2950L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(9600L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(2100L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1600L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(6700L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(19850L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3600L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(12100L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3100L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(7750L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), (boolean)true)) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateBalance3() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder chartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElementBuilder.type(ChartOfAccountsElementType.CUSTOMER).organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).currency(this.currency).create();
        EntityReference chartOfAccountsElement = chartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date operationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5));
        Date calculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15));
        String operationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(operationDate);
        String calculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calculationDate);
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance = (OpeningBalance)testOpeningBalanceBuilder.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7000L))).credit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5200L))).dimension1(null).dimension2(null).dimension3(null).create();
        Date transaction01OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction01CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30));
        String transaction01OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01OperationDate);
        String transaction01CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01CalculationDate);
        TestTransactionBuilder testTransactionBuilder01 = new TestTransactionBuilder();
        EntityContainer transaction01Container = testTransactionBuilder01.operationDate(transaction01OperationDateString).calculationDate(transaction01CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6100L))).dimension1(null).dimension2(null).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L))).dimension1(null).dimension2(null).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction01 = transaction01Container.toReference();
        Date transaction02OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20));
        Date transaction02CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40));
        String transaction02OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02OperationDate);
        String transaction02CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02CalculationDate);
        TestTransactionBuilder testTransactionBuilder02 = new TestTransactionBuilder();
        EntityContainer transaction02Container = testTransactionBuilder02.operationDate(transaction02OperationDateString).calculationDate(transaction02CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3000L))).dimension1(null).dimension2(null).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1500L))).dimension1(null).dimension2(null).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction02 = transaction02Container.toReference();
        Date transaction03OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25));
        Date transaction03CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50));
        String transaction03OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03OperationDate);
        String transaction03CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03CalculationDate);
        TestTransactionBuilder testTransactionBuilder03 = new TestTransactionBuilder();
        EntityContainer transaction03Container = testTransactionBuilder03.operationDate(transaction03OperationDateString).calculationDate(transaction03CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3400L))).dimension1(null).dimension2(null).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3300L))).dimension1(null).dimension2(null).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction03 = transaction03Container.toReference();
        Assert.assertTrue((BigDecimal.valueOf(7000L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(5200L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(13100L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(13100L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(16100L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(14600L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(19500L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(17900L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateBalance4() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder chartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElementBuilder.type(ChartOfAccountsElementType.CUSTOMER).organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).currency(this.currency).create();
        EntityReference chartOfAccountsElement = chartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date operationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15));
        Date calculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30));
        String operationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(operationDate);
        String calculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calculationDate);
        TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder testOpeningBalanceBuilder = new TestOpeningBalanceInternalBuilder.TestOpeningBalanceBuilder();
        OpeningBalance balance = (OpeningBalance)testOpeningBalanceBuilder.accoountUid(chartOfAccountsElement.getUid()).operationDate(operationDateString).calculationDate(calculationDateString).debit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1500L))).credit(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3000L))).dimension1(null).dimension2(null).dimension3(null).create();
        Date transaction01OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction01CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40));
        String transaction01OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01OperationDate);
        String transaction01CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01CalculationDate);
        TestTransactionBuilder testTransactionBuilder01 = new TestTransactionBuilder();
        EntityContainer transaction01Container = testTransactionBuilder01.operationDate(transaction01OperationDateString).calculationDate(transaction01CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L))).dimension1(null).dimension2(null).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5200L))).dimension1(null).dimension2(null).dimension3(null).credit(true).end().historical(true).autocreated(true).create();
        EntityReference transaction01 = transaction01Container.toReference();
        Date transaction02OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction02CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50));
        String transaction02OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02OperationDate);
        String transaction02CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02CalculationDate);
        TestTransactionBuilder testTransactionBuilder02 = new TestTransactionBuilder();
        EntityContainer transaction02Container = testTransactionBuilder02.operationDate(transaction02OperationDateString).calculationDate(transaction02CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5200L))).dimension1(null).dimension2(null).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L))).dimension1(null).dimension2(null).dimension3(null).credit(true).end().historical(true).autocreated(true).create();
        EntityReference transaction02 = transaction02Container.toReference();
        Date transaction03OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction03CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50));
        String transaction03OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03OperationDate);
        String transaction03CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03CalculationDate);
        TestTransactionBuilder testTransactionBuilder03 = new TestTransactionBuilder();
        EntityContainer transaction03Container = testTransactionBuilder03.operationDate(transaction03OperationDateString).calculationDate(transaction03CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7500L))).dimension1(null).dimension2(null).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5300L))).dimension1(null).dimension2(null).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction03 = transaction03Container.toReference();
        Assert.assertTrue((BigDecimal.valueOf(1500L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3000L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(8900L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(8200L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(21600L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(20900L).compareTo(FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), (boolean)true)) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTransactions1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder chartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElementBuilder.type(ChartOfAccountsElementType.CUSTOMER).organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).currency(this.currency).create();
        EntityReference chartOfAccountsElement = chartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date transaction01OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5));
        Date transaction01CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35));
        String transaction01OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01OperationDate);
        String transaction01CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01CalculationDate);
        TestTransactionBuilder testTransactionBuilder01 = new TestTransactionBuilder();
        EntityContainer transaction01Container = testTransactionBuilder01.operationDate(transaction01OperationDateString).calculationDate(transaction01CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5600L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3000L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction01 = transaction01Container.toReference();
        Date transaction02OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20));
        Date transaction02CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50));
        String transaction02OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02OperationDate);
        String transaction02CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02CalculationDate);
        TestTransactionBuilder testTransactionBuilder02 = new TestTransactionBuilder();
        EntityContainer transaction02Container = testTransactionBuilder02.operationDate(transaction02OperationDateString).calculationDate(transaction02CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3900L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5100L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction02 = transaction02Container.toReference();
        Date transaction03OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25));
        Date transaction03CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40));
        String transaction03OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03OperationDate);
        String transaction03CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03CalculationDate);
        TestTransactionBuilder testTransactionBuilder03 = new TestTransactionBuilder();
        EntityContainer transaction03Container = testTransactionBuilder03.operationDate(transaction03OperationDateString).calculationDate(transaction03CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4400L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).dimension3(null).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3300L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).dimension3(null).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction03 = transaction03Container.toReference();
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), this.getDimensions(null, null, null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(4400L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3300L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1100L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(10000L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(6300L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3700L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(null, null, null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(5600L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3000L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(2600L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(4400L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3300L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1100L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(13900L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(11400L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(2500L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(null, null, null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(9500L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(8100L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1400L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(4400L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3300L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1100L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.MTD), null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.MTD), null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)55)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.MTD), null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTransactions2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder chartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElementBuilder.type(ChartOfAccountsElementType.CUSTOMER).organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).currency(this.currency).create();
        EntityReference chartOfAccountsElement = chartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date transaction01OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5));
        Date transaction01CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)15));
        String transaction01OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01OperationDate);
        String transaction01CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01CalculationDate);
        TestTransactionBuilder testTransactionBuilder01 = new TestTransactionBuilder();
        EntityContainer transaction01Container = testTransactionBuilder01.operationDate(transaction01OperationDateString).calculationDate(transaction01CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1000L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(null).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4100L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(null).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)).credit(true).end().bookingFile(this.fakeBookingFile).historical(true).autocreated(true).create();
        EntityReference transaction01 = transaction01Container.toReference();
        Date transaction02OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)25));
        Date transaction02CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50));
        String transaction02OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02OperationDate);
        String transaction02CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02CalculationDate);
        TestTransactionBuilder testTransactionBuilder02 = new TestTransactionBuilder();
        EntityContainer transaction02Container = testTransactionBuilder02.operationDate(transaction02OperationDateString).calculationDate(transaction02CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(null).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3800L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(null).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)).credit(true).end().bookingFile(null).historical(true).autocreated(true).create();
        EntityReference transaction02 = transaction02Container.toReference();
        Date transaction03OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)35));
        Date transaction03CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45));
        String transaction03OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03OperationDate);
        String transaction03CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03CalculationDate);
        TestTransactionBuilder testTransactionBuilder03 = new TestTransactionBuilder();
        EntityContainer transaction03Container = testTransactionBuilder03.operationDate(transaction03OperationDateString).calculationDate(transaction03CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2000L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(null).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2400L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency)).dimension2(null).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).credit(true).end().bookingFile(this.fakeBookingFile).historical(false).autocreated(true).create();
        EntityReference transaction03 = transaction03Container.toReference();
        Assert.assertTrue((BigDecimal.valueOf(1000L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), this.getDimensions(null, null, null), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.TRUE)), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(4100L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), this.getDimensions(null, null, null), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.TRUE)), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(-3100L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), this.getDimensions(null, null, null), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.TRUE)))) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), this.getDimensions(null, null, null), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE)), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), this.getDimensions(null, null, null), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE)), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(0L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), this.getDimensions(null, null, null), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE)))) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(2000L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)this.fakeBookingFile.getUid())), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(2400L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)this.fakeBookingFile.getUid())), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(-400L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)45)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)this.fakeBookingFile.getUid())))) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(10900L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(10300L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(null, null, null), Collections.emptyList(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(600L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(null, null, null), Collections.emptyList())) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(8900L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.TRUE)), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(7900L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.TRUE)), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(1000L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.TRUE)))) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(7900L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.TRUE), SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), null)), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(3800L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.TRUE), SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), null)), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(4100L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.TRUE), SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), null)))) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(2000L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE), SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)this.fakeBookingFile.getUid())), (boolean)false)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(2400L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE), SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)this.fakeBookingFile.getUid())), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BigDecimal.valueOf(-400L).compareTo(FinanceHelper.calculateTransactions((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)5)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)), Arrays.asList(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE), SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)this.fakeBookingFile.getUid())))) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetDimensionValues() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsElementBuilder chartOfAccountsElementBuilder = new TestChartOfAccountsElementBuilder();
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElementBuilder.type(ChartOfAccountsElementType.SUPPLIER).organization(TestBookingFileBuilder.agency).settings(chartOfAccountsSettings).currency(this.currency).create();
        EntityReference chartOfAccountsElement = chartOfAccountsElementContainer.toReference();
        Date date = new Date();
        Date transaction01OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction01CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)30));
        String transaction01OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01OperationDate);
        String transaction01CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction01CalculationDate);
        TestTransactionBuilder testTransactionBuilder01 = new TestTransactionBuilder();
        EntityContainer transaction01Container = testTransactionBuilder01.operationDate(transaction01OperationDateString).calculationDate(transaction01CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1000L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1000L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).credit(true).end().historical(true).autocreated(true).create();
        EntityReference transaction01 = transaction01Container.toReference();
        Date transaction02OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction02CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)40));
        String transaction02OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02OperationDate);
        String transaction02CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction02CalculationDate);
        TestTransactionBuilder testTransactionBuilder02 = new TestTransactionBuilder();
        EntityContainer transaction02Container = testTransactionBuilder02.operationDate(transaction02OperationDateString).calculationDate(transaction02CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6100L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT)).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6100L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT)).credit(true).end().historical(true).autocreated(true).create();
        EntityReference transaction02 = transaction02Container.toReference();
        Date transaction03OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction03CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)50));
        String transaction03OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03OperationDate);
        String transaction03CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction03CalculationDate);
        TestTransactionBuilder testTransactionBuilder03 = new TestTransactionBuilder();
        EntityContainer transaction03Container = testTransactionBuilder03.operationDate(transaction03OperationDateString).calculationDate(transaction03CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5500L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.subagency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5500L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.subagency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction03 = transaction03Container.toReference();
        Date transaction04OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction04CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)60));
        String transaction04OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction04OperationDate);
        String transaction04CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction04CalculationDate);
        TestTransactionBuilder testTransactionBuilder04 = new TestTransactionBuilder();
        EntityContainer transaction04Container = testTransactionBuilder04.operationDate(transaction04OperationDateString).calculationDate(transaction04CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.subagency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.subagency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction04 = transaction04Container.toReference();
        Date transaction05OperationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)10));
        Date transaction05CalculationDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)70));
        String transaction05OperationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction05OperationDate);
        String transaction05CalculationDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transaction05CalculationDate);
        TestTransactionBuilder testTransactionBuilder05 = new TestTransactionBuilder();
        EntityContainer transaction05Container = testTransactionBuilder05.operationDate(transaction05OperationDateString).calculationDate(transaction05CalculationDateString).split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4000L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.subagency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)).credit(false).end().split().account(chartOfAccountsElement).amount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4000L))).dimension1(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.subagency)).dimension2(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY)).dimension3(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)).credit(true).end().historical(false).autocreated(true).create();
        EntityReference transaction05 = transaction05Container.toReference();
        ProjectionQueryHelper.GroupValues values = FinanceHelper.getDimensionsValues((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)70)), this.getDimensions(null, null, null), Arrays.asList(FinanceHelper.Dimension.DIMENSION_2, FinanceHelper.Dimension.DIMENSION_3));
        Assert.assertEquals((long)values.getData().size(), (long)5L);
        Assert.assertTrue((boolean)values.values((Object)FinanceHelper.Dimension.DIMENSION_2, false).equals(new HashSet<String>(Arrays.asList(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY)))));
        Assert.assertTrue((boolean)values.groupBy((Object)FinanceHelper.Dimension.DIMENSION_2, (Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), false).values((Object)FinanceHelper.Dimension.DIMENSION_3, false).equals(new HashSet<String>(Arrays.asList(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT)))));
        Assert.assertTrue((boolean)values.groupBy((Object)FinanceHelper.Dimension.DIMENSION_2, (Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY), false).values((Object)FinanceHelper.Dimension.DIMENSION_3, false).equals(new HashSet<String>(Arrays.asList(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD)))));
        values = FinanceHelper.getDimensionsValues((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)70)), this.getDimensions(FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.subagency), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)), Arrays.asList(FinanceHelper.Dimension.DIMENSION_2, FinanceHelper.Dimension.DIMENSION_3));
        Assert.assertEquals((long)values.getData().size(), (long)1L);
        Assert.assertTrue((boolean)values.values((Object)FinanceHelper.Dimension.DIMENSION_2, false).equals(new HashSet<String>(Arrays.asList(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY)))));
        Assert.assertTrue((boolean)values.groupBy((Object)FinanceHelper.Dimension.DIMENSION_2, (Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY), false).values((Object)FinanceHelper.Dimension.DIMENSION_3, false).equals(new HashSet<String>(Arrays.asList(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH)))));
        values = FinanceHelper.getDimensionsValues((EntityReference)chartOfAccountsElement, (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)20)), (Date)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)70)), this.getDimensions(null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)), Arrays.asList(FinanceHelper.Dimension.DIMENSION_2, FinanceHelper.Dimension.DIMENSION_3));
        Assert.assertTrue((boolean)values.values((Object)FinanceHelper.Dimension.DIMENSION_2, false).equals(new HashSet<String>(Arrays.asList(FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY)))));
        Assert.assertTrue((boolean)values.groupBy((Object)FinanceHelper.Dimension.DIMENSION_2, (Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), false).values((Object)FinanceHelper.Dimension.DIMENSION_3, false).equals(new HashSet<String>(Arrays.asList(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)))));
        Assert.assertTrue((boolean)values.groupBy((Object)FinanceHelper.Dimension.DIMENSION_2, (Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.SUBAGENCY), false).values((Object)FinanceHelper.Dimension.DIMENSION_3, false).equals(new HashSet<String>(Arrays.asList(FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE)))));
    }

    private Map<FinanceHelper.Dimension, String> getDimensions(String dimension1, String dimension2, String dimension3) {
        HashMap<FinanceHelper.Dimension, String> dimensions = new HashMap<FinanceHelper.Dimension, String>();
        if (dimension1 != null) {
            dimensions.put(FinanceHelper.Dimension.DIMENSION_1, dimension1);
        }
        if (dimension2 != null) {
            dimensions.put(FinanceHelper.Dimension.DIMENSION_2, dimension2);
        }
        if (dimension3 != null) {
            dimensions.put(FinanceHelper.Dimension.DIMENSION_3, dimension3);
        }
        return dimensions;
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }
}

