/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.CreditSlipType;
import com.gridnine.xtrip.common.model.finance.DebitSlipType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationData;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationDataIndex;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.model.test.TestBillingTransactionBuilder;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestCreditBankTransferOrderBuilder;
import com.gridnine.xtrip.server.model.test.TestCreditSlipBuilder;
import com.gridnine.xtrip.server.model.test.TestDebitBankTransferOrderBuilder;
import com.gridnine.xtrip.server.model.test.TestDebitSlipBuilder;
import com.gridnine.xtrip.server.model.test.TestFinanceInitializationDataBuilder;
import com.gridnine.xtrip.server.model.test.TestOpeningBalanceInternalBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import com.gridnine.xtrip.server.model.test.TestTransactionBuilder;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class FinanceInitializationTest
extends FinanceTestBase {
    private final LongRunningTaskCallback callback = new LongRunningTaskCallback(){

        @Override
        public boolean isToBeStopped() {
            return false;
        }

        @Override
        public void addEvent(String eventId, Message description) {
        }

        @Override
        public void updateProgress(byte progress) {
        }
    };
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        EntityContainer agencyContainer = EntityStorage.get().resolve(TestBookingFileBuilder.agency);
        TestOrganizationBuilder agencyBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)agencyContainer.getEntity()).containerUid(agencyContainer.getUid());
        agencyContainer = ((TestOrganizationBuilder)((TestOrganizationBuilder)((TestOrganizationBuilder)((TestOrganizationBuilder)((TestOrganizationBuilder)agencyBuilder.fopPaymentInfo().paymentType(PaymentType.CASH).createPaymentDate(false).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.INVOICE).createPaymentDate(false).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.CREDIT_CARD).createPaymentDate(false).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.PTA).createPaymentDate(false).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.CREDIT).createPaymentDate(false).createPaymentTransaction(false).end()).create();
        EntityContainer clientContainer = EntityStorage.get().resolve(TestBookingFileBuilder.client);
        TestOrganizationBuilder clientBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)clientContainer.getEntity()).containerUid(clientContainer.getUid());
        clientContainer = ((TestOrganizationBuilder)((TestOrganizationBuilder)((TestOrganizationBuilder)clientBuilder.fopPaymentInfo().paymentType(PaymentType.CASH).createPaymentDate(true).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.INVOICE).createPaymentDate(true).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.CREDIT_CARD).createPaymentDate(true).createPaymentTransaction(false).end()).create();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testFinanceInitialization1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-4));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-3));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.PTA).amount(1540.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.CASH).amount(340.0).oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.INVOICE).amount(1200.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        new TestTransactionBuilder().organization(TestBookingFileBuilder.agency).bookingFile(bookingFile).split().credit(false).end().split().credit(true).end().create();
        new TestTransactionBuilder().organization(TestBookingFileBuilder.agency).bookingFile(bookingFile).split().credit(false).end().split().credit(true).end().create();
        new TestTransactionBuilder().organization(TestBookingFileBuilder.agency).bookingFile(bookingFile).split().credit(false).end().split().credit(true).end().create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)3L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        Assert.assertEquals((long)0L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)0L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-4));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-3));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.PTA).amount(2300.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.CASH).amount(1050.0).oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.INVOICE).amount(1250.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)3L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)3L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)0L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)0L, (long)balances.size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)3L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization3() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().dimension2().type(DimensionType.AGENT).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.PTA).amount(7100.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.CASH).amount(6090.0).oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.INVOICE).amount(1010.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)3L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7100L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7100L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7100L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7100L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1010L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1010L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)10L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization4() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.PTA).amount(2300.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.CASH).amount(1050.0).oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.INVOICE).amount(1250.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)3L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1050L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1250L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1050L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1250L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)10L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization5() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension2().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct product = new HotelProduct();
        HotelProductFop vendorFop = new HotelProductFop();
        HotelProductFop clientFop01 = new HotelProductFop();
        HotelProductFop clientFop02 = new HotelProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = TestBookingFileBuilder.getDateFormat().format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().hotelProduct(product).rulesApplied(true).issueDate(issueDateString).unholdDate(null).vendorContractRelation().fop(vendorFop).paymentType(PaymentType.PTA).amount(2300.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.CASH).amount(1050.0).oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.INVOICE).amount(1250.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)3L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1050L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1250L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1050L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1250L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1050L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1250L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1050L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1250L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)20L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization6() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct product = new HotelProduct();
        HotelProductFop vendorFop = new HotelProductFop();
        HotelProductFop clientFop01 = new HotelProductFop();
        HotelProductFop clientFop02 = new HotelProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        Date unholdDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-5));
        String unholdDateString = TestBookingFileBuilder.getDateFormat().format(unholdDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = TestBookingFileBuilder.getDateFormat().format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().hotelProduct(product).rulesApplied(true).issueDate(issueDateString).unholdDate(unholdDateString).vendorContractRelation().fop(vendorFop).paymentType(PaymentType.CREDIT_CARD).amount(7900.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.INVOICE).amount(5900.0).oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.CASH).amount(2100.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)9L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7900L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)12L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)12L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)32L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization7() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.AGENT).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().dimension2().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder01 = new TestBookingFileBuilder();
        Product product01 = new Product();
        ProductFop product01VendorFop01 = new ProductFop();
        ProductFop product01VendorFop02 = new ProductFop();
        ProductFop product01ClientFop01 = new ProductFop();
        ProductFop product01ClientFop02 = new ProductFop();
        Date product01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String product01IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product01IssueDate);
        Date product01PaymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-1));
        String product01PaymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product01PaymentDate);
        EntityContainer bookingFileContainer01 = bookingFileBuilder01.traveller().end().reservation().airProduct(product01).rulesApplied(true).systemNumber("0000000001").issueDate(product01IssueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(product01VendorFop01).paymentType(PaymentType.CASH).amount(240.0).oparationDate(product01PaymentDateString).end().fop(product01VendorFop02).paymentType(PaymentType.CREDIT).amount(1100.0).oparationDate(product01PaymentDateString).end().end().clientContractRelation().fop(product01ClientFop01).paymentType(PaymentType.CASH).amount(960.0).oparationDate(product01PaymentDateString).end().fop(product01ClientFop02).paymentType(PaymentType.CREDIT_CARD).amount(380.0).oparationDate(product01PaymentDateString).end().end().end().end().create();
        EntityReference bookingFile01 = bookingFileContainer01.toReference();
        TestBookingFileBuilder bookingFileBuilder02 = new TestBookingFileBuilder();
        Product product02 = new Product();
        ProductFop product02VendorFop01 = new ProductFop();
        ProductFop product02VendorFop02 = new ProductFop();
        ProductFop product02ClientFop01 = new ProductFop();
        ProductFop product02ClientFop02 = new ProductFop();
        Date product02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String product02IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product02IssueDate);
        Date product02PaymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String product02PaymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product02PaymentDate);
        EntityContainer bookingFileContainer02 = bookingFileBuilder02.traveller().end().reservation().airProduct(product02).rulesApplied(true).systemNumber("0000000002").issueDate(product02IssueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(product02VendorFop01).paymentType(PaymentType.INVOICE).amount(2250.0).oparationDate(product02PaymentDateString).end().fop(product02VendorFop02).paymentType(PaymentType.CASH).amount(2500.0).oparationDate(product02PaymentDateString).end().end().clientContractRelation().fop(product02ClientFop01).paymentType(PaymentType.INVOICE).amount(3020.0).oparationDate(product02PaymentDateString).end().fop(product02ClientFop02).paymentType(PaymentType.INTERLINE).amount(1730.0).oparationDate(product02PaymentDateString).end().end().end().end().create();
        EntityReference bookingFile02 = bookingFileContainer02.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)9L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile01);
        Assert.assertEquals((long)4L, (long)transactions.size());
        transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile02);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4750L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4750L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2250L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2250L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2500L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2500L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)12L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3020L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INTERLINE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3020L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INTERLINE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3020L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INTERLINE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3020L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INTERLINE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1730L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)4L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)18L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization8() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop01 = new ProductFop();
        ProductFop vendorFop02 = new ProductFop();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().generalData().currency("USD").end().fop(vendorFop01).paymentType(PaymentType.INVOICE).amount(6100.0, "USD").oparationDate(paymentDateString).end().fop(vendorFop02).paymentType(PaymentType.CREDIT).amount(1400.0, "USD").oparationDate(paymentDateString).end().end().clientContractRelation().generalData().currency("EUR").end().fop(clientFop01).paymentType(PaymentType.CASH).amount(7000.0, "EUR").oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.INVOICE).amount(2100.0, "EUR").oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)4L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7500L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6100L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1400L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7500L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6100L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1400L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)10L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization9() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer vendorChartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.blankOwner).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference vendorChartOfAccountsSettings = vendorChartOfAccountsSettingsContainer.toReference();
        chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettings = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop01 = new ProductFop();
        ProductFop vendorFop02 = new ProductFop();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().generalData().currency("EUR").end().fop(vendorFop01).paymentType(PaymentType.INVOICE).amount(5500.0, "EUR").oparationDate(paymentDateString).end().fop(vendorFop02).paymentType(PaymentType.CREDIT).amount(2900.0, "EUR").oparationDate(paymentDateString).end().end().clientContractRelation().generalData().currency("USD").end().fop(clientFop01).paymentType(PaymentType.CASH).amount(7200.0, "USD").oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.CREDIT_CARD).amount(2000.0, "USD").oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.blankOwner).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.blankOwner).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.client).create();
        Assert.assertEquals((long)8L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)5L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.blankOwner, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.blankOwner, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.blankOwner, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.blankOwner, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.blankOwner, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.blankOwner, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5500L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.blankOwner, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.blankOwner, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.blankOwner, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5500L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.blankOwner, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8400L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5500L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8400L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5500L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.client, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.client, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7200L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.client, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2000L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.client, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.client, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7200L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.client, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2000L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.blankOwner).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.client).size());
        Assert.assertEquals((long)0L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)24L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)3L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization10() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestDebitBankTransferOrderBuilder bankTransferOrderBuilder = new TestDebitBankTransferOrderBuilder();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-4));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer bankTransferOrderContainer = bankTransferOrderBuilder.name("Debit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(issueDateString).amount(6900.0).create();
        EntityReference bankTransferOrder = bankTransferOrderContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)1L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)bankTransferOrder);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)0L, (long)balances.size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)1L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization11() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestDebitBankTransferOrderBuilder bankTransferOrderBuilder = new TestDebitBankTransferOrderBuilder();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer bankTransferOrderContainer = bankTransferOrderBuilder.name("Debit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(issueDateString).amount(1500.0).create();
        EntityReference bankTransferOrder = bankTransferOrderContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)1L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)bankTransferOrder);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1500L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1500L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1500L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1500L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)4L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization12() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestCreditBankTransferOrderBuilder bankTransferOrderBuilder = new TestCreditBankTransferOrderBuilder();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer bankTransferOrderContainer = bankTransferOrderBuilder.name("Credit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(issueDateString).amount(2200.0).create();
        EntityReference bankTransferOrder = bankTransferOrderContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)1L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)bankTransferOrder);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)4L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization13() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.AGENT).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().dimension2().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestDebitBankTransferOrderBuilder debitBankTransferOrderBuilder = new TestDebitBankTransferOrderBuilder();
        Date debitBankTransferOrderIssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String debitBankTransferOrderIssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(debitBankTransferOrderIssueDate);
        EntityContainer debitBankTransferOrderContainer = debitBankTransferOrderBuilder.name("Debit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(debitBankTransferOrderIssueDateString).amount(4300.0).create();
        EntityReference debitBankTransferOrder = debitBankTransferOrderContainer.toReference();
        TestCreditBankTransferOrderBuilder creditBankTransferOrderBuilder = new TestCreditBankTransferOrderBuilder();
        Date creditBankTransferOrderIssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String creditBankTransferOrderIssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(creditBankTransferOrderIssueDate);
        EntityContainer creditBankTransferOrderContainer = creditBankTransferOrderBuilder.name("Credit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(creditBankTransferOrderIssueDateString).amount(9750.0).create();
        EntityReference creditBankTransferOrder = creditBankTransferOrderContainer.toReference();
        TestDebitSlipBuilder debitSlipBuilder = new TestDebitSlipBuilder();
        Date debitSlipIssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String debitSlipIssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(debitSlipIssueDate);
        EntityContainer debitSlipContainer = debitSlipBuilder.type(DebitSlipType.CASH_REGISTER).cashier(TestBookingFileBuilder.agencyAgent02).person(TestBookingFileBuilder.agencyAgent01).name("Debit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(debitSlipIssueDateString).amount(1650.0).create();
        EntityReference debitSlip = debitSlipContainer.toReference();
        TestCreditSlipBuilder creditSlipBuilder = new TestCreditSlipBuilder();
        Date creditSlipIssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String creditSlipIssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(creditSlipIssueDate);
        EntityContainer creditSlipContainer = creditSlipBuilder.type(CreditSlipType.BANK).cashier(TestBookingFileBuilder.agencyAgent).person(null).name("Credit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.agency).contract(contract).date(creditSlipIssueDateString).amount(6500.0).create();
        EntityReference creditSlip = creditSlipContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)2L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)debitBankTransferOrder);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)creditBankTransferOrder);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)debitSlip);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)creditSlip);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)8L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4300L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)8L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization14() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension2().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.CONTRACT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestDebitBankTransferOrderBuilder debitBankTransferOrderBuilder01 = new TestDebitBankTransferOrderBuilder();
        Date debitBankTransferOrder01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String debitBankTransferOrder01IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(debitBankTransferOrder01IssueDate);
        EntityContainer debitBankTransferOrderContainer01 = debitBankTransferOrderBuilder01.name("Debit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(debitBankTransferOrder01IssueDateString).amount(5100.0, "USD").create();
        EntityReference debitBankTransferOrder01 = debitBankTransferOrderContainer01.toReference();
        TestDebitBankTransferOrderBuilder debitBankTransferOrderBuilder02 = new TestDebitBankTransferOrderBuilder();
        Date debitBankTransferOrder02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-3));
        String debitBankTransferOrder02IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(debitBankTransferOrder02IssueDate);
        EntityContainer debitBankTransferOrderContainer02 = debitBankTransferOrderBuilder02.name("Debit bank transfer order #1234567891").number("1234567891").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(debitBankTransferOrder02IssueDateString).amount(2100.0, "USD").create();
        EntityReference debitBankTransferOrder02 = debitBankTransferOrderContainer02.toReference();
        TestCreditBankTransferOrderBuilder creditBankTransferOrderBuilder01 = new TestCreditBankTransferOrderBuilder();
        Date creditBankTransferOrder01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-4));
        String creditBankTransferOrder01IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(creditBankTransferOrder01IssueDate);
        EntityContainer creditBankTransferOrderContainer01 = creditBankTransferOrderBuilder01.name("Credit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(creditBankTransferOrder01IssueDateString).amount(4400.0, "EUR").create();
        EntityReference creditBankTransferOrder01 = creditBankTransferOrderContainer01.toReference();
        TestCreditBankTransferOrderBuilder creditBankTransferOrderBuilder02 = new TestCreditBankTransferOrderBuilder();
        Date creditBankTransferOrder02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String creditBankTransferOrder02IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(creditBankTransferOrder02IssueDate);
        EntityContainer creditBankTransferOrderContainer02 = creditBankTransferOrderBuilder02.name("Credit bank transfer order #1234567891").number("1234567891").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(creditBankTransferOrder02IssueDateString).amount(9200.0, "EUR").create();
        EntityReference creditBankTransferOrder02 = creditBankTransferOrderContainer02.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)4L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)debitBankTransferOrder01);
        Assert.assertEquals((long)1L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)debitBankTransferOrder02);
        Assert.assertEquals((long)1L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)creditBankTransferOrder01);
        Assert.assertEquals((long)1L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)creditBankTransferOrder02);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)0L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)3L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)4L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization15() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension2().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestDebitBankTransferOrderBuilder debitBankTransferOrderBuilder01 = new TestDebitBankTransferOrderBuilder();
        Date debitBankTransferOrder01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String debitBankTransferOrder01IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(debitBankTransferOrder01IssueDate);
        EntityContainer debitBankTransferOrderContainer01 = debitBankTransferOrderBuilder01.name("Debit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(debitBankTransferOrder01IssueDateString).amount(3000.0, "EUR").create();
        EntityReference debitBankTransferOrder01 = debitBankTransferOrderContainer01.toReference();
        TestDebitBankTransferOrderBuilder debitBankTransferOrderBuilder02 = new TestDebitBankTransferOrderBuilder();
        Date debitBankTransferOrder02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String debitBankTransferOrder02IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(debitBankTransferOrder02IssueDate);
        EntityContainer debitBankTransferOrderContainer02 = debitBankTransferOrderBuilder02.name("Debit bank transfer order #1234567891").number("1234567891").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(debitBankTransferOrder02IssueDateString).amount(1600.0, "USD").create();
        EntityReference debitBankTransferOrder02 = debitBankTransferOrderContainer02.toReference();
        TestDebitBankTransferOrderBuilder debitBankTransferOrderBuilder03 = new TestDebitBankTransferOrderBuilder();
        Date debitBankTransferOrder03IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String debitBankTransferOrder03IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(debitBankTransferOrder03IssueDate);
        EntityContainer debitBankTransferOrderContainer03 = debitBankTransferOrderBuilder03.name("Debit bank transfer order #1234567892").number("1234567892").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(debitBankTransferOrder03IssueDateString).amount(5300.0, "EUR").create();
        EntityReference debitBankTransferOrder03 = debitBankTransferOrderContainer03.toReference();
        TestCreditBankTransferOrderBuilder creditBankTransferOrderBuilder01 = new TestCreditBankTransferOrderBuilder();
        Date creditBankTransferOrder01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String creditBankTransferOrder01IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(creditBankTransferOrder01IssueDate);
        EntityContainer creditBankTransferOrderContainer01 = creditBankTransferOrderBuilder01.name("Credit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(creditBankTransferOrder01IssueDateString).amount(4900.0, "USD").create();
        EntityReference creditBankTransferOrder01 = creditBankTransferOrderContainer01.toReference();
        TestCreditBankTransferOrderBuilder creditBankTransferOrderBuilder02 = new TestCreditBankTransferOrderBuilder();
        Date creditBankTransferOrder02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String creditBankTransferOrder02IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(creditBankTransferOrder02IssueDate);
        EntityContainer creditBankTransferOrderContainer02 = creditBankTransferOrderBuilder02.name("Credit bank transfer order #1234567891").number("1234567891").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(creditBankTransferOrder02IssueDateString).amount(2500.0, "USD").create();
        EntityReference creditBankTransferOrder02 = creditBankTransferOrderContainer02.toReference();
        TestCreditBankTransferOrderBuilder creditBankTransferOrderBuilder03 = new TestCreditBankTransferOrderBuilder();
        Date creditBankTransferOrder03IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String creditBankTransferOrder03IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(creditBankTransferOrder03IssueDate);
        EntityContainer creditBankTransferOrderContainer03 = creditBankTransferOrderBuilder03.name("Credit bank transfer order #1234567892").number("1234567892").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(creditBankTransferOrder02IssueDateString).amount(1100.0, "EUR").create();
        EntityReference creditBankTransferOrder03 = creditBankTransferOrderContainer03.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)6L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)debitBankTransferOrder01);
        Assert.assertEquals((long)1L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)debitBankTransferOrder02);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)debitBankTransferOrder03);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)creditBankTransferOrder01);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)creditBankTransferOrder02);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)creditBankTransferOrder03);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1600L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1600L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1600L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1600L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5300L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5300L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)1L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)8L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization16() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).systemNumber("0000000001").issueDate(issueDateString).status(ProductStatus.SELL).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(4200.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.CREDIT_CARD).amount(2900.0).oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.CASH).amount(1300.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestDebitBankTransferOrderBuilder debitBankTransferOrderBuilder = new TestDebitBankTransferOrderBuilder();
        Date debitBankTransferOrderIssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String debitBankTransferOrderIssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(debitBankTransferOrderIssueDate);
        EntityContainer debitBankTransferOrderContainer = debitBankTransferOrderBuilder.name("Debit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(debitBankTransferOrderIssueDateString).amount(2800.0).create();
        EntityReference debitBankTransferOrder = debitBankTransferOrderContainer.toReference();
        TestCreditBankTransferOrderBuilder creditBankTransferOrderBuilder = new TestCreditBankTransferOrderBuilder();
        Date creditBankTransferOrderIssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String creditBankTransferOrderIssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(creditBankTransferOrderIssueDate);
        EntityContainer creditBankTransferOrderContainer = creditBankTransferOrderBuilder.name("Credit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(creditBankTransferOrderIssueDateString).amount(6200.0).create();
        EntityReference creditBankTransferOrder = creditBankTransferOrderContainer.toReference();
        TestDebitSlipBuilder debitSlipBuilder = new TestDebitSlipBuilder();
        Date debitSlipIssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String debitSlipIssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(debitSlipIssueDate);
        EntityContainer debitSlipContainer = debitSlipBuilder.type(DebitSlipType.TRANSFER).cashier(TestBookingFileBuilder.agencyAgent).person(TestBookingFileBuilder.agencyAgent).name("Debit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(debitSlipIssueDateString).amount(1750.0).create();
        EntityReference debitSlip = debitSlipContainer.toReference();
        TestCreditSlipBuilder creditSlipBuilder = new TestCreditSlipBuilder();
        Date creditSlipIssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String creditSlipIssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(creditSlipIssueDate);
        EntityContainer creditSlipContainer = creditSlipBuilder.type(CreditSlipType.TRANSFER).cashier(TestBookingFileBuilder.agencyAgent).person(TestBookingFileBuilder.agencyAgent).name("Credit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(creditSlipIssueDateString).amount(5600.0).create();
        EntityReference creditSlip = creditSlipContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)3L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)4L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)debitBankTransferOrder);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)creditBankTransferOrder);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)creditSlip);
        Assert.assertEquals((long)1L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)debitSlip);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4200L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4200L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4200L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4200L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)16L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(10400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2800L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2800L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(10400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2800L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2800L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(10400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2800L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2800L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(10400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2800L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2900L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2800L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)1L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)20L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization17() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension2().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().dimension3().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product01 = new Product();
        Product product02 = new Product();
        product01.setNextProduct(product02);
        product02.setPreviousProduct(product01);
        ProductFop product01VendorFop01 = new ProductFop();
        ProductFop product01VendorFop02 = new ProductFop();
        ProductFop product01ClientFop01 = new ProductFop();
        ProductFop product01ClientFop02 = new ProductFop();
        ProductFop product02VendorFop01 = new ProductFop();
        ProductFop product02VendorFop02 = new ProductFop();
        ProductFop product02ClientFop01 = new ProductFop();
        ProductFop product02ClientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product01).rulesApplied(true).systemNumber("0000000001").issueDate(issueDateString).status(ProductStatus.SELL).segmentTariff().segment().end().end().vendorContractRelation().fop(product01VendorFop01).paymentType(PaymentType.PTA).amount(1250.0).oparationDate(paymentDateString).end().fop(product01VendorFop02).paymentType(PaymentType.CASH).amount(6750.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(product01ClientFop01).paymentType(PaymentType.CASH).amount(3600.0).oparationDate(paymentDateString).end().fop(product01ClientFop02).paymentType(PaymentType.CREDIT_CARD).amount(4400.0).oparationDate(paymentDateString).end().end().end().airProduct(product02).rulesApplied(true).systemNumber("0000000001").issueDate(issueDateString).status(ProductStatus.REFUND).segmentTariff().segment().end().end().vendorContractRelation().fop(product02VendorFop01).paymentType(PaymentType.INVOICE).amount(2100.0).oparationDate(paymentDateString).end().fop(product02VendorFop02).paymentType(PaymentType.PTA).amount(5100.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(product02ClientFop01).paymentType(PaymentType.CASH).amount(6000.0).oparationDate(paymentDateString).end().fop(product02ClientFop02).paymentType(PaymentType.INVOICE).amount(1200.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestDebitBankTransferOrderBuilder bankTransferOrderBuilder = new TestDebitBankTransferOrderBuilder();
        issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer bankTransferOrderContainer = bankTransferOrderBuilder.name("Debit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(issueDateString).amount(1850.0).create();
        EntityReference bankTransferOrder = bankTransferOrderContainer.toReference();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)8L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)1L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBookingFileTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
        transactions = this.getPaymentDocumentTransactions((EntityReference<? extends BasePaymentDocument>)bankTransferOrder);
        Assert.assertEquals((long)0L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)8L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1250L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6750L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1250L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6750L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)16L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9050L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9050L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9050L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8000L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9050L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3600L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3600L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3600L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3600L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3050L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3050L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3050L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3050L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getBookingFileTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getPaymentDocumentTransactions(null).size());
        Assert.assertEquals((long)24L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization18() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBillingTransactionBuilder billingTransactionBuilder01 = new TestBillingTransactionBuilder();
        Date billingTransaction01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-3));
        String billingTransaction01IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction01IssueDate);
        EntityContainer billingTransactionContainer01 = billingTransactionBuilder01.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(5100.0).date(billingTransaction01IssueDateString).description("Deposit").create();
        EntityReference billingTransactionReference01 = billingTransactionContainer01.toReference();
        BillingTransaction billingTransaction01 = (BillingTransaction)billingTransactionContainer01.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder02 = new TestBillingTransactionBuilder();
        Date billingTransaction02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String billingTransaction02IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction02IssueDate);
        EntityContainer billingTransactionContainer02 = billingTransactionBuilder02.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.CORRECTION).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(4000.0).date(billingTransaction02IssueDateString).description("Correction 01").create();
        EntityReference billingTransactionReference02 = billingTransactionContainer02.toReference();
        BillingTransaction billingTransaction02 = (BillingTransaction)billingTransactionContainer02.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder03 = new TestBillingTransactionBuilder();
        Date billingTransaction03IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-1));
        String billingTransaction03IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction03IssueDate);
        EntityContainer billingTransactionContainer03 = billingTransactionBuilder03.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.CREDIT).type(BillingTransactionType.CORRECTION).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(6150.0).date(billingTransaction03IssueDateString).description("Correction 02").create();
        EntityReference billingTransactionReference03 = billingTransactionContainer03.toReference();
        BillingTransaction billingTransaction03 = (BillingTransaction)billingTransactionContainer03.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder04 = new TestBillingTransactionBuilder();
        Date billingTransaction04IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-8));
        String billingTransaction04IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction04IssueDate);
        EntityContainer billingTransactionContainer04 = billingTransactionBuilder04.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.COMMISSION).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(2700.0).date(billingTransaction04IssueDateString).description("Commission").create();
        EntityReference billingTransactionReference04 = billingTransactionContainer04.toReference();
        BillingTransaction billingTransaction04 = (BillingTransaction)billingTransactionContainer04.getEntity();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)4L, (long)this.getBillingTransactionTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBillingTransactionTransactions((EntityReference<BillingTransaction>)billingTransactionReference01);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getBillingTransactionTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, billingTransactionReference01.getUid(), false, false);
        Assert.assertEquals((Object)billingTransactionReference01.getUid(), (Object)transaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction01.getDate(), (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5100L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5100L)), (long)debitTransactionSplit.getAmount());
        transactions = this.getBillingTransactionTransactions((EntityReference<BillingTransaction>)billingTransactionReference02);
        Assert.assertEquals((long)1L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getBillingTransactionTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, billingTransactionReference02.getUid(), false, false);
        Assert.assertEquals((Object)billingTransactionReference02.getUid(), (Object)transaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction02.getDate(), (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4000L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4000L)), (long)debitTransactionSplit.getAmount());
        transactions = this.getBillingTransactionTransactions((EntityReference<BillingTransaction>)billingTransactionReference03);
        Assert.assertEquals((long)1L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getBillingTransactionTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, billingTransactionReference03.getUid(), false, true);
        Assert.assertEquals((Object)billingTransactionReference03.getUid(), (Object)transaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction03.getDate(), (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-6150L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-6150L)), (long)debitTransactionSplit.getAmount());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2700L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2700L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)3L, (long)this.getBillingTransactionTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization19() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBillingTransactionBuilder billingTransactionBuilder01 = new TestBillingTransactionBuilder();
        Date billingTransaction01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String billingTransaction01IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction01IssueDate);
        EntityContainer billingTransactionContainer01 = billingTransactionBuilder01.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.HOLD).paymentType(PaymentType.INVOICE).amount(7700.0).date(billingTransaction01IssueDateString).description("Payment 01").create();
        EntityReference billingTransactionReference01 = billingTransactionContainer01.toReference();
        BillingTransaction billingTransaction01 = (BillingTransaction)billingTransactionContainer01.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder02 = new TestBillingTransactionBuilder();
        Date billingTransaction02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-8));
        String billingTransaction02IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction02IssueDate);
        EntityContainer billingTransactionContainer02 = billingTransactionBuilder02.agency(TestBookingFileBuilder.blankOwner).client(TestBookingFileBuilder.agency).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.HOLD).paymentType(PaymentType.INVOICE).amount(5750.0).date(billingTransaction02IssueDateString).description("Payment 02").create();
        EntityReference billingTransactionReference02 = billingTransactionContainer02.toReference();
        BillingTransaction billingTransaction02 = (BillingTransaction)billingTransactionContainer02.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder03 = new TestBillingTransactionBuilder();
        Date billingTransaction03IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String billingTransaction03IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction03IssueDate);
        EntityContainer billingTransactionContainer03 = billingTransactionBuilder03.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.HOLD).paymentType(PaymentType.INVOICE).amount(9200.0).date(billingTransaction03IssueDateString).description("Payment 03").create();
        EntityReference billingTransactionReference03 = billingTransactionContainer03.toReference();
        BillingTransaction billingTransaction03 = (BillingTransaction)billingTransactionContainer03.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder04 = new TestBillingTransactionBuilder();
        Date billingTransaction04IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String billingTransaction04IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction04IssueDate);
        EntityContainer billingTransactionContainer04 = billingTransactionBuilder04.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.CREDIT).type(BillingTransactionType.CORRECTION).status(BillingTransactionStatus.HOLD).paymentType(PaymentType.INVOICE).amount(1300.0).date(billingTransaction04IssueDateString).description("Correction").create();
        EntityReference billingTransactionReference04 = billingTransactionContainer04.toReference();
        BillingTransaction billingTransaction04 = (BillingTransaction)billingTransactionContainer04.getEntity();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)4L, (long)this.getBillingTransactionTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBillingTransactionTransactions((EntityReference<BillingTransaction>)billingTransactionReference01);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getBillingTransactionTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, billingTransactionReference01.getUid(), false, false);
        Assert.assertEquals((Object)billingTransactionReference01.getUid(), (Object)transaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction01.getDate(), (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7700L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7700L)), (long)debitTransactionSplit.getAmount());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9200L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)1L, (long)this.getBillingTransactionTransactions(null).size());
        Assert.assertEquals((long)4L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization20() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBillingTransactionBuilder billingTransactionBuilder01 = new TestBillingTransactionBuilder();
        Date billingTransaction01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String billingTransaction01IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction01IssueDate);
        EntityContainer billingTransactionContainer01 = billingTransactionBuilder01.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(7400.0, "USD").date(billingTransaction01IssueDateString).description("Payment 01").create();
        EntityReference billingTransactionReference01 = billingTransactionContainer01.toReference();
        BillingTransaction billingTransaction01 = (BillingTransaction)billingTransactionContainer01.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder02 = new TestBillingTransactionBuilder();
        Date billingTransaction02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String billingTransaction02IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction02IssueDate);
        EntityContainer billingTransactionContainer02 = billingTransactionBuilder02.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(1500.0, "USD").date(billingTransaction02IssueDateString).description("Payment 02").create();
        EntityReference billingTransactionReference02 = billingTransactionContainer02.toReference();
        BillingTransaction billingTransaction02 = (BillingTransaction)billingTransactionContainer02.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder03 = new TestBillingTransactionBuilder();
        Date billingTransaction03IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-8));
        String billingTransaction03IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction03IssueDate);
        EntityContainer billingTransactionContainer03 = billingTransactionBuilder03.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.CREDIT).type(BillingTransactionType.CORRECTION).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(1300.0, "USD").date(billingTransaction03IssueDateString).description("Correction 01").create();
        EntityReference billingTransactionReference03 = billingTransactionContainer03.toReference();
        BillingTransaction billingTransaction03 = (BillingTransaction)billingTransactionContainer03.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder04 = new TestBillingTransactionBuilder();
        Date billingTransaction04IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-9));
        String billingTransaction04IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction04IssueDate);
        EntityContainer billingTransactionContainer04 = billingTransactionBuilder04.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(5200.0, "EUR").date(billingTransaction04IssueDateString).description("Payment 03").create();
        EntityReference billingTransactionReference04 = billingTransactionContainer04.toReference();
        BillingTransaction billingTransaction04 = (BillingTransaction)billingTransactionContainer04.getEntity();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)4L, (long)this.getBillingTransactionTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8900L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1300L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8900L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5200L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5200L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)0L, (long)this.getBillingTransactionTransactions(null).size());
        Assert.assertEquals((long)4L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    @Test
    public void testFinanceInitialization21() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBillingTransactionBuilder billingTransactionBuilder01 = new TestBillingTransactionBuilder();
        Date billingTransaction01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String billingTransaction01IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction01IssueDate);
        EntityContainer billingTransactionContainer01 = billingTransactionBuilder01.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(3200.0, "USD").date(billingTransaction01IssueDateString).description("Payment 01").create();
        EntityReference billingTransactionReference01 = billingTransactionContainer01.toReference();
        BillingTransaction billingTransaction01 = (BillingTransaction)billingTransactionContainer01.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder02 = new TestBillingTransactionBuilder();
        Date billingTransaction02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-3));
        String billingTransaction02IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction02IssueDate);
        EntityContainer billingTransactionContainer02 = billingTransactionBuilder02.agency(TestBookingFileBuilder.blankOwner).client(TestBookingFileBuilder.agency).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(6000.0, "EUR").date(billingTransaction02IssueDateString).description("Payment 02").create();
        EntityReference billingTransactionReference02 = billingTransactionContainer02.toReference();
        BillingTransaction billingTransaction02 = (BillingTransaction)billingTransactionContainer02.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder03 = new TestBillingTransactionBuilder();
        Date billingTransaction03IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-4));
        String billingTransaction03IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction03IssueDate);
        EntityContainer billingTransactionContainer03 = billingTransactionBuilder03.agency(TestBookingFileBuilder.blankOwner).client(TestBookingFileBuilder.agency).category(BillingTransactionCategory.CREDIT).type(BillingTransactionType.CORRECTION).status(BillingTransactionStatus.HOLD).paymentType(PaymentType.INVOICE).amount(2500.0, "USD").date(billingTransaction03IssueDateString).description("Correction 01").create();
        EntityReference billingTransactionReference03 = billingTransactionContainer03.toReference();
        BillingTransaction billingTransaction03 = (BillingTransaction)billingTransactionContainer03.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder04 = new TestBillingTransactionBuilder();
        Date billingTransaction04IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String billingTransaction04IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction04IssueDate);
        EntityContainer billingTransactionContainer04 = billingTransactionBuilder04.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(7800.0, "EUR").date(billingTransaction04IssueDateString).description("Payment 03").create();
        EntityReference billingTransactionReference04 = billingTransactionContainer04.toReference();
        BillingTransaction billingTransaction04 = (BillingTransaction)billingTransactionContainer04.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder05 = new TestBillingTransactionBuilder();
        Date billingTransaction05IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String billingTransaction05IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction05IssueDate);
        EntityContainer billingTransactionContainer05 = billingTransactionBuilder05.agency(TestBookingFileBuilder.blankOwner).client(TestBookingFileBuilder.agency).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.CORRECTION).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(1400.0, "USD").date(billingTransaction05IssueDateString).description("Correction 02").create();
        EntityReference billingTransactionReference05 = billingTransactionContainer05.toReference();
        BillingTransaction billingTransaction05 = (BillingTransaction)billingTransactionContainer05.getEntity();
        TestBillingTransactionBuilder billingTransactionBuilder06 = new TestBillingTransactionBuilder();
        Date billingTransaction06IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-8));
        String billingTransaction06IssueDateString = TestBookingFileBuilder.getDateFormat().format(billingTransaction06IssueDate);
        EntityContainer billingTransactionContainer06 = billingTransactionBuilder06.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.CREDIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.HOLD).paymentType(PaymentType.INVOICE).amount(8100.0, "EUR").date(billingTransaction06IssueDateString).description("Payment 04").create();
        EntityReference billingTransactionReference06 = billingTransactionContainer06.toReference();
        BillingTransaction billingTransaction06 = (BillingTransaction)billingTransactionContainer06.getEntity();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestOpeningBalanceInternalBuilder().organizationUid(TestBookingFileBuilder.agency.getUid()).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        new TestFinanceInitializationDataBuilder().organization(TestBookingFileBuilder.agency).create();
        Assert.assertEquals((long)6L, (long)this.getBillingTransactionTransactions(null).size());
        Assert.assertEquals((long)2L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)2L, (long)this.getFinanceInitiaizationDatas(null).size());
        this.fireInitialization();
        List<Transaction> transactions = this.getBillingTransactionTransactions((EntityReference<BillingTransaction>)billingTransactionReference01);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getBillingTransactionTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, billingTransactionReference01.getUid(), false, false);
        Assert.assertEquals((Object)billingTransactionReference01.getUid(), (Object)transaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction01.getDate(), (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3200L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3200L)), (long)debitTransactionSplit.getAmount());
        transactions = this.getBillingTransactionTransactions((EntityReference<BillingTransaction>)billingTransactionReference02);
        Assert.assertEquals((long)1L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getBillingTransactionTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, billingTransactionReference02.getUid(), false, false);
        Assert.assertEquals((Object)billingTransactionReference02.getUid(), (Object)transaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction02.getDate(), (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), (long)debitTransactionSplit.getAmount());
        transactions = this.getBillingTransactionTransactions((EntityReference<BillingTransaction>)billingTransactionReference03);
        Assert.assertEquals((long)1L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getBillingTransactionTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, billingTransactionReference03.getUid(), false, true);
        Assert.assertEquals((Object)billingTransactionReference03.getUid(), (Object)transaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction03.getDate(), (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-2500L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-2500L)), (long)debitTransactionSplit.getAmount());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)0L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)0L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)0L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7800L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7800L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_USD);
        Assert.assertEquals((long)0L, (long)chartOfAccountsElements.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT, (DictionaryReference<CurrencyInfo>)TestBookingFileBuilder.CURRENCY_EUR);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, null, null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, (EntityReference<Organization>)TestBookingFileBuilder.agency, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8100L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas((EntityReference<Organization>)TestBookingFileBuilder.agency).size());
        Assert.assertEquals((long)3L, (long)this.getBillingTransactionTransactions(null).size());
        Assert.assertEquals((long)6L, (long)this.getBalances(null).size());
        Assert.assertEquals((long)1L, (long)this.getFinanceInitiaizationDatas(null).size());
    }

    private void checkBalance(List<OpeningBalance> balances, EntityReference<Organization> organization, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, String dimension1, String dimension2, String dimension3, long debit, long credit, boolean exists) throws Exception {
        OpeningBalance balance = this.getBalance(balances, dimension1, dimension2, dimension3);
        if (exists) {
            Assert.assertNotNull((Object)balance);
            Assert.assertEquals((Object)organization.getUid(), (Object)balance.getOrganizationUid());
            Assert.assertEquals((Object)chartOfAccountsElement.getUid(), (Object)balance.getAccountUid());
            Assert.assertEquals((Object)dimension1, (Object)balance.getDimension1());
            Assert.assertEquals((Object)dimension2, (Object)balance.getDimension2());
            Assert.assertEquals((Object)dimension3, (Object)balance.getDimension3());
            Assert.assertEquals((long)debit, (long)balance.getDebit());
            Assert.assertEquals((long)credit, (long)balance.getCredit());
        } else {
            Assert.assertNull((Object)balance);
        }
    }

    private List<Transaction> getBookingFileTransactions(EntityReference<BookingFile> bookingFile) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.bookingUid.name(), null));
        if (bookingFile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), bookingFile));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<Transaction> getPaymentDocumentTransactions(EntityReference<? extends BasePaymentDocument> paymentDocument) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.documentUid.name(), null));
        if (paymentDocument != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.documentUid.name(), paymentDocument));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<Transaction> getBillingTransactionTransactions(EntityReference<BillingTransaction> billingTransaction) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.transactionUid.name(), null));
        if (billingTransaction != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.transactionUid.name(), billingTransaction));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private Transaction getBillingTransactionTransaction(List<Transaction> transactions, EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement, EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement, String transactionUid, boolean historical, boolean refund) {
        for (Transaction transaction : transactions) {
            TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
            TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
            if (!TextUtil.isSame((String)transaction.getTransactionUid(), (String)transactionUid) || transaction.isHistorical() != historical || creditTransactionSplit == null || creditTransactionSplit.getAmount() < 0L != refund || debitTransactionSplit == null || debitTransactionSplit.getAmount() < 0L != refund) continue;
            return transaction;
        }
        return null;
    }

    private List<OpeningBalance> getBalances(EntityReference<ChartOfAccountsElement> chartOfAccountsElement) {
        SearchQuery query = new SearchQuery();
        if (chartOfAccountsElement != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.accountUid.name(), chartOfAccountsElement));
        }
        return AssetsStorage.get().search(OpeningBalance.class, query).getData();
    }

    private OpeningBalance getBalance(List<OpeningBalance> balances, String dimension1, String dimension2, String dimension3) {
        for (OpeningBalance balance : balances) {
            if (!MiscUtil.equals((Object)balance.getDimension1(), (Object)dimension1) || !MiscUtil.equals((Object)balance.getDimension2(), (Object)dimension2) || !MiscUtil.equals((Object)balance.getDimension3(), (Object)dimension3)) continue;
            return balance;
        }
        return null;
    }

    private TransactionSplit getTransactionSplit(Transaction transaction, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, boolean credit) {
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            if (credit != transactionSplit.isCredit() || !MiscUtil.equals((Object)transactionSplit.getAccount(), chartOfAccountsElement)) continue;
            return transactionSplit;
        }
        return null;
    }

    private List<FinanceInitializationData> getFinanceInitiaizationDatas(EntityReference<Organization> organization) {
        ArrayList<FinanceInitializationData> datas = new ArrayList<FinanceInitializationData>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)FinanceInitializationDataIndex.Property.organization.name(), null));
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceInitializationDataIndex.Property.organization.name(), organization));
        }
        List dataIndexes = EntityStorage.get().search(FinanceInitializationDataIndex.class, query).getData();
        for (FinanceInitializationDataIndex dataIndex : dataIndexes) {
            FinanceInitializationData data;
            EntityContainer dataContainer = EntityStorage.get().resolve(dataIndex.getSource());
            if (dataContainer == null || datas.contains(data = (FinanceInitializationData)dataContainer.getEntity())) continue;
            datas.add(data);
        }
        return datas;
    }

    protected void fireInitialization() {
        HashMap<String, LongRunningTaskCallback> data = new HashMap<String, LongRunningTaskCallback>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:initialization").processSync(data);
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }
}

