/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.test.TestBillingTransactionBuilder;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceSaveBillingTransactionTest
extends FinanceTestBase {
    private final EntityReference<BookingFile> fakeBookingFile = new EntityReference("fake_booking_file", BookingFile.class, "Fake booking file");
    private final EntityReference<DebitBankTransferOrder> fakePaymentDocument = new EntityReference("fake_payment_document", DebitBankTransferOrder.class, "Fake payment document");
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testFinanceSaveTransaction1() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettingsReference = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBillingTransactionBuilder billingTransactionBuilder = new TestBillingTransactionBuilder();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        EntityContainer billingTransactionContainer = billingTransactionBuilder.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.REPAYMENT).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.CASH).amount(3100.0).date(issueDateString).entity(this.fakeBookingFile).description("Refund").create();
        EntityReference billingTransactionReference = billingTransactionContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BillingTransaction>)billingTransactionReference);
        Assert.assertEquals((long)0L, (long)transactions.size());
    }

    @Test
    public void testFinanceSaveTransaction2() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettingsReference = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBillingTransactionBuilder billingTransactionBuilder = new TestBillingTransactionBuilder();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        EntityContainer billingTransactionContainer = billingTransactionBuilder.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.CASH).amount(3100.0).date(issueDateString).entity(this.fakeBookingFile).description("Payment").create();
        EntityReference billingTransactionReference = billingTransactionContainer.toReference();
        BillingTransaction billingTransaction = (BillingTransaction)billingTransactionContainer.getEntity();
        List<Transaction> transactions = this.getTransactions((EntityReference<BillingTransaction>)billingTransactionReference);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> agencyCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> agencyDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)agencyCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)agencyDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> agencyCreditChartOfAccountsElement = agencyCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> agencyDebitChartOfAccountsElement = agencyDebitChartOfAccountsElements.get(0);
        Transaction agencyTransaction = this.getTransaction(transactions, agencyCreditChartOfAccountsElement, agencyDebitChartOfAccountsElement, billingTransactionReference.getUid(), false, false);
        Assert.assertNotNull((Object)agencyTransaction);
        Assert.assertEquals((Object)billingTransaction.getEntity(), (Object)agencyTransaction.getBooking());
        Assert.assertEquals((Object)billingTransactionReference.getUid(), (Object)agencyTransaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction.getDate(), (Object)agencyTransaction.getOperationDate());
        Assert.assertFalse((boolean)agencyTransaction.isAutocreated());
        Assert.assertFalse((boolean)agencyTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)agencyTransaction.getSplits().size());
        TransactionSplit agencyCreditTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)agencyCreditTransactionSplit);
        Assert.assertTrue((boolean)agencyCreditTransactionSplit.isCredit());
        Assert.assertEquals(agencyCreditChartOfAccountsElement, (Object)agencyCreditTransactionSplit.getAccount());
        Assert.assertNull((Object)agencyCreditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), (Object)agencyCreditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)agencyCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3100L)), (long)agencyCreditTransactionSplit.getAmount());
        TransactionSplit agencyDebitTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyDebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)agencyDebitTransactionSplit);
        Assert.assertFalse((boolean)agencyDebitTransactionSplit.isCredit());
        Assert.assertEquals(agencyDebitChartOfAccountsElement, (Object)agencyDebitTransactionSplit.getAccount());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension1());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension2());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3100L)), (long)agencyDebitTransactionSplit.getAmount());
        List<EntityReference<ChartOfAccountsElement>> clientCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.BANK, this.currency);
        List<EntityReference<ChartOfAccountsElement>> clientDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)clientCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)clientDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> clientCreditChartOfAccountsElement = clientCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> clientCebitChartOfAccountsElement = clientDebitChartOfAccountsElements.get(0);
        Transaction clientTransaction = this.getTransaction(transactions, clientCreditChartOfAccountsElement, clientCebitChartOfAccountsElement, billingTransactionReference.getUid(), false, false);
        Assert.assertNotNull((Object)clientTransaction);
        Assert.assertEquals((Object)billingTransaction.getEntity(), (Object)agencyTransaction.getBooking());
        Assert.assertEquals((Object)billingTransactionReference.getUid(), (Object)clientTransaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction.getDate(), (Object)clientTransaction.getOperationDate());
        Assert.assertFalse((boolean)clientTransaction.isAutocreated());
        Assert.assertFalse((boolean)clientTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)clientTransaction.getSplits().size());
        TransactionSplit clientCreditTransactionSplit = this.getTransactionSplit(clientTransaction, clientCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)clientCreditTransactionSplit);
        Assert.assertTrue((boolean)clientCreditTransactionSplit.isCredit());
        Assert.assertEquals(clientCreditChartOfAccountsElement, (Object)clientCreditTransactionSplit.getAccount());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension1());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension2());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3100L)), (long)clientCreditTransactionSplit.getAmount());
        TransactionSplit clientDebitTransactionSplit = this.getTransactionSplit(clientTransaction, clientCebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)clientDebitTransactionSplit);
        Assert.assertFalse((boolean)clientDebitTransactionSplit.isCredit());
        Assert.assertEquals(clientCebitChartOfAccountsElement, (Object)clientDebitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)clientDebitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), (Object)clientDebitTransactionSplit.getDimension2());
        Assert.assertNull((Object)clientDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3100L)), (long)clientDebitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveTransaction3() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettingsReference = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBillingTransactionBuilder billingTransactionBuilder = new TestBillingTransactionBuilder();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        EntityContainer billingTransactionContainer = billingTransactionBuilder.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.CORRECTION).status(BillingTransactionStatus.ACTIVE).paymentType(PaymentType.INVOICE).amount(7450.0).date(issueDateString).entity(this.fakePaymentDocument).description("Correction").create();
        EntityReference billingTransactionReference = billingTransactionContainer.toReference();
        BillingTransaction billingTransaction = (BillingTransaction)billingTransactionContainer.getEntity();
        List<Transaction> transactions = this.getTransactions((EntityReference<BillingTransaction>)billingTransactionReference);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> agencyCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> agencyDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)agencyCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)agencyDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> agencyCreditChartOfAccountsElement = agencyCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> agencyDebitChartOfAccountsElement = agencyDebitChartOfAccountsElements.get(0);
        Transaction agencyTransaction = this.getTransaction(transactions, agencyCreditChartOfAccountsElement, agencyDebitChartOfAccountsElement, billingTransactionReference.getUid(), false, false);
        Assert.assertNotNull((Object)agencyTransaction);
        Assert.assertEquals((Object)this.fakePaymentDocument.getUid(), (Object)agencyTransaction.getDocumentUid());
        Assert.assertEquals((Object)billingTransactionReference.getUid(), (Object)agencyTransaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction.getDate(), (Object)agencyTransaction.getOperationDate());
        Assert.assertFalse((boolean)agencyTransaction.isAutocreated());
        Assert.assertFalse((boolean)agencyTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)agencyTransaction.getSplits().size());
        TransactionSplit agencyCreditTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)agencyCreditTransactionSplit);
        Assert.assertTrue((boolean)agencyCreditTransactionSplit.isCredit());
        Assert.assertEquals(agencyCreditChartOfAccountsElement, (Object)agencyCreditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)agencyCreditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)agencyCreditTransactionSplit.getDimension2());
        Assert.assertNull((Object)agencyCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7450L)), (long)agencyCreditTransactionSplit.getAmount());
        TransactionSplit agencyDebitTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyDebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)agencyDebitTransactionSplit);
        Assert.assertFalse((boolean)agencyDebitTransactionSplit.isCredit());
        Assert.assertEquals(agencyDebitChartOfAccountsElement, (Object)agencyDebitTransactionSplit.getAccount());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension1());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension2());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7450L)), (long)agencyDebitTransactionSplit.getAmount());
        List<EntityReference<ChartOfAccountsElement>> clientCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.BANK, this.currency);
        List<EntityReference<ChartOfAccountsElement>> clientDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)clientCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)clientDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> clientCreditChartOfAccountsElement = clientCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> clientCebitChartOfAccountsElement = clientDebitChartOfAccountsElements.get(0);
        Transaction clientTransaction = this.getTransaction(transactions, clientCreditChartOfAccountsElement, clientCebitChartOfAccountsElement, billingTransactionReference.getUid(), false, false);
        Assert.assertNotNull((Object)clientTransaction);
        Assert.assertEquals((Object)this.fakePaymentDocument.getUid(), (Object)agencyTransaction.getDocumentUid());
        Assert.assertEquals((Object)billingTransactionReference.getUid(), (Object)clientTransaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction.getDate(), (Object)clientTransaction.getOperationDate());
        Assert.assertFalse((boolean)clientTransaction.isAutocreated());
        Assert.assertFalse((boolean)clientTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)clientTransaction.getSplits().size());
        TransactionSplit clientCreditTransactionSplit = this.getTransactionSplit(clientTransaction, clientCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)clientCreditTransactionSplit);
        Assert.assertTrue((boolean)clientCreditTransactionSplit.isCredit());
        Assert.assertEquals(clientCreditChartOfAccountsElement, (Object)clientCreditTransactionSplit.getAccount());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension1());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension2());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7450L)), (long)clientCreditTransactionSplit.getAmount());
        TransactionSplit clientDebitTransactionSplit = this.getTransactionSplit(clientTransaction, clientCebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)clientDebitTransactionSplit);
        Assert.assertFalse((boolean)clientDebitTransactionSplit.isCredit());
        Assert.assertEquals(clientCebitChartOfAccountsElement, (Object)clientDebitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)clientDebitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)clientDebitTransactionSplit.getDimension2());
        Assert.assertNull((Object)clientDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7450L)), (long)clientDebitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveTransaction4() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettingsReference = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBillingTransactionBuilder billingTransactionBuilder = new TestBillingTransactionBuilder();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String issueDateString = TestBookingFileBuilder.getDateFormat().format(issueDate);
        EntityContainer billingTransactionContainer = billingTransactionBuilder.agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).category(BillingTransactionCategory.DEBIT).type(BillingTransactionType.BILLING).status(BillingTransactionStatus.HOLD).paymentType(PaymentType.INVOICE).amount(7700.0).date(issueDateString).entity(null).description("Payment").create();
        EntityReference billingTransactionReference = billingTransactionContainer.toReference();
        BillingTransaction billingTransaction = (BillingTransaction)billingTransactionContainer.getEntity();
        List<Transaction> transactions = this.getTransactions((EntityReference<BillingTransaction>)billingTransactionReference);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> agencyCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT, this.currency);
        List<EntityReference<ChartOfAccountsElement>> agencyDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)agencyCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)agencyDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> agencyCreditChartOfAccountsElement = agencyCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> agencyDebitChartOfAccountsElement = agencyDebitChartOfAccountsElements.get(0);
        Transaction agencyTransaction = this.getTransaction(transactions, agencyCreditChartOfAccountsElement, agencyDebitChartOfAccountsElement, billingTransactionReference.getUid(), false, false);
        Assert.assertNotNull((Object)agencyTransaction);
        Assert.assertEquals((Object)billingTransactionReference.getUid(), (Object)agencyTransaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction.getDate(), (Object)agencyTransaction.getOperationDate());
        Assert.assertFalse((boolean)agencyTransaction.isAutocreated());
        Assert.assertFalse((boolean)agencyTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)agencyTransaction.getSplits().size());
        TransactionSplit agencyCreditTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)agencyCreditTransactionSplit);
        Assert.assertTrue((boolean)agencyCreditTransactionSplit.isCredit());
        Assert.assertEquals(agencyCreditChartOfAccountsElement, (Object)agencyCreditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)agencyCreditTransactionSplit.getDimension1());
        Assert.assertNull((Object)agencyCreditTransactionSplit.getDimension2());
        Assert.assertNull((Object)agencyCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7700L)), (long)agencyCreditTransactionSplit.getAmount());
        TransactionSplit agencyDebitTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyDebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)agencyDebitTransactionSplit);
        Assert.assertFalse((boolean)agencyDebitTransactionSplit.isCredit());
        Assert.assertEquals(agencyDebitChartOfAccountsElement, (Object)agencyDebitTransactionSplit.getAccount());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension1());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension2());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7700L)), (long)agencyDebitTransactionSplit.getAmount());
        List<EntityReference<ChartOfAccountsElement>> clientCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.BANK, this.currency);
        List<EntityReference<ChartOfAccountsElement>> clientDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT, this.currency);
        Assert.assertEquals((long)1L, (long)clientCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)clientDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> clientCreditChartOfAccountsElement = clientCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> clientCebitChartOfAccountsElement = clientDebitChartOfAccountsElements.get(0);
        Transaction clientTransaction = this.getTransaction(transactions, clientCreditChartOfAccountsElement, clientCebitChartOfAccountsElement, billingTransactionReference.getUid(), false, false);
        Assert.assertNotNull((Object)clientTransaction);
        Assert.assertEquals((Object)billingTransactionReference.getUid(), (Object)clientTransaction.getTransactionUid());
        Assert.assertEquals((Object)billingTransaction.getDate(), (Object)clientTransaction.getOperationDate());
        Assert.assertFalse((boolean)clientTransaction.isAutocreated());
        Assert.assertFalse((boolean)clientTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)clientTransaction.getSplits().size());
        TransactionSplit clientCreditTransactionSplit = this.getTransactionSplit(clientTransaction, clientCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)clientCreditTransactionSplit);
        Assert.assertTrue((boolean)clientCreditTransactionSplit.isCredit());
        Assert.assertEquals(clientCreditChartOfAccountsElement, (Object)clientCreditTransactionSplit.getAccount());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension1());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension2());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7700L)), (long)clientCreditTransactionSplit.getAmount());
        TransactionSplit clientDebitTransactionSplit = this.getTransactionSplit(clientTransaction, clientCebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)clientDebitTransactionSplit);
        Assert.assertFalse((boolean)clientDebitTransactionSplit.isCredit());
        Assert.assertEquals(clientCebitChartOfAccountsElement, (Object)clientDebitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)clientDebitTransactionSplit.getDimension1());
        Assert.assertNull((Object)clientDebitTransactionSplit.getDimension2());
        Assert.assertNull((Object)clientDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7700L)), (long)clientDebitTransactionSplit.getAmount());
    }

    private List<Transaction> getTransactions(EntityReference<BillingTransaction> billingTransaction) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.transactionUid.name(), null));
        if (billingTransaction != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.transactionUid.name(), billingTransaction));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private Transaction getTransaction(List<Transaction> transactions, EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement, EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement, String transactionUid, boolean historical, boolean refund) {
        for (Transaction transaction : transactions) {
            TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
            TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
            if (!TextUtil.isSame((String)transaction.getTransactionUid(), (String)transactionUid) || transaction.isHistorical() != historical || creditTransactionSplit == null || creditTransactionSplit.getAmount() < 0L != refund || debitTransactionSplit == null || debitTransactionSplit.getAmount() < 0L != refund) continue;
            return transaction;
        }
        return null;
    }

    private TransactionSplit getTransactionSplit(Transaction transaction, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, boolean credit) {
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            if (credit != transactionSplit.isCredit() || !MiscUtil.equals((Object)transactionSplit.getAccount(), chartOfAccountsElement)) continue;
            return transactionSplit;
        }
        return null;
    }
}

