/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesUpdateTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.fops.Actions;
import com.gridnine.xtrip.common.model.rules.fops.Properties;
import com.gridnine.xtrip.common.model.rules.fops.Targets;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.finance.FinanceUpdateBalancesTest;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.model.test.TestAirProductBuilder;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionPropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestModelContractBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import com.gridnine.xtrip.server.model.test.TestRuleSetBuilder;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceSaveBookingFileTest
extends FinanceTestBase {
    private final LongRunningTaskCallback callback = new LongRunningTaskCallback(){

        @Override
        public boolean isToBeStopped() {
            return false;
        }

        @Override
        public void addEvent(String eventId, Message description) {
        }

        @Override
        public void updateProgress(byte progress) {
        }
    };
    private final FinanceBalancesUpdateTaskConfiguration balancesUpdateConfiguration = new FinanceBalancesUpdateTaskConfiguration();
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        EntityContainer agencyContainer = EntityStorage.get().resolve(TestBookingFileBuilder.agency);
        TestOrganizationBuilder agencyBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)agencyContainer.getEntity()).containerUid(agencyContainer.getUid());
        agencyContainer = ((TestOrganizationBuilder)((TestOrganizationBuilder)agencyBuilder.fopPaymentInfo().paymentType(PaymentType.INVOICE).createPaymentDate(false).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.MTD).createPaymentDate(false).createPaymentTransaction(false).end()).create();
        EntityContainer clientContainer = EntityStorage.get().resolve(TestBookingFileBuilder.client);
        TestOrganizationBuilder clientBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)clientContainer.getEntity()).containerUid(clientContainer.getUid());
        clientContainer = ((TestOrganizationBuilder)((TestOrganizationBuilder)clientBuilder.fopPaymentInfo().paymentType(PaymentType.CASH).createPaymentDate(true).createPaymentTransaction(true).end()).fopPaymentInfo().paymentType(PaymentType.MTD).createPaymentDate(true).createPaymentTransaction(false).end()).create();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testFinanceSaveBookingFile1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).end().end().clientContractRelation().fop(clientFop).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)0L, (long)transactions.size());
    }

    @Test
    public void testFinanceSaveBookingFile2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(false).end().agentSettings().enabled(true).dimension1().type(DimensionType.CASH_REGISTER_WORKPLACE).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(115.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(130.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(115L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(115L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.AGENT, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)clientFop.getOperationDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(130L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(130L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveBookingFile3() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.MTD).amount(490.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.MTD).amount(500.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(490L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(490L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(500L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(500L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveBookingFile4() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension2().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.AGENT).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.SALES_POINT).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(210.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(220.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)3L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)vendorFop.getType()), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(210L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(210L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(220L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(220L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.AGENT, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)clientFop.getOperationDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(220L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)clientFop.getType()), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(220L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveBookingFile5() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().agentSettings().enabled(true).dimension2().type(DimensionType.SALES_POINT).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product01 = new Product();
        Product product02 = new Product();
        product01.setNextProduct(product02);
        product02.setPreviousProduct(product01);
        ProductFop product01VendorFop = new ProductFop();
        ProductFop product01ClientFop = new ProductFop();
        ProductFop product02VendorFop = new ProductFop();
        ProductFop product02ClientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product01).rulesApplied(true).segmentTariff().segment().end().end().vendorContractRelation().fop(product01VendorFop).paymentType(PaymentType.INVOICE).amount(750.0).end().end().clientContractRelation().fop(product01ClientFop).paymentType(PaymentType.MTD).amount(775.0).end().end().end().airProduct(product02).rulesApplied(true).status(ProductStatus.REFUND).segmentTariff().segment().end().end().vendorContractRelation().fop(product02VendorFop).paymentType(PaymentType.INVOICE).amount(740.0).end().end().clientContractRelation().fop(product02ClientFop).paymentType(PaymentType.MTD).amount(710.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)4L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product01.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product01.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product01.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(750L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(750L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product01.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product01.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product01.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(775L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)product01ClientFop.getType()), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(775L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product02.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product02.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product02.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-740L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-740L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product02.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product02.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product02.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-710L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)product02ClientFop.getType()), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-710L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveBookingFile6() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(true).supplierSettings().enabled(true).end().customerSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestModelContractBuilder modelContractBuilder = new TestModelContractBuilder();
        EntityContainer modelContractContainer = ((TestModelContractBuilder)((TestRuleSetBuilder)modelContractBuilder.ruleSet().rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.CASH)).result((RuleAction)Actions.FOP_AGENT_NOT_FILL, null).result((RuleAction)Actions.FOP_DATE_NOT_FILL, null).end()).end()).create();
        EntityReference modelContract = modelContractContainer.toReference();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        EntityContainer contractContainer = contractBuilder.newModel(Boolean.TRUE).contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customerNewContract(TestBookingFileBuilder.client).modelContract(modelContract).create();
        EntityReference contract = contractContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(650.0).oparationDate(null).agent(null).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(550.0).oparationDate(null).agent(null).end().generalData().contractData().contract(contract).end().end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(650L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(650L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(550L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)clientFop.getType()), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(550L)), (long)debitTransactionSplit.getAmount());
        Date oldIssueDate = product.getIssueDate();
        PaymentType oldClientFopType = clientFop.getType();
        TestAirProductBuilder productBuilder = new TestAirProductBuilder(null, product, false);
        TestBookingFileBuilder.TestProductFopBuilder fopBuilder = new TestBookingFileBuilder.TestProductFopBuilder(null, clientFop, ContractType.CLIENT, false);
        productBuilder.issueDate("2010-01-02 00:00:00");
        fopBuilder.paymentType(PaymentType.MTD);
        bookingFileBuilder.create();
        bookingFile = bookingFileContainer.toReference();
        transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)6L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(650L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(650L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(550L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)clientFop.getType()), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(550L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(650L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(650L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(550L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)oldClientFopType), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(550L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-650L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-650L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-550L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)oldClientFopType), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-550L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveBookingFile7() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-8));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.MTD).amount(555.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.MTD).amount(595.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(555L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(555L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(595L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(595L)), (long)debitTransactionSplit.getAmount());
        List<OpeningBalance> balances = this.getBalances(null);
        Assert.assertEquals((long)0L, (long)balances.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(555L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(555L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(595L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(595L));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(555L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(555L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(595L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(595L)), (long)debitTransactionSplit.getAmount());
        balances = this.getBalances(null);
        Assert.assertEquals((long)6L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(555L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(555L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(595L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(595L));
        TestBookingFileBuilder.TestProductFopBuilder clientFopBuilder = new TestBookingFileBuilder.TestProductFopBuilder(null, clientFop, ContractType.CLIENT, false);
        TestBookingFileBuilder.TestProductFopBuilder vendorFopBuilder = new TestBookingFileBuilder.TestProductFopBuilder(null, vendorFop, ContractType.CLIENT, false);
        vendorFopBuilder.amount(590.0);
        clientFopBuilder.amount(615.0);
        bookingFileBuilder.create();
        bookingFile = bookingFileContainer.toReference();
        transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)6L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(590L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(590L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(615L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(615L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(555L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(555L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(595L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(595L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-555L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-555L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-595L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-595L)), (long)debitTransactionSplit.getAmount());
        balances = this.getBalances(null);
        Assert.assertEquals((long)6L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(590L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(590L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(615L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(615L));
    }

    @Test
    public void testFinanceSaveBookingFile8() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.MTD).amount(320.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.MTD).amount(410.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(320L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(320L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(410L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(410L)), (long)debitTransactionSplit.getAmount());
        List<OpeningBalance> balances = this.getBalances(null);
        Assert.assertEquals((long)0L, (long)balances.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(320L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(320L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(410L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(410L));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(320L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(320L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(410L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(410L)), (long)debitTransactionSplit.getAmount());
        balances = this.getBalances(null);
        Assert.assertEquals((long)6L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(320L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(320L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(410L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(410L));
        TestAirProductBuilder productBuilder = new TestAirProductBuilder(null, product, false);
        TestBookingFileBuilder.TestProductFopBuilder clientFopBuilder = new TestBookingFileBuilder.TestProductFopBuilder(null, clientFop, ContractType.CLIENT, false);
        TestBookingFileBuilder.TestProductFopBuilder vendorFopBuilder = new TestBookingFileBuilder.TestProductFopBuilder(null, vendorFop, ContractType.CLIENT, false);
        Date oldIssueDate = issueDate;
        issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        productBuilder.issueDate(issueDateString);
        vendorFopBuilder.amount(375.0);
        clientFopBuilder.amount(450.0);
        bookingFileBuilder.create();
        bookingFile = bookingFileContainer.toReference();
        transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)6L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(375L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(375L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(450L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(450L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(320L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(320L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(410L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(410L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-320L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-320L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-410L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-410L)), (long)debitTransactionSplit.getAmount());
        balances = this.getBalances(null);
        Assert.assertEquals((long)6L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(375L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(375L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(450L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(450L));
        vendorFopBuilder.amount(720.0);
        clientFopBuilder.amount(825.0);
        bookingFileBuilder.create();
        bookingFile = bookingFileContainer.toReference();
        transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)6L, (long)transactions.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(720L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(720L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(825L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(825L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(320L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(320L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(410L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(410L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-320L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-320L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), true, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)oldIssueDate, (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-410L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-410L)), (long)debitTransactionSplit.getAmount());
        balances = this.getBalances(null);
        Assert.assertEquals((long)6L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(720L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(720L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(825L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(825L));
    }

    @Test
    public void testFinanceSaveBookingFile9() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension2().type(DimensionType.AGENT).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().dimension2().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct product = new HotelProduct();
        HotelProductFop vendorFop = new HotelProductFop();
        HotelProductFop clientFop = new HotelProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().hotelProduct(product).rulesApplied(true).unholdDate(null).vendorContractRelation().fop(vendorFop).paymentType(PaymentType.MTD).amount(340.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.MTD).amount(510.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(340L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(340L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(510L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(510L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveBookingFile10() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.CONTRACT_TYPE).end().dimension2().type(DimensionType.SALES_POINT).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension3().type(DimensionType.AGENT).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct product = new HotelProduct();
        HotelProductFop vendorFop = new HotelProductFop();
        HotelProductFop clientFop = new HotelProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().hotelProduct(product).rulesApplied(true).vendorContractRelation().fop(vendorFop).paymentType(PaymentType.MTD).amount(720.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.MTD).amount(815.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)6L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(720L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(720L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-720L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-720L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(720L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(720L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(815L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(815L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-815L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-815L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(815L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(815L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveBookingFile11() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.AGENT).end().end().customerSettings().enabled(true).dimension2().type(DimensionType.CONTRACT_TYPE).end().dimension3().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        HotelProduct product01 = new HotelProduct();
        HotelProduct product02 = new HotelProduct();
        product01.setNextProduct(product02);
        product02.setPreviousProduct(product01);
        HotelProductFop product01VendorFop = new HotelProductFop();
        HotelProductFop product01ClientFop = new HotelProductFop();
        HotelProductFop product02VendorFop = new HotelProductFop();
        HotelProductFop product02ClientFop = new HotelProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().hotelProduct(product01).rulesApplied(true).vendorContractRelation().fop(product01VendorFop).paymentType(PaymentType.INVOICE).amount(770.0).end().end().clientContractRelation().fop(product01ClientFop).paymentType(PaymentType.INVOICE).amount(805.0).end().end().end().hotelProduct(product02).rulesApplied(true).status(ProductStatus.REFUND).vendorContractRelation().fop(product02VendorFop).paymentType(PaymentType.INVOICE).amount(750.0).end().end().clientContractRelation().fop(product02ClientFop).paymentType(PaymentType.INVOICE).amount(790.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)10L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product01.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product01.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product01.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(770L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(770L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product01.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product01.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product01.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-770L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-770L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product01.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product01.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product01.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(770L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(770L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product02.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product02.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product02.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-750L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-750L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product01.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product01.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product01.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(805L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(805L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product01.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product01.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product01.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-805L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-805L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product01.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product01.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product01.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(805L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(805L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product02.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product02.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product02.getUnholdDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-790L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-790L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product01.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product01.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product01ClientFop.getOperationDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(805L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(805L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, null, null, null, null, null, null, product02.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product02.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product02ClientFop.getOperationDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-790L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-790L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveBookingFile12() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().dimension3().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestCommissionCategoryBuilder commissionCategoryBuilder = new TestCommissionCategoryBuilder();
        DictionaryReference commissionCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)commissionCategoryBuilder.code("commission")).translation("commission")).create();
        TestCommissionPropertiesBuilder commissionPropertiesBuilder = new TestCommissionPropertiesBuilder();
        EntityContainer commissionPropertiesContainer = commissionPropertiesBuilder.displayName("commission").category(commissionCategory).operation(Operation.SELL).create();
        EntityReference commissionProperties = commissionPropertiesContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        Commission vendorCommission = new Commission();
        Commission clientCommission = new Commission();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).segmentTariff().segment().end().end().rulesApplied(true).vendorContractRelation().commission(vendorCommission).amount(160.0).equivalentAmount(160.0).properties(commissionProperties).end().fop(vendorFop).paymentType(PaymentType.MTD).amount(490.0).end().end().clientContractRelation().commission(clientCommission).amount(110.0).equivalentAmount(110.0).properties(commissionProperties).end().fop(clientFop).paymentType(PaymentType.MTD).amount(500.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)4L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(490L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(490L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(500L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(500L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME_COMMISSION, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER_COMMISSION, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(160L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(160L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER_COMMISSION, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE_COMMISSION, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(110L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(110L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveBookingFile13() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer vendorChartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.blankOwner).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).dimension1().type(DimensionType.AGENT).end().end().create();
        EntityReference vendorChartOfAccountsSettings = vendorChartOfAccountsSettingsContainer.toReference();
        chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().end().create();
        EntityReference agencyChartOfAccountsSettings = agencyChartOfAccountsSettingsContainer.toReference();
        chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().end().create();
        EntityReference clientChartOfAccountsSettings = clientChartOfAccountsSettingsContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(3400.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.MTD).amount(3700.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)4L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.blankOwner, ChartOfAccountsElementType.INCOME, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.blankOwner, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.blankOwner, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3400L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3400L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3400L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3400L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3700L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3700L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3700L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(3700L)), (long)debitTransactionSplit.getAmount());
    }

    private void checkBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, BigDecimal credit, BigDecimal debit) throws Exception {
        Assert.assertTrue((credit.compareTo(FinanceHelper.calculateBalance(chartOfAccountsElement, null, null, null, (boolean)true, Collections.emptyMap(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((debit.compareTo(FinanceHelper.calculateBalance(chartOfAccountsElement, null, null, null, (boolean)true, Collections.emptyMap(), (boolean)false)) == 0 ? 1 : 0) != 0);
    }

    private List<Transaction> getTransactions(EntityReference<BookingFile> bookingFile) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.bookingUid.name(), null));
        if (bookingFile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), bookingFile));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private Transaction getTransaction(List<Transaction> transactions, EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement, EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement, String productUid, boolean historical, boolean refund) {
        for (Transaction transaction : transactions) {
            TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
            TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
            if (!TextUtil.isSame((String)transaction.getProductUid(), (String)productUid) || transaction.isHistorical() != historical || creditTransactionSplit == null || creditTransactionSplit.getAmount() < 0L != refund || debitTransactionSplit == null || debitTransactionSplit.getAmount() < 0L != refund) continue;
            return transaction;
        }
        return null;
    }

    private Transaction getTransaction(List<Transaction> transactions, EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement, EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement, Object creditDimension1Value, Object creditDimension2Value, Object creditDimension3Value, Object debitDimension1Value, Object debitDimension2Value, Object debitDimension3Value, String productUid, boolean historical, boolean refund) {
        for (Transaction transaction : transactions) {
            TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
            TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
            if (!TextUtil.isSame((String)transaction.getProductUid(), (String)productUid) || transaction.isHistorical() != historical || creditTransactionSplit == null || creditTransactionSplit.getAmount() < 0L != refund || creditDimension1Value != null && !MiscUtil.equals((Object)creditDimension1Value, (Object)creditTransactionSplit.getDimension1()) || creditDimension2Value != null && !MiscUtil.equals((Object)creditDimension2Value, (Object)creditTransactionSplit.getDimension2()) || creditDimension3Value != null && !MiscUtil.equals((Object)creditDimension3Value, (Object)creditTransactionSplit.getDimension3()) || debitTransactionSplit == null || debitTransactionSplit.getAmount() < 0L != refund || debitDimension1Value != null && !MiscUtil.equals((Object)debitDimension1Value, (Object)debitTransactionSplit.getDimension1()) || debitDimension2Value != null && !MiscUtil.equals((Object)debitDimension2Value, (Object)debitTransactionSplit.getDimension2()) || debitDimension3Value != null && !MiscUtil.equals((Object)debitDimension3Value, (Object)debitTransactionSplit.getDimension3())) continue;
            return transaction;
        }
        return null;
    }

    private TransactionSplit getTransactionSplit(Transaction transaction, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, boolean credit) {
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            if (credit != transactionSplit.isCredit() || !MiscUtil.equals((Object)transactionSplit.getAccount(), chartOfAccountsElement)) continue;
            return transactionSplit;
        }
        return null;
    }

    private List<OpeningBalance> getBalances(EntityReference<ChartOfAccountsElement> chartOfAccountsElement) {
        SearchQuery query = new SearchQuery();
        if (chartOfAccountsElement != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.accountUid.name(), chartOfAccountsElement));
        }
        return AssetsStorage.get().search(OpeningBalance.class, query).getData();
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }

    protected List<URL> collectIntegrationBusDescriptions() {
        List result = super.collectIntegrationBusDescriptions();
        result.add(ResourceUtil.getResource(FinanceUpdateBalancesTest.class, (String)"ibus-finance-test.xml"));
        return result;
    }
}

