/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.CreditBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.CreditSlip;
import com.gridnine.xtrip.common.model.finance.CreditSlipType;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.DebitSlip;
import com.gridnine.xtrip.common.model.finance.DebitSlipType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestCreditBankTransferOrderBuilder;
import com.gridnine.xtrip.server.model.test.TestCreditSlipBuilder;
import com.gridnine.xtrip.server.model.test.TestDebitBankTransferOrderBuilder;
import com.gridnine.xtrip.server.model.test.TestDebitSlipBuilder;
import com.gridnine.xtrip.server.model.test.TestWorklogBuilder;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceSavePaymentDocumentTest
extends FinanceTestBase {
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testFinanceSaveDebitBankTransferOrder1() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference agencyChartOfAccountsSettingsReference = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference clientChartOfAccountsSettingsReference = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestDebitBankTransferOrderBuilder bankTransferOrderBuilder = new TestDebitBankTransferOrderBuilder();
        Date issueDate = MiscUtil.clearTime((Date)date, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer bankTransferOrderContainer = bankTransferOrderBuilder.name("Bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(issueDateString).amount(150.0).create();
        EntityReference bankTransferOrderReference = bankTransferOrderContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<? extends BasePaymentDocument>)bankTransferOrderReference);
        Assert.assertEquals((long)0L, (long)transactions.size());
    }

    @Test
    public void testFinanceSaveDebitBankTransferOrder2() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(true).end().create();
        EntityReference agencyChartOfAccountsSettingsReference = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(true).end().create();
        EntityReference clientChartOfAccountsSettingsReference = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestDebitBankTransferOrderBuilder bankTransferOrderBuilder = new TestDebitBankTransferOrderBuilder();
        Date issueDate = MiscUtil.clearTime((Date)date, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer bankTransferOrderContainer = bankTransferOrderBuilder.name("Debit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(issueDateString).amount(270.0).create();
        EntityReference bankTransferOrderReference = bankTransferOrderContainer.toReference();
        DebitBankTransferOrder bankTransferOrder = (DebitBankTransferOrder)bankTransferOrderContainer.getEntity();
        List<Transaction> transactions = this.getTransactions((EntityReference<? extends BasePaymentDocument>)bankTransferOrderReference);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> agencyCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> agencyDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)agencyCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)agencyDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> agencyCreditChartOfAccountsElement = agencyCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> agencyDebitChartOfAccountsElement = agencyDebitChartOfAccountsElements.get(0);
        Transaction agencyTransaction = this.getTransaction(transactions, agencyCreditChartOfAccountsElement, agencyDebitChartOfAccountsElement, bankTransferOrderReference.getUid(), false, false);
        Assert.assertNotNull((Object)agencyTransaction);
        Assert.assertEquals((Object)bankTransferOrderReference.getUid(), (Object)agencyTransaction.getDocumentUid());
        Assert.assertEquals((Object)bankTransferOrder.getDate(), (Object)agencyTransaction.getOperationDate());
        Assert.assertTrue((boolean)agencyTransaction.isAutocreated());
        Assert.assertFalse((boolean)agencyTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)agencyTransaction.getSplits().size());
        TransactionSplit agencyCreditTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)agencyCreditTransactionSplit);
        Assert.assertTrue((boolean)agencyCreditTransactionSplit.isCredit());
        Assert.assertEquals(agencyCreditChartOfAccountsElement, (Object)agencyCreditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)agencyCreditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)agencyCreditTransactionSplit.getDimension2());
        Assert.assertNull((Object)agencyCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(270L)), (long)agencyCreditTransactionSplit.getAmount());
        TransactionSplit agencyDebitTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyDebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)agencyDebitTransactionSplit);
        Assert.assertFalse((boolean)agencyDebitTransactionSplit.isCredit());
        Assert.assertEquals(agencyDebitChartOfAccountsElement, (Object)agencyDebitTransactionSplit.getAccount());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension1());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension2());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(270L)), (long)agencyDebitTransactionSplit.getAmount());
        List<EntityReference<ChartOfAccountsElement>> clientCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.BANK, this.currency);
        List<EntityReference<ChartOfAccountsElement>> clientDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)clientCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)clientDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> clientCreditChartOfAccountsElement = clientCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> clientCebitChartOfAccountsElement = clientDebitChartOfAccountsElements.get(0);
        Transaction clientTransaction = this.getTransaction(transactions, clientCreditChartOfAccountsElement, clientCebitChartOfAccountsElement, bankTransferOrderReference.getUid(), false, false);
        Assert.assertNotNull((Object)clientTransaction);
        Assert.assertEquals((Object)bankTransferOrderReference.getUid(), (Object)clientTransaction.getDocumentUid());
        Assert.assertEquals((Object)bankTransferOrder.getDate(), (Object)clientTransaction.getOperationDate());
        Assert.assertTrue((boolean)clientTransaction.isAutocreated());
        Assert.assertFalse((boolean)clientTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)clientTransaction.getSplits().size());
        TransactionSplit clientCreditTransactionSplit = this.getTransactionSplit(clientTransaction, clientCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)clientCreditTransactionSplit);
        Assert.assertTrue((boolean)clientCreditTransactionSplit.isCredit());
        Assert.assertEquals(clientCreditChartOfAccountsElement, (Object)clientCreditTransactionSplit.getAccount());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension1());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension2());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(270L)), (long)clientCreditTransactionSplit.getAmount());
        TransactionSplit clientDebitTransactionSplit = this.getTransactionSplit(clientTransaction, clientCebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)clientDebitTransactionSplit);
        Assert.assertFalse((boolean)clientDebitTransactionSplit.isCredit());
        Assert.assertEquals(clientCebitChartOfAccountsElement, (Object)clientDebitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)clientDebitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)clientDebitTransactionSplit.getDimension2());
        Assert.assertNull((Object)clientDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(270L)), (long)clientDebitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveCreditBankTransferOrder1() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.CONTRACT_TYPE).end().end().agentSettings().enabled(true).end().create();
        EntityReference agencyChartOfAccountsSettingsReference = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.CONTRACT_TYPE).end().end().agentSettings().enabled(true).end().create();
        EntityReference clientChartOfAccountsSettingsReference = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestCreditBankTransferOrderBuilder bankTransferOrderBuilder = new TestCreditBankTransferOrderBuilder();
        Date issueDate = MiscUtil.clearTime((Date)date, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer bankTransferOrderContainer = bankTransferOrderBuilder.name("Credit bank transfer order #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(issueDateString).amount(780.0).create();
        EntityReference bankTransferOrderReference = bankTransferOrderContainer.toReference();
        CreditBankTransferOrder bankTransferOrder = (CreditBankTransferOrder)bankTransferOrderContainer.getEntity();
        List<Transaction> transactions = this.getTransactions((EntityReference<? extends BasePaymentDocument>)bankTransferOrderReference);
        Assert.assertEquals((long)2L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> agencyCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> agencyDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)agencyCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)agencyDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> agencyCreditChartOfAccountsElement = agencyCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> agencyDebitChartOfAccountsElement = agencyDebitChartOfAccountsElements.get(0);
        Transaction agencyTransaction = this.getTransaction(transactions, agencyCreditChartOfAccountsElement, agencyDebitChartOfAccountsElement, bankTransferOrderReference.getUid(), false, true);
        Assert.assertNotNull((Object)agencyTransaction);
        Assert.assertEquals((Object)bankTransferOrderReference.getUid(), (Object)agencyTransaction.getDocumentUid());
        Assert.assertEquals((Object)bankTransferOrder.getDate(), (Object)agencyTransaction.getOperationDate());
        Assert.assertTrue((boolean)agencyTransaction.isAutocreated());
        Assert.assertFalse((boolean)agencyTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)agencyTransaction.getSplits().size());
        TransactionSplit agencyCreditTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)agencyCreditTransactionSplit);
        Assert.assertTrue((boolean)agencyCreditTransactionSplit.isCredit());
        Assert.assertEquals(agencyCreditChartOfAccountsElement, (Object)agencyCreditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)agencyCreditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)agencyCreditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)agencyCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-780L)), (long)agencyCreditTransactionSplit.getAmount());
        TransactionSplit agencyDebitTransactionSplit = this.getTransactionSplit(agencyTransaction, agencyDebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)agencyDebitTransactionSplit);
        Assert.assertFalse((boolean)agencyDebitTransactionSplit.isCredit());
        Assert.assertEquals(agencyDebitChartOfAccountsElement, (Object)agencyDebitTransactionSplit.getAccount());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension1());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension2());
        Assert.assertNull((Object)agencyDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-780L)), (long)agencyDebitTransactionSplit.getAmount());
        List<EntityReference<ChartOfAccountsElement>> clientCreditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.BANK, this.currency);
        List<EntityReference<ChartOfAccountsElement>> clientDebitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.client, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)clientCreditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)clientDebitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> clientCreditChartOfAccountsElement = clientCreditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> clientCebitChartOfAccountsElement = clientDebitChartOfAccountsElements.get(0);
        Transaction clientTransaction = this.getTransaction(transactions, clientCreditChartOfAccountsElement, clientCebitChartOfAccountsElement, bankTransferOrderReference.getUid(), false, true);
        Assert.assertNotNull((Object)clientTransaction);
        Assert.assertEquals((Object)bankTransferOrderReference.getUid(), (Object)clientTransaction.getDocumentUid());
        Assert.assertEquals((Object)bankTransferOrder.getDate(), (Object)clientTransaction.getOperationDate());
        Assert.assertTrue((boolean)clientTransaction.isAutocreated());
        Assert.assertFalse((boolean)clientTransaction.isHistorical());
        Assert.assertEquals((long)2L, (long)clientTransaction.getSplits().size());
        TransactionSplit clientCreditTransactionSplit = this.getTransactionSplit(clientTransaction, clientCreditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)clientCreditTransactionSplit);
        Assert.assertTrue((boolean)clientCreditTransactionSplit.isCredit());
        Assert.assertEquals(clientCreditChartOfAccountsElement, (Object)clientCreditTransactionSplit.getAccount());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension1());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension2());
        Assert.assertNull((Object)clientCreditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-780L)), (long)clientCreditTransactionSplit.getAmount());
        TransactionSplit clientDebitTransactionSplit = this.getTransactionSplit(clientTransaction, clientCebitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)clientDebitTransactionSplit);
        Assert.assertFalse((boolean)clientDebitTransactionSplit.isCredit());
        Assert.assertEquals(clientCebitChartOfAccountsElement, (Object)clientDebitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)clientDebitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)clientDebitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), (Object)clientDebitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-780L)), (long)clientDebitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveDebitSlip1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettingsReference = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestDebitSlipBuilder debitSlipBuilder = new TestDebitSlipBuilder();
        Date issueDate = MiscUtil.clearTime((Date)date, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer debitSlipContainer = debitSlipBuilder.type(DebitSlipType.CASH_REGISTER).cashier(TestBookingFileBuilder.agencyAgent02).person(TestBookingFileBuilder.agencyAgent01).name("Debit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.agency).contract(null).date(issueDateString).amount(130.0).create();
        EntityReference debitSlipReference = debitSlipContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<? extends BasePaymentDocument>)debitSlipReference);
        Assert.assertEquals((long)0L, (long)transactions.size());
    }

    @Test
    public void testFinanceSaveDebitSlip2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.CASH).end().dimension2().type(DimensionType.CASH_REGISTER).end().dimension3().type(DimensionType.AGENT).end().end().create();
        EntityReference chartOfAccountsSettingsReference = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestWorklogBuilder worklogBuilder = new TestWorklogBuilder();
        Date startDate = MiscUtil.clearTime((Date)MiscUtil.addHoursToDate((Date)date, (int)-4), (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        Date endDate = MiscUtil.clearTime((Date)MiscUtil.addHoursToDate((Date)date, (int)4), (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String startDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(startDate);
        String endDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(endDate);
        EntityContainer worklogContainer = worklogBuilder.employee(TestBookingFileBuilder.agencyAgent01).types(new PersonType[]{PersonType.AGENT, PersonType.CASHIER_CLERK}).salesPoint(TestBookingFileBuilder.agencySalesPoint).cash(TestBookingFileBuilder.agencyCash).cashRegister(TestBookingFileBuilder.agencyCashRegister).cashRegisterWorkplace(TestBookingFileBuilder.agencyCashRegisterWorkplace).startDate(startDateString).endDate(endDateString).forceEnd(false).create();
        TestDebitSlipBuilder debitSlipBuilder = new TestDebitSlipBuilder();
        Date issueDate = MiscUtil.clearTime((Date)date, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer debitSlipContainer = debitSlipBuilder.type(DebitSlipType.CASH_REGISTER).cashier(TestBookingFileBuilder.agencyAgent02).person(TestBookingFileBuilder.agencyAgent01).name("Debit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.agency).contract(null).date(issueDateString).amount(640.0).create();
        EntityReference debitSlipReference = debitSlipContainer.toReference();
        DebitSlip debitSlip = (DebitSlip)debitSlipContainer.getEntity();
        List<Transaction> transactions = this.getTransactions((EntityReference<? extends BasePaymentDocument>)debitSlipReference);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH_REGISTER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, debitSlipReference.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)debitSlipReference.getUid(), (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)debitSlip.getDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH, (Object)TestBookingFileBuilder.agencyCash), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.CASH_REGISTER, (Object)TestBookingFileBuilder.agencyCashRegister), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent01), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(640L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent02), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(640L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveDebitSlip3() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.AGENT).end().end().create();
        EntityReference chartOfAccountsSettingsReference = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestDebitSlipBuilder debitSlipBuilder = new TestDebitSlipBuilder();
        Date issueDate = MiscUtil.clearTime((Date)date, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer debitSlipContainer = debitSlipBuilder.type(DebitSlipType.TRANSFER).cashier(TestBookingFileBuilder.agencyAgent01).person(TestBookingFileBuilder.agencyAgent02).name("Debit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.agency).contract(null).date(issueDateString).amount(990.0).create();
        EntityReference debitSlipReference = debitSlipContainer.toReference();
        DebitSlip debitSlip = (DebitSlip)debitSlipContainer.getEntity();
        List<Transaction> transactions = this.getTransactions((EntityReference<? extends BasePaymentDocument>)debitSlipReference);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.TRANSFER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, debitSlipReference.getUid(), false, true);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)debitSlipReference.getUid(), (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)debitSlip.getDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent01), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-990L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent02), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-990L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveCreditSlip1() throws Exception {
        TestChartOfAccountsSettingsBuilder agencyChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer agencyChartOfAccountsSettingsContainer = agencyChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.AGENT).end().end().create();
        EntityReference agencyChartOfAccountsSettingsReference = agencyChartOfAccountsSettingsContainer.toReference();
        TestChartOfAccountsSettingsBuilder clientChartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer clientChartOfAccountsSettingsContainer = clientChartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.client).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.CONTRACT_TYPE).end().end().agentSettings().enabled(true).end().create();
        EntityReference clientChartOfAccountsSettingsReference = clientChartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestCreditSlipBuilder creditSlipBuilder = new TestCreditSlipBuilder();
        Date issueDate = MiscUtil.clearTime((Date)date, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer creditSlipContainer = creditSlipBuilder.type(CreditSlipType.CUSTOMER).cashier(TestBookingFileBuilder.agencyAgent).person(TestBookingFileBuilder.agencyAgent).name("Credit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.client).contract(contract).date(issueDateString).amount(990.0).create();
        EntityReference creditSlipReference = creditSlipContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<? extends BasePaymentDocument>)creditSlipReference);
        Assert.assertEquals((long)0L, (long)transactions.size());
    }

    @Test
    public void testFinanceSaveCreditSlip2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.AGENT).end().end().create();
        EntityReference chartOfAccountsSettingsReference = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestCreditSlipBuilder creditSlipBuilder = new TestCreditSlipBuilder();
        Date issueDate = MiscUtil.clearTime((Date)date, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer creditSlipContainer = creditSlipBuilder.type(CreditSlipType.TRANSFER).cashier(TestBookingFileBuilder.agencyAgent01).person(TestBookingFileBuilder.agencyAgent02).name("Credit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.agency).contract(null).date(issueDateString).amount(270.0).create();
        EntityReference creditSlipReference = creditSlipContainer.toReference();
        CreditSlip creditSlip = (CreditSlip)creditSlipContainer.getEntity();
        List<Transaction> transactions = this.getTransactions((EntityReference<? extends BasePaymentDocument>)creditSlipReference);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.TRANSFER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, creditSlipReference.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)creditSlipReference.getUid(), (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)creditSlip.getDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent01), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(270L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), (Object)debitTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent02), (Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(270L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceSaveCreditSlip3() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().dimension3().type(DimensionType.AGENT).end().end().create();
        EntityReference chartOfAccountsSettingsReference = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestCreditSlipBuilder creditSlipBuilder = new TestCreditSlipBuilder();
        Date issueDate = MiscUtil.clearTime((Date)date, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        EntityContainer creditSlipContainer = creditSlipBuilder.type(CreditSlipType.BANK).cashier(TestBookingFileBuilder.agencyAgent01).person(TestBookingFileBuilder.agencyAgent02).name("Credit slip #1234567890").number("1234567890").organization(TestBookingFileBuilder.agency).payer(TestBookingFileBuilder.agency).contract(null).date(issueDateString).amount(650.0).create();
        EntityReference creditSlipReference = creditSlipContainer.toReference();
        CreditSlip creditSlip = (CreditSlip)creditSlipContainer.getEntity();
        List<Transaction> transactions = this.getTransactions((EntityReference<? extends BasePaymentDocument>)creditSlipReference);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CASH, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, creditSlipReference.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)creditSlipReference.getUid(), (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)creditSlip.getDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.agency), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), (Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent01), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(650L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(650L)), (long)debitTransactionSplit.getAmount());
    }

    private List<Transaction> getTransactions(EntityReference<? extends BasePaymentDocument> paymentDocument) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.documentUid.name(), null));
        if (paymentDocument != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.documentUid.name(), paymentDocument));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private Transaction getTransaction(List<Transaction> transactions, EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement, EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement, String documentUid, boolean historical, boolean refund) {
        for (Transaction transaction : transactions) {
            TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
            TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
            if (!TextUtil.isSame((String)transaction.getDocumentUid(), (String)documentUid) || transaction.isHistorical() != historical || creditTransactionSplit == null || creditTransactionSplit.getAmount() < 0L != refund || debitTransactionSplit == null || debitTransactionSplit.getAmount() < 0L != refund) continue;
            return transaction;
        }
        return null;
    }

    private TransactionSplit getTransactionSplit(Transaction transaction, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, boolean credit) {
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            if (credit != transactionSplit.isCredit() || !MiscUtil.equals((Object)transactionSplit.getAccount(), chartOfAccountsElement)) continue;
            return transactionSplit;
        }
        return null;
    }
}

