/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesUpdateTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.StandardTransactionActions;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionAction;
import com.gridnine.xtrip.common.model.finance.TransactionDataHolder;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.finance.FinanceUpdateBalancesTest;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceSaveTransactionTest
extends FinanceTestBase {
    private final LongRunningTaskCallback callback = new LongRunningTaskCallback(){

        @Override
        public boolean isToBeStopped() {
            return false;
        }

        @Override
        public void addEvent(String eventId, Message description) {
        }

        @Override
        public void updateProgress(byte progress) {
        }
    };
    private final FinanceBalancesUpdateTaskConfiguration balancesUpdateConfiguration = new FinanceBalancesUpdateTaskConfiguration();
    private final EntityReference<BookingFile> fakeBookingFile = new EntityReference("fake_booking_file", BookingFile.class, "Fake booking file");
    private final String fakeProductUid = "fake_product_uid";
    private final String fakeDocumentUid = "fake_document_uid";
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testFinanceSaveTransaction1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(false).end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String description = "Billing";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.EXPENSE, (EntityReference)TestBookingFileBuilder.agency, (EntityReference)TestBookingFileBuilder.client).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(issueDate).amount(SystemHelper.getMoney((double)5250.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().debitDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().build();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<EntityContainer<Transaction>> transactionContainers = this.getTransactionContainers(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactionContainers.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        EntityContainer<Transaction> transactionContainer = this.getTransactionContainer(transactionContainers, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Transaction transaction = (Transaction)transactionContainer.getEntity();
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)issueDate, (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5250L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5250L)), (long)debitTransactionSplit.getAmount());
        List<OpeningBalance> balances = this.getBalances(null);
        Assert.assertEquals((long)0L, (long)balances.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(5250L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(5250L));
        for (TransactionSplit split : transaction.getSplits()) {
            split.setAmount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6100L)));
        }
        data = new HashMap();
        data.put(IBusFinanceContextKeys.TRANSACTION_CONTAINER.name(), transactionContainer);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:save-transaction").processSync(data);
        transactionContainers = this.getTransactionContainers(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactionContainers.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transactionContainer = this.getTransactionContainer(transactionContainers, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        transaction = (Transaction)transactionContainer.getEntity();
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)issueDate, (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6100L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6100L)), (long)debitTransactionSplit.getAmount());
        balances = this.getBalances(null);
        Assert.assertEquals((long)0L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(6100L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(6100L));
    }

    @Test
    public void testFinanceSaveTransaction2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(5).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().dimension3().type(DimensionType.SALES_POINT).end().end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-8));
        String description = "Issuing ticket";
        TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.EXPENSE, (EntityReference)TestBookingFileBuilder.blankOwner, (EntityReference)TestBookingFileBuilder.agency).bookingFile(this.fakeBookingFile).productUid("fake_product_uid").documentUid("fake_document_uid").transactionUid(null).date(issueDate).amount(SystemHelper.getMoney((double)2300.0, (String)this.currency.getCode())).description(description).creditDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().debitDimensionData().paymentType(PaymentType.INVOICE).contractType(ContractType.CLIENT).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).cash(null).cashRegister(null).cashRegisterWorkplace(null).end().build();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:create-custom-transaction").processSync(data);
        List<EntityContainer<Transaction>> transactionContainers = this.getTransactionContainers(this.fakeBookingFile);
        Assert.assertEquals((long)1L, (long)transactionContainers.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        EntityContainer<Transaction> transactionContainer = this.getTransactionContainer(transactionContainers, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        Transaction transaction = (Transaction)transactionContainer.getEntity();
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)issueDate, (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), (long)debitTransactionSplit.getAmount());
        List<OpeningBalance> balances = this.getBalances(null);
        Assert.assertEquals((long)0L, (long)balances.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(2300L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(2300L));
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        for (TransactionSplit split : transaction.getSplits()) {
            split.setAmount(ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8450L)));
        }
        data = new HashMap();
        data.put(IBusFinanceContextKeys.TRANSACTION_CONTAINER.name(), transactionContainer);
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:save-transaction").processSync(data);
        transactionContainers = this.getTransactionContainers(this.fakeBookingFile);
        Assert.assertEquals((long)3L, (long)transactionContainers.size());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transactionContainer = this.getTransactionContainer(transactionContainers, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", false, false);
        transaction = (Transaction)transactionContainer.getEntity();
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)issueDate, (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8450L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8450L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transactionContainer = this.getTransactionContainer(transactionContainers, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", true, false);
        transaction = (Transaction)transactionContainer.getEntity();
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)issueDate, (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2300L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transactionContainer = this.getTransactionContainer(transactionContainers, creditChartOfAccountsElement, debitChartOfAccountsElement, "fake_product_uid", true, true);
        transaction = (Transaction)transactionContainer.getEntity();
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals(this.fakeBookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)"fake_product_uid", (Object)transaction.getProductUid());
        Assert.assertEquals((Object)"fake_document_uid", (Object)transaction.getDocumentUid());
        Assert.assertEquals((Object)issueDate, (Object)transaction.getOperationDate());
        Assert.assertFalse((boolean)transaction.isAutocreated());
        Assert.assertTrue((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), (Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), (Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-2300L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(-2300L)), (long)debitTransactionSplit.getAmount());
        balances = this.getBalances(null);
        Assert.assertEquals((long)5L, (long)balances.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(8450L), BigDecimal.valueOf(0L));
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        this.checkBalance(chartOfAccountsElement, BigDecimal.valueOf(0L), BigDecimal.valueOf(8450L));
    }

    private void checkBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, BigDecimal credit, BigDecimal debit) throws Exception {
        Assert.assertTrue((credit.compareTo(FinanceHelper.calculateBalance(chartOfAccountsElement, null, null, null, (boolean)true, Collections.emptyMap(), (boolean)true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((debit.compareTo(FinanceHelper.calculateBalance(chartOfAccountsElement, null, null, null, (boolean)true, Collections.emptyMap(), (boolean)false)) == 0 ? 1 : 0) != 0);
    }

    private List<EntityContainer<Transaction>> getTransactionContainers(EntityReference<BookingFile> bookingFile) {
        ArrayList<EntityContainer<Transaction>> transactionContainers = new ArrayList<EntityContainer<Transaction>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.bookingUid.name(), null));
        if (bookingFile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), bookingFile));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactionContainers.contains(transactionContainer)) continue;
            transactionContainers.add((EntityContainer<Transaction>)transactionContainer);
        }
        return transactionContainers;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private EntityContainer<Transaction> getTransactionContainer(List<EntityContainer<Transaction>> transactionContainers, EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement, EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement, String productUid, boolean historical, boolean refund) {
        for (EntityContainer<Transaction> transactionContainer : transactionContainers) {
            TransactionSplit creditTransactionSplit = this.getTransactionSplit((Transaction)transactionContainer.getEntity(), creditChartOfAccountsElement, true);
            TransactionSplit debitTransactionSplit = this.getTransactionSplit((Transaction)transactionContainer.getEntity(), debitChartOfAccountsElement, false);
            if (!TextUtil.isSame((String)((Transaction)transactionContainer.getEntity()).getProductUid(), (String)productUid) || ((Transaction)transactionContainer.getEntity()).isHistorical() != historical || creditTransactionSplit == null || creditTransactionSplit.getAmount() < 0L != refund || debitTransactionSplit == null || debitTransactionSplit.getAmount() < 0L != refund) continue;
            return transactionContainer;
        }
        return null;
    }

    private TransactionSplit getTransactionSplit(Transaction transaction, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, boolean credit) {
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            if (credit != transactionSplit.isCredit() || !MiscUtil.equals((Object)transactionSplit.getAccount(), chartOfAccountsElement)) continue;
            return transactionSplit;
        }
        return null;
    }

    private List<OpeningBalance> getBalances(EntityReference<ChartOfAccountsElement> chartOfAccountsElement) {
        SearchQuery query = new SearchQuery();
        if (chartOfAccountsElement != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.accountUid.name(), chartOfAccountsElement));
        }
        return AssetsStorage.get().search(OpeningBalance.class, query).getData();
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }

    protected List<URL> collectIntegrationBusDescriptions() {
        List result = super.collectIntegrationBusDescriptions();
        result.add(ResourceUtil.getResource(FinanceUpdateBalancesTest.class, (String)"ibus-finance-test.xml"));
        return result;
    }
}

