/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.fops.Actions;
import com.gridnine.xtrip.common.model.rules.fops.Properties;
import com.gridnine.xtrip.common.model.rules.fops.Targets;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.vip.NewFinanceModuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestModelContractBuilder;
import com.gridnine.xtrip.server.model.test.TestRuleSetBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceTransactionsRulesTest
extends FinanceTestBase {
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Override
    protected void initialize(NewFinanceModuleSettings settings) {
        settings.setUseNewTransactionRulesSettngs(true);
    }

    @Test
    public void testFinanceTransactionsRules1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(false).end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.VENDOR).blankOwner(TestBookingFileBuilder.blankOwner).supplier(TestBookingFileBuilder.blankOwner).customerNewContract(TestBookingFileBuilder.agency).newModel(true).create();
        EntityReference contract = contractContainer.toReference();
        TestModelContractBuilder modelContractBuilder = new TestModelContractBuilder();
        EntityContainer modelContractContainer = ((TestModelContractBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)modelContractBuilder.setContractType(ContractType.VENDOR).ruleSet().rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.CASH)).result((RuleAction)Actions.FOP_TRANSACTION_PAYMENT_TYPE_REPLACE, (Object)PaymentType.INVOICE).end()).rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.MTD)).result((RuleAction)Actions.FOP_PAYMENT_TRANSACTION_CREATE, null).end()).end()).create();
        EntityReference modelContract = modelContractContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.CASH).amount(4000.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CASH).amount(4500.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)1L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4000L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4000L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceTransactionsRules2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestContractBuilderBuilder vendorContractBuilder = new TestContractBuilderBuilder();
        EntityContainer vendorContractContainer = vendorContractBuilder.contractType(ContractType.VENDOR).blankOwner(TestBookingFileBuilder.blankOwner).supplier(TestBookingFileBuilder.blankOwner).customerNewContract(TestBookingFileBuilder.agency).newModel(true).create();
        EntityReference vendorContract = vendorContractContainer.toReference();
        TestModelContractBuilder vendorModelContractBuilder = new TestModelContractBuilder();
        EntityContainer vendorModelContractContainer = ((TestModelContractBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)vendorModelContractBuilder.setContractType(ContractType.VENDOR).ruleSet().rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.CASH)).result((RuleAction)Actions.FOP_TRANSACTION_PAYMENT_TYPE_REPLACE, (Object)PaymentType.INVOICE).end()).rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.MTD)).result((RuleAction)Actions.FOP_PAYMENT_TRANSACTION_CREATE, null).end()).end()).create();
        EntityReference vendorModelContract = vendorModelContractContainer.toReference();
        TestContractBuilderBuilder clientContractBuilder = new TestContractBuilderBuilder();
        EntityContainer clientContractContainer = clientContractBuilder.contractType(ContractType.CLIENT).blankOwner(null).supplier(TestBookingFileBuilder.agency).customerNewContract(TestBookingFileBuilder.client).newModel(true).create();
        EntityReference clientContract = clientContractContainer.toReference();
        TestModelContractBuilder clientModelContractBuilder = new TestModelContractBuilder();
        EntityContainer clientModelContractContainer = ((TestModelContractBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)clientModelContractBuilder.setContractType(ContractType.CLIENT).ruleSet().rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.CASH)).result((RuleAction)Actions.FOP_TRANSACTION_PAYMENT_TYPE_REPLACE, (Object)PaymentType.INVOICE).end()).rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.MTD)).result((RuleAction)Actions.FOP_PAYMENT_TRANSACTION_CREATE, null).end()).end()).create();
        EntityReference clientModelContract = clientModelContractContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.MTD).amount(6000.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.MTD).amount(6200.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)4L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.MTD), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.MTD), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6000L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.MTD), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)vendorFop.getOperationDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.MTD), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), (long)debitTransactionSplit.getAmount());
    }

    @Test
    public void testFinanceTransactionsRules3() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().dimension2().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        TestContractBuilderBuilder vendorContractBuilder = new TestContractBuilderBuilder();
        EntityContainer vendorContractContainer = vendorContractBuilder.contractType(ContractType.VENDOR).blankOwner(TestBookingFileBuilder.blankOwner).supplier(TestBookingFileBuilder.blankOwner).customerNewContract(TestBookingFileBuilder.agency).newModel(true).create();
        EntityReference vendorContract = vendorContractContainer.toReference();
        TestModelContractBuilder vendorModelContractBuilder = new TestModelContractBuilder();
        EntityContainer vendorModelContractContainer = ((TestModelContractBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)vendorModelContractBuilder.setContractType(ContractType.VENDOR).ruleSet().rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.CASH, PaymentType.INVOICE, PaymentType.CREDIT_CARD)).result((RuleAction)Actions.FOP_TRANSACTION_PAYMENT_TYPE_REPLACE, (Object)PaymentType.PTA).end()).rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.CASH, PaymentType.PTA)).result((RuleAction)Actions.FOP_TRANSACTION_PAYMENT_TYPE_REPLACE, (Object)PaymentType.MTD).end()).rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.CASH)).result((RuleAction)Actions.FOP_PAYMENT_TRANSACTION_CREATE, null).end()).rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.PTA)).result((RuleAction)Actions.FOP_PAYMENT_TRANSACTION_CREATE, null).end()).end()).create();
        EntityReference vendorModelContract = vendorModelContractContainer.toReference();
        TestContractBuilderBuilder clientContractBuilder = new TestContractBuilderBuilder();
        EntityContainer clientContractContainer = clientContractBuilder.contractType(ContractType.CLIENT).blankOwner(null).supplier(TestBookingFileBuilder.agency).customerNewContract(TestBookingFileBuilder.client).newModel(true).create();
        EntityReference clientContract = clientContractContainer.toReference();
        TestModelContractBuilder clientModelContractBuilder = new TestModelContractBuilder();
        EntityContainer clientModelContractContainer = ((TestModelContractBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)((TestRuleSetBuilder)clientModelContractBuilder.setContractType(ContractType.CLIENT).ruleSet().rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.PTA, PaymentType.MTD)).result((RuleAction)Actions.FOP_TRANSACTION_PAYMENT_TYPE_REPLACE, (Object)PaymentType.MCO).end()).rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.CASH, PaymentType.INVOICE, PaymentType.CREDIT_CARD)).result((RuleAction)Actions.FOP_TRANSACTION_PAYMENT_TYPE_REPLACE, (Object)PaymentType.CASH).end()).rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.INVOICE)).result((RuleAction)Actions.FOP_PAYMENT_TRANSACTION_CREATE, null).end()).rule().target((RuleTarget)Targets.FOPS).restriction((RuleProperty)Properties.PAYMENT_TYPE, (RuleCondition)Conditions.EQUALS, Arrays.asList(PaymentType.CASH)).result((RuleAction)Actions.FOP_PAYMENT_TRANSACTION_CREATE, null).end()).end()).create();
        EntityReference clientModelContract = clientModelContractContainer.toReference();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop = new ProductFop();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.CASH).amount(7500.0).end().end().clientContractRelation().fop(clientFop).paymentType(PaymentType.CREDIT_CARD).amount(8200.0).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)4L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        List<EntityReference<ChartOfAccountsElement>> debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        Transaction transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7500L)), (long)creditTransactionSplit.getAmount());
        TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7500L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7500L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7500L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)product.getIssueDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertNull((Object)creditTransactionSplit.getDimension1());
        Assert.assertNull((Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8200L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)debitTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), (Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8200L)), (long)debitTransactionSplit.getAmount());
        creditChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        debitChartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)creditChartOfAccountsElements.size());
        Assert.assertEquals((long)1L, (long)debitChartOfAccountsElements.size());
        creditChartOfAccountsElement = creditChartOfAccountsElements.get(0);
        debitChartOfAccountsElement = debitChartOfAccountsElements.get(0);
        transaction = this.getTransaction(transactions, creditChartOfAccountsElement, debitChartOfAccountsElement, product.getUid(), false, false);
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)transaction.getOrganization());
        Assert.assertEquals((Object)bookingFile, (Object)transaction.getBooking());
        Assert.assertEquals((Object)product.getUid(), (Object)transaction.getProductUid());
        Assert.assertEquals((Object)vendorFop.getOperationDate(), (Object)transaction.getOperationDate());
        Assert.assertTrue((boolean)transaction.isAutocreated());
        Assert.assertFalse((boolean)transaction.isHistorical());
        Assert.assertEquals((long)2L, (long)transaction.getSplits().size());
        creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
        Assert.assertNotNull((Object)creditTransactionSplit);
        Assert.assertTrue((boolean)creditTransactionSplit.isCredit());
        Assert.assertEquals(creditChartOfAccountsElement, (Object)creditTransactionSplit.getAccount());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), (Object)creditTransactionSplit.getDimension1());
        Assert.assertEquals((Object)FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), (Object)creditTransactionSplit.getDimension2());
        Assert.assertNull((Object)creditTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8200L)), (long)creditTransactionSplit.getAmount());
        debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
        Assert.assertNotNull((Object)debitTransactionSplit);
        Assert.assertFalse((boolean)debitTransactionSplit.isCredit());
        Assert.assertEquals(debitChartOfAccountsElement, (Object)debitTransactionSplit.getAccount());
        Assert.assertNull((Object)debitTransactionSplit.getDimension1());
        Assert.assertNull((Object)debitTransactionSplit.getDimension2());
        Assert.assertNull((Object)debitTransactionSplit.getDimension3());
        Assert.assertEquals((long)ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8200L)), (long)debitTransactionSplit.getAmount());
    }

    private List<Transaction> getTransactions(EntityReference<BookingFile> bookingFile) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TransactionSplitIndex.Property.bookingUid.name(), null));
        if (bookingFile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), bookingFile));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private Transaction getTransaction(List<Transaction> transactions, EntityReference<ChartOfAccountsElement> creditChartOfAccountsElement, EntityReference<ChartOfAccountsElement> debitChartOfAccountsElement, String productUid, boolean historical, boolean refund) {
        for (Transaction transaction : transactions) {
            TransactionSplit creditTransactionSplit = this.getTransactionSplit(transaction, creditChartOfAccountsElement, true);
            TransactionSplit debitTransactionSplit = this.getTransactionSplit(transaction, debitChartOfAccountsElement, false);
            if (!TextUtil.isSame((String)transaction.getProductUid(), (String)productUid) || transaction.isHistorical() != historical || creditTransactionSplit == null || creditTransactionSplit.getAmount() < 0L != refund || debitTransactionSplit == null || debitTransactionSplit.getAmount() < 0L != refund) continue;
            return transaction;
        }
        return null;
    }

    private TransactionSplit getTransactionSplit(Transaction transaction, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, boolean credit) {
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            if (credit != transactionSplit.isCredit() || !MiscUtil.equals((Object)transactionSplit.getAccount(), chartOfAccountsElement)) continue;
            return transactionSplit;
        }
        return null;
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }
}

