/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesUpdateTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestChartOfAccountsSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinanceUpdateBalancesTest
extends FinanceTestBase {
    private final LongRunningTaskCallback callback = new LongRunningTaskCallback(){

        @Override
        public boolean isToBeStopped() {
            return false;
        }

        @Override
        public void addEvent(String eventId, Message description) {
        }

        @Override
        public void updateProgress(byte progress) {
        }
    };
    private final FinanceBalancesUpdateTaskConfiguration balancesUpdateConfiguration = new FinanceBalancesUpdateTaskConfiguration();
    private DictionaryReference<CurrencyInfo> currency = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        EntityContainer agencyContainer = EntityStorage.get().resolve(TestBookingFileBuilder.agency);
        TestOrganizationBuilder agencyBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)agencyContainer.getEntity()).containerUid(agencyContainer.getUid());
        agencyContainer = ((TestOrganizationBuilder)((TestOrganizationBuilder)((TestOrganizationBuilder)agencyBuilder.fopPaymentInfo().paymentType(PaymentType.INVOICE).createPaymentDate(false).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.CREDIT_CARD).createPaymentDate(false).createPaymentTransaction(false).end()).fopPaymentInfo().paymentType(PaymentType.PTA).createPaymentDate(false).createPaymentTransaction(false).end()).create();
        this.currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    }

    @Test
    public void testFinanceUpdateBalances1() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(10).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.SALES_POINT).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.ORGANIZATION).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-12));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-11));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(5750.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.CASH).amount(620.0).oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.CREDIT_CARD).amount(5130.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        Assert.assertEquals((long)5L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-10));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)5L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.SALES_POINT, (Object)TestBookingFileBuilder.agencySalesPoint), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.client), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5750L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)5L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)7L, (long)this.getBalances(null).size());
    }

    @Test
    public void testFinanceUpdateBalances2() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(10).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension2().type(DimensionType.ORGANIZATION).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        ProductFop vendorFop = new ProductFop();
        ProductFop clientFop01 = new ProductFop();
        ProductFop clientFop02 = new ProductFop();
        Date issueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-12));
        String issueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(issueDate);
        Date paymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-11));
        String paymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentDate);
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().reservation().airProduct(product).rulesApplied(true).issueDate(issueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(vendorFop).paymentType(PaymentType.INVOICE).amount(9400.0).oparationDate(paymentDateString).end().end().clientContractRelation().fop(clientFop01).paymentType(PaymentType.CASH).amount(1340.0).oparationDate(paymentDateString).end().fop(clientFop02).paymentType(PaymentType.CREDIT_CARD).amount(8060.0).oparationDate(paymentDateString).end().end().end().end().create();
        EntityReference bookingFile = bookingFileContainer.toReference();
        Assert.assertEquals((long)5L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-10));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)5L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)3L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1340L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1340L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8060L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8060L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile);
        Assert.assertEquals((long)5L, (long)transactions.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)TestBookingFileBuilder.blankOwner), null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1340L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1340L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8060L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8060L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CASH), null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1340L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1340L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8060L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(8060L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9400L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)5L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)16L, (long)this.getBalances(null).size());
    }

    @Test
    public void testFinanceUpdateBalances3() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(10).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension2().type(DimensionType.CONTRACT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.AGENT).end().dimension3().type(DimensionType.PAYMENT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder01 = new TestBookingFileBuilder();
        Product product01 = new Product();
        ProductFop product01VendorFop = new ProductFop();
        ProductFop product01ClientFop = new ProductFop();
        Date product01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-12));
        String product01IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product01IssueDate);
        Date product01PaymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-11));
        String product01PaymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product01PaymentDate);
        EntityContainer bookingFileContainer01 = bookingFileBuilder01.traveller().end().reservation().airProduct(product01).rulesApplied(true).issueDate(product01IssueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(product01VendorFop).paymentType(PaymentType.CREDIT_CARD).amount(9090.0).oparationDate(product01PaymentDateString).end().end().clientContractRelation().fop(product01ClientFop).paymentType(PaymentType.CREDIT_CARD).amount(9090.0).oparationDate(product01PaymentDateString).end().end().end().end().create();
        EntityReference bookingFile01 = bookingFileContainer01.toReference();
        Assert.assertEquals((long)3L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-10));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile01);
        Assert.assertEquals((long)3L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        TestBookingFileBuilder bookingFileBuilder02 = new TestBookingFileBuilder();
        Product product02 = new Product();
        ProductFop product02VendorFop = new ProductFop();
        ProductFop product02ClientFop = new ProductFop();
        Date product02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-3));
        String product02IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product02IssueDate);
        Date product02PaymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-2));
        String product02PaymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product02PaymentDate);
        EntityContainer bookingFileContainer02 = bookingFileBuilder02.traveller().end().reservation().airProduct(product02).rulesApplied(true).issueDate(product02IssueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(product02VendorFop).paymentType(PaymentType.CREDIT_CARD).amount(7300.0).oparationDate(product02PaymentDateString).end().end().clientContractRelation().fop(product02ClientFop).paymentType(PaymentType.INVOICE).amount(2100.0).oparationDate(product02PaymentDateString).end().end().end().end().create();
        EntityReference bookingFile02 = bookingFileContainer02.toReference();
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile02);
        Assert.assertEquals((long)3L, (long)transactions.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.VENDOR), null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)8L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.AGENT, (Object)TestBookingFileBuilder.agencyAgent), null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(9090L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)6L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)18L, (long)this.getBalances(null).size());
    }

    @Test
    public void testFinanceUpdateBalances4() throws Exception {
        TestChartOfAccountsSettingsBuilder chartOfAccountsSettingsBuilder = new TestChartOfAccountsSettingsBuilder();
        EntityContainer chartOfAccountsSettingsContainer = chartOfAccountsSettingsBuilder.organization(TestBookingFileBuilder.agency).balancesDepth(10).trackTransactionsChanges(false).supplierSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().end().customerSettings().enabled(true).dimension1().type(DimensionType.PAYMENT_TYPE).end().dimension2().type(DimensionType.CONTRACT_TYPE).end().end().agentSettings().enabled(false).end().create();
        EntityReference chartOfAccountsSettings = chartOfAccountsSettingsContainer.toReference();
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder01 = new TestBookingFileBuilder();
        Product product01 = new Product();
        ProductFop product01VendorFop01 = new ProductFop();
        ProductFop product01VendorFop02 = new ProductFop();
        ProductFop product01ClientFop = new ProductFop();
        Date product01IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-12));
        String product01IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product01IssueDate);
        Date product01PaymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-11));
        String product01PaymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product01PaymentDate);
        EntityContainer bookingFileContainer01 = bookingFileBuilder01.traveller().end().reservation().airProduct(product01).rulesApplied(true).issueDate(product01IssueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(product01VendorFop01).paymentType(PaymentType.INVOICE).amount(1280.0).oparationDate(product01PaymentDateString).end().fop(product01VendorFop02).paymentType(PaymentType.PTA).amount(4400.0).oparationDate(product01PaymentDateString).end().end().clientContractRelation().fop(product01ClientFop).paymentType(PaymentType.INVOICE).amount(5680.0).oparationDate(product01PaymentDateString).end().end().end().end().create();
        EntityReference bookingFile01 = bookingFileContainer01.toReference();
        Assert.assertEquals((long)4L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)0L, (long)this.getBalances(null).size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-10));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        List<Transaction> transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile01);
        Assert.assertEquals((long)4L, (long)transactions.size());
        List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        EntityReference<ChartOfAccountsElement> chartOfAccountsElement = chartOfAccountsElements.get(0);
        List<OpeningBalance> balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)3L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1280L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4400L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)4L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)1L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        TestBookingFileBuilder bookingFileBuilder02 = new TestBookingFileBuilder();
        Product product02 = new Product();
        ProductFop product02VendorFop01 = new ProductFop();
        ProductFop product02VendorFop02 = new ProductFop();
        ProductFop product02ClientFop01 = new ProductFop();
        ProductFop product02ClientFop02 = new ProductFop();
        Date product02IssueDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-7));
        String product02IssueDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product02IssueDate);
        Date product02PaymentDate = MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)date, (int)-6));
        String product02PaymentDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(product02PaymentDate);
        EntityContainer bookingFileContainer02 = bookingFileBuilder02.traveller().end().reservation().airProduct(product02).rulesApplied(true).issueDate(product02IssueDateString).segmentTariff().segment().end().end().vendorContractRelation().fop(product02VendorFop01).paymentType(PaymentType.PTA).amount(7300.0).oparationDate(product02PaymentDateString).end().fop(product02VendorFop02).paymentType(PaymentType.INVOICE).amount(1000.0).oparationDate(product02PaymentDateString).end().end().clientContractRelation().fop(product02ClientFop01).paymentType(PaymentType.INVOICE).amount(2100.0).oparationDate(product02PaymentDateString).end().fop(product02ClientFop02).paymentType(PaymentType.CREDIT_CARD).amount(6200.0).oparationDate(product02PaymentDateString).end().end().end().end().create();
        EntityReference bookingFile02 = bookingFileContainer02.toReference();
        data = new HashMap();
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), this.callback);
        data.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.balancesUpdateConfiguration);
        data.put(IBusFinanceContextKeys.OPERATION_DATE.name(), MiscUtil.addDaysToDate((Date)date, (int)-5));
        IntegrationBusFacade.get().getRequestReplyAdapter("finance:balances-update").processSync(data);
        transactions = this.getTransactions((EntityReference<BookingFile>)bookingFile02);
        Assert.assertEquals((long)6L, (long)transactions.size());
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.SUPPLIER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)6L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(1280L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(4400L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(13980L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(2280L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.PTA), null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(11700L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.EXPENSE, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(13980L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.INCOME, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(13980L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.CUSTOMER, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)10L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(13980L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(13980L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(13980L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(13980L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7780L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7780L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.INVOICE), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7780L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(7780L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), true);
        this.checkBalance(balances, chartOfAccountsElement, FinanceHelper.getDimensionValue((DimensionType)DimensionType.PAYMENT_TYPE, (Object)PaymentType.CREDIT_CARD), FinanceHelper.getDimensionValue((DimensionType)DimensionType.CONTRACT_TYPE, (Object)ContractType.CLIENT), null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(6200L)), true);
        chartOfAccountsElements = this.getChartOfAccountsElements((EntityReference<Organization>)TestBookingFileBuilder.agency, ChartOfAccountsElementType.BANK, this.currency);
        Assert.assertEquals((long)1L, (long)chartOfAccountsElements.size());
        chartOfAccountsElement = chartOfAccountsElements.get(0);
        balances = this.getBalances(chartOfAccountsElement);
        Assert.assertEquals((long)2L, (long)balances.size());
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 0, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(5680L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        this.checkBalance(balances, chartOfAccountsElement, null, null, null, 1, ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(13980L)), ModelHelper.bigDecimal2Long((BigDecimal)BigDecimal.valueOf(0L)), true);
        Assert.assertEquals((long)10L, (long)this.getTransactions(null).size());
        Assert.assertEquals((long)22L, (long)this.getBalances(null).size());
    }

    private void checkBalance(List<OpeningBalance> balances, EntityReference<ChartOfAccountsElement> chartOfAccountsElement, String dimension1, String dimension2, String dimension3, int index, long debit, long credit, boolean exists) throws Exception {
        OpeningBalance balance = this.getBalance(balances, dimension1, dimension2, dimension3, index);
        if (exists) {
            Assert.assertNotNull((Object)balance);
            Assert.assertEquals((Object)chartOfAccountsElement.getUid(), (Object)balance.getAccountUid());
            Assert.assertEquals((Object)dimension1, (Object)balance.getDimension1());
            Assert.assertEquals((Object)dimension2, (Object)balance.getDimension2());
            Assert.assertEquals((Object)dimension3, (Object)balance.getDimension3());
            Assert.assertEquals((long)debit, (long)balance.getDebit());
            Assert.assertEquals((long)credit, (long)balance.getCredit());
        } else {
            Assert.assertNull((Object)balance);
        }
    }

    private List<Transaction> getTransactions(EntityReference<BookingFile> bookingFile) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        SearchQuery query = new SearchQuery();
        if (bookingFile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), bookingFile));
        }
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            Transaction transaction;
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactions.contains(transaction = (Transaction)transactionContainer.getEntity())) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization, ChartOfAccountsElementType type, DictionaryReference<CurrencyInfo> currency) {
        ArrayList<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = new ArrayList<EntityReference<ChartOfAccountsElement>>();
        SearchQuery query = new SearchQuery();
        if (organization != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        }
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)type));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currency));
        }
        List chartOfAccountsElementIndexes = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData();
        for (ChartOfAccountsElementIndex chartOfAccountsElementIndex : chartOfAccountsElementIndexes) {
            if (chartOfAccountsElements.contains(chartOfAccountsElementIndex.getSource())) continue;
            chartOfAccountsElements.add((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementIndex.getSource());
        }
        return chartOfAccountsElements;
    }

    private List<OpeningBalance> getBalances(EntityReference<ChartOfAccountsElement> chartOfAccountsElement) {
        SearchQuery query = new SearchQuery();
        if (chartOfAccountsElement != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.accountUid.name(), chartOfAccountsElement));
        }
        query.getCriteria().getOrders().put(OpeningBalance.Property.operationDate.name(), SortOrder.ASC);
        query.getCriteria().getOrders().put(OpeningBalance.Property.calculationDate.name(), SortOrder.ASC);
        return AssetsStorage.get().search(OpeningBalance.class, query).getData();
    }

    private OpeningBalance getBalance(List<OpeningBalance> balances, String dimension1, String dimension2, String dimension3, int index) {
        int count = 0;
        for (OpeningBalance balance : balances) {
            if (!MiscUtil.equals((Object)balance.getDimension1(), (Object)dimension1) || !MiscUtil.equals((Object)balance.getDimension2(), (Object)dimension2) || !MiscUtil.equals((Object)balance.getDimension3(), (Object)dimension3)) continue;
            if (count == index) {
                return balance;
            }
            ++count;
        }
        return null;
    }

    protected boolean isUseNoSchemeTestStorage() {
        return false;
    }

    protected List<URL> collectIntegrationBusDescriptions() {
        List result = super.collectIntegrationBusDescriptions();
        result.add(ResourceUtil.getResource(FinanceUpdateBalancesTest.class, (String)"ibus-finance-test.xml"));
        return result;
    }
}

