/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance.document;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.document.FinanceConsolidatedDocumentsCreateTaskParameters;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCorrectionCreateTaskParameters;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateFromShipmentTaskParameters;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskParameters;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskResult;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FinanceDocumentsCreateTaskHelper {
    public static FinanceDocumentsCreateTaskResult create(FinanceDocumentsCreateTaskParameters parameters, FinanceDocumentsCreateTaskCallback callback) throws Exception {
        ChangeData changedData = new ChangeData();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(IBusFinanceContextKeys.DATE.name(), parameters.getDate());
        context.put(IBusFinanceContextKeys.PRODUCT_REFERENCES.name(), parameters.getProducts());
        context.put(IBusFinanceContextKeys.CONTRACT_TYPE.name(), parameters.getContractType());
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT.name(), Boolean.FALSE);
        IntegrationBusFacade.get().processRouteSync("shipments:create", context);
        callback.addMessages(((Map)context.get("messages")).values());
        Collection shipments = (Collection)context.get(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name());
        if (CollectionUtil.isNotEmpty((Collection)shipments)) {
            ChangeData shipmentsChangeData = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
            if (shipmentsChangeData != null) {
                changedData.getChanged().addAll(shipmentsChangeData.getChanged());
                changedData.getDeleted().addAll(shipmentsChangeData.getDeleted());
            }
            context.clear();
            context.put(IBusFinanceContextKeys.DATE.name(), parameters.getDate());
            context.put(IBusFinanceContextKeys.USE_DELEGATE.name(), parameters.getUseDelegate());
            context.put(IBusFinanceContextKeys.USE_FACSIMILE.name(), parameters.getUseFacsimile());
            context.put(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name(), shipments);
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_CONSOLIDATED.name(), Boolean.FALSE);
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT.name(), Boolean.FALSE);
            IntegrationBusFacade.get().processRouteSync("finance-documents:create", context);
            callback.addMessages(((Map)context.get("messages")).values());
            Collection documents = (Collection)context.get(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name());
            ChangeData documentsChangeData = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
            if (documentsChangeData != null) {
                changedData.getChanged().addAll(documentsChangeData.getChanged());
                changedData.getDeleted().addAll(documentsChangeData.getDeleted());
            }
            for (EntityReference document : documents) {
                context.clear();
                context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), document);
                IntegrationBusFacade.get().processRouteSync("finance-documents:render-and-save", context);
                callback.addMessages(((Map)context.get("messages")).values());
            }
            FinanceDocumentsCreateTaskResult result = new FinanceDocumentsCreateTaskResult();
            result.setChangeData(changedData);
            result.getDocuments().clear();
            result.getDocuments().addAll(documents);
            return result;
        }
        return new FinanceDocumentsCreateTaskResult();
    }

    public static FinanceDocumentsCreateTaskResult create(FinanceDocumentsCorrectionCreateTaskParameters parameters, FinanceDocumentsCreateTaskCallback callback) throws Exception {
        ChangeData changedData = new ChangeData();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(IBusFinanceContextKeys.DATE.name(), parameters.getDate());
        context.put(IBusFinanceContextKeys.PRODUCT_REFERENCES.name(), parameters.getProducts());
        context.put(IBusFinanceContextKeys.ORIGINAL_SHIPMENT_REFERENCE.name(), parameters.getShipment());
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT.name(), Boolean.FALSE);
        IntegrationBusFacade.get().processRouteSync("shipments:create-correction", context);
        callback.addMessages(((Map)context.get("messages")).values());
        Collection shipments = (Collection)context.get(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name());
        if (shipments.size() > 0) {
            ChangeData shipmentsChangeData = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
            if (shipmentsChangeData != null) {
                changedData.getChanged().addAll(shipmentsChangeData.getChanged());
                changedData.getDeleted().addAll(shipmentsChangeData.getDeleted());
            }
            context.clear();
            context.put(IBusFinanceContextKeys.DATE.name(), parameters.getDate());
            context.put(IBusFinanceContextKeys.USE_DELEGATE.name(), parameters.getUseDelegate());
            context.put(IBusFinanceContextKeys.USE_FACSIMILE.name(), parameters.getUseFacsimile());
            context.put(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name(), shipments);
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_CONSOLIDATED.name(), Boolean.FALSE);
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT.name(), Boolean.FALSE);
            IntegrationBusFacade.get().processRouteSync("finance-documents:create", context);
            callback.addMessages(((Map)context.get("messages")).values());
            Collection documents = (Collection)context.get(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name());
            ChangeData documentsChangeData = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
            if (documentsChangeData != null) {
                changedData.getChanged().addAll(documentsChangeData.getChanged());
                changedData.getDeleted().addAll(documentsChangeData.getDeleted());
            }
            for (EntityReference document : documents) {
                context.clear();
                context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), document);
                IntegrationBusFacade.get().processRouteSync("finance-documents:render-and-save", context);
                callback.addMessages(((Map)context.get("messages")).values());
            }
            FinanceDocumentsCreateTaskResult result = new FinanceDocumentsCreateTaskResult();
            result.setChangeData(changedData);
            result.getDocuments().clear();
            result.getDocuments().addAll(documents);
            return result;
        }
        return new FinanceDocumentsCreateTaskResult();
    }

    public static FinanceDocumentsCreateTaskResult createConsolidated(FinanceConsolidatedDocumentsCreateTaskParameters parameters, FinanceDocumentsCreateTaskCallback callback) throws Exception {
        ChangeData changedData = new ChangeData();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(IBusFinanceContextKeys.DATE.name(), parameters.getDate());
        context.put(IBusFinanceContextKeys.USE_DELEGATE.name(), parameters.getUseDelegate());
        context.put(IBusFinanceContextKeys.USE_FACSIMILE.name(), parameters.getUseFacsimile());
        context.put(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name(), parameters.getShipments());
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_CONSOLIDATED.name(), Boolean.TRUE);
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT.name(), Boolean.FALSE);
        IntegrationBusFacade.get().processRouteSync("finance-documents:create", context);
        callback.addMessages(((Map)context.get("messages")).values());
        Collection documents = (Collection)context.get(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name());
        ChangeData documentsChangeData = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
        if (documentsChangeData != null) {
            changedData.getChanged().addAll(documentsChangeData.getChanged());
            changedData.getDeleted().addAll(documentsChangeData.getDeleted());
        }
        for (EntityReference document : documents) {
            context.clear();
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), document);
            IntegrationBusFacade.get().processRouteSync("finance-documents:render-and-save", context);
            callback.addMessages(((Map)context.get("messages")).values());
        }
        FinanceDocumentsCreateTaskResult result = new FinanceDocumentsCreateTaskResult();
        result.setChangeData(changedData);
        result.getDocuments().clear();
        result.getDocuments().addAll(documents);
        return result;
    }

    public static FinanceDocumentsCreateTaskResult createPrepayment(FinanceDocumentsCreateTaskParameters parameters, FinanceDocumentsCreateTaskCallback callback) throws Exception {
        ChangeData changedData = new ChangeData();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(IBusFinanceContextKeys.DATE.name(), parameters.getDate());
        context.put(IBusFinanceContextKeys.USE_DELEGATE.name(), parameters.getUseDelegate());
        context.put(IBusFinanceContextKeys.USE_FACSIMILE.name(), parameters.getUseFacsimile());
        context.put(IBusFinanceContextKeys.PRODUCT_REFERENCES.name(), parameters.getProducts());
        context.put(IBusFinanceContextKeys.CONTRACT_TYPE.name(), parameters.getContractType());
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT.name(), Boolean.TRUE);
        IntegrationBusFacade.get().processRouteSync("finance-documents:create-prepayment", context);
        callback.addMessages(((Map)context.get("messages")).values());
        Collection documents = (Collection)context.get(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name());
        ChangeData documentsChangeData = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
        if (documentsChangeData != null) {
            changedData.getChanged().addAll(documentsChangeData.getChanged());
            changedData.getDeleted().addAll(documentsChangeData.getDeleted());
        }
        for (EntityReference document : documents) {
            context.clear();
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), document);
            IntegrationBusFacade.get().processRouteSync("finance-documents:render-and-save", context);
            callback.addMessages(((Map)context.get("messages")).values());
        }
        FinanceDocumentsCreateTaskResult result = new FinanceDocumentsCreateTaskResult();
        result.setChangeData(changedData);
        result.getDocuments().clear();
        result.getDocuments().addAll(documents);
        return result;
    }

    public static FinanceDocumentsCreateTaskResult create(FinanceDocumentsCreateFromShipmentTaskParameters parameters, FinanceDocumentsCreateTaskCallback callback) throws Exception {
        ChangeData changedData = new ChangeData();
        HashMap<String, Object> context = new HashMap<String, Object>();
        EntityReference shipment = parameters.getShipmentReference();
        context.put(IBusFinanceContextKeys.DATE.name(), parameters.getDate());
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT.name(), Boolean.FALSE);
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_CONSOLIDATED.name(), Boolean.FALSE);
        context.put(IBusFinanceContextKeys.USE_DELEGATE.name(), parameters.getUseDelegate());
        context.put(IBusFinanceContextKeys.USE_FACSIMILE.name(), parameters.getUseFacsimile());
        context.put(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name(), Collections.singleton(shipment));
        FinanceDocumentData financeDocumentData = new FinanceDocumentData();
        financeDocumentData.setType(parameters.getFinanceDocumentType());
        financeDocumentData.setTemplate(parameters.getTemplate());
        financeDocumentData.setBillingItemIncludeMode(parameters.getBillingItemIncludeMode());
        financeDocumentData.setVatViewMode(parameters.getVatViewMode());
        financeDocumentData.setGroupByTraveller(parameters.isGroupByTraveller());
        financeDocumentData.setNotGroupByProduct(parameters.isNotGroupByProduct());
        financeDocumentData.setMergeBillingItems(parameters.getMergeBillingItems());
        financeDocumentData.setDisableCustomerQuotes(parameters.isDisableCustomerQuotes());
        financeDocumentData.setDisplayContract(parameters.isDisplayContract());
        financeDocumentData.setNotDisplayTitleContractNumber(parameters.isNotDisplayTitleContractNumber());
        financeDocumentData.setNotGroupByServiceType(parameters.isNotGroupByServiceType());
        financeDocumentData.setInvertSign(parameters.isInvertSign());
        financeDocumentData.setVendorDocument(parameters.isVendorDocument());
        financeDocumentData.setCaptionTemplate(parameters.getCaptionTemplate());
        financeDocumentData.setUniversalDocumentStatus(parameters.getUniversalDocumentStatus());
        financeDocumentData.getCustomParameters().putAll(parameters.getCustomParameters());
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_DATA.name(), financeDocumentData);
        IntegrationBusFacade.get().processRouteSync("finance-documents:create-manual", context);
        callback.addMessages(((Map)context.get("messages")).values());
        Collection documents = (Collection)context.get(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name());
        ChangeData documentsChangeData = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
        if (documentsChangeData != null) {
            changedData.getChanged().addAll(documentsChangeData.getChanged());
            changedData.getDeleted().addAll(documentsChangeData.getDeleted());
        }
        for (EntityReference document : documents) {
            context.clear();
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), document);
            IntegrationBusFacade.get().processRouteSync("finance-documents:render-and-save", context);
            callback.addMessages(((Map)context.get("messages")).values());
        }
        FinanceDocumentsCreateTaskResult result = new FinanceDocumentsCreateTaskResult();
        result.setChangeData(changedData);
        result.getDocuments().clear();
        result.getDocuments().addAll(documents);
        return result;
    }

    public static interface FinanceDocumentsCreateTaskCallback {
        public void setProgress(byte var1, String var2) throws Exception;

        public void addMessages(Collection<Message> var1) throws Exception;
    }
}

