/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance.documents;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.dict.ShipmentCategoryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.ibus.finance.shipments.ShipmentsIbusHelper;
import com.gridnine.xtrip.server.model.test.TestBillingItemsListBuilder;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFinanceDocumentBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import com.gridnine.xtrip.server.model.test.TestShipmentBuilder;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;

public class FinanceDocumentsBuildPrintFormTest
extends FinanceTestBase {
    private static final EntityReference<TemplateDocument> invoiceTemplate = new EntityReference("invoiceTemplate", TemplateDocument.class, "Invoice Template");
    private static final DictionaryReference<CurrencyInfo> currency = new CurrencyInfoReference("RUB");
    private DictionaryReference<ShipmentCategory> category = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.category = new ShipmentCategoryReference("air");
        EntityContainer agencyContainer = EntityStorage.get().resolve(TestBookingFileBuilder.agency);
        TestOrganizationBuilder agencyBuilder = (TestOrganizationBuilder)new TestOrganizationBuilder((Organization)agencyContainer.getEntity()).containerUid(agencyContainer.getUid());
        agencyContainer = agencyBuilder.financeProperties().invoice().useSettings(true).template(invoiceTemplate).end().end().create();
    }

    public void financeDocumentPrintFormTest() throws Exception {
        Date date = new Date();
        TestBookingFileBuilder bookingFileBuilder = new TestBookingFileBuilder();
        Product product = new Product();
        EntityContainer bookingFileContainer = bookingFileBuilder.traveller().end().agency(TestBookingFileBuilder.agency).client(TestBookingFileBuilder.client).reservation().bookingAgent(TestBookingFileBuilder.agencyAgent).airProduct(product).productCategory(ProductCategory.AIR).status(ProductStatus.SELL).blankType("555 ETKT").systemNumber("0000000001").carrier("SU").issueDate(date).ticketType(TicketType.OWN).fare().equivalentFare(13700.0).end().rulesApplied(true).segmentTariff().segment().end().end().vendorContractRelation().fop().paymentType(PaymentType.INVOICE).amount(13700.0).end().end().clientContractRelation().fop().paymentType(PaymentType.CASH).amount(13700.0).end().end().end().end().create();
        NestedEntityReference productReference = new NestedEntityReference(bookingFileContainer, (BaseEntity)product);
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        EntityContainer contractContainer = contractBuilder.newModel(Boolean.valueOf(true)).contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customerNewContract(TestBookingFileBuilder.client).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference<Contract, ContractCustomerInfo> contract = ShipmentsIbusHelper.createContractReference((EntityReference<Contract>)contractContainer.toReference());
        TestBillingItemsListBuilder billingItemsListBuilder = new TestBillingItemsListBuilder();
        EntityContainer billingItemsListContainer = ((TestBillingItemsListBuilder)((TestBillingItemsListBuilder)billingItemsListBuilder.billingItem().name("Billing item 01").serviceType(ServiceType.TICKET).amount(VatAmount.of((BigDecimal)BigDecimal.valueOf(6700L), (double)18.0)).product(productReference).end()).billingItem().name("Billing item 02").serviceType(ServiceType.TICKET).amount(VatAmount.of((BigDecimal)BigDecimal.valueOf(7000L), (double)10.0)).product(productReference).end()).create();
        NestedEntityReference billingItem01 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)((BillingItemsList)billingItemsListContainer.getEntity()).getData().get(0));
        NestedEntityReference billingItem02 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)((BillingItemsList)billingItemsListContainer.getEntity()).getData().get(1));
        TestShipmentBuilder shipmentBuilder = new TestShipmentBuilder();
        EntityContainer shipmentContainer = shipmentBuilder.category(this.category).contract(contract).currency(currency).supplier(TestBookingFileBuilder.agency).customer(TestBookingFileBuilder.client).payer(TestBookingFileBuilder.client).agent(TestBookingFileBuilder.agencyAgent).date(date).number("Shipment 01").billingItem(billingItem01).billingItem(billingItem02).create();
        EntityReference shipment = shipmentContainer.toReference();
        TestFinanceDocumentBuilder financeDocumentBuilder = new TestFinanceDocumentBuilder();
        EntityContainer financeDocumentContainer = financeDocumentBuilder.name("Invoice 000000001").number("000000001").type(FinanceDocumentType.INVOICE).date(date).template(invoiceTemplate).contract(contract).currency(currency).supplier(TestBookingFileBuilder.agency).customer(TestBookingFileBuilder.client).payer(TestBookingFileBuilder.client).agent(TestBookingFileBuilder.agencyAgent).shipment(shipment).billingItem(billingItem01).billingItem(billingItem02).create();
        EntityReference financeDocument = financeDocumentContainer.toReference();
        HashMap<String, EntityReference> data = new HashMap<String, EntityReference>();
        data.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), financeDocument);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("finance-documents:render-and-save", data);
        financeDocumentContainer = EntityStorage.get().resolve(financeDocument);
        Assert.assertNotNull((Object)((FinanceDocument)financeDocumentContainer.getEntity()).getContent());
    }

    protected List<URL> getEntitiesSetupFiles() throws Exception {
        List result = super.getEntitiesSetupFiles();
        result.add(ResourceUtil.getResource(FinanceDocumentsBuildPrintFormTest.class, (String)"testdata/Template-Invoice.xml", (boolean)true));
        return result;
    }
}

