/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.finance.documents;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.dict.ShipmentCategoryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.finance.FinanceTestBase;
import com.gridnine.xtrip.server.model.test.TestBillingItemsListBuilder;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestShipmentBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;

public class FinanceDocumentsDeleteTest
extends FinanceTestBase {
    private final Comparator<EntityReference<?>> entityReferenceComparator = new Comparator<EntityReference<?>>(){

        @Override
        public int compare(EntityReference<?> o1, EntityReference<?> o2) {
            return o1.getUid().compareTo(o2.getUid());
        }
    };
    private final Comparator<NestedEntityReference<?, ?>> nestedEntityReferenceComparator = new Comparator<NestedEntityReference<?, ?>>(){

        @Override
        public int compare(NestedEntityReference<?, ?> o1, NestedEntityReference<?, ?> o2) {
            int result = o1.getUid().compareTo(o2.getUid());
            if (result != 0) {
                return result;
            }
            return o1.getNestedEntityUid().compareTo(o2.getNestedEntityUid());
        }
    };
    private final Comparator<DictionaryReference<?>> dictionaryReferenceComparator = new Comparator<DictionaryReference<?>>(){

        @Override
        public int compare(DictionaryReference<?> o1, DictionaryReference<?> o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    };
    private DictionaryReference<ShipmentCategory> category01 = null;
    private DictionaryReference<ShipmentCategory> category02 = null;

    @Override
    @Before
    public void initialize() throws Exception {
        super.initialize();
        this.category01 = new ShipmentCategoryReference("air");
        this.category02 = new ShipmentCategoryReference("hotel");
    }

    public void financeDocumentCreateTest1() throws Exception {
        Date date = new Date();
        TestBillingItemsListBuilder billingItemsListBuilder = new TestBillingItemsListBuilder();
        EntityContainer billingItemsListContainer = ((TestBillingItemsListBuilder)((TestBillingItemsListBuilder)((TestBillingItemsListBuilder)billingItemsListBuilder.billingItem().name("Billing item 01").serviceType(ServiceType.TICKET).amount(15000.0, 18.0).end()).billingItem().name("Billing item 02").serviceType(ServiceType.TICKET).amount(7000.0, 10.0).end()).billingItem().name("Billing item 03").serviceType(ServiceType.FEE).amount(5000.0, 18.0).end()).create();
        NestedEntityReference billingItem01 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)((BillingItemsList)billingItemsListContainer.getEntity()).getData().get(0));
        NestedEntityReference billingItem02 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)((BillingItemsList)billingItemsListContainer.getEntity()).getData().get(1));
        NestedEntityReference billingItem03 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)((BillingItemsList)billingItemsListContainer.getEntity()).getData().get(2));
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        EntityContainer contractContainer = contractBuilder.contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customer(contractCustomerInfo).customer(TestBookingFileBuilder.client).end().create();
        NestedEntityReference contract = new NestedEntityReference(contractContainer, (BaseEntity)contractCustomerInfo);
        TestShipmentBuilder shipmentBuilder01 = new TestShipmentBuilder();
        EntityContainer shipmentContainer01 = shipmentBuilder01.number("12345").category(this.category01).date(date).contract(contract).supplier(TestBookingFileBuilder.agency).customer(TestBookingFileBuilder.client).payer(TestBookingFileBuilder.client).billingItem(billingItem01).billingItem(billingItem02).create();
        EntityReference shipment01 = shipmentContainer01.toReference();
        TestShipmentBuilder shipmentBuilder02 = new TestShipmentBuilder();
        EntityContainer shipmentContainer02 = shipmentBuilder02.number("12346").category(this.category02).date(date).contract(contract).supplier(TestBookingFileBuilder.agency).customer(TestBookingFileBuilder.client).payer(TestBookingFileBuilder.client).billingItem(billingItem03).create();
        EntityReference shipment02 = shipmentContainer02.toReference();
        ArrayList<EntityReference> shipmentss = new ArrayList<EntityReference>();
        shipmentss.add(shipment01);
        shipmentss.add(shipment02);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusFinanceContextKeys.DATE.name(), date);
        data.put(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name(), shipmentss);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("finance-documents:create", data);
        Collection documentss = (Collection)data.get(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name());
        Assert.assertEquals((long)3L, (long)documentss.size());
        Map<FinanceDocumentType, EntityReference> map = documentss.stream().collect(Collectors.toMap(item -> ((FinanceDocument)EntityStorage.get().resolve(item).getEntity()).getType(), item -> item));
        data = new HashMap();
        data.put(IBusFinanceContextKeys.FINDOCS_REFERENCES_COLLECTION.name(), Arrays.asList(map.get(FinanceDocumentType.INVOICE), map.get(FinanceDocumentType.INVOICE_FACTURA)));
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("finance-documents:delete-finance-document", data);
        List<FinanceDocument> documents = this.getFinanceDocuments(FinanceDocumentType.INVOICE);
        Assert.assertEquals((long)0L, (long)documents.size());
        documents = this.getFinanceDocuments(FinanceDocumentType.INVOICE_FACTURA);
        Assert.assertEquals((long)0L, (long)documents.size());
        documents = this.getFinanceDocuments(FinanceDocumentType.STANDARD_BILL);
        Assert.assertEquals((long)1L, (long)documents.size());
        FinanceDocument document = documents.get(0);
        Assert.assertEquals((Object)FinanceDocumentType.STANDARD_BILL, (Object)document.getType());
        Assert.assertEquals((Object)date, (Object)document.getDate());
        Assert.assertEquals((Object)contract, (Object)document.getContract());
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)document.getSupplier());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)document.getCustomer());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)document.getPayer());
        Assert.assertEquals(Arrays.asList(billingItem01, billingItem02, billingItem03).stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()), document.getBillingItems().stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()));
        Assert.assertEquals(shipmentss.stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()), document.getRelatedShipments().stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()));
        List<DictionaryReference<ShipmentCategory>> categories = Arrays.asList(this.category01);
        List<Shipment> shipments = this.getShipments(categories);
        Assert.assertEquals((long)1L, (long)shipments.size());
        Shipment shipment = shipments.get(0);
        Assert.assertEquals(categories.stream().sorted(this.dictionaryReferenceComparator).collect(Collectors.toList()), shipment.getCategories().stream().sorted(this.dictionaryReferenceComparator).collect(Collectors.toList()));
        Assert.assertEquals((Object)date, (Object)shipment.getDate());
        Assert.assertEquals((Object)contract, (Object)shipment.getContract());
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)shipment.getSupplier());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)shipment.getCustomer());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)shipment.getPayer());
        Assert.assertEquals(Arrays.asList(billingItem01, billingItem02).stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()), shipment.getBillingItems().stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()));
        Assert.assertEquals(Arrays.asList(map.get(FinanceDocumentType.STANDARD_BILL)).stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()), shipment.getFinanceDocuments().stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()));
        categories = Arrays.asList(this.category02);
        shipments = this.getShipments(categories);
        Assert.assertEquals((long)1L, (long)shipments.size());
        shipment = shipments.get(0);
        Assert.assertEquals(categories.stream().sorted(this.dictionaryReferenceComparator).collect(Collectors.toList()), shipment.getCategories().stream().sorted(this.dictionaryReferenceComparator).collect(Collectors.toList()));
        Assert.assertEquals((Object)date, (Object)shipment.getDate());
        Assert.assertEquals((Object)contract, (Object)shipment.getContract());
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)shipment.getSupplier());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)shipment.getCustomer());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)shipment.getPayer());
        Assert.assertEquals(Arrays.asList(billingItem03).stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()), shipment.getBillingItems().stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()));
        Assert.assertEquals(Arrays.asList(map.get(FinanceDocumentType.STANDARD_BILL)).stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()), shipment.getFinanceDocuments().stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()));
        data = new HashMap();
        data.put(IBusFinanceContextKeys.FINDOCS_REFERENCES_COLLECTION.name(), Arrays.asList(map.get(FinanceDocumentType.STANDARD_BILL)));
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("finance-documents:delete-finance-document", data);
        documents = this.getFinanceDocuments(FinanceDocumentType.INVOICE);
        Assert.assertEquals((long)0L, (long)documents.size());
        documents = this.getFinanceDocuments(FinanceDocumentType.INVOICE_FACTURA);
        Assert.assertEquals((long)0L, (long)documents.size());
        documents = this.getFinanceDocuments(FinanceDocumentType.STANDARD_BILL);
        Assert.assertEquals((long)0L, (long)documents.size());
        categories = Arrays.asList(this.category01);
        shipments = this.getShipments(categories);
        Assert.assertEquals((long)1L, (long)shipments.size());
        shipment = shipments.get(0);
        Assert.assertEquals(categories.stream().sorted(this.dictionaryReferenceComparator).collect(Collectors.toList()), shipment.getCategories().stream().sorted(this.dictionaryReferenceComparator).collect(Collectors.toList()));
        Assert.assertEquals((Object)date, (Object)shipment.getDate());
        Assert.assertEquals((Object)contract, (Object)shipment.getContract());
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)shipment.getSupplier());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)shipment.getCustomer());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)shipment.getPayer());
        Assert.assertEquals(Arrays.asList(billingItem01, billingItem02).stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()), shipment.getBillingItems().stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()));
        Assert.assertEquals(Collections.emptyList().stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()), shipment.getFinanceDocuments().stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()));
        categories = Arrays.asList(this.category02);
        shipments = this.getShipments(categories);
        Assert.assertEquals((long)1L, (long)shipments.size());
        shipment = shipments.get(0);
        Assert.assertEquals(categories.stream().sorted(this.dictionaryReferenceComparator).collect(Collectors.toList()), shipment.getCategories().stream().sorted(this.dictionaryReferenceComparator).collect(Collectors.toList()));
        Assert.assertEquals((Object)date, (Object)shipment.getDate());
        Assert.assertEquals((Object)contract, (Object)shipment.getContract());
        Assert.assertEquals((Object)TestBookingFileBuilder.agency, (Object)shipment.getSupplier());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)shipment.getCustomer());
        Assert.assertEquals((Object)TestBookingFileBuilder.client, (Object)shipment.getPayer());
        Assert.assertEquals(Arrays.asList(billingItem03).stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()), shipment.getBillingItems().stream().sorted(this.nestedEntityReferenceComparator).collect(Collectors.toList()));
        Assert.assertEquals(Collections.emptyList().stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()), shipment.getFinanceDocuments().stream().sorted(this.entityReferenceComparator).collect(Collectors.toList()));
    }

    private List<FinanceDocument> getFinanceDocuments(FinanceDocumentType type) {
        ArrayList<FinanceDocument> documents = new ArrayList<FinanceDocument>();
        SearchQuery query = new SearchQuery();
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.documentType.name(), (Object)type));
        }
        List indexes = EntityStorage.get().search(FinanceDocumentRecordIndex.class, query).getData();
        for (FinanceDocumentRecordIndex index : indexes) {
            FinanceDocument document;
            EntityContainer documentContainer = EntityStorage.get().resolve(index.getSource());
            if (documentContainer == null || documents.contains(document = (FinanceDocument)documentContainer.getEntity())) continue;
            documents.add(document);
        }
        return documents;
    }

    private List<Shipment> getShipments(List<DictionaryReference<ShipmentCategory>> categories) {
        ArrayList<Shipment> shipments = new ArrayList<Shipment>();
        SearchQuery query = new SearchQuery();
        for (DictionaryReference<ShipmentCategory> category : categories) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)ShipmentIndex.Property.categories.name(), category));
        }
        List indexes = EntityStorage.get().search(ShipmentIndex.class, query).getData();
        for (ShipmentIndex index : indexes) {
            Shipment shipment;
            EntityContainer shipmentContainer = EntityStorage.get().resolve(index.getSource());
            if (shipmentContainer == null || shipments.contains(shipment = (Shipment)shipmentContainer.getEntity())) continue;
            shipments.add(shipment);
        }
        return shipments;
    }
}

