/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AddServiceTypeFopComponent;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectBillingItemProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.format.object.Format;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public enum ModelFormatObjectBillingItemPropertyHandlers implements FormatObjectPropertyHandler
{
    NAME{

        public String getId() {
            return ModelFormatObjectBillingItemProperties.NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectBillingItemProperties.NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BillingItem billingItem = (BillingItem)proxy.getObject();
            return billingItem.getName();
        }
    }
    ,
    NOMENCLATURE{

        public String getId() {
            return ModelFormatObjectBillingItemProperties.NOMENCLATURE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectBillingItemProperties.NOMENCLATURE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BillingItem billingItem = (BillingItem)proxy.getObject();
            return Optional.ofNullable(billingItem.getNomenclature()).map(item -> {
                Nomenclature nomenclature = (Nomenclature)DictionaryCache.get().resolveReference(item);
                if (nomenclature == null) {
                    return item.getCode();
                }
                String name = (String)nomenclature.getTranslations().get(locale);
                return TextUtil.nonBlank((String)name) ? name : item.getCode();
            }).orElse(null);
        }
    }
    ,
    TRAVELLER{

        public String getId() {
            return ModelFormatObjectBillingItemProperties.TRAVELLER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectBillingItemProperties.TRAVELLER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Traveller traveller;
            BillingItem billingItem = (BillingItem)proxy.getObject();
            BookingFile bookingFile = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)billingItem.getTraveller(), (EntityStorageContext)storageContext)).map(item -> (BookingFile)item.getEntity()).orElse(null);
            if (bookingFile != null && (traveller = (Traveller)EntityStorageHelper.findNestedEntity((BaseEntity)bookingFile, (NestedEntityReference)billingItem.getTraveller())) != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.TRAVELLER.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)traveller, ModelFormatObjects.TRAVELLER.getId()).rootObject((Object)bookingFile, ModelFormatObjects.BOOKING_FILE.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    }
    ,
    PRODUCT{

        public String getId() {
            return ModelFormatObjectBillingItemProperties.PRODUCT.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectBillingItemProperties.PRODUCT.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product;
            BillingItem billingItem = (BillingItem)proxy.getObject();
            BookingFile bookingFile = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext)).map(item -> (BookingFile)item.getEntity()).orElse(null);
            if (bookingFile != null && (product = (BaseProduct)EntityStorageHelper.findNestedEntity((BaseEntity)bookingFile, (NestedEntityReference)billingItem.getProduct())) != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.PRODUCT.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)product, ModelFormatObjects.PRODUCT.getId()).rootObject((Object)bookingFile, ModelFormatObjects.BOOKING_FILE.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    }
    ,
    ADDITIONAL_SERVICES_NAMES{

        public String getId() {
            return ModelFormatObjectBillingItemProperties.ADDITIONAL_SERVICES_NAMES.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectBillingItemProperties.ADDITIONAL_SERVICES_NAMES.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BillingItem billingItem = (BillingItem)proxy.getObject();
            Set sources = billingItem.getFopComponents().stream().map(EntityStorageHelper::resolve).filter(component -> component instanceof AddServiceTypeFopComponent).flatMap(component -> ((AddServiceTypeFopComponent)component).getSources().stream()).filter(Objects::nonNull).collect(Collectors.toSet());
            if (sources.isEmpty()) {
                return null;
            }
            BaseProduct baseProduct = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct());
            if (baseProduct instanceof HotelProduct) {
                HotelProduct product = (HotelProduct)baseProduct;
                return product.getAdditionalServices().stream().filter(item -> sources.contains(item.getUid()) && TextUtil.nonBlank((String)item.getName())).map(item -> {
                    if (ModelFormatObjectBillingItemPropertyHandlers.isEnLocale(locale)) {
                        return TranslitUtil.cyr2lat((String)item.getName(), (TranslitUtil.TranslitRules)TRANSLIT_RULES);
                    }
                    return item.getName();
                }).collect(Collectors.joining(TextUtil.nonBlank((String)separator) ? separator : ", "));
            }
            return null;
        }
    };


    private static boolean isEnLocale(Locale locale) {
        String localLanguage = Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null);
        return MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), (Object)localLanguage);
    }
}

