/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectBookingFileProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public enum ModelFormatObjectBookingFilePropertyHandlers implements FormatObjectPropertyHandler
{
    NUMBER{

        public String getId() {
            return ModelFormatObjectBookingFileProperties.NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectBookingFileProperties.NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BookingFile bookingFile = (BookingFile)proxy.getObject();
            return bookingFile.getNumber();
        }
    }
    ,
    CUSTOMER_PROFILE{

        public String getId() {
            return ModelFormatObjectBookingFileProperties.CUSTOMER_PROFILE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectBookingFileProperties.CUSTOMER_PROFILE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BookingFile bookingFile = (BookingFile)proxy.getObject();
            Organization organization = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)bookingFile.getCustomerProfile(), (EntityStorageContext)storageContext)).map(item -> (Organization)item.getEntity()).orElse(null);
            if (organization != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.ORGANIZATION.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)organization, ModelFormatObjects.ORGANIZATION.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    }
    ,
    RESERVATIONS{

        public String getId() {
            return ModelFormatObjectBookingFileProperties.RESERVATIONS.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectBookingFileProperties.RESERVATIONS.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BookingFile bookingFile = (BookingFile)proxy.getObject();
            Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.RESERVATION.getPattern()));
            return bookingFile.getReservations().stream().map(item -> format.format(Format.FormatObjectDataBuilder.get().object(item, ModelFormatObjects.RESERVATION.getId()).parentProxy(proxy).build(), storageContext, locale)).collect(Collectors.joining(!TextUtil.isBlank((String)separator, (boolean)false) ? separator : ", "));
        }
    }
    ,
    TRAVELLERS{

        public String getId() {
            return ModelFormatObjectBookingFileProperties.TRAVELLERS.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectBookingFileProperties.TRAVELLERS.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BookingFile bookingFile = (BookingFile)proxy.getObject();
            Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.TRAVELLER.getPattern()));
            return bookingFile.getTravellers().stream().map(item -> format.format(Format.FormatObjectDataBuilder.get().object(item, ModelFormatObjects.TRAVELLER.getId()).parentProxy(proxy).build(), storageContext, locale)).collect(Collectors.joining(!TextUtil.isBlank((String)separator, (boolean)false) ? separator : ", "));
        }
    };

}

