/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectContractProperties;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Optional;

public enum ModelFormatObjectContractPropertyHandlers implements FormatObjectPropertyHandler
{
    NAME{

        public String getId() {
            return ModelFormatObjectContractProperties.NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectContractProperties.NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Contract contract = (Contract)proxy.getObject();
            if (MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null))) {
                return TranslitUtil.cyr2lat((String)contract.getName(), (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return contract.getName();
        }
    }
    ,
    TYPE{

        public String getId() {
            return ModelFormatObjectContractProperties.TYPE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectContractProperties.TYPE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Contract contract = (Contract)proxy.getObject();
            return Optional.ofNullable(contract.getContractType()).map(item -> item.toString(locale)).orElse(null);
        }
    }
    ,
    NUMBER{

        public String getId() {
            return ModelFormatObjectContractProperties.NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectContractProperties.NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Contract contract = (Contract)proxy.getObject();
            return contract.getNumber();
        }
    }
    ,
    DATE{

        public String getId() {
            return ModelFormatObjectContractProperties.DATE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectContractProperties.DATE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Contract contract = (Contract)proxy.getObject();
            return contract.getIssueDate() != null ? (!TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format(contract.getIssueDate()) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateFormatPattern()).format(contract.getIssueDate()) : contract.getIssueDate().toString())) : null;
        }
    };

}

