/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectFinanceDocumentProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberPeriod;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberSerial;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumberHelper;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;

public enum ModelFormatObjectFinanceDocumentPropertyHandlers implements FormatObjectPropertyHandler
{
    DATE{

        public String getId() {
            return ModelFormatObjectFinanceDocumentProperties.DATE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectFinanceDocumentProperties.DATE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            FinanceDocument document = (FinanceDocument)proxy.getObject();
            return document.getDate() != null ? (!TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format(document.getDate()) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateFormatPattern()).format(document.getDate()) : document.getDate().toString())) : null;
        }
    }
    ,
    NUMBER{

        public String getId() {
            return ModelFormatObjectFinanceDocumentProperties.NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectFinanceDocumentProperties.NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            FinanceDocument document = (FinanceDocument)proxy.getObject();
            return document.getNumber();
        }
    }
    ,
    NUMBER_GENERATE{

        public String getId() {
            return ModelFormatObjectFinanceDocumentProperties.NUMBER_GENERATE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectFinanceDocumentProperties.NUMBER_GENERATE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            final FinanceDocument document = (FinanceDocument)proxy.getObject();
            final FinanceDocumentsProperties properties = FinanceDocumentHelper.getFinanceDocumentsProperties((EntityReference<Organization>)document.getSupplier(), false);
            if (properties != null) {
                long number = ConsecutiveNumberHelper.incrementAndGetNumber(new ConsecutiveNumberHelper.ConsecutiveNumberHandler(){

                    @Override
                    public ConsecutiveNumberCategory getCategory() {
                        return FinanceDocumentHelper.getCategory(document.getType());
                    }

                    @Override
                    public ConsecutiveNumberSerial getSerial() {
                        return properties.getNumberSerial();
                    }

                    @Override
                    public ConsecutiveNumberPeriod getPeriod() {
                        return properties.getNumberPeriod();
                    }

                    @Override
                    public EntityReference<Organization> getAgency() {
                        return document.getSupplier();
                    }

                    @Override
                    public EntityReference<Contract> getContract() {
                        return document.getContract();
                    }

                    @Override
                    public EntityReference<Cash> getCash() {
                        return null;
                    }

                    @Override
                    public Date getDate() {
                        return document.getDate();
                    }
                });
                if (!TextUtil.isBlank((String)pattern)) {
                    DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                    format.applyPattern(pattern);
                    return format.format(number);
                }
                return String.valueOf(number);
            }
            return null;
        }
    }
    ,
    VENDOR_NUMBER{

        public String getId() {
            return ModelFormatObjectFinanceDocumentProperties.VENDOR_NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectFinanceDocumentProperties.VENDOR_NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            FinanceDocument document = (FinanceDocument)proxy.getObject();
            if (document.getVendorFinanceDocumentData() != null) {
                return document.getVendorFinanceDocumentData().getVendorNumber();
            }
            return null;
        }
    }
    ,
    VENDOR_SEQUENCE_NUMBER{

        public String getId() {
            return ModelFormatObjectFinanceDocumentProperties.VENDOR_SEQUENCE_NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectFinanceDocumentProperties.VENDOR_SEQUENCE_NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            FinanceDocument document = (FinanceDocument)proxy.getObject();
            if (document.getVendorFinanceDocumentData() != null) {
                return String.valueOf(document.getVendorFinanceDocumentData().getSequenceNumber());
            }
            return null;
        }
    }
    ,
    SUPPLIER{

        public String getId() {
            return ModelFormatObjectFinanceDocumentProperties.SUPPLIER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectFinanceDocumentProperties.SUPPLIER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            FinanceDocument document = (FinanceDocument)proxy.getObject();
            Organization supplier = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getSupplier(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
            if (supplier != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.ORGANIZATION.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)supplier, ModelFormatObjects.ORGANIZATION.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    }
    ,
    CUSTOMER{

        public String getId() {
            return ModelFormatObjectFinanceDocumentProperties.CUSTOMER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectFinanceDocumentProperties.CUSTOMER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            FinanceDocument document = (FinanceDocument)proxy.getObject();
            Organization customer = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getCustomer(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
            if (customer != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.ORGANIZATION.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)customer, ModelFormatObjects.ORGANIZATION.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    }
    ,
    CONTRACT{

        public String getId() {
            return ModelFormatObjectFinanceDocumentProperties.CONTRACT.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectFinanceDocumentProperties.CONTRACT.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            FinanceDocument document = (FinanceDocument)proxy.getObject();
            Contract contract = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)document.getContract(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
            if (contract != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.CONTRACT.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)contract, ModelFormatObjects.CONTRACT.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    }
    ,
    SHIPMENT{

        public String getId() {
            return ModelFormatObjectFinanceDocumentProperties.SHIPMENT.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectFinanceDocumentProperties.SHIPMENT.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            FinanceDocument document = (FinanceDocument)proxy.getObject();
            Shipment shipment = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)((EntityReference)CollectionUtil.head((Iterable)document.getRelatedShipments())), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null);
            if (shipment != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.SHIPMENT.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)shipment, ModelFormatObjects.SHIPMENT.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    };

}

