/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectOrganizationProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Locale;
import java.util.Optional;

public enum ModelFormatObjectOrganizationPropertyHandlers implements FormatObjectPropertyHandler
{
    CODE{

        public String getId() {
            return ModelFormatObjectOrganizationProperties.CODE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectOrganizationProperties.CODE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Organization organization = (Organization)proxy.getObject();
            return organization.getCode();
        }
    }
    ,
    SHORT_NAME{

        public String getId() {
            return ModelFormatObjectOrganizationProperties.SHORT_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectOrganizationProperties.SHORT_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Organization organization = (Organization)proxy.getObject();
            return L10nStringHelper.getValue((L10nString)organization.getShortName(), (Locale)locale, (boolean)false);
        }
    }
    ,
    FULL_NAME{

        public String getId() {
            return ModelFormatObjectOrganizationProperties.FULL_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectOrganizationProperties.FULL_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Organization organization = (Organization)proxy.getObject();
            return L10nStringHelper.getValue((L10nString)organization.getFullName(), (Locale)locale, (boolean)false);
        }
    }
    ,
    LEGAL_FORM{

        public String getId() {
            return ModelFormatObjectOrganizationProperties.LEGAL_FORM.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectOrganizationProperties.LEGAL_FORM.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Organization organization = (Organization)proxy.getObject();
            return Optional.ofNullable(DictionaryCache.get().resolveReference(organization.getLegalForm())).map(item -> item.getAbbreviations().entrySet().stream().filter(entry -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)entry.getKey())), (Object)LocaleUtil.createNormalizedLocale((Locale)locale))).findFirst().orElse(item.getAbbreviations().values().size() > 0 ? item.getAbbreviations().entrySet().iterator().next() : null)).map(item -> (String)item.getValue()).orElse(null);
        }
    }
    ,
    REGISTRATION_ID{

        public String getId() {
            return ModelFormatObjectOrganizationProperties.REGISTRATION_ID.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectOrganizationProperties.REGISTRATION_ID.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Organization organization = (Organization)proxy.getObject();
            return organization.getRegistrationId();
        }
    }
    ,
    KPP{

        public String getId() {
            return ModelFormatObjectOrganizationProperties.KPP.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectOrganizationProperties.KPP.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Organization organization = (Organization)proxy.getObject();
            return organization.getKpp();
        }
    };

}

