/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectPassportProperties;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;

public enum ModelFormatObjectPassportPropertyHandlers implements FormatObjectPropertyHandler
{
    TYPE{

        public String getId() {
            return ModelFormatObjectPassportProperties.TYPE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPassportProperties.TYPE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Passport passport = (Passport)proxy.getObject();
            return Optional.ofNullable(passport.getType()).map(item -> item.toString(locale)).orElse(null);
        }
    }
    ,
    NUMBER{

        public String getId() {
            return ModelFormatObjectPassportProperties.NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPassportProperties.NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Passport passport = (Passport)proxy.getObject();
            return passport.getNumber();
        }
    }
    ,
    FIRST_NAME{

        public String getId() {
            return ModelFormatObjectPassportProperties.FIRST_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPassportProperties.FIRST_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Passport passport = (Passport)proxy.getObject();
            if (ModelFormatObjectPassportPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)passport.getFirstName(), (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return passport.getFirstName();
        }
    }
    ,
    LAST_NAME{

        public String getId() {
            return ModelFormatObjectPassportProperties.LAST_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPassportProperties.LAST_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Passport passport = (Passport)proxy.getObject();
            if (ModelFormatObjectPassportPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)passport.getLastName(), (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return passport.getLastName();
        }
    }
    ,
    MIDDLE_NAME{

        public String getId() {
            return ModelFormatObjectPassportProperties.MIDDLE_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPassportProperties.MIDDLE_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Passport passport = (Passport)proxy.getObject();
            if (ModelFormatObjectPassportPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)passport.getMiddleName(), (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return passport.getMiddleName();
        }
    }
    ,
    SECOND_NAME{

        public String getId() {
            return ModelFormatObjectPassportProperties.SECOND_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPassportProperties.SECOND_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Passport passport = (Passport)proxy.getObject();
            if (ModelFormatObjectPassportPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)passport.getSecondName(), (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return passport.getSecondName();
        }
    }
    ,
    ISSUED{

        public String getId() {
            return ModelFormatObjectPassportProperties.ISSUED.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPassportProperties.ISSUED.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Passport passport = (Passport)proxy.getObject();
            return Optional.ofNullable(passport.getIssued()).map(item -> !TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format((Date)item) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateTimeFormatPattern()).format((Date)item) : item.toString())).orElse(null);
        }
    };


    private static boolean isEnLocale(Locale locale) {
        String localLanguage = Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null);
        return MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), (Object)localLanguage);
    }
}

