/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectPaymentDocumentProperties;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.PaymentDocumentHandler;
import com.gridnine.xtrip.common.model.helpers.WorklogHelper;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentsProperties;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberPeriod;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberSerial;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumberHelper;
import com.gridnine.xtrip.server.model.helpers.PaymentDocumentHelper;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public enum ModelFormatObjectPaymentDocumentPropertyHandlers implements FormatObjectPropertyHandler
{
    DATE{

        public String getId() {
            return ModelFormatObjectPaymentDocumentProperties.DATE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPaymentDocumentProperties.DATE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BasePaymentDocument document = (BasePaymentDocument)proxy.getObject();
            return document.getDate() != null ? (!TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format(document.getDate()) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateFormatPattern()).format(document.getDate()) : document.getDate().toString())) : null;
        }
    }
    ,
    NUMBER{

        public String getId() {
            return ModelFormatObjectPaymentDocumentProperties.NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPaymentDocumentProperties.NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BasePaymentDocument document = (BasePaymentDocument)proxy.getObject();
            return document.getNumber();
        }
    }
    ,
    NUMBER_GENERATE{

        public String getId() {
            return ModelFormatObjectPaymentDocumentProperties.NUMBER_GENERATE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPaymentDocumentProperties.NUMBER_GENERATE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, final EntityStorageContext storageContext) throws Exception {
            PaymentDocumentHandler handler;
            final BasePaymentDocument document = (BasePaymentDocument)proxy.getObject();
            final PaymentDocumentsProperties properties = PaymentDocumentHelper.getPaymentDocumentsProperties((EntityReference<Organization>)document.getOrganization(), false);
            if (properties != null && (handler = HandlersRegistry.get().findPaymentDocumentHandler(document.getClass())) != null) {
                long number = ConsecutiveNumberHelper.incrementAndGetNumber(new ConsecutiveNumberHelper.ConsecutiveNumberHandler(){

                    @Override
                    public ConsecutiveNumberCategory getCategory() {
                        return PaymentDocumentHelper.getCategory(handler.getDocumentType(document));
                    }

                    @Override
                    public ConsecutiveNumberSerial getSerial() {
                        return properties.getNumberSerial();
                    }

                    @Override
                    public ConsecutiveNumberPeriod getPeriod() {
                        return properties.getNumberPeriod();
                    }

                    @Override
                    public EntityReference<Organization> getAgency() {
                        return document.getOrganization();
                    }

                    @Override
                    public EntityReference<Contract> getContract() {
                        return document.getContract();
                    }

                    @Override
                    public EntityReference<Cash> getCash() {
                        EntityContainer worklogContainer = EntityStorageHelper.resolve((EntityReference)WorklogHelper.getWorklog((EntityReference)handler.getCashier(document), (Date)document.getDate()), (EntityStorageContext)storageContext);
                        return worklogContainer != null ? ((Worklog)worklogContainer.getEntity()).getCash() : null;
                    }

                    @Override
                    public Date getDate() {
                        return document.getDate();
                    }
                });
                if (!TextUtil.isBlank((String)pattern)) {
                    DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                    format.applyPattern(pattern);
                    return format.format(number);
                }
                return String.valueOf(number);
            }
            return null;
        }
    };

}

