/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectPersonProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import java.util.Locale;
import java.util.stream.Collectors;

public enum ModelFormatObjectPersonPropertyHandlers implements FormatObjectPropertyHandler
{
    CODE{

        public String getId() {
            return ModelFormatObjectPersonProperties.CODE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPersonProperties.CODE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Person person = (Person)proxy.getObject();
            return person.getCode();
        }
    }
    ,
    FIRST_NAME{

        public String getId() {
            return ModelFormatObjectPersonProperties.FIRST_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPersonProperties.FIRST_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Person person = (Person)proxy.getObject();
            return L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)locale, (boolean)false);
        }
    }
    ,
    LAST_NAME{

        public String getId() {
            return ModelFormatObjectPersonProperties.LAST_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPersonProperties.LAST_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Person person = (Person)proxy.getObject();
            return L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)locale, (boolean)false);
        }
    }
    ,
    MIDDLE_NAME{

        public String getId() {
            return ModelFormatObjectPersonProperties.MIDDLE_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPersonProperties.MIDDLE_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Person person = (Person)proxy.getObject();
            return L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)locale, (boolean)false);
        }
    }
    ,
    SECOND_NAME{

        public String getId() {
            return ModelFormatObjectPersonProperties.SECOND_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPersonProperties.SECOND_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Person person = (Person)proxy.getObject();
            return L10nStringHelper.getValue((L10nString)person.getSecondName(), (Locale)locale, (boolean)false);
        }
    }
    ,
    PASSPORTS{

        public String getId() {
            return ModelFormatObjectPersonProperties.PASSPORTS.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectPersonProperties.PASSPORTS.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Person person = (Person)proxy.getObject();
            Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.PASSPORT.getPattern()));
            return person.getPassports().stream().map(item -> format.format(Format.FormatObjectDataBuilder.get().object(item, ModelFormatObjects.PASSPORT.getId()).parentProxy(proxy).build(), storageContext, locale)).collect(Collectors.joining(!TextUtil.isBlank((String)separator, (boolean)false) ? separator : ", "));
        }
    };

}

