/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectProductProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.format.object.Format;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ModelFormatObjectProductPropertyHandlers implements FormatObjectPropertyHandler
{
    TYPE{

        public String getId() {
            return ModelFormatObjectProductProperties.TYPE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.TYPE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)ProductHandler.of((BaseProduct)product).getUniversalProductDescription(product), (EntityStorageContext)storageContext)).map(item -> {
                if (ModelFormatObjectProductPropertyHandlers.isEnLocale(locale)) {
                    return TranslitUtil.cyr2lat((String)((UniversalProductDescription)item.getEntity()).getName(), (TranslitUtil.TranslitRules)TRANSLIT_RULES);
                }
                return ((UniversalProductDescription)item.getEntity()).getName();
            }).orElse(Optional.ofNullable(ProductHandler.of((BaseProduct)product).getProductType(product)).map(item -> item.toString(locale)).orElse(null));
        }
    }
    ,
    NUMBER{

        public String getId() {
            return ModelFormatObjectProductProperties.NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return Optional.ofNullable(ProductHandler.of((BaseProduct)product).getProductNumbers(product).stream().findFirst().orElse(null)).orElse(null);
        }
    }
    ,
    STATUS{

        public String getId() {
            return ModelFormatObjectProductProperties.STATUS.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.STATUS.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return Optional.ofNullable(ProductHandler.of((BaseProduct)product).getStatus(product)).map(item -> item.toString(locale)).orElse(null);
        }
    }
    ,
    SUPPLIER{

        public String getId() {
            return ModelFormatObjectProductProperties.SUPPLIER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.SUPPLIER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            Organization organization = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product), (EntityStorageContext)storageContext)).map(item -> (Organization)item.getEntity()).orElse(null);
            if (organization != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.ORGANIZATION.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)organization, ModelFormatObjects.ORGANIZATION.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    }
    ,
    ETICKET{

        public String getId() {
            return ModelFormatObjectProductProperties.ETICKET.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.ETICKET.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return String.valueOf(Optional.ofNullable(DictionaryCache.get().resolveReference(ProductHandler.of((BaseProduct)product).getBlankType(product))).map(item -> item.getBlankCategory() == BlankCategory.ETICKET).orElse(Boolean.FALSE));
        }
    }
    ,
    CITIES{

        public String getId() {
            return ModelFormatObjectProductProperties.CITIES.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.CITIES.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return ProductHandler.of((BaseProduct)product).getCities(product, locale);
        }
    }
    ,
    COUNTRIES{

        public String getId() {
            return ModelFormatObjectProductProperties.COUNTRIES.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.COUNTRIES.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return ProductHandler.of((BaseProduct)product).getCountries(product, locale);
        }
    }
    ,
    ADDRESSES{

        public String getId() {
            return ModelFormatObjectProductProperties.ADDRESSES.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.ADDRESSES.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return ProductHandler.of((BaseProduct)product).getAddresses(product, locale, TRANSLIT_RULES);
        }
    }
    ,
    START_DATE{

        public String getId() {
            return ModelFormatObjectProductProperties.START_DATE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.START_DATE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return Optional.ofNullable(ProductHandler.of((BaseProduct)product).getFirstStartDate(product)).map(item -> !TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format((Date)item) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateTimeFormatPattern()).format((Date)item) : item.toString())).orElse(null);
        }
    }
    ,
    END_DATE{

        public String getId() {
            return ModelFormatObjectProductProperties.END_DATE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.END_DATE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return Optional.ofNullable(ProductHandler.of((BaseProduct)product).getLastEndDate(product)).map(item -> !TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format((Date)item) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateTimeFormatPattern()).format((Date)item) : item.toString())).orElse(null);
        }
    }
    ,
    START_DATES{

        public String getId() {
            return ModelFormatObjectProductProperties.START_DATES.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.START_DATES.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            String lastStartDate;
            BaseProduct product = (BaseProduct)proxy.getObject();
            String firstStartDate = Optional.ofNullable(ProductHandler.of((BaseProduct)product).getFirstStartDate(product)).map(item -> !TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format((Date)item) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateTimeFormatPattern()).format((Date)item) : item.toString())).orElse(null);
            return MiscUtil.equals((Object)firstStartDate, (Object)(lastStartDate = (String)Optional.ofNullable(ProductHandler.of((BaseProduct)product).getLastStartDate(product)).map(item -> !TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format((Date)item) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateTimeFormatPattern()).format((Date)item) : item.toString())).orElse(null)), (boolean)false) ? firstStartDate : String.format("%s - %s", Optional.ofNullable(firstStartDate).orElse("?"), Optional.ofNullable(lastStartDate).orElse("?"));
        }
    }
    ,
    END_DATES{

        public String getId() {
            return ModelFormatObjectProductProperties.END_DATES.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.END_DATES.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            String lastEndDate;
            BaseProduct product = (BaseProduct)proxy.getObject();
            String firstEndDate = Optional.ofNullable(ProductHandler.of((BaseProduct)product).getFirstEndDate(product)).map(item -> !TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format((Date)item) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateTimeFormatPattern()).format((Date)item) : item.toString())).orElse(null);
            return MiscUtil.equals((Object)firstEndDate, (Object)(lastEndDate = (String)Optional.ofNullable(ProductHandler.of((BaseProduct)product).getLastEndDate(product)).map(item -> !TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format((Date)item) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateTimeFormatPattern()).format((Date)item) : item.toString())).orElse(null)), (boolean)false) ? firstEndDate : String.format("%s - %s", Optional.ofNullable(firstEndDate).orElse("?"), Optional.ofNullable(lastEndDate).orElse("?"));
        }
    }
    ,
    DATES{

        public String getId() {
            return ModelFormatObjectProductProperties.DATES.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.DATES.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            String endDate;
            BaseProduct product = (BaseProduct)proxy.getObject();
            String startDate = Optional.ofNullable(ProductHandler.of((BaseProduct)product).getFirstStartDate(product)).map(item -> !TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format((Date)item) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateTimeFormatPattern()).format((Date)item) : item.toString())).orElse(null);
            return MiscUtil.equals((Object)startDate, (Object)(endDate = (String)Optional.ofNullable(ProductHandler.of((BaseProduct)product).getLastEndDate(product)).map(item -> !TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format((Date)item) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateTimeFormatPattern()).format((Date)item) : item.toString())).orElse(null)), (boolean)false) ? startDate : String.format("%s - %s", Optional.ofNullable(startDate).orElse("?"), Optional.ofNullable(endDate).orElse("?"));
        }
    }
    ,
    DAYS{

        public String getId() {
            return ModelFormatObjectProductProperties.DAYS.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.DAYS.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            LocalDate startDate = Optional.ofNullable(ProductHandler.of((BaseProduct)product).getFirstStartDate(product)).map(item -> item.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).orElse(null);
            LocalDate endDate = Optional.ofNullable(ProductHandler.of((BaseProduct)product).getLastEndDate(product)).map(item -> item.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).orElse(null);
            int days = 0;
            if (startDate != null && endDate != null) {
                days = Period.between(startDate, endDate).getDays() + 1;
            }
            if (!TextUtil.isBlank((String)pattern)) {
                DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                format.applyPattern(pattern);
                return format.format(days);
            }
            return String.valueOf(days);
        }
    }
    ,
    NIGHTS{

        public String getId() {
            return ModelFormatObjectProductProperties.NIGHTS.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.NIGHTS.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            LocalDate startDate = Optional.ofNullable(ProductHandler.of((BaseProduct)product).getFirstStartDate(product)).map(item -> item.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).orElse(null);
            LocalDate endDate = Optional.ofNullable(ProductHandler.of((BaseProduct)product).getLastEndDate(product)).map(item -> item.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).orElse(null);
            int days = 0;
            if (startDate != null && endDate != null && (days = (int)Duration.between(startDate.atStartOfDay(), endDate.atStartOfDay()).toDays()) == 0) {
                days = 1;
            }
            if (!TextUtil.isBlank((String)pattern)) {
                DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                format.applyPattern(pattern);
                return format.format(days);
            }
            return String.valueOf(days);
        }
    }
    ,
    CARRIER{

        public String getId() {
            return ModelFormatObjectProductProperties.CARRIER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.CARRIER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            if (ProductHandler.of((BaseProduct)product).getCarrier(product) != null) {
                return ProductHandler.of((BaseProduct)product).getCarrier(product).toString(locale);
            }
            if (ProductHandler.of((BaseProduct)product).getPrincipal(product) != null) {
                return ProductHandler.of((BaseProduct)product).getPrincipal(product).toString(locale);
            }
            return null;
        }
    }
    ,
    CARRIER_NUMBER{

        public String getId() {
            return ModelFormatObjectProductProperties.CARRIER_NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.CARRIER_NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return ProductHandler.of((BaseProduct)product).getCarrierNumber(product);
        }
    }
    ,
    CARRIER_CODE{

        public String getId() {
            return ModelFormatObjectProductProperties.CARRIER_CODE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.CARRIER_CODE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            Airline carrier = (Airline)DictionaryCache.get().resolveReference(ProductHandler.of((BaseProduct)product).getCarrier(product));
            if (carrier != null) {
                String value;
                if (!TextUtil.isBlank((String)pattern) && !TextUtil.isBlank((String)(value = (String)Stream.of(pattern.split(",")).map(item -> CodeSystem.valueOf((String)item.toUpperCase().trim())).map(item -> (String)carrier.getCodeVariants().get(item.name())).filter(item -> item != null).findFirst().orElse(null)))) {
                    return value;
                }
                return Stream.of(CodeSystem.IATA, CodeSystem.CRT).map(item -> (String)carrier.getCodeVariants().get(item.name())).filter(item -> item != null).findFirst().orElse(carrier.getCodeVariants().values().stream().filter(item -> item != null).findFirst().orElse(null));
            }
            return null;
        }
    }
    ,
    CARRIER_REGISTRATION_ID{

        public String getId() {
            return ModelFormatObjectProductProperties.CARRIER_REGISTRATION_ID.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.CARRIER_REGISTRATION_ID.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            Airline carrier = (Airline)DictionaryCache.get().resolveReference(ProductHandler.of((BaseProduct)product).getCarrier(product));
            if (carrier != null && !TextUtil.isBlank((String)carrier.getRegistrationId())) {
                return carrier.getRegistrationId();
            }
            Principal principal = (Principal)DictionaryCache.get().resolveReference(ProductHandler.of((BaseProduct)product).getPrincipal(product));
            if (principal != null && !TextUtil.isBlank((String)principal.getRegistrationId())) {
                return principal.getRegistrationId();
            }
            return null;
        }
    }
    ,
    SEGMENTS_CARRIERS{

        public String getId() {
            return ModelFormatObjectProductProperties.SEGMENTS_CARRIERS.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.SEGMENTS_CARRIERS.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct baseProduct = (BaseProduct)proxy.getObject();
            if (baseProduct instanceof Product) {
                Product product = (Product)baseProduct;
                return product.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getCodeShareCarrier).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(DictionaryReference::getCode)).map(s -> s.toString(locale)).collect(Collectors.joining(TextUtil.nonBlank((String)separator) ? separator : ", "));
            }
            List railwaySegments = new ArrayList();
            if (baseProduct instanceof RailwayProduct) {
                railwaySegments = ((RailwayProduct)baseProduct).getSegments();
            }
            if (baseProduct instanceof RailwayMcoProduct) {
                railwaySegments = ((RailwayMcoProduct)baseProduct).getSegments();
            }
            if (baseProduct instanceof RailwayCrimeaMco) {
                railwaySegments = ((RailwayCrimeaMco)baseProduct).getSegments();
            }
            return railwaySegments.stream().map(RailwaySegment::getCarrier).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(DictionaryReference::getCode)).map(s -> s.toString(locale)).collect(Collectors.joining(TextUtil.nonBlank((String)separator) ? separator : ", "));
        }
    }
    ,
    SEGMENTS_CARRIERS_INN{

        public String getId() {
            return ModelFormatObjectProductProperties.SEGMENTS_CARRIERS_INN.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.SEGMENTS_CARRIERS_INN.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct baseProduct = (BaseProduct)proxy.getObject();
            if (baseProduct instanceof Product) {
                Product product = (Product)baseProduct;
                return product.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).map(seg -> (Airline)DictionaryCache.get().resolveReference(seg.getCodeShareCarrier())).filter(Objects::nonNull).distinct().map(Airline::getRegistrationId).filter(TextUtil::nonBlank).sorted(String::compareTo).collect(Collectors.joining(TextUtil.nonBlank((String)separator) ? separator : ", "));
            }
            List railwaySegments = new ArrayList();
            if (baseProduct instanceof RailwayProduct) {
                railwaySegments = ((RailwayProduct)baseProduct).getSegments();
            }
            if (baseProduct instanceof RailwayMcoProduct) {
                railwaySegments = ((RailwayMcoProduct)baseProduct).getSegments();
            }
            if (baseProduct instanceof RailwayCrimeaMco) {
                railwaySegments = ((RailwayCrimeaMco)baseProduct).getSegments();
            }
            return railwaySegments.stream().map(seg -> (RailwayCarrier)DictionaryCache.get().resolveReference(seg.getCarrier())).filter(Objects::nonNull).distinct().map(RailwayCarrier::getInn).filter(TextUtil::nonBlank).sorted(String::compareTo).collect(Collectors.joining(TextUtil.nonBlank((String)separator) ? separator : ", "));
        }
    }
    ,
    SEGMENTS_COUNT{

        public String getId() {
            return ModelFormatObjectProductProperties.SEGMENTS_COUNT.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.SEGMENTS_COUNT.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct baseProduct = (BaseProduct)proxy.getObject();
            if (baseProduct instanceof Product) {
                Product product = (Product)baseProduct;
                return String.valueOf(product.getSegmentTariffs().stream().mapToLong(item -> item.getSegments().size()).sum());
            }
            if (baseProduct instanceof RailwayProduct) {
                return String.valueOf(((RailwayProduct)baseProduct).getSegments().size());
            }
            if (baseProduct instanceof RailwayMcoProduct) {
                return String.valueOf(((RailwayMcoProduct)baseProduct).getSegments());
            }
            if (baseProduct instanceof RailwayCrimeaMco) {
                return String.valueOf(((RailwayCrimeaMco)baseProduct).getSegments());
            }
            return null;
        }
    }
    ,
    SERVICE_CLASS{

        public String getId() {
            return ModelFormatObjectProductProperties.SERVICE_CLASS.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.SERVICE_CLASS.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            return ProductHandler.of((BaseProduct)product).getServiceClasses(product, locale).stream().collect(Collectors.joining(!TextUtil.isBlank((String)separator, (boolean)false) ? separator : ", "));
        }
    }
    ,
    TRAIN{

        public String getId() {
            return ModelFormatObjectProductProperties.TRAIN.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.TRAIN.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            String train = ProductHandler.of((BaseProduct)product).getTrain(product);
            if (ModelFormatObjectProductPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)train, (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return train;
        }
    }
    ,
    HOTEL{

        public String getId() {
            return ModelFormatObjectProductProperties.HOTEL.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.HOTEL.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            String hotel = ProductHandler.of((BaseProduct)product).getHotel(product);
            if (ModelFormatObjectProductPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)hotel, (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return hotel;
        }
    }
    ,
    ROOM{

        public String getId() {
            return ModelFormatObjectProductProperties.ROOM.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.ROOM.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            String room = ProductHandler.of((BaseProduct)product).getRoom(product);
            if (ModelFormatObjectProductPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)room, (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return room;
        }
    }
    ,
    UDID_VALUE{

        public String getId() {
            return ModelFormatObjectProductProperties.UDID_VALUE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.UDID_VALUE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            try {
                CostCodeType type = CostCodeType.valueOf((String)String.format("COST_CODE_%s", pattern));
                if (type != null) {
                    BaseProduct product = (BaseProduct)proxy.getObject();
                    ProductHandler handler = ProductHandler.of((BaseProduct)product);
                    StatisticalData statisticalData = handler.getStatisticalData(product);
                    if (statisticalData == null) {
                        return null;
                    }
                    return statisticalData.getTravellerCostCodes().stream().map(travellerCostCodes -> this.getCostCode(travellerCostCodes.getCostCodes(), type, locale)).filter(Objects::nonNull).findFirst().orElse(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public boolean isLocaleOptional() {
            return true;
        }

        private String getCostCode(List<CostCode> costCodes, CostCodeType type, Locale locale) {
            return costCodes.stream().filter(item -> item.getCostCodeProperties().getType() == type).findFirst().map(costCode -> {
                String localLanguage = Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null);
                if (MiscUtil.equals((Object)LocaleHelper.getCurrentLocale().getLanguage(), (Object)localLanguage)) {
                    return costCode.getLocalValue();
                }
                if (MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), (Object)localLanguage)) {
                    return costCode.getEnglishValue();
                }
                return costCode.getValue();
            }).orElse(null);
        }
    }
    ,
    TRAVELLERS{

        public String getId() {
            return ModelFormatObjectProductProperties.TRAVELLERS.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.TRAVELLERS.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.TRAVELLER.getPattern()));
            return ProductHandler.of((BaseProduct)product).getTravellers(product).stream().map(item -> format.format(Format.FormatObjectDataBuilder.get().object(item, ModelFormatObjects.TRAVELLER.getId()).parentProxy(proxy).build(), storageContext, locale)).collect(Collectors.joining(!TextUtil.isBlank((String)separator, (boolean)false) ? separator : ", "));
        }
    }
    ,
    PREVIOUS_PRODUCT{

        public String getId() {
            return ModelFormatObjectProductProperties.PREVIOUS_PRODUCT.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.PREVIOUS_PRODUCT.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.PRODUCT.getPattern()));
            return Optional.ofNullable(ProductHandler.of((BaseProduct)product).getPreviousProduct(product)).map(item -> format.format(Format.FormatObjectDataBuilder.get().object(item, ModelFormatObjects.PRODUCT.getId()).parentProxy(proxy).build(), storageContext, locale)).orElse(null);
        }
    }
    ,
    NEXT_PRODUCT{

        public String getId() {
            return ModelFormatObjectProductProperties.NEXT_PRODUCT.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.NEXT_PRODUCT.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.PRODUCT.getPattern()));
            return Optional.ofNullable(ProductHandler.of((BaseProduct)product).getNextProduct(product)).map(item -> format.format(Format.FormatObjectDataBuilder.get().object(item, ModelFormatObjects.PRODUCT.getId()).parentProxy(proxy).build(), storageContext, locale)).orElse(null);
        }
    }
    ,
    RELATED_PRODUCT{

        public String getId() {
            return ModelFormatObjectProductProperties.RELATED_PRODUCT.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.RELATED_PRODUCT.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.PRODUCT.getPattern()));
            return Optional.ofNullable(ProductHandler.of((BaseProduct)product).getRelatedProducts(product).stream().findFirst().orElse(null)).map(item -> format.format(Format.FormatObjectDataBuilder.get().object(item, ModelFormatObjects.PRODUCT.getId()).parentProxy(proxy).build(), storageContext, locale)).orElse(null);
        }
    }
    ,
    DESCRIPTION{

        public String getId() {
            return ModelFormatObjectProductProperties.DESCRIPTION.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectProductProperties.DESCRIPTION.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            BaseProduct product = (BaseProduct)proxy.getObject();
            String descriptionLine = ProductHandler.of((BaseProduct)product).getDescriptionLine(product);
            if (ModelFormatObjectProductPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)descriptionLine, (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return descriptionLine;
        }
    };


    private static boolean isEnLocale(Locale locale) {
        String localLanguage = Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null);
        return MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), (Object)localLanguage);
    }
}

