/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AddServiceTypeFopComponent;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectReceiptLineProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import java.util.Locale;

public enum ModelFormatObjectReceiptLinePropertyHandlers implements FormatObjectPropertyHandler
{
    NAME{

        public String getId() {
            return ModelFormatObjectReceiptLineProperties.NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectReceiptLineProperties.NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            ReceiptLine receiptLine = (ReceiptLine)proxy.getObject();
            if (receiptLine != null) {
                return receiptLine.getLineType().toString(locale);
            }
            return null;
        }
    }
    ,
    SERVICE_NAME{

        public String getId() {
            return ModelFormatObjectReceiptLineProperties.SERVICE_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectReceiptLineProperties.SERVICE_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            ReceiptLine receiptLine = (ReceiptLine)proxy.getObject();
            FopComponent fopComponent = (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)receiptLine.getFopComponent(), (EntityStorageContext)storageContext);
            if (fopComponent != null && fopComponent instanceof AddServiceTypeFopComponent) {
                return ((AddServiceTypeFopComponent)fopComponent).getServiceType().toString(locale);
            }
            return null;
        }
    }
    ,
    PRODUCT{

        public String getId() {
            return ModelFormatObjectReceiptLineProperties.PRODUCT.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectReceiptLineProperties.PRODUCT.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            ReceiptLine receiptLine = (ReceiptLine)proxy.getObject();
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)receiptLine.getProductReference(), (EntityStorageContext)storageContext);
            if (product != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.PRODUCT.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)product, ModelFormatObjects.PRODUCT.getId()).rootObject((Object)product.getReservation().getBookingFile(), ModelFormatObjects.BOOKING_FILE.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    };

}

