/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectShipmentProperties;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ShipmentProperties;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberPeriod;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberSerial;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumberHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.stream.Collectors;

public enum ModelFormatObjectShipmentPropertyHandlers implements FormatObjectPropertyHandler
{
    DATE{

        public String getId() {
            return ModelFormatObjectShipmentProperties.DATE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectShipmentProperties.DATE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Shipment shipment = (Shipment)proxy.getObject();
            return shipment.getDate() != null ? (!TextUtil.isBlank((String)pattern) ? new SimpleDateFormat(pattern, locale).format(shipment.getDate()) : (LocaleManager.get().isSupportedLocale(locale) ? new SimpleDateFormat(LocaleManager.get().getLocaleData(locale).getDateFormatPattern()).format(shipment.getDate()) : shipment.getDate().toString())) : null;
        }
    }
    ,
    NUMBER{

        public String getId() {
            return ModelFormatObjectShipmentProperties.NUMBER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectShipmentProperties.NUMBER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Shipment shipment = (Shipment)proxy.getObject();
            return shipment.getNumber();
        }
    }
    ,
    NUMBER_GENERATE{

        public String getId() {
            return ModelFormatObjectShipmentProperties.NUMBER_GENERATE.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectShipmentProperties.NUMBER_GENERATE.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            final Shipment shipment = (Shipment)proxy.getObject();
            final ShipmentProperties properties = ShipmentHelper.getShipmentsProperties((EntityReference<Organization>)shipment.getSupplier(), false);
            if (properties != null) {
                long number = ConsecutiveNumberHelper.incrementAndGetNumber(new ConsecutiveNumberHelper.ConsecutiveNumberHandler(){

                    @Override
                    public ConsecutiveNumberCategory getCategory() {
                        return ConsecutiveNumberCategory.SHIPMENT;
                    }

                    @Override
                    public ConsecutiveNumberSerial getSerial() {
                        return properties.getNumberSerial();
                    }

                    @Override
                    public ConsecutiveNumberPeriod getPeriod() {
                        return properties.getNumberPeriod();
                    }

                    @Override
                    public EntityReference<Organization> getAgency() {
                        return shipment.getSupplier();
                    }

                    @Override
                    public EntityReference<Contract> getContract() {
                        return shipment.getContract();
                    }

                    @Override
                    public EntityReference<Cash> getCash() {
                        return null;
                    }

                    @Override
                    public Date getDate() {
                        return shipment.getDate();
                    }
                });
                if (!TextUtil.isBlank((String)pattern)) {
                    DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                    format.applyPattern(pattern);
                    return format.format(number);
                }
                return String.valueOf(number);
            }
            return null;
        }
    }
    ,
    CATEGORIES{

        public String getId() {
            return ModelFormatObjectShipmentProperties.CATEGORIES.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectShipmentProperties.CATEGORIES.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Shipment shipment = (Shipment)proxy.getObject();
            return shipment.getCategories().stream().map(item -> item.toString(locale)).sorted().collect(Collectors.joining(!TextUtil.isBlank((String)separator, (boolean)false) ? separator : ", "));
        }
    }
    ,
    PERIOD_BEGIN{

        public String getId() {
            return ModelFormatObjectShipmentProperties.PERIOD_BEGIN.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectShipmentProperties.PERIOD_BEGIN.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Shipment shipment = (Shipment)proxy.getObject();
            return ((DateFormat)DATE_FORMAT.get()).format(shipment.getPeriodBegin());
        }
    }
    ,
    PERIOD_END{

        public String getId() {
            return ModelFormatObjectShipmentProperties.PERIOD_END.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectShipmentProperties.PERIOD_END.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Shipment shipment = (Shipment)proxy.getObject();
            return ((DateFormat)DATE_FORMAT.get()).format(shipment.getPeriodEnd());
        }
    };

    private static final ThreadLocal<DateFormat> DATE_FORMAT;

    static {
        DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd.MM.yyyy"));
    }
}

