/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.format.object;

import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectTravellerProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.format.object.Format;
import java.util.Locale;
import java.util.Optional;

public enum ModelFormatObjectTravellerPropertyHandlers implements FormatObjectPropertyHandler
{
    NAME{

        public String getId() {
            return ModelFormatObjectTravellerProperties.NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectTravellerProperties.NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Traveller traveller = (Traveller)proxy.getObject();
            if (ModelFormatObjectTravellerPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)traveller.getName(), (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return traveller.getName();
        }
    }
    ,
    CYRILLIC_NAME{

        public String getId() {
            return ModelFormatObjectTravellerProperties.CYRILLIC_NAME.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectTravellerProperties.CYRILLIC_NAME.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Traveller traveller = (Traveller)proxy.getObject();
            if (ModelFormatObjectTravellerPropertyHandlers.isEnLocale(locale)) {
                return TranslitUtil.cyr2lat((String)traveller.getCyrillicName(), (TranslitUtil.TranslitRules)TRANSLIT_RULES);
            }
            return traveller.getCyrillicName();
        }
    }
    ,
    PASSENGER{

        public String getId() {
            return ModelFormatObjectTravellerProperties.PASSENGER.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectTravellerProperties.PASSENGER.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Traveller traveller = (Traveller)proxy.getObject();
            Person person = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)traveller.getPassenger(), (EntityStorageContext)storageContext)).map(item -> (Person)item.getEntity()).orElse(null);
            if (person != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.PERSON.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)person, ModelFormatObjects.PERSON.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    }
    ,
    PASSPORT{

        public String getId() {
            return ModelFormatObjectTravellerProperties.PASSPORT.getId();
        }

        public String getPropertyId() {
            return ModelFormatObjectTravellerProperties.PASSPORT.getId();
        }

        public String getValue(FormatObjectProxy proxy, String separator, String pattern, Locale locale, EntityStorageContext storageContext) throws Exception {
            Traveller traveller = (Traveller)proxy.getObject();
            Passport passport = traveller.getPassport();
            if (passport != null) {
                Format format = Format.of((String)(!TextUtil.isBlank((String)pattern, (boolean)false) ? pattern : ModelFormatObjects.PASSPORT.getPattern()));
                return format.format(Format.FormatObjectDataBuilder.get().object((Object)passport, ModelFormatObjects.PASSPORT.getId()).parentProxy(proxy).build(), storageContext, locale);
            }
            return null;
        }
    };


    private static boolean isEnLocale(Locale locale) {
        String localLanguage = Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null);
        return MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), (Object)localLanguage);
    }
}

