/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.fsprovider;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSTopicListener;
import com.gridnine.xtrip.server.model.fsprovider.FsProvider;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class FsNodeGetContentRequestWorker
implements JMSTopicListener<FsNodeGetContentRequest> {
    public static final String FS_NODE_GET_CONTENT_RESPONSE_TOPIC_ID = "FS_NODE_GET_CONTENT_RESPONSE_TOPIC_ID";
    public static final String FS_NODE_GET_CONTENT_REQUEST_TOPIC_ID = "FS_NODE_GET_CONTENT_REQUEST_TOPIC_ID";

    public void onMessage(FsNodeGetContentRequest message) {
        if (!Environment.getApplicationId().equals(message.getNodeId())) {
            return;
        }
        File file = new File(TextUtil.isBlank((String)message.getFileName()) ? "." : message.getFileName());
        FsNodeGetContentResponse result = new FsNodeGetContentResponse();
        result.setUid(message.getUid());
        if (!file.isFile() || !file.exists()) {
            result.setException((Exception)((Object)Xeption.forEndUser((String)"\u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 ", (Object[])new Object[0])));
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(FS_NODE_GET_CONTENT_RESPONSE_TOPIC_ID, (Object)result);
            return;
        }
        try {
            MiscUtil.Pair<Long, byte[]> pair = FsProvider.getFileBytes(file, message.getOffset(), message.getChunkSize());
            result.setOffset((Long)pair.getFirst());
            result.setContent((byte[])pair.getSecond());
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(FS_NODE_GET_CONTENT_RESPONSE_TOPIC_ID, (Object)result);
        }
        catch (IOException e) {
            result.setException(e);
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(FS_NODE_GET_CONTENT_RESPONSE_TOPIC_ID, (Object)result);
        }
    }

    public static class FsNodeGetContentRequest
    implements Serializable {
        private String uid;
        private String nodeId;
        private String fileName;
        private long offset;
        private int chunkSize;

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public int getChunkSize() {
            return this.chunkSize;
        }

        public void setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
        }
    }

    public static class FsNodeGetContentResponse
    implements Serializable {
        private byte[] content;
        private long offset;
        private String uid;
        private Exception e;

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public Exception getException() {
            return this.e;
        }

        public void setException(Exception e) {
            this.e = e;
        }
    }
}

