/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.fsprovider;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.system.fs.ServerFile;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSTopicListener;
import java.io.File;
import java.io.Serializable;
import java.util.Date;

public class FsNodeGetFileRequestWorker
implements JMSTopicListener<FsNodeGetFileRequest> {
    public static final String FS_NODE_GET_FILE_RESPONSE_TOPIC_ID = "FS_NODE_GET_FILE_RESPONSE_TOPIC_ID";
    public static final String FS_NODE_GET_FILE_REQUEST_TOPIC_ID = "FS_NODE_GET_FILE_REQUEST_TOPIC_ID";

    public void onMessage(FsNodeGetFileRequest message) {
        if (!Environment.getApplicationId().equals(message.getNodeId())) {
            return;
        }
        File file = new File(TextUtil.isBlank((String)message.getFileName()) ? "." : message.getFileName());
        FsNodeGetFileResponse response = new FsNodeGetFileResponse();
        ServerFile result = null;
        if (file.exists()) {
            result = FsNodeGetFileRequestWorker.toServerFile(file);
        }
        response.setUid(message.getUid());
        response.setFile(result);
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(FS_NODE_GET_FILE_RESPONSE_TOPIC_ID, (Object)response);
    }

    static ServerFile toServerFile(File file) {
        if (!file.exists()) {
            return null;
        }
        ServerFile serverFile = new ServerFile();
        serverFile.setDirectory(file.isDirectory());
        serverFile.setFileName(file.getName());
        serverFile.setAbsolutePath(file.getAbsolutePath());
        serverFile.setModified(MiscUtil.toLocalDateTime((Date)new Date(file.lastModified())));
        serverFile.setSizeInBytes(file.length());
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (child.getName().equals(".") || child.getName().equals("..")) continue;
                serverFile.getChildren().add(FsNodeGetFileRequestWorker.toServerFile(child));
            }
        }
        return serverFile;
    }

    public static class FsNodeGetFileRequest
    implements Serializable {
        private String uid;
        private String nodeId;
        private String fileName;

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }
    }

    public static class FsNodeGetFileResponse
    implements Serializable {
        private String uid;
        private ServerFile file;

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public ServerFile getFile() {
            return this.file;
        }

        public void setFile(ServerFile file) {
            this.file = file;
        }
    }
}

