/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.fsprovider;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSTopicListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class FsNodePresenceResponseWorker
implements JMSTopicListener<FsNodePresenceResponse>,
Disposable {
    private volatile Timer timer;
    private ConcurrentHashMap<String, Boolean> nodesMap = new ConcurrentHashMap();
    public static final String FS_NODE_PRESENCE_RESPONSE_TOPIC_ID = "FS_NODE_PRESENCE_RESPONSE_TOPIC_ID";

    FsNodePresenceResponseWorker() {
        this.timer = new Timer("fs-node-presence-timer");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                FsNodePresenceResponse response = new FsNodePresenceResponse();
                response.setNodeId(Environment.getApplicationId());
                response.setPresent(true);
                ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(FsNodePresenceResponseWorker.FS_NODE_PRESENCE_RESPONSE_TOPIC_ID, (Object)response);
            }
        }, TimeUnit.SECONDS.toMillis(1L), TimeUnit.MINUTES.toMillis(1L));
    }

    public void onMessage(FsNodePresenceResponse message) {
        this.nodesMap.put(message.getNodeId(), message.isPresent());
    }

    List<String> getAllActiveNodes() {
        return new ArrayList<String>(this.nodesMap.keySet());
    }

    public void dispose() {
        this.timer.cancel();
        FsNodePresenceResponse response = new FsNodePresenceResponse();
        response.setNodeId(Environment.getApplicationId());
        response.setPresent(false);
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(FS_NODE_PRESENCE_RESPONSE_TOPIC_ID, (Object)response);
    }

    public static class FsNodePresenceResponse
    implements Serializable {
        private String nodeId;
        private boolean present;

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public boolean isPresent() {
            return this.present;
        }

        public void setPresent(boolean present) {
            this.present = present;
        }
    }
}

