/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.fsprovider;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.system.fs.ServerFile;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSTopicListener;
import com.gridnine.xtrip.server.model.fsprovider.FsNodeGetContentRequestWorker;
import com.gridnine.xtrip.server.model.fsprovider.FsNodeGetFileRequestWorker;
import com.gridnine.xtrip.server.model.fsprovider.FsNodePresenceResponseWorker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;

public class FsProvider
implements Disposable {
    private final FsNodePresenceResponseWorker presenceWorker;
    private ConcurrentHashMap<String, ResponseWrapper<FsNodeGetFileRequestWorker.FsNodeGetFileResponse>> serverFileResults = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ResponseWrapper<FsNodeGetContentRequestWorker.FsNodeGetContentResponse>> serverContentResults = new ConcurrentHashMap();
    private final Timer timer;

    public static FsProvider get() {
        return (FsProvider)Environment.getPublished(FsProvider.class);
    }

    protected FsProvider(FsNodePresenceResponseWorker presenceWorker) {
        this.presenceWorker = presenceWorker;
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).registerTopicListener("FS_NODE_GET_FILE_RESPONSE_TOPIC_ID", (JMSTopicListener)new JMSTopicListener<FsNodeGetFileRequestWorker.FsNodeGetFileResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(FsNodeGetFileRequestWorker.FsNodeGetFileResponse message) {
                FsProvider fsProvider = FsProvider.this;
                synchronized (fsProvider) {
                    FsProvider.this.serverFileResults.put(message.getUid(), new ResponseWrapper<FsNodeGetFileRequestWorker.FsNodeGetFileResponse>(null, message, true));
                    FsProvider.this.notifyAll();
                }
            }
        });
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).registerTopicListener("FS_NODE_GET_CONTENT_RESPONSE_TOPIC_ID", (JMSTopicListener)new JMSTopicListener<FsNodeGetContentRequestWorker.FsNodeGetContentResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(FsNodeGetContentRequestWorker.FsNodeGetContentResponse message) {
                FsProvider fsProvider = FsProvider.this;
                synchronized (fsProvider) {
                    FsProvider.this.serverContentResults.put(message.getUid(), new ResponseWrapper<FsNodeGetContentRequestWorker.FsNodeGetContentResponse>(null, message, true));
                    FsProvider.this.notifyAll();
                }
            }
        });
        this.timer = new Timer("fs-provider-release-locks-timer");
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FsProvider fsProvider = FsProvider.this;
                synchronized (fsProvider) {
                    FsProvider.this.notifyAll();
                }
            }
        }, TimeUnit.SECONDS.toMillis(1L), TimeUnit.MINUTES.toMillis(1L));
    }

    public List<String> getActiveNodes() {
        return this.presenceWorker.getAllActiveNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerFile getFile(String nodeId, String path) throws Exception {
        if (Environment.getApplicationId().equals(nodeId) && this.useLocalCallIfPossible()) {
            return FsNodeGetFileRequestWorker.toServerFile(new File(path));
        }
        String uuid = UUID.randomUUID().toString();
        this.serverFileResults.put(uuid, new ResponseWrapper<Object>(new Date(), null, false));
        FsNodeGetFileRequestWorker.FsNodeGetFileRequest request = new FsNodeGetFileRequestWorker.FsNodeGetFileRequest();
        request.setFileName(path);
        request.setNodeId(nodeId);
        request.setUid(uuid);
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync("FS_NODE_GET_FILE_REQUEST_TOPIC_ID", (Object)request);
        FsProvider fsProvider = this;
        synchronized (fsProvider) {
            while (!this.serverFileResults.get((Object)uuid).responded && this.serverFileResults.get((Object)uuid).startDate != null && System.currentTimeMillis() - this.serverFileResults.get((Object)uuid).startDate.getTime() < TimeUnit.MINUTES.toMillis(1L)) {
                this.wait();
            }
        }
        return ((FsNodeGetFileRequestWorker.FsNodeGetFileResponse)this.serverFileResults.remove((Object)uuid).response).getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContent(String nodeId, String path) throws Exception {
        if (Environment.getApplicationId().equals(nodeId) && this.useLocalCallIfPossible()) {
            return FileUtils.readFileToByteArray((File)new File(path));
        }
        String uuid = UUID.randomUUID().toString();
        this.serverContentResults.put(uuid, new ResponseWrapper<Object>(new Date(), null, false));
        FsNodeGetContentRequestWorker.FsNodeGetContentRequest request = new FsNodeGetContentRequestWorker.FsNodeGetContentRequest();
        request.setFileName(path);
        request.setNodeId(nodeId);
        request.setUid(uuid);
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync("FS_NODE_GET_CONTENT_REQUEST_TOPIC_ID", (Object)request);
        FsProvider fsProvider = this;
        synchronized (fsProvider) {
            while (!this.serverContentResults.get((Object)uuid).responded && this.serverContentResults.get((Object)uuid).startDate != null && System.currentTimeMillis() - this.serverContentResults.get((Object)uuid).startDate.getTime() < TimeUnit.MINUTES.toMillis(1L)) {
                this.wait();
            }
        }
        FsNodeGetContentRequestWorker.FsNodeGetContentResponse response = (FsNodeGetContentRequestWorker.FsNodeGetContentResponse)this.serverContentResults.remove((Object)uuid).response;
        if (response.getException() != null) {
            throw response.getException();
        }
        return response.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiscUtil.Pair<Long, byte[]> getContent(String nodeId, String path, long offset) throws Exception {
        int chunkSize = 20000000;
        if (Environment.getApplicationId().equals(nodeId) && this.useLocalCallIfPossible()) {
            File file = new File(path);
            return FsProvider.getFileBytes(file, offset, chunkSize);
        }
        String uuid = UUID.randomUUID().toString();
        this.serverContentResults.put(uuid, new ResponseWrapper<Object>(new Date(), null, false));
        FsNodeGetContentRequestWorker.FsNodeGetContentRequest request = new FsNodeGetContentRequestWorker.FsNodeGetContentRequest();
        request.setFileName(path);
        request.setNodeId(nodeId);
        request.setUid(uuid);
        request.setOffset(offset);
        request.setChunkSize(chunkSize);
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync("FS_NODE_GET_CONTENT_REQUEST_TOPIC_ID", (Object)request);
        FsProvider fsProvider = this;
        synchronized (fsProvider) {
            while (!this.serverContentResults.get((Object)uuid).responded && this.serverContentResults.get((Object)uuid).startDate != null && System.currentTimeMillis() - this.serverContentResults.get((Object)uuid).startDate.getTime() < TimeUnit.MINUTES.toMillis(1L)) {
                this.wait();
            }
        }
        FsNodeGetContentRequestWorker.FsNodeGetContentResponse response = (FsNodeGetContentRequestWorker.FsNodeGetContentResponse)this.serverContentResults.remove((Object)uuid).response;
        if (response != null) {
            if (response.getException() != null) {
                throw response.getException();
            }
        } else {
            return null;
        }
        return new MiscUtil.Pair((Object)response.getOffset(), (Object)response.getContent());
    }

    public static MiscUtil.Pair<Long, byte[]> getFileBytes(File file, long offset, int chunkSize) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            byte[] buffer = new byte[chunkSize];
            long skipped = ((InputStream)inputStream).skip(offset);
            int bytesRead = ((InputStream)inputStream).read(buffer, 0, chunkSize);
            if (bytesRead <= 0) {
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)-1L, null);
                return pair;
            }
            long to = offset + (long)bytesRead;
            if (bytesRead != chunkSize) {
                byte[] bytesToSend = new byte[bytesRead];
                System.arraycopy(buffer, 0, bytesToSend, 0, bytesRead);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)to, (Object)bytesToSend);
                return pair;
            }
            MiscUtil.Pair pair = new MiscUtil.Pair((Object)to, (Object)buffer);
            return pair;
        }
    }

    public void dispose() {
        this.presenceWorker.dispose();
        this.timer.cancel();
    }

    protected boolean useLocalCallIfPossible() {
        return true;
    }

    static class ResponseWrapper<T> {
        Date startDate;
        T response;
        boolean responded;

        ResponseWrapper(Date startDate, T response, boolean responsed) {
            this.startDate = startDate;
            this.response = response;
            this.responded = responsed;
        }
    }
}

