/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.CertificateOfCompletedFlightData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.AdditionalServiceProductPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.AdditionalServiceProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class AdditionalServiceProductActionSet
extends GeneralProductCommissionActionSet {
    private static final long serialVersionUID = -5539057801992324829L;
    private CertificateOfCompletedFlightData certificateOfCompletedFlightData;

    public AdditionalServiceProductActionSet(RuleProxy<AdditionalServiceProductPropertySet, AdditionalServiceProductActionSet> proxy, AdditionalServiceProductPropertiesProvider propertySet, AdditionalServiceProduct product) {
        super(proxy, (BaseProduct)product, AdditionalServiceProductActionSet.createHandler(product, propertySet));
    }

    private static GeneralProductCommissionActionSet.CommissionActionProxy createHandler(final AdditionalServiceProduct product, AdditionalServiceProductPropertiesProvider propertySet) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            @Override
            public boolean isOneWayTicket() {
                return true;
            }

            @Override
            public boolean isForcedRefund() {
                return false;
            }

            @Override
            public List<ValidationMessage> getValidationMessages() {
                return product.getValidationMessages();
            }

            @Override
            public TicketType getTicketType() {
                return null;
            }

            @Override
            public BigDecimal getAdditionalFare() {
                return null;
            }

            @Override
            public String getTargetType() {
                return "TICKET";
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public int getSegmentsCount() {
                return AirProductHelper.getSegments((Collection)product.getSegments()).size();
            }

            @Override
            public ProductType getProductType() {
                return ProductType.ADDITIONAL_SERVICE;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                return null;
            }

            @Override
            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                return null;
            }

            @Override
            public Set<String> getPaymentTypes() {
                return Collections.emptySet();
            }

            @Override
            public Date getIssueDate() {
                return product.getIssueDate();
            }

            @Override
            public EntityReference<SalesPoint> getSalesPoint() {
                return product.getSalesPoint();
            }

            @Override
            public int getSegmentTariffsCount() {
                return product.getSegments().size();
            }

            @Override
            public int getTravellersCount() {
                return product.getTravellers().size();
            }
        };
    }

    public CertificateOfCompletedFlightData getCertificateOfCompletedFlightData() {
        return this.certificateOfCompletedFlightData;
    }

    public void setCertificateOfCompletedFlightData(CertificateOfCompletedFlightData template) {
        this.certificateOfCompletedFlightData = template;
    }
}

