/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.AdditionalServiceProductPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductTicketInfoPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AdditionalServiceProductPropertySet
implements AdditionalServiceProductPropertiesProvider,
ProductTicketInfoPropertiesProvider {
    private final RuleProxy<?, ?> proxy;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private EntityReference<Person> agent;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> client;
    private EntityReference<Organization> supplier;
    private AdditionalServiceProduct product;
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private String agencyCode;
    private EntityReference<SalesPoint> salesPoint;
    private TicketType ticketType;
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);

    public AdditionalServiceProductPropertySet(RuleProxy<?, ?> proxy) {
        this.proxy = proxy;
    }

    public void init(AdditionalServiceProduct product) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            this.product = product;
            this.agent = product.getAgent();
            this.bookingAgent = product.getReservation().getBookingAgent();
            this.client = product.getReservation().getBookingFile().getCustomerProfile();
            this.supplier = AdditionalServiceProductHelper.getSupplier((AdditionalServiceProduct)product);
            this.agencyCode = CommonProductHelper.getAgencyCode(product);
            this.salesPoint = product.getSalesPoint();
            this.ticketType = product.getTicketType();
            CommonProductHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference<Organization>)AdditionalServiceProductHelper.getSubagency((AdditionalServiceProduct)product));
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)this.product));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)product.getReservation()));
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)product.getReservation()));
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public AdditionalServiceCategory getCategory() {
        return this.product.getCategory();
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return null;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public EntityReference<Organization> getBlankOwner() {
        return null;
    }

    public EntityReference<Person> getTicketingAgent() {
        return this.agent;
    }

    public EntityReference<SalesPoint> getSalesPoint() {
        return this.salesPoint;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public TicketType getTicketType() {
        return this.ticketType;
    }
}

