/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.AeroexpressTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.EmployeeCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.PayersPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductStatusPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ReservationPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TicketTypePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.UDIDsPropertyProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.PayersCollector;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeroexpressTicketPropertySet
implements Serializable,
AeroexpressTicketPropertiesProvider,
PayersPropertiesProvider,
UDIDsPropertyProvider,
TicketTypePropertiesProvider,
EmployeeCategoriesProvider,
ClientCreditCardVendorProvider,
ReservationPropertiesProvider,
ProductStatusPropertiesProvider,
TravelSubjectPropertiesProvider {
    private static final Logger log = LoggerFactory.getLogger(AeroexpressTicketPropertySet.class);
    private static final long serialVersionUID = -6375760116854375880L;
    private final Set<String> salesPointCountryCodes = new HashSet<String>();
    private boolean forcedRefund;
    private String passengerType;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private String classOfService;
    private String salesPointUid;
    private final Set<String> routeLocationsCodes = new HashSet<String>();
    private final Set<String> departureLocationCodes = new HashSet<String>();
    private final Set<String> arrivalLocationCodes = new HashSet<String>();
    private Date departureDate;
    private Date issueDate;
    private String pnr;
    private String pcc;
    private boolean eticket;
    private double fare;
    private final Set<String> vendorPaymentTypes = new HashSet<String>();
    private final Set<String> clientPaymentTypes = new HashSet<String>();
    private final RuleProxy<? extends AeroexpressTicketPropertySet, ?> proxy;
    private String gdsName;
    private final List<CostCode> costCodes = new ArrayList<CostCode>();
    private TicketType ticketType;
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);
    private String clientCreditCardVendor;
    private final Set<String> profileGroups = new HashSet<String>();
    private EntityReference<Person> agent;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> client;
    private String agencyCode;
    protected AeroexpressTicket product;
    private EntityReference<Organization> supplier;
    private Money travelSubjectTotalPrice;
    private TravelSubject travelSubject;
    private final Collection<EntityReference<Organization>> payers = new HashSet<EntityReference<Organization>>();

    public AeroexpressTicketPropertySet(RuleProxy<? extends AeroexpressTicketPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AeroexpressTicket ticket) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            String enumName;
            block13: {
                try {
                    this.product = ticket;
                    this.supplier = AeroexpressTicketHelper.getSupplier((AeroexpressTicket)ticket);
                    this.agencyCode = CommonProductHelper.getAgencyCode(ticket);
                    this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)ticket.getReservation()));
                    EntityContainer spCtr = EntityStorage.get().resolve(ticket.getSalesPoint());
                    if (spCtr == null) break block13;
                    this.salesPointUid = spCtr.getUid();
                    for (Address addr : ((SalesPoint)spCtr.getEntity()).getAddresses()) {
                        Country country = (Country)DictionaryCache.get().resolveReference(addr.getCountry());
                        if (country == null) continue;
                        this.salesPointCountryCodes.addAll(country.getCodeVariants().values());
                        break;
                    }
                }
                catch (Exception e) {
                    log.error("unable to resolve salesPoint " + ticket.getSalesPoint(), (Throwable)e);
                }
            }
            if (this.salesPointCountryCodes.isEmpty()) {
                this.salesPointCountryCodes.add("RU");
                this.salesPointCountryCodes.add("\u0420\u0424");
            }
            this.gdsName = Optional.ofNullable(ticket.getReservation()).map(CommonReservationGdsNameInfoHelper::getRulesGdsName).map(Enum::name).orElse(null);
            this.forcedRefund = ticket.isForcedRefund();
            this.passengerType = RulesHelper.getDictCode((DictionaryReference)ticket.getPassengerType());
            this.classOfService = RulesHelper.getEnumName((Enum)ticket.getClassOfService());
            if (ticket.getDepartureLocation() != null) {
                this.departureLocationCodes.add(ticket.getDepartureLocation().getCode());
                RulesHelper.collectGeoCodes(this.departureLocationCodes, (boolean)true);
            }
            if (ticket.getArrivalLocation() != null) {
                this.arrivalLocationCodes.add(ticket.getArrivalLocation().getCode());
                RulesHelper.collectGeoCodes(this.arrivalLocationCodes, (boolean)true);
            }
            this.routeLocationsCodes.addAll(this.departureLocationCodes);
            this.routeLocationsCodes.addAll(this.arrivalLocationCodes);
            this.departureDate = ticket.getDepartureDate();
            this.issueDate = ticket.getIssueDate();
            this.pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)ticket.getReservation());
            this.pcc = ticket.getPcc();
            this.eticket = ticket.isEticket();
            this.fare = RulesHelper.getDoubleValue((BigDecimal)ticket.getEquivalentFare());
            for (GeneralProductFop fop : AeroexpressTicketHelper.getVendorFops((AeroexpressTicket)ticket)) {
                enumName = RulesHelper.getEnumName((Enum)fop.getType());
                if (TextUtil.isBlank((String)enumName)) continue;
                this.vendorPaymentTypes.add(enumName);
            }
            for (GeneralProductFop fop : AeroexpressTicketHelper.getClientFops((AeroexpressTicket)ticket)) {
                enumName = RulesHelper.getEnumName((Enum)fop.getType());
                if (TextUtil.isBlank((String)enumName)) continue;
                this.clientPaymentTypes.add(enumName);
            }
            this.payers.addAll(PayersCollector.collect(ticket));
            if (ticket.getStatisticalData() != null) {
                this.costCodes.addAll(StatisticsHelper.getAllCostCodes((StatisticalData)ticket.getStatisticalData()));
            }
            this.ticketType = ticket.getTicketType();
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)ticket));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)ticket.getReservation()));
            this.clientCreditCardVendor = ProductPropertiesHelper.getClientCreditCardVendor(ticket);
            CommonProductHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference<Organization>)AeroexpressTicketHelper.getSubagency((AeroexpressTicket)ticket));
            this.setTravelSubject(ProductHandler.of((BaseProduct)this.product).findTravelSubject((BaseProduct)this.product));
            this.setTravelSubjectTotalPrice(BookingHelper.getTravelSubjectTotalPrice((BaseProduct)this.product));
            if (ticket.getReservation() != null && ticket.getReservation().getBookingFile() != null) {
                this.client = ticket.getReservation().getBookingFile().getCustomerProfile();
            }
            this.agent = ticket.getAgent();
            this.bookingAgent = ticket.getReservation().getBookingAgent();
            CommonProductHelper.addProfileGroups(this.profileGroups, this.agent);
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public Set<String> getSalesPointCountryCodes() {
        return this.salesPointCountryCodes;
    }

    public boolean isForcedRefund() {
        return this.forcedRefund;
    }

    public String getPassengerType() {
        return this.passengerType;
    }

    public String getClassOfService() {
        return this.classOfService;
    }

    public String getSalesPointUid() {
        return this.salesPointUid;
    }

    public Set<String> getRouteLocationsCodes() {
        return this.routeLocationsCodes;
    }

    public Set<String> getDepartureLocationCodes() {
        return this.departureLocationCodes;
    }

    public Set<String> getArrivalLocationCodes() {
        return this.arrivalLocationCodes;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getPnr() {
        return this.pnr;
    }

    public String getAgentLocation() {
        return null;
    }

    public String getPcc() {
        return this.pcc;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public double getFare() {
        return this.fare;
    }

    public Set<String> getVendorPaymentTypes() {
        return this.vendorPaymentTypes;
    }

    public Set<String> getClientPaymentTypes() {
        return this.clientPaymentTypes;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public Collection<EntityReference<Organization>> getPayers() {
        return this.payers;
    }

    public List<CostCode> getCostCodes() {
        return this.costCodes;
    }

    public TicketType getTicketType() {
        return this.ticketType;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public Money getTravelSubjectTotalPrice() {
        return this.travelSubjectTotalPrice;
    }

    public void setTravelSubjectTotalPrice(Money totalPrice) {
        this.travelSubjectTotalPrice = totalPrice;
    }

    public TravelSubject getTravelSubject() {
        return this.travelSubject;
    }

    public void setTravelSubject(TravelSubject travelSubject) {
        this.travelSubject = travelSubject;
    }

    public Set<String> getPassengerTypeCategories() {
        return Collections.emptySet();
    }
}

