/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.AgencyMemoPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;

public class AgencyMemoPropertySet
implements AgencyMemoPropertiesProvider {
    private final RuleProxy<AgencyMemoPropertySet, ?> proxy;
    private AgencyMemoProductType agencyMemoType;
    private EntityReference<Person> bookingAgent;
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);

    public AgencyMemoPropertySet(RuleProxy<AgencyMemoPropertySet, ?> aProxy) {
        this.proxy = aProxy;
    }

    public void init(AgencyMemoProduct product) {
        this.proxy.getTracer().traceEnteringMethod(this.getClass(), "init", new String[0]);
        try {
            this.agencyMemoType = product.getType();
            this.bookingAgent = product.getReservation().getBookingAgent();
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)product.getReservation()));
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)product.getReservation()));
        }
        finally {
            this.proxy.getTracer().traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            this.proxy.getTracer().traceExitingMethod(this.getClass(), "init()", new String[0]);
        }
    }

    public AgencyMemoProductType getAgencyMemoType() {
        return this.agencyMemoType;
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }
}

