/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.air.FlightDistance;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.AirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.DateTimeConverter;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAirPropertySet
implements Serializable,
AirTicketPropertiesProvider {
    private static final long serialVersionUID = -7420263677952721006L;
    private String agentLocation;
    private String agencyTchCode;
    private DictionaryReference<Country> countryForVisaHolder;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    private final HashSet<String> airlines = new HashSet();
    private final HashSet<String> allLocations = new HashSet();
    private Date arrivalDate;
    private final HashSet<String> arrivalLocations = new HashSet();
    private Money baseFare;
    private final HashSet<String> blankOwners = new HashSet();
    private String blankType;
    private final ArrayList<String> bookingClasses = new ArrayList();
    private String carrierNumber;
    private final HashSet<String> carriers = new HashSet();
    private final List<String[]> allValidatingCarriersCodes = new ArrayList<String[]>();
    private Date currentDate;
    private Date departureDate;
    private final ArrayList<Date> departureDates = new ArrayList();
    private final HashSet<String> departureLocations = new HashSet();
    private final HashSet<String> salesPointCountryCodes = new HashSet();
    private final HashSet<String> agencyCountryCodes = new HashSet();
    private boolean directContract;
    private boolean eticket;
    private double fare;
    private BigDecimal fareDifference = BigDecimal.ZERO;
    private BigDecimal totalDifference = BigDecimal.ZERO;
    private double sellTotal;
    private double addCollectTotal;
    private final ArrayList<String> fareBasises = new ArrayList();
    private final ArrayList<String> flightNumbers = new ArrayList();
    private boolean groupFare;
    private boolean hasOpenJaw;
    private boolean interline;
    private boolean latinRegistration;
    private final ArrayList<String[]> interlineCarriers = new ArrayList();
    private final HashSet<String> openJawEnd = new HashSet();
    private final HashSet<String> openJawLoc = new HashSet();
    private final HashSet<String> openJawStart = new HashSet();
    private final HashSet<String> paymentTypes = new HashSet();
    private final HashSet<String> tchPaymentTypes = new HashSet();
    private final HashSet<String> clientPaymentTypes = new HashSet();
    private String pnr;
    private String salesPointCity;
    private String salesPointRegion;
    private final ArrayList<String> serviceClasses = new ArrayList();
    private final ArrayList<Boolean> surfaceSegments = new ArrayList();
    private final HashSet<String> taxCodes = new HashSet();
    private final HashSet<String> bookingContent = new HashSet();
    private final Map<String, Object> customParameters = new HashMap<String, Object>();
    private String targetType;
    private String tariffType;
    private String transportationType;
    private String validator;
    private String productCategory;
    private String mcoCategory;
    private final ArrayList<String[]> visitedCities = new ArrayList();
    private final ArrayList<String[]> visitedGeolocations = new ArrayList();
    private final ArrayList<List<String[]>> flightSegments = new ArrayList();
    private final ArrayList<String[]> segmentAirlines = new ArrayList();
    private final ArrayList<String> aircraftsCodes = new ArrayList();
    private final ArrayList<String[]> segmentOperatingAirlines = new ArrayList();
    private final HashSet<String> codeShareAirlines = new HashSet();
    private final Set<String> specialTariffs = new HashSet<String>();
    private final ArrayList<Boolean> domesticFlightsAC = new ArrayList();
    private final ArrayList<Boolean> connectedFlights = new ArrayList();
    private int numOfSegments;
    private int numOfSegmentTariffs;
    private boolean oneWayTicket = true;
    private Date issueDate;
    private BigDecimal price;
    private String priceCurrency;
    private String passengerType;
    private final Set<String> passengerTypeCategories = new HashSet<String>();
    private String clientCreditCardVendor;
    private String tourCode;
    private String contractCode;
    private final HashSet<String> firstSegmentAirline = new HashSet();
    private int numOfInterlineSegments = 0;
    private boolean simpleTaxed = false;
    private final HashSet<String> primaryCarrierCountry = new HashSet();
    private boolean forcedRefund;
    private String gdsName;
    private String reservationType;
    private String passengerStatus;
    private String pcc;
    private String branchUid;
    private String salesPointUid;
    private boolean hasTransferTariffs;
    private boolean hasAirlineBonusCards;
    private boolean hasCodeSharing;
    private boolean issuedInExchange;
    private final HashSet<String> operatingAirlines = new HashSet();
    private Double vendorCommissionRate;
    private boolean transatlanticFlight;
    private int travelDuration;
    private Double vendorCommissionValue;
    private String gdsCurrency;
    private EntityReference<Person> agent;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> client;
    private Date firstSegmentDepartureDate;
    private DictionaryReference<GeoLocation> firstSegmentDepartureLocation;
    private L10nString brandName;
    private Supplier<Double> hoursBeforeDepartureSupplier;
    private String rfisc;
    private String ersp;
    private BigDecimal bspCommissionEquivalentValue;
    private static final Logger log = LoggerFactory.getLogger(BaseAirPropertySet.class);
    private FlightDistance flightDistance;
    private Supplier<Double> hoursBeforeSellAndDepartureSupplier;
    private boolean hasLuggage;
    private String agencyCode;
    private boolean issuedForVoucher;
    private EntityReference<Organization> supplier;
    private String m2AgreementCode;
    private TicketType mainDocumentType;
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final Set<String> lastRoutePointCodes = new HashSet<String>();
    private boolean offlineFee;
    private Money travelSubjectTotalPrice;
    private TravelSubject travelSubject;
    private HashMap<ContractType, Boolean> manualFeeAppliedFlags = new HashMap();
    private HashMap<ContractType, Boolean> manualCommissionAppliedFlags = new HashMap();
    private HashMap<ContractType, Boolean> manualDiscountAppliedFlags = new HashMap();
    private String accountCode;

    public void setHoursBeforeDepartureSupplier(Supplier<Double> hoursSupplier) {
        this.hoursBeforeDepartureSupplier = hoursSupplier;
    }

    public String getAgentLocation() {
        return this.agentLocation;
    }

    public void setAgentLocation(String value) {
        this.agentLocation = value;
    }

    public String getAgencyTchCode() {
        return this.agencyTchCode;
    }

    public void setAgencyTchCode(String value) {
        this.agencyTchCode = value;
    }

    public Date getArrivalDate() {
        return this.arrivalDate;
    }

    public void setArrivalDate(Date value) {
        this.arrivalDate = value;
    }

    public Money getBaseFare() {
        return this.baseFare;
    }

    public void setBaseFare(Money value) {
        this.baseFare = value;
    }

    public String getCarrierNumber() {
        return this.carrierNumber;
    }

    public void setCarrierNumber(String value) {
        this.carrierNumber = value;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date value) {
        this.currentDate = value;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public void setDepartureDate(Date value) {
        this.departureDate = value;
    }

    public boolean isDirectContract() {
        return this.directContract;
    }

    public void setDirectContract(boolean value) {
        this.directContract = value;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public void setEticket(boolean value) {
        this.eticket = value;
    }

    public double getFare() {
        return this.fare;
    }

    public void setFare(double value) {
        this.fare = value;
    }

    public double getSellTotal() {
        return this.sellTotal;
    }

    public void setSellTotal(double value) {
        this.sellTotal = value;
    }

    public double getAddCollectTotal() {
        return this.addCollectTotal;
    }

    public void setAddCollectTotal(double value) {
        this.addCollectTotal = value;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal value) {
        this.price = value;
    }

    public String getPriceCurrency() {
        return this.priceCurrency;
    }

    public void setPriceCurrency(String priceCurrency) {
        this.priceCurrency = priceCurrency;
    }

    public boolean isGroupFare() {
        return this.groupFare;
    }

    public void setGroupFare(boolean value) {
        this.groupFare = value;
    }

    public boolean isHasOpenJaw() {
        return this.hasOpenJaw;
    }

    public void setHasOpenJaw(boolean value) {
        this.hasOpenJaw = value;
    }

    public boolean isLatinRegistration() {
        return this.latinRegistration;
    }

    public void setLatinRegistration(boolean latinRegistration) {
        this.latinRegistration = latinRegistration;
    }

    public boolean isInterline() {
        return this.interline;
    }

    public void setInterline(boolean value) {
        this.interline = value;
    }

    public String getPnr() {
        return this.pnr;
    }

    public void setPnr(String value) {
        this.pnr = value;
    }

    public String getSalesPointCity() {
        return this.salesPointCity;
    }

    public void setSalesPointCity(String value) {
        this.salesPointCity = value;
    }

    public String getSalesPointRegion() {
        return this.salesPointRegion;
    }

    public void setSalesPointRegion(String value) {
        this.salesPointRegion = value;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String value) {
        this.targetType = value;
    }

    public String getTariffType() {
        return this.tariffType;
    }

    public void setTariffType(String value) {
        this.tariffType = value;
    }

    public String getTransportationType() {
        return this.transportationType;
    }

    public void setTransportationType(String value) {
        this.transportationType = value;
    }

    public String getValidator() {
        return this.validator;
    }

    public void setValidator(String value) {
        this.validator = value;
    }

    public String getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(String value) {
        this.productCategory = value;
    }

    public String getMcoCategory() {
        return this.mcoCategory;
    }

    public void setMcoCategory(String value) {
        this.mcoCategory = value;
    }

    public int getNumOfSegments() {
        return this.numOfSegments;
    }

    public void setNumOfSegments(int value) {
        this.numOfSegments = value;
    }

    public int getNumOfSegmentTariffs() {
        return this.numOfSegmentTariffs;
    }

    public void setNumOfSegmentTariffs(int value) {
        this.numOfSegmentTariffs = value;
    }

    public boolean isOneWayTicket() {
        return this.oneWayTicket;
    }

    public void setOneWayTicket(boolean value) {
        this.oneWayTicket = value;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date value) {
        this.issueDate = value;
    }

    public Set<String> getAirlines() {
        return this.airlines;
    }

    public List<String> getAircraftsCodes() {
        return this.aircraftsCodes;
    }

    public Set<String> getAllLocations() {
        return this.allLocations;
    }

    public Set<String> getArrivalLocations() {
        return this.arrivalLocations;
    }

    public Set<String> getBlankOwners() {
        return this.blankOwners;
    }

    public String getBlankType() {
        return this.blankType;
    }

    public void setBlankType(String blankType) {
        this.blankType = blankType;
    }

    public List<String> getBookingClasses() {
        return this.bookingClasses;
    }

    public Set<String> getCarriers() {
        return this.carriers;
    }

    public List<Date> getDepartureDates() {
        return this.departureDates;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public List<String> getFareBasises() {
        return this.fareBasises;
    }

    public List<String> getFlightNumbers() {
        return this.flightNumbers;
    }

    public List<String[]> getInterlineCarriers() {
        return this.interlineCarriers;
    }

    public Set<String> getOpenJawEnd() {
        return this.openJawEnd;
    }

    public Set<String> getOpenJawLoc() {
        return this.openJawLoc;
    }

    public Set<String> getOpenJawStart() {
        return this.openJawStart;
    }

    public Set<String> getPaymentTypes() {
        return this.paymentTypes;
    }

    public Set<String> getClientPaymentTypes() {
        return this.clientPaymentTypes;
    }

    public List<String> getServiceClasses() {
        return this.serviceClasses;
    }

    public Set<String> getBookingContent() {
        return this.bookingContent;
    }

    public List<Boolean> getSurfaceSegments() {
        return this.surfaceSegments;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public void setPassengerType(String val) {
        this.passengerType = val;
    }

    public String getPassengerType() {
        return this.passengerType;
    }

    public Set<String> getPassengerTypeCategories() {
        return this.passengerTypeCategories;
    }

    public void setTourCode(String val) {
        this.tourCode = val;
    }

    public String getTourCode() {
        return this.tourCode;
    }

    public String getContractCode() {
        return this.contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Set<String> getFirstSegmentAirline() {
        return this.firstSegmentAirline;
    }

    public List<List<String[]>> getFlightSegments() {
        return this.flightSegments;
    }

    public List<String[]> getVisitedGeolocations() {
        return this.visitedGeolocations;
    }

    public void setNumOfInterlineSegments(int val) {
        this.numOfInterlineSegments = val;
    }

    public int getNumOfInterlineSegments() {
        return this.numOfInterlineSegments;
    }

    public List<String[]> getSegmentAirlines() {
        return this.segmentAirlines;
    }

    public void setSimpleTaxed(boolean val) {
        this.simpleTaxed = val;
    }

    public boolean isSimpleTaxed() {
        return this.simpleTaxed;
    }

    public Set<String> getPrimaryCarrierCountry() {
        return this.primaryCarrierCountry;
    }

    public void setForcedRefund(boolean value) {
        this.forcedRefund = value;
    }

    public boolean isForcedRefund() {
        return this.forcedRefund;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public List<Boolean> getDomesticFlightsAC() {
        return this.domesticFlightsAC;
    }

    public List<Boolean> getConnectedFlights() {
        return this.connectedFlights;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public void setGdsName(String value) {
        this.gdsName = value;
    }

    public String getReservationType() {
        return this.reservationType;
    }

    public void setReservationType(String value) {
        this.reservationType = value;
    }

    public Set<String> getTaxCodes() {
        return this.taxCodes;
    }

    public String getPassengerStatus() {
        return this.passengerStatus;
    }

    public void setPassengerStatus(String value) {
        this.passengerStatus = value;
    }

    public Set<String> getSpecialTariffs() {
        return this.specialTariffs;
    }

    public String getPcc() {
        return this.pcc;
    }

    public void setPcc(String value) {
        this.pcc = value;
    }

    public void setBranchUid(String value) {
        this.branchUid = value;
    }

    public String getBranchUid() {
        return this.branchUid;
    }

    public void setSalesPointUid(String value) {
        this.salesPointUid = value;
    }

    public L10nString getBrandName() {
        return this.brandName;
    }

    public void setBrandName(L10nString brandName) {
        this.brandName = brandName;
    }

    public String getSalesPointUid() {
        return this.salesPointUid;
    }

    public Set<String> getSalesPointCountryCodes() {
        return this.salesPointCountryCodes;
    }

    public boolean isHasTransferTariffs() {
        return this.hasTransferTariffs;
    }

    public void setHasTransferTariffs(boolean value) {
        this.hasTransferTariffs = value;
    }

    protected void addSubagencyCodes(EntityReference<Organization> agencyRef) {
        CommonProductHelper.addSubagencyCodes(this.subagencyCodes, agencyRef);
    }

    protected void addProfileGroups(EntityReference<? extends BaseProfile> ref) {
        CommonProductHelper.addProfileGroups(this.profileGroups, ref);
    }

    public DictionaryReference<Country> getCountryForVisaHolder() {
        return this.countryForVisaHolder;
    }

    public void setCountryForVisaHolder(DictionaryReference<Country> value) {
        this.countryForVisaHolder = value;
    }

    protected Boolean isDomesticFlightAC(DictionaryReference<Airline> airlineReference, DictionaryReference<GeoLocation> departureRef, DictionaryReference<GeoLocation> arrivalRef) {
        DictionaryCache dc = DictionaryCache.get();
        Airline airline = (Airline)dc.resolveReference(airlineReference);
        GeoLocation departure = (GeoLocation)dc.resolveReference(departureRef);
        GeoLocation arrival = (GeoLocation)dc.resolveReference(arrivalRef);
        if (airline == null) {
            return null;
        }
        DictionaryReference countryRef = airline.getCountry();
        if (countryRef == null) {
            return null;
        }
        if (!(departure != null && departure.getCountry() != null || arrival != null && arrival.getCountry() != null)) {
            return null;
        }
        if (departure != null && departure.getCountry() != null && !departure.getCountry().equals((Object)countryRef)) {
            return Boolean.FALSE;
        }
        if (arrival != null && arrival.getCountry() != null && !arrival.getCountry().equals((Object)countryRef)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean isHasAirlineBonusCards() {
        return this.hasAirlineBonusCards;
    }

    public void setHasAirlineBonusCards(boolean value) {
        this.hasAirlineBonusCards = value;
    }

    protected double calculateHoursBeforeDeparture() {
        if (this.firstSegmentDepartureDate == null) {
            log.warn("First segment departure location not specified, can't calculate the number of hours before departure.");
            return -1.0;
        }
        ZonedDateTime now = this.getCurrentDateTime();
        ZoneId departureZoneId = DictHelper.getZoneId(this.getFirstSegmentDepartureLocation());
        if (departureZoneId == null) {
            return -1.0;
        }
        Date departureDate = DateTimeConverter.convert((Date)this.firstSegmentDepartureDate, (ZoneId)departureZoneId, (ZoneId)this.getServerZoneId());
        return (double)(departureDate.getTime() - Date.from(now.toInstant()).getTime()) / 3600000.0;
    }

    public double getHoursBeforeDeparture() {
        return Optional.ofNullable(this.hoursBeforeDepartureSupplier).map(Supplier::get).orElse(0.0);
    }

    protected ZonedDateTime getCurrentDateTime() {
        return ((TimeService)Environment.getPublished(TimeService.class)).getCurrentZonedDateTime();
    }

    public boolean isHasCodeSharing() {
        return this.hasCodeSharing;
    }

    public void setIssuedInExchange(boolean issuedInExchange) {
        this.issuedInExchange = issuedInExchange;
    }

    public boolean isIssuedInExchange() {
        return this.issuedInExchange;
    }

    public void setHasCodeSharing(boolean value) {
        this.hasCodeSharing = value;
    }

    public HashSet<String> getOperatingAirlines() {
        return this.operatingAirlines;
    }

    public Double getVendorCommissionRate() {
        return this.vendorCommissionRate;
    }

    public void setVendorCommissionRate(Double value) {
        this.vendorCommissionRate = value;
    }

    public List<String[]> getSegmentOperatingAirlines() {
        return this.segmentOperatingAirlines;
    }

    public HashSet<String> getCodeShareAirlines() {
        return this.codeShareAirlines;
    }

    public boolean isTransatlanticFlight() {
        return this.transatlanticFlight;
    }

    public void setTransatlanticFlight(boolean value) {
        this.transatlanticFlight = value;
    }

    public List<String[]> getAllValidatingCarriersCodes() {
        return this.allValidatingCarriersCodes;
    }

    public double getHoursBetweenSellAndDeparture() {
        return Optional.ofNullable(this.hoursBeforeSellAndDepartureSupplier).map(Supplier::get).orElse(0.0);
    }

    protected ZoneId getDepartureZoneId() {
        if (this.firstSegmentDepartureLocation == null) {
            log.warn("First segment departure location not specified, using server time zone.");
            return this.getServerZoneId();
        }
        GeoLocation departureLoc = this.getDepartureLocation();
        if (departureLoc == null) {
            log.warn(String.format("Cannot find geolocation '%s', using server time zone.", this.firstSegmentDepartureLocation.getCode()));
            return this.getServerZoneId();
        }
        String timeZoneId = departureLoc.getTimeZoneId();
        if (StringUtils.isBlank((String)timeZoneId)) {
            log.warn(String.format("Geolocation '%s' has no timezone ID, using server time zone.", this.firstSegmentDepartureLocation.getCode()));
        }
        return StringUtils.isEmpty((String)timeZoneId) ? ZoneId.systemDefault() : ZoneId.of(timeZoneId);
    }

    public double calculateHourseBeforeSellAndDepature() {
        if (this.getFirstSegmentDepartureDate() == null) {
            log.warn("First segment departure location not specified, can't calculate the number of hours between sale and departure.");
            return -1.0;
        }
        ZoneId departureZoneId = DictHelper.getZoneId(this.getFirstSegmentDepartureLocation());
        if (departureZoneId == null) {
            return -1.0;
        }
        Date departureDate = DateTimeConverter.convert((Date)this.getFirstSegmentDepartureDate(), (ZoneId)departureZoneId, (ZoneId)this.getServerZoneId());
        Date issueDate = this.getIssueDate();
        return (double)(departureDate.getTime() - (issueDate != null ? this.getIssueDate().getTime() : System.currentTimeMillis())) / 3600000.0;
    }

    protected GeoLocation getDepartureLocation() {
        return (GeoLocation)DictionaryCache.get().resolveReference(this.firstSegmentDepartureLocation);
    }

    protected ZoneId getServerZoneId() {
        return ZoneId.systemDefault();
    }

    public int getTravelDuration() {
        return this.travelDuration;
    }

    public void setTravelDuration(int travelDuration) {
        this.travelDuration = travelDuration;
    }

    public Double getVendorCommissionValue() {
        return this.vendorCommissionValue;
    }

    public void setVendorCommissionValue(Double value) {
        this.vendorCommissionValue = value;
    }

    public String getGdsCurrency() {
        return this.gdsCurrency;
    }

    public void setGdsCurrency(String value) {
        this.gdsCurrency = value;
    }

    public <T> T getCustomParameter(String parameterName) {
        return (T)this.customParameters.get(parameterName);
    }

    public Map<String, Object> getCustomParameters() {
        return this.customParameters;
    }

    public Set<String> getAgencyCountryCodes() {
        return this.agencyCountryCodes;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public void setAgent(EntityReference<Person> agent) {
        this.agent = agent;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public void setBookingAgent(EntityReference<Person> bookingAgent) {
        this.bookingAgent = bookingAgent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public void setClient(EntityReference<Organization> client) {
        this.client = client;
    }

    public Date getFirstSegmentDepartureDate() {
        return this.firstSegmentDepartureDate;
    }

    public void setFirstSegmentDepartureDate(Date firstSegmentDepartureDate) {
        this.firstSegmentDepartureDate = firstSegmentDepartureDate;
    }

    public DictionaryReference<GeoLocation> getFirstSegmentDepartureLocation() {
        return this.firstSegmentDepartureLocation;
    }

    public void setFirstSegmentDepartureLocation(DictionaryReference<GeoLocation> firstSegmentDepartureLocation) {
        this.firstSegmentDepartureLocation = firstSegmentDepartureLocation;
    }

    public String getRfisc() {
        return this.rfisc;
    }

    public void setRfisc(String value) {
        this.rfisc = value;
    }

    public Set<String> getTCHPaymentTypes() {
        return this.tchPaymentTypes;
    }

    public BigDecimal getBspCommissionEquivalentValue() {
        return this.bspCommissionEquivalentValue;
    }

    public void setBspCommissionEquivalentValue(BigDecimal val) {
        this.bspCommissionEquivalentValue = val;
    }

    public BigDecimal getFareDifference() {
        return this.fareDifference;
    }

    public void setFareDifference(BigDecimal value) {
        this.fareDifference = value;
    }

    public BigDecimal getTotalDifference() {
        return this.totalDifference;
    }

    public void setTotalDifference(BigDecimal totalDifference) {
        this.totalDifference = totalDifference;
    }

    public FlightDistance getFlightDistance() {
        return this.flightDistance;
    }

    public void setFlightDistance(FlightDistance value) {
        this.flightDistance = value;
    }

    public String getErsp() {
        return this.ersp;
    }

    public void setErsp(String value) {
        this.ersp = value;
    }

    public void setHoursBeforeSellAndDepartureSupplier(Supplier<Double> valueSupplier) {
        this.hoursBeforeSellAndDepartureSupplier = valueSupplier;
    }

    public boolean isHasLuggage() {
        return this.hasLuggage;
    }

    public void setHasLuggage(boolean hasLuggage) {
        this.hasLuggage = hasLuggage;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    protected LazyValueHolder<List<EmployeeCategory>> getEmployeeCategoriesHolder() {
        return this.employeeCategories;
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    protected LazyValueHolder<List<EntityReference<Organization>>> getEmployersOfBookingAgentHolder() {
        return this.employers;
    }

    protected LazyValueHolder<Boolean> getCreatedByClientHolder() {
        return this.createdByClient;
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public void setClientCreditCardVendor(String clientCreditCardVendor) {
        this.clientCreditCardVendor = clientCreditCardVendor;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public void setAgencyCode(String agencyCode) {
        this.agencyCode = agencyCode;
    }

    public Set<String> getLastRoutePointCodes() {
        return this.lastRoutePointCodes;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public void setSupplier(EntityReference<Organization> supplier) {
        this.supplier = supplier;
    }

    public boolean isOfflineFee() {
        return this.offlineFee;
    }

    public void setOfflineFee(boolean offlineFee) {
        this.offlineFee = offlineFee;
    }

    public boolean isIssuedForVoucher() {
        return this.issuedForVoucher;
    }

    public void setIssuedForVoucher(boolean issuedForVoucher) {
        this.issuedForVoucher = issuedForVoucher;
    }

    public String getM2AgreementCode() {
        return this.m2AgreementCode;
    }

    public void setM2AgreementCode(String m2AgreementCode) {
        this.m2AgreementCode = m2AgreementCode;
    }

    public void setMainDocumentType(TicketType mainDocumentType) {
        this.mainDocumentType = mainDocumentType;
    }

    public TicketType getMainDocumentType() {
        return this.mainDocumentType;
    }

    public Money getTravelSubjectTotalPrice() {
        return this.travelSubjectTotalPrice;
    }

    public void setTravelSubjectTotalPrice(Money totalPrice) {
        this.travelSubjectTotalPrice = totalPrice;
    }

    public TravelSubject getTravelSubject() {
        return this.travelSubject;
    }

    public void setTravelSubject(TravelSubject travelSubject) {
        this.travelSubject = travelSubject;
    }

    public HashMap<ContractType, Boolean> getManualFeeAppliedFlags() {
        return this.manualFeeAppliedFlags;
    }

    public HashMap<ContractType, Boolean> getManualCommissionAppliedFlags() {
        return this.manualCommissionAppliedFlags;
    }

    public HashMap<ContractType, Boolean> getManualDiscountAppliedFlags() {
        return this.manualDiscountAppliedFlags;
    }

    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }
}

