/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.handlers;

import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.server.model.handlers.BaseAirPropertySet;
import com.gridnine.xtrip.server.model.rules.test.RulesTestBase;
import java.net.URL;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class BaseAirPropertySetTest
extends RulesTestBase {
    private static final String MOW = "MOW";
    private static final String BER = "BER";
    private static final String BERLIN = "Europe/Berlin";
    private static final ZoneId BERLIN_ZONEID = ZoneId.of("Europe/Berlin");
    private static final ZoneId MOSCOW_ZONEID = ZoneId.of("Europe/Moscow");

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("dictionaries.xml");
    }

    @Test
    public void getDepartureTimeZoneReturnsServerTzIfLocationNotSpecified() {
        ZoneId serverZoneId = MOSCOW_ZONEID;
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(serverZoneId, null);
        Assert.assertSame((Object)serverZoneId, (Object)((BaseAirPropertySet)testObject).getDepartureZoneId());
    }

    @Test
    public void getDepartureTimeZoneReturnsServerTzIfGeoLocationNull() {
        ZoneId serverZoneId = MOSCOW_ZONEID;
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(serverZoneId, null);
        testObject.setFirstSegmentDepartureLocation((DictionaryReference<GeoLocation>)new GeoLocationReference("Test"));
        Assert.assertSame((Object)serverZoneId, (Object)((BaseAirPropertySet)testObject).getDepartureZoneId());
    }

    @Test
    public void getDepartureTimeZoneReturnsServerTzIfGeoLocationHasNoTz() {
        GeoLocation location = new GeoLocation();
        Assert.assertNull((Object)location.getTimeZoneId());
        ZoneId serverZoneId = MOSCOW_ZONEID;
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(serverZoneId, location);
        testObject.setFirstSegmentDepartureLocation((DictionaryReference<GeoLocation>)new GeoLocationReference(location));
        Assert.assertEquals((Object)serverZoneId, (Object)((BaseAirPropertySet)testObject).getDepartureZoneId());
    }

    @Test
    public void getDepartureTimeZoneReturnsDepartureTzIfPossible() {
        GeoLocation location = new GeoLocation();
        location.setTimeZoneId(BERLIN);
        ZoneId serverZoneId = MOSCOW_ZONEID;
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(serverZoneId, location);
        testObject.setFirstSegmentDepartureLocation((DictionaryReference<GeoLocation>)new GeoLocationReference(location));
        Assert.assertEquals((Object)ZoneId.of(BERLIN), (Object)((BaseAirPropertySet)testObject).getDepartureZoneId());
    }

    @Test
    public void getHoursBetweenSellAndDepartureCalculatesCorrectTimeDifference() {
        this.getHoursBetweenSellAndDepartureTestLogic(MOW, MOSCOW_ZONEID, MOSCOW_ZONEID, this.createDateTime(2015, 3, 23, 12, 11), this.createDateTime(2015, 3, 22, 12, 11), 24);
        this.getHoursBetweenSellAndDepartureTestLogic(BER, BERLIN_ZONEID, MOSCOW_ZONEID, this.createDateTime(2015, 3, 23, 12, 11), this.createDateTime(2015, 3, 22, 12, 11), 26);
        this.getHoursBetweenSellAndDepartureTestLogic(MOW, MOSCOW_ZONEID, BERLIN_ZONEID, this.createDateTime(2015, 3, 23, 12, 11), this.createDateTime(2015, 3, 22, 12, 11), 22);
        this.getHoursBetweenSellAndDepartureTestLogic(BER, BERLIN_ZONEID, BERLIN_ZONEID, this.createDateTime(2015, 3, 23, 12, 11), this.createDateTime(2015, 3, 22, 12, 11), 24);
    }

    @Test
    public void getHoursBeforeDepartureCalculatesCorrectNumberOfHours() {
        this.getHoursBeforeDepartureTestLogic(MOW, this.createDateTime(2015, 3, 23, 12, 57), ZonedDateTime.of(2015, 3, 22, 12, 57, 0, 0, MOSCOW_ZONEID), MOSCOW_ZONEID, MOSCOW_ZONEID, 24);
        this.getHoursBeforeDepartureTestLogic(MOW, this.createDateTime(2015, 3, 23, 12, 57), ZonedDateTime.of(2015, 3, 22, 12, 57, 0, 0, MOSCOW_ZONEID), MOSCOW_ZONEID, BERLIN_ZONEID, 22);
        this.getHoursBeforeDepartureTestLogic(BER, this.createDateTime(2015, 3, 23, 12, 57), ZonedDateTime.of(2015, 3, 22, 12, 57, 0, 0, MOSCOW_ZONEID), BERLIN_ZONEID, MOSCOW_ZONEID, 26);
        this.getHoursBeforeDepartureTestLogic(BER, this.createDateTime(2015, 3, 23, 12, 57), ZonedDateTime.of(2015, 3, 22, 12, 57, 0, 0, MOSCOW_ZONEID), BERLIN_ZONEID, BERLIN_ZONEID, 24);
    }

    protected Date createDateTime(int year, int month, int day, int hour, int minute) {
        return Date.from(ZonedDateTime.of(year, month, day, hour, minute, 0, 0, MOSCOW_ZONEID).toInstant());
    }

    private void getHoursBeforeDepartureTestLogic(String departureCode, Date firstSegmentDepartureDate, ZonedDateTime now, ZoneId departureZoneId, ZoneId serverZoneId, int expectedResult) {
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(serverZoneId, null, departureZoneId, now);
        testObject.setFirstSegmentDepartureLocation(this.getGeoLocationRef(departureCode));
        testObject.setFirstSegmentDepartureDate(firstSegmentDepartureDate);
        Assert.assertEquals((long)expectedResult, (long)((int)testObject.calculateHoursBeforeDeparture()));
    }

    private void getHoursBetweenSellAndDepartureTestLogic(String departureCode, ZoneId departureZoneId, ZoneId serverZoneId, Date firstSegmentDepartureDate, Date issueDate, int expectedResult) {
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(serverZoneId, null, departureZoneId);
        testObject.setFirstSegmentDepartureLocation(this.getGeoLocationRef(departureCode));
        testObject.setFirstSegmentDepartureDate(firstSegmentDepartureDate);
        testObject.setIssueDate(issueDate);
        testObject.initHourseBeroreSellAndDeparture();
        Assert.assertEquals((long)expectedResult, (long)((int)testObject.getHoursBetweenSellAndDeparture()));
    }

    @Test
    public void getHoursBetweenSellAndDepartureCorrectlyHandlesMonths() {
        this.getHoursBetweenSellAndDepartureMonthTestLogic(1, 744);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(2, 672);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(3, 744);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(4, 720);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(5, 744);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(6, 720);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(7, 744);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(8, 744);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(9, 720);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(10, 744);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(11, 720);
        this.getHoursBetweenSellAndDepartureMonthTestLogic(12, 744);
    }

    protected void getHoursBetweenSellAndDepartureMonthTestLogic(int month, int expectedNumberOfHours) {
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(MOSCOW_ZONEID, null, MOSCOW_ZONEID);
        DateTime issueDate = new DateTime(2015, month, 25, 17, 55);
        DateTime departureDate = issueDate.plusMonths(1);
        testObject.setFirstSegmentDepartureLocation(this.getGeoLocationRef(MOW));
        testObject.setFirstSegmentDepartureDate(departureDate.toDate());
        testObject.setIssueDate(issueDate.toDate());
        testObject.initHourseBeroreSellAndDeparture();
        Assert.assertEquals((long)expectedNumberOfHours, (long)((int)testObject.getHoursBetweenSellAndDeparture()));
    }

    @Test
    public void getHoursBeforeDepartureCorrectlyHandlesMonths() {
        this.getHoursBeforeDepartureMonthTestLogic(1, 744);
        this.getHoursBeforeDepartureMonthTestLogic(2, 672);
        this.getHoursBeforeDepartureMonthTestLogic(3, 744);
        this.getHoursBeforeDepartureMonthTestLogic(4, 720);
        this.getHoursBeforeDepartureMonthTestLogic(5, 744);
        this.getHoursBeforeDepartureMonthTestLogic(6, 720);
        this.getHoursBeforeDepartureMonthTestLogic(7, 744);
        this.getHoursBeforeDepartureMonthTestLogic(8, 744);
        this.getHoursBeforeDepartureMonthTestLogic(9, 720);
        this.getHoursBeforeDepartureMonthTestLogic(10, 744);
        this.getHoursBeforeDepartureMonthTestLogic(11, 720);
        this.getHoursBeforeDepartureMonthTestLogic(12, 744);
    }

    protected void getHoursBeforeDepartureMonthTestLogic(int month, int expectedNumberOfHours) {
        ZonedDateTime now = ZonedDateTime.of(2015, month, 25, 17, 55, 0, 0, ZoneId.systemDefault());
        ZonedDateTime departureDate = now.plusMonths(1L);
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(MOSCOW_ZONEID, null, MOSCOW_ZONEID, now);
        testObject.setFirstSegmentDepartureLocation(this.getGeoLocationRef(MOW));
        testObject.setFirstSegmentDepartureDate(Date.from(departureDate.toInstant()));
        Assert.assertEquals((long)expectedNumberOfHours, (long)((int)testObject.calculateHoursBeforeDeparture()));
    }

    @Test
    public void getHoursBetweenSellAndDepartureWorksWhenFirstSegmentDepartureDateIsNull() {
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(MOSCOW_ZONEID, null, MOSCOW_ZONEID);
        Assert.assertNull((Object)testObject.getFirstSegmentDepartureDate());
        testObject.initHourseBeroreSellAndDeparture();
        Assert.assertEquals((long)-1L, (long)((int)testObject.getHoursBetweenSellAndDeparture()));
    }

    @Test
    public void getHoursBeforeDepartureWorksWhenFirstSegmentDepartureDateIsNull() {
        BaseAirPropertySetForTesting testObject = new BaseAirPropertySetForTesting(MOSCOW_ZONEID, null, MOSCOW_ZONEID);
        Assert.assertNull((Object)testObject.getFirstSegmentDepartureDate());
        Assert.assertEquals((long)-1L, (long)((int)testObject.calculateHoursBeforeDeparture()));
    }

    private DictionaryReference<GeoLocation> getGeoLocationRef(String code) {
        return ((GeoLocation)DictionaryCache.get().findByCode(GeoLocation.class, code)).toReference();
    }

    private final class BaseAirPropertySetForTesting
    extends BaseAirPropertySet {
        private static final long serialVersionUID = 1L;
        private final ZoneId serverZoneId;
        private final ZoneId departureZoneId;
        private final GeoLocation departureLocation;
        private final ZonedDateTime now;

        public BaseAirPropertySetForTesting(ZoneId serverZoneId, GeoLocation departureLoc, ZoneId departureZoneId) {
            this(serverZoneId, departureLoc, departureZoneId, null);
        }

        public BaseAirPropertySetForTesting(ZoneId serverZoneId, GeoLocation departureLoc, ZoneId departureZoneId, ZonedDateTime currentDateTime) {
            this.serverZoneId = serverZoneId;
            this.departureLocation = departureLoc;
            this.departureZoneId = departureZoneId;
            this.now = currentDateTime;
        }

        public void initHourseBeroreSellAndDeparture() {
            this.setHoursBeforeSellAndDepartureSupplier(this::calculateHourseBeforeSellAndDepature);
            this.setHoursBeforeDepartureSupplier(this::calculateHoursBeforeDeparture);
        }

        public BaseAirPropertySetForTesting(ZoneId serverZoneId, GeoLocation departureLoc) {
            this(serverZoneId, departureLoc, null);
        }

        @Override
        protected ZoneId getServerZoneId() {
            return this.serverZoneId;
        }

        @Override
        protected GeoLocation getDepartureLocation() {
            return this.departureLocation;
        }

        @Override
        protected ZoneId getDepartureZoneId() {
            if (this.departureZoneId != null) {
                return this.departureZoneId;
            }
            return super.getDepartureZoneId();
        }

        @Override
        protected ZonedDateTime getCurrentDateTime() {
            if (this.now != null) {
                return this.now;
            }
            return super.getCurrentDateTime();
        }
    }
}

